/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.core.file.FileResolverTestBase;
import java.net.MalformedURLException;
import java.net.URL;

public class NestedZipFileResolverTest
extends FileResolverTestBase {
    private ClassLoader prevCL;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.webRoot = "webroot6";
        this.prevCL = Thread.currentThread().getContextClassLoader();
        final URL webroot6URL = this.prevCL.getResource("webroot6.zip");
        this.prevCL = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = new ClassLoader(this.prevCL){

            @Override
            public URL getResource(String name) {
                try {
                    if (name.startsWith("lib/")) {
                        return new URL("jar:" + webroot6URL + "!/" + name);
                    }
                    if (name.startsWith("webroot6")) {
                        return new URL("jar:" + webroot6URL + "!/lib/nested.zip!/" + name.substring(7));
                    }
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
                return super.getResource(name);
            }
        };
        Thread.currentThread().setContextClassLoader(loader);
    }

    @Override
    public void after() throws Exception {
        if (this.prevCL != null) {
            Thread.currentThread().setContextClassLoader(this.prevCL);
        }
        super.after();
    }
}

