/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.channel.socket.DuplexChannel;
import io.netty.handler.codec.TooLongFrameException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.Http2TestBase;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpTest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.TestUtils;
import io.vertx.test.tls.Cert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLHandshakeException;
import org.junit.Test;

public class Http2Test
extends HttpTest {
    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return Http2TestBase.createHttp2ServerOptions(8080, "localhost");
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return Http2TestBase.createHttp2ClientOptions();
    }

    @Override
    @Test
    public void testCloseHandlerNotCalledWhenConnectionClosedAfterEnd() throws Exception {
        this.testCloseHandlerNotCalledWhenConnectionClosedAfterEnd(1);
    }

    @Test
    public void testServerResponseWriteBufferFromOtherThread() throws Exception {
        this.server.requestHandler(req -> this.runAsync(() -> req.response().write("hello world"))).listen(this.testAddress, this.onSuccess(v -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.handler(buff -> {
                this.assertEquals(Buffer.buffer((String)"hello world"), buff);
                this.testComplete();
            });
        }).exceptionHandler(this::fail).end()));
        this.await();
    }

    @Test
    public void testServerResponseEndFromOtherThread() throws Exception {
        this.server.requestHandler(req -> this.runAsync(() -> req.response().end())).listen(this.testAddress, this.onSuccess(v1 -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.endHandler(v2 -> this.testComplete());
        }).exceptionHandler(this::fail).end()));
        this.await();
    }

    @Test
    public void testServerResponseEndWithTrailersFromOtherThread() throws Exception {
        this.server.requestHandler(req -> this.runAsync(() -> req.response().putTrailer("some", "trailer").end())).listen(this.testAddress, this.onSuccess(v1 -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.endHandler(v2 -> {
                this.assertEquals(1L, resp.trailers().size());
                this.assertEquals("trailer", resp.trailers().get("some"));
                this.testComplete();
            });
        }).exceptionHandler(this::fail).end()));
        this.await();
    }

    @Test
    public void testServerResponseResetFromOtherThread() throws Exception {
        this.server.requestHandler(req -> this.runAsync(() -> req.response().reset(0L))).listen(this.testAddress, this.onSuccess(v -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> this.fail()).exceptionHandler(err -> {
            this.assertTrue(err instanceof StreamResetException);
            this.testComplete();
        }).sendHead()));
        this.await();
    }

    void runAsync(Runnable runnable) {
        new Thread(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.fail(e);
            }
        }).start();
    }

    @Test
    public void testClientRequestWriteFromOtherThread() throws Exception {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            latch2.countDown();
            req.endHandler(v -> req.response().end());
        }).listen(this.testAddress, this.onSuccess(v -> latch1.countDown()));
        this.awaitLatch(latch1);
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).setChunked(true).sendHead();
        this.awaitLatch(latch2);
        req2.write("hello ").end("world");
        this.await();
    }

    @Test
    public void testServerOpenSSL() throws Exception {
        HttpServerOptions opts = new HttpServerOptions().setPort(4043).setHost("localhost").setUseAlpn(true).setSsl(true).addEnabledCipherSuite("TLS_RSA_WITH_AES_128_CBC_SHA").setPemKeyCertOptions((PemKeyCertOptions)Cert.SERVER_PEM.get()).setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions());
        this.server.close();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.server = this.vertx.createHttpServer(opts);
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 4043, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testServerStreamPausedWhenConnectionIsPaused() throws Exception {
        CountDownLatch fullLatch = new CountDownLatch(1);
        CompletableFuture resumeLatch = new CompletableFuture();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            switch (req.path()) {
                case "/0": {
                    this.vertx.setPeriodic(1L, timerID -> {
                        if (resp.writeQueueFull()) {
                            this.vertx.cancelTimer(timerID.longValue());
                            fullLatch.countDown();
                        } else {
                            resp.write(Buffer.buffer((String)TestUtils.randomAlphaString(512)));
                        }
                    });
                    break;
                }
                case "/1": {
                    this.assertTrue(resp.writeQueueFull());
                    resp.drainHandler(v -> resp.end());
                    resumeLatch.complete(null);
                }
            }
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/0", resp -> {
            resp.pause();
            Context ctx = this.vertx.getOrCreateContext();
            resumeLatch.thenAccept(v1 -> ctx.runOnContext(v2 -> {
                resp.endHandler(v -> this.testComplete());
                resp.resume();
            }));
        }).end();
        this.awaitLatch(fullLatch);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/1", resp -> resp.endHandler(v -> this.complete())).end();
        resumeLatch.get(20L, TimeUnit.SECONDS);
        this.await();
    }

    @Test
    public void testClientStreamPausedWhenConnectionIsPaused() throws Exception {
        this.waitFor(2);
        Buffer buffer = TestUtils.randomBuffer(512);
        CompletableFuture resumeLatch = new CompletableFuture();
        this.server.requestHandler(req -> {
            switch (req.path()) {
                case "/0": {
                    req.pause();
                    resumeLatch.thenAccept(v -> req.resume());
                    req.endHandler(v -> req.response().end());
                    break;
                }
                case "/1": {
                    req.bodyHandler(v -> {
                        this.assertEquals(v, buffer);
                        req.response().end();
                    });
                }
            }
        });
        this.startServer(this.testAddress);
        HttpClientRequest req1 = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/0", resp -> this.complete()).setChunked(true);
        while (!req1.writeQueueFull()) {
            req1.write(Buffer.buffer((String)TestUtils.randomAlphaString(512)));
            Thread.sleep(1L);
        }
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/1", resp -> this.complete()).setChunked(true);
        this.assertFalse(req2.writeQueueFull());
        req2.sendHead(v -> {
            this.assertTrue(req2.writeQueueFull());
            resumeLatch.complete(null);
        });
        resumeLatch.get(20L, TimeUnit.SECONDS);
        AsyncTestBase.assertWaitUntil(() -> !req2.writeQueueFull());
        req1.end();
        req2.end(buffer);
        this.await();
    }

    @Test
    public void testResetClientRequestNotYetSent() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setInitialSettings(new Http2Settings().setMaxConcurrentStreams(1L)));
        AtomicInteger numReq = new AtomicInteger();
        this.server.requestHandler(req -> this.fail());
        this.startServer(this.testAddress);
        this.vertx.runOnContext(v -> {
            HttpClientRequest post = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "some-uri", resp -> this.fail());
            post.exceptionHandler(err -> {
                if (err instanceof StreamResetException) {
                    this.complete();
                }
            });
            post.setChunked(true).write(TestUtils.randomBuffer(1024));
            this.assertTrue(post.reset());
        });
        this.await();
    }

    @Test
    public void testDiscardConnectionWhenChannelBecomesInactive() throws Exception {
        AtomicInteger count = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (count.getAndIncrement() == 0) {
                Http2ServerConnection a = (Http2ServerConnection)req.connection();
                DuplexChannel channel = (DuplexChannel)a.channel();
                channel.shutdown();
            } else {
                req.response().end();
            }
        });
        this.startServer(this.testAddress);
        AtomicBoolean closed = new AtomicBoolean();
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.fail()).connectionHandler(conn -> conn.closeHandler(v -> closed.set(true))).end();
        AsyncTestBase.assertWaitUntil(closed::get);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.testComplete()).exceptionHandler(err -> this.fail()).end();
        this.await();
    }

    @Test
    public void testClientDoesNotSupportAlpn() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setProtocolVersion(HttpVersion.HTTP_1_1).setUseAlpn(false));
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(HttpVersion.HTTP_1_1, resp.version());
            this.complete();
        }).exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testServerDoesNotSupportAlpn() throws Exception {
        this.waitFor(2);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setUseAlpn(false));
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(HttpVersion.HTTP_1_1, resp.version());
            this.complete();
        }).exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testClientMakeRequestHttp2WithSSLWithoutAlpn() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setUseAlpn(false));
        try {
            this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri");
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testServePendingRequests() throws Exception {
        int n = 10;
        this.waitFor(n);
        LinkedList requests = new LinkedList();
        HashSet connections = new HashSet();
        this.server.requestHandler(req -> {
            requests.add(req);
            connections.add(req.connection());
            this.assertEquals(1L, connections.size());
            if (requests.size() == n) {
                while (requests.size() > 0) {
                    ((HttpServerRequest)requests.removeFirst()).response().end();
                }
            }
        });
        this.startServer(this.testAddress);
        for (int i = 0; i < n; ++i) {
            this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.complete()).end();
        }
        this.await();
    }

    @Test
    public void testInitialMaxConcurrentStreamZero() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setInitialSettings(new Http2Settings().setMaxConcurrentStreams(0L)));
        this.server.requestHandler(req -> req.response().end());
        this.server.connectionHandler(conn -> this.vertx.setTimer(500L, id -> conn.updateSettings(new Http2Settings().setMaxConcurrentStreams(10L))));
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.testComplete()).connectionHandler(conn -> this.assertEquals(10L, conn.remoteSettings().getMaxConcurrentStreams())).setTimeout(10000L).exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testMaxHaderListSize() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setInitialSettings(new Http2Settings().setMaxHeaderListSize(Integer.MAX_VALUE)));
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(Integer.MAX_VALUE, resp.request().connection().remoteSettings().getMaxHeaderListSize());
            this.testComplete();
        }).setTimeout(10000L).exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testFoo() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.write("Hello");
            resp.end("World");
            this.assertNull(resp.headers().get("content-length"));
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertNull(resp.getHeader("content-length"));
            resp.bodyHandler(body -> {
                this.assertEquals("HelloWorld", body.toString());
                this.complete();
            });
        }).end();
        this.await();
    }

    @Test
    public void testStreamWeightAndDependency() throws Exception {
        int requestStreamDependency = 56;
        short requestStreamWeight = 43;
        int responseStreamDependency = 98;
        short responseStreamWeight = 55;
        this.waitFor(2);
        this.server.requestHandler(req -> {
            this.assertEquals(requestStreamWeight, req.streamPriority().getWeight());
            this.assertEquals(requestStreamDependency, req.streamPriority().getDependency());
            req.response().setStreamPriority(new StreamPriority().setDependency(responseStreamDependency).setWeight(responseStreamWeight).setExclusive(false));
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        HttpClientRequest request = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(responseStreamWeight, resp.request().getStreamPriority().getWeight());
            this.assertEquals(responseStreamDependency, resp.request().getStreamPriority().getDependency());
            this.complete();
        });
        request.setStreamPriority(new StreamPriority().setDependency(requestStreamDependency).setWeight(requestStreamWeight).setExclusive(false));
        request.end();
        this.await();
    }

    @Test
    public void testStreamWeightAndDependencyChange() throws Exception {
        int requestStreamDependency = 56;
        short requestStreamWeight = 43;
        int requestStreamDependency2 = 157;
        short requestStreamWeight2 = 143;
        int responseStreamDependency = 98;
        short responseStreamWeight = 55;
        int responseStreamDependency2 = 198;
        short responseStreamWeight2 = 155;
        this.waitFor(4);
        this.server.requestHandler(req -> {
            req.streamPriorityHandler(sp -> {
                this.assertEquals(requestStreamWeight2, sp.getWeight());
                this.assertEquals(requestStreamDependency2, sp.getDependency());
                this.assertEquals(requestStreamWeight2, req.streamPriority().getWeight());
                this.assertEquals(requestStreamDependency2, req.streamPriority().getDependency());
                this.complete();
            });
            this.assertEquals(requestStreamWeight, req.streamPriority().getWeight());
            this.assertEquals(requestStreamDependency, req.streamPriority().getDependency());
            req.response().setStreamPriority(new StreamPriority().setDependency(responseStreamDependency).setWeight(responseStreamWeight).setExclusive(false));
            req.response().write("hello");
            req.response().setStreamPriority(new StreamPriority().setDependency(responseStreamDependency2).setWeight(responseStreamWeight2).setExclusive(false));
            req.response().drainHandler(h -> {});
            req.response().end("world");
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        HttpClientRequest request = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(responseStreamWeight, resp.request().getStreamPriority().getWeight());
            this.assertEquals(responseStreamDependency, resp.request().getStreamPriority().getDependency());
            resp.streamPriorityHandler(sp -> {
                this.assertEquals(responseStreamWeight2, sp.getWeight());
                this.assertEquals(responseStreamDependency2, sp.getDependency());
                this.assertEquals(responseStreamWeight2, resp.request().getStreamPriority().getWeight());
                this.assertEquals(responseStreamDependency2, resp.request().getStreamPriority().getDependency());
                this.complete();
            });
            this.complete();
        });
        request.setStreamPriority(new StreamPriority().setDependency(requestStreamDependency).setWeight(requestStreamWeight).setExclusive(false));
        request.sendHead(h -> {
            request.setStreamPriority(new StreamPriority().setDependency(requestStreamDependency2).setWeight(requestStreamWeight2).setExclusive(false));
            request.end();
        });
        this.await();
    }

    @Test
    public void testStreamWeightAndDependencyNoChange() throws Exception {
        int requestStreamDependency = 56;
        short requestStreamWeight = 43;
        int responseStreamDependency = 98;
        short responseStreamWeight = 55;
        this.waitFor(2);
        this.server.requestHandler(req -> {
            req.streamPriorityHandler(sp -> this.fail("Stream priority handler shoudl not be called"));
            this.assertEquals(requestStreamWeight, req.streamPriority().getWeight());
            this.assertEquals(requestStreamDependency, req.streamPriority().getDependency());
            req.response().setStreamPriority(new StreamPriority().setDependency(responseStreamDependency).setWeight(responseStreamWeight).setExclusive(false));
            req.response().write("hello");
            req.response().setStreamPriority(new StreamPriority().setDependency(responseStreamDependency).setWeight(responseStreamWeight).setExclusive(false));
            req.response().drainHandler(h -> {});
            req.response().end("world");
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        HttpClientRequest request = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(responseStreamWeight, resp.request().getStreamPriority().getWeight());
            this.assertEquals(responseStreamDependency, resp.request().getStreamPriority().getDependency());
            resp.streamPriorityHandler(sp -> {
                this.fail("Stream priority handler shoudl not be called");
                this.complete();
            });
            this.complete();
        });
        request.setStreamPriority(new StreamPriority().setDependency(requestStreamDependency).setWeight(requestStreamWeight).setExclusive(false));
        request.sendHead(h -> {
            request.setStreamPriority(new StreamPriority().setDependency(requestStreamDependency).setWeight(requestStreamWeight).setExclusive(false));
            request.end();
        });
        this.await();
    }

    @Test
    public void testStreamWeightAndDependencyInheritance() throws Exception {
        int requestStreamDependency = 86;
        short requestStreamWeight = 53;
        this.waitFor(2);
        this.server.requestHandler(req -> {
            this.assertEquals(requestStreamWeight, req.streamPriority().getWeight());
            this.assertEquals(requestStreamDependency, req.streamPriority().getDependency());
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        HttpClientRequest request = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(requestStreamWeight, resp.request().getStreamPriority().getWeight());
            this.assertEquals(requestStreamDependency, resp.request().getStreamPriority().getDependency());
            this.complete();
        });
        request.setStreamPriority(new StreamPriority().setDependency(requestStreamDependency).setWeight(requestStreamWeight).setExclusive(false));
        request.end();
        this.await();
    }

    @Test
    public void testDefaultStreamWeightAndDependency() throws Exception {
        int defaultStreamDependency = 0;
        short defaultStreamWeight = 16;
        this.waitFor(2);
        this.server.requestHandler(req -> {
            this.assertEquals(defaultStreamWeight, req.streamPriority().getWeight());
            this.assertEquals(defaultStreamDependency, req.streamPriority().getDependency());
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        HttpClientRequest request = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(defaultStreamWeight, resp.request().getStreamPriority().getWeight());
            this.assertEquals(defaultStreamDependency, resp.request().getStreamPriority().getDependency());
            this.complete();
        });
        request.end();
        this.await();
    }

    @Test
    public void testStreamWeightAndDependencyPushPromise() throws Exception {
        int pushStreamDependency = 456;
        short pushStreamWeight = 14;
        this.waitFor(4);
        this.server.requestHandler(req -> {
            req.response().push(HttpMethod.GET, "/pushpath", ar -> {
                this.assertTrue(ar.succeeded());
                HttpServerResponse pushedResp = (HttpServerResponse)ar.result();
                pushedResp.setStreamPriority(new StreamPriority().setDependency(pushStreamDependency).setWeight(pushStreamWeight).setExclusive(false));
                pushedResp.end();
            });
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        HttpClientRequest request = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.complete());
        request.pushHandler(pushReq -> {
            this.complete();
            pushReq.handler(pushResp -> {
                this.assertEquals(pushStreamDependency, pushResp.request().getStreamPriority().getDependency());
                this.assertEquals(pushStreamWeight, pushResp.request().getStreamPriority().getWeight());
                this.complete();
            });
        });
        request.end();
        this.await();
    }

    @Test
    public void testStreamWeightAndDependencyInheritancePushPromise() throws Exception {
        int reqStreamDependency = 556;
        short reqStreamWeight = 84;
        this.waitFor(4);
        this.server.requestHandler(req -> {
            req.response().push(HttpMethod.GET, "/pushpath", ar -> {
                this.assertTrue(ar.succeeded());
                HttpServerResponse pushedResp = (HttpServerResponse)ar.result();
                pushedResp.end();
            });
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        HttpClientRequest request = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.complete());
        request.pushHandler(pushReq -> {
            this.complete();
            pushReq.handler(pushResp -> {
                this.assertEquals(reqStreamDependency, pushResp.request().getStreamPriority().getDependency());
                this.assertEquals(reqStreamWeight, pushResp.request().getStreamPriority().getWeight());
                this.complete();
            });
        });
        request.setStreamPriority(new StreamPriority().setDependency(reqStreamDependency).setWeight(reqStreamWeight).setExclusive(false));
        request.end();
        this.await();
    }

    @Test
    public void testClearTextUpgradeWithBody() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer().requestHandler(req -> req.bodyHandler(body -> req.response().end(body)));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2));
        this.client.connectionHandler(conn -> conn.goAwayHandler(ga -> this.assertEquals(0L, ga.getErrorCode())));
        Buffer payload = Buffer.buffer((String)"some-data");
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, this.testAddress, new RequestOptions().setSsl(Boolean.valueOf(false)), response -> response.bodyHandler(body -> {
            this.assertEquals(Buffer.buffer().appendBuffer(payload).appendBuffer(payload), body);
            this.testComplete();
        }));
        req2.putHeader("Content-Length", "" + payload.length() * 2);
        req2.exceptionHandler(this::fail);
        req2.write(payload);
        Thread.sleep(1000L);
        req2.end(payload);
        this.await();
    }

    @Test
    public void testClearTextUpgradeWithBodyTooLongFrameResponse() throws Exception {
        this.server.close();
        Buffer buffer = TestUtils.randomBuffer(1024);
        this.server = this.vertx.createHttpServer().requestHandler(req -> {
            req.response().setChunked(true);
            this.vertx.setPeriodic(1L, id -> req.response().write(buffer));
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2));
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, this.testAddress, new RequestOptions().setSsl(Boolean.valueOf(false)), response -> this.fail());
        req2.setChunked(true);
        req2.exceptionHandler(err -> {
            if (err instanceof TooLongFrameException) {
                this.testComplete();
            }
        });
        req2.sendHead();
        this.await();
    }

    @Test
    public void testSslHandshakeTimeout() throws Exception {
        this.waitFor(2);
        HttpServerOptions opts = this.createBaseServerOptions().setSslHandshakeTimeout(1234L).setSslHandshakeTimeoutUnit(TimeUnit.MILLISECONDS);
        this.server.close();
        this.server = this.vertx.createHttpServer(opts).requestHandler(req -> this.fail("Should not be called")).exceptionHandler(err -> {
            if (err instanceof SSLHandshakeException) {
                this.assertEquals("handshake timed out after 1234ms", err.getMessage());
                this.complete();
            }
        });
        this.startServer();
        this.vertx.createNetClient().connect(8080, "localhost", (Handler)new Handler<AsyncResult<NetSocket>>(){

            public void handle(AsyncResult<NetSocket> event) {
                if (event.failed()) {
                    Http2Test.this.fail(event.cause());
                } else {
                    ((NetSocket)event.result()).closeHandler(u -> Http2Test.this.complete());
                }
            }
        });
        this.await();
    }

    @Test
    public void testAppendToHttpChunks() throws Exception {
        List<String> expected = Arrays.asList("chunk-1", "chunk-2", "chunk-3");
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            expected.forEach(arg_0 -> ((HttpServerResponse)resp).write(arg_0));
            resp.end();
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 4043, "localhost", "some-uri", resp -> {
            ArrayList chunks = new ArrayList();
            resp.handler(chunk -> {
                chunk.appendString("-suffix");
                chunks.add(chunk.toString());
            });
            resp.endHandler(v -> {
                this.assertEquals(Stream.concat(expected.stream(), Stream.of("")).map(s -> s + "-suffix").collect(Collectors.toList()), chunks);
                this.testComplete();
            });
        }).end();
        this.await();
    }
}

