/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.util.AsciiString;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.Http1xTest;
import io.vertx.core.http.Http2Test;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.DetectFileDescriptorLeaks;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.TestUtils;
import io.vertx.test.netty.TestLoggerFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class HttpTest
extends HttpTestBase {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();
    protected File testDir;
    private File tmp;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testDir = this.testFolder.newFolder();
        if (USE_DOMAIN_SOCKETS) {
            this.assertTrue("Native transport not enabled", USE_NATIVE_TRANSPORT);
            this.tmp = TestUtils.tmpFile(".sock");
            this.testAddress = SocketAddress.domainSocketAddress((String)this.tmp.getAbsolutePath());
        }
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions());
    }

    protected HttpServerOptions createBaseServerOptions() {
        return new HttpServerOptions().setPort(8080).setHost("localhost");
    }

    protected HttpClientOptions createBaseClientOptions() {
        return new HttpClientOptions();
    }

    @Test
    public void testClientRequestArguments() throws Exception {
        HttpClientRequest req = this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", this.noOpHandler());
        TestUtils.assertNullPointerException(() -> req.putHeader((String)null, "someValue"));
        TestUtils.assertNullPointerException(() -> req.putHeader((CharSequence)null, (CharSequence)"someValue"));
        TestUtils.assertNullPointerException(() -> req.putHeader("someKey", (Iterable)null));
        TestUtils.assertNullPointerException(() -> req.write((Buffer)null));
        TestUtils.assertNullPointerException(() -> req.write((String)null));
        TestUtils.assertNullPointerException(() -> req.write(null, "UTF-8"));
        TestUtils.assertNullPointerException(() -> req.write("someString", (String)null));
        TestUtils.assertNullPointerException(() -> req.end((Buffer)null));
        TestUtils.assertNullPointerException(() -> req.end((String)null));
        TestUtils.assertNullPointerException(() -> req.end(null, "UTF-8"));
        TestUtils.assertNullPointerException(() -> req.end("someString", (String)null));
        TestUtils.assertIllegalArgumentException(() -> req.setTimeout(0L));
    }

    @Test
    public void testClientChaining() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.PUT, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler());
            this.assertTrue(req.setChunked(true) == req);
            this.assertTrue(req.sendHead() == req);
            this.assertTrue(req.write("foo", "UTF-8") == req);
            this.assertTrue(req.write("foo") == req);
            this.assertTrue(req.write(Buffer.buffer((String)"foo")) == req);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListenSocketAddress() {
        NetClient netClient = this.vertx.createNetClient();
        this.server = this.vertx.createHttpServer().requestHandler(req -> req.response().end());
        SocketAddress sockAddress = SocketAddress.inetSocketAddress((int)8080, (String)"localhost");
        this.server.listen(sockAddress, this.onSuccess(server -> netClient.connect(sockAddress, this.onSuccess(sock -> {
            sock.handler(buf -> {
                this.assertTrue("Response is not an http 200", buf.toString("UTF-8").startsWith("HTTP/1.1 200 OK"));
                this.testComplete();
            });
            sock.write("GET / HTTP/1.1\r\n\r\n");
        }))));
        try {
            this.await();
        }
        finally {
            netClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListenDomainSocketAddress() throws Exception {
        int i;
        Vertx vx = Vertx.vertx((VertxOptions)new VertxOptions().setPreferNativeTransport(true));
        Assume.assumeTrue((String)"Native transport must be enabled", (boolean)vx.isNativeTransportEnabled());
        int len = 3;
        this.waitFor(len * len);
        ArrayList<SocketAddress> addresses = new ArrayList<SocketAddress>();
        for (i = 0; i < len; ++i) {
            File sockFile = TestUtils.tmpFile(".sock");
            SocketAddress sockAddress = SocketAddress.domainSocketAddress((String)sockFile.getAbsolutePath());
            HttpServer server = this.vertx.createHttpServer(this.createBaseServerOptions()).requestHandler(req -> req.response().end(sockAddress.path()));
            this.startServer(sockAddress, server);
            addresses.add(sockAddress);
        }
        for (i = 0; i < len; ++i) {
            SocketAddress sockAddress = (SocketAddress)addresses.get(i);
            for (int j = 0; j < len; ++j) {
                this.client.request(HttpMethod.GET, sockAddress, new RequestOptions().setHost("localhost").setPort(8080).setURI("some-uri"), resp -> {
                    resp.exceptionHandler(this::fail);
                    resp.bodyHandler(body -> {
                        this.assertEquals(sockAddress.path(), body.toString());
                        this.complete();
                    });
                }).exceptionHandler(this::fail).end();
            }
        }
        try {
            this.await();
        }
        finally {
            vx.close();
        }
    }

    @Test
    public void testLowerCaseHeaders() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals("foo", req.headers().get("Foo"));
            this.assertEquals("foo", req.headers().get("foo"));
            this.assertEquals("foo", req.headers().get("fOO"));
            this.assertTrue(req.headers().contains("Foo"));
            this.assertTrue(req.headers().contains("foo"));
            this.assertTrue(req.headers().contains("fOO"));
            req.response().putHeader("Quux", "quux");
            this.assertEquals("quux", req.response().headers().get("Quux"));
            this.assertEquals("quux", req.response().headers().get("quux"));
            this.assertEquals("quux", req.response().headers().get("qUUX"));
            this.assertTrue(req.response().headers().contains("Quux"));
            this.assertTrue(req.response().headers().contains("quux"));
            this.assertTrue(req.response().headers().contains("qUUX"));
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals("quux", resp.headers().get("Quux"));
                this.assertEquals("quux", resp.headers().get("quux"));
                this.assertEquals("quux", resp.headers().get("qUUX"));
                this.assertTrue(resp.headers().contains("Quux"));
                this.assertTrue(resp.headers().contains("quux"));
                this.assertTrue(resp.headers().contains("qUUX"));
                this.testComplete();
            });
            req.putHeader("Foo", "foo");
            this.assertEquals("foo", req.headers().get("Foo"));
            this.assertEquals("foo", req.headers().get("foo"));
            this.assertEquals("foo", req.headers().get("fOO"));
            this.assertTrue(req.headers().contains("Foo"));
            this.assertTrue(req.headers().contains("foo"));
            this.assertTrue(req.headers().contains("fOO"));
            req.end();
        }));
        this.await();
    }

    @Test
    public void testServerActualPortWhenSet() {
        this.server.requestHandler(request -> request.response().end("hello")).listen(ar -> {
            this.assertEquals(((HttpServer)ar.result()).actualPort(), 8080L);
            this.vertx.createHttpClient(this.createBaseClientOptions()).getNow(((HttpServer)ar.result()).actualPort(), "localhost", "/", response -> {
                this.assertEquals(response.statusCode(), 200L);
                response.bodyHandler(body -> {
                    this.assertEquals(body.toString("UTF-8"), "hello");
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testServerActualPortWhenZero() {
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setPort(0).setHost("localhost"));
        this.server.requestHandler(request -> request.response().end("hello")).listen(ar -> {
            this.assertTrue(((HttpServer)ar.result()).actualPort() != 0);
            this.vertx.createHttpClient(this.createBaseClientOptions()).getNow(((HttpServer)ar.result()).actualPort(), "localhost", "/", response -> {
                this.assertEquals(response.statusCode(), 200L);
                response.bodyHandler(body -> {
                    this.assertEquals(body.toString("UTF-8"), "hello");
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testServerActualPortWhenZeroPassedInListen() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions(this.createBaseServerOptions()).setHost("localhost"));
        this.server.requestHandler(request -> request.response().end("hello")).listen(0, ar -> {
            this.assertTrue(((HttpServer)ar.result()).actualPort() != 0);
            this.vertx.createHttpClient(this.createBaseClientOptions()).getNow(((HttpServer)ar.result()).actualPort(), "localhost", "/", response -> {
                this.assertEquals(response.statusCode(), 200L);
                response.bodyHandler(body -> {
                    this.assertEquals(body.toString("UTF-8"), "hello");
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testRequestNPE() {
        String uri = "/some-uri?foo=bar";
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, "localhost", uri, null));
        TestUtils.assertNullPointerException(() -> this.client.request((HttpMethod)null, 8080, "localhost", uri, resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.requestAbs((HttpMethod)null, "http://someuri", resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, "localhost", "/somepath", null));
        TestUtils.assertNullPointerException(() -> this.client.request((HttpMethod)null, 8080, "localhost", "/somepath", resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, null, "/somepath", resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, "localhost", null, resp -> {}));
    }

    @Test
    public void testInvalidAbsoluteURI() {
        try {
            this.client.requestAbs(HttpMethod.GET, "ijdijwidjqwoijd192d192192ej12d", resp -> {}).end();
            this.fail("Should throw exception");
        }
        catch (VertxException vertxException) {
            // empty catch block
        }
    }

    @Test
    public void testPutHeadersOnRequest() {
        this.server.requestHandler(req -> {
            this.assertEquals("bar", req.headers().get("foo"));
            this.assertEquals("bar", req.getHeader("foo"));
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).putHeader("foo", "bar").end()));
        this.await();
    }

    @Test
    public void testPutHeaderReplacesPreviousHeaders() throws Exception {
        this.server.requestHandler(req -> req.response().putHeader("Location", "http://example1.org").putHeader("location", "http://example2.org").end());
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(Collections.singletonList("http://example2.org"), resp.headers().getAll("LocatioN"));
            this.testComplete();
        }).end()));
        this.await();
    }

    @Test
    public void testSimpleGET() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.GET, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePUT() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PUT, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePOST() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.POST, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleDELETE() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.DELETE, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleHEAD() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.HEAD, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleTRACE() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.TRACE, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleCONNECT() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.CONNECT, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleOPTIONS() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.OPTIONS, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePATCH() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PATCH, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleGETAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.GET, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testEmptyPathGETAbsolute() {
        String uri = "";
        this.testSimpleRequest(uri, HttpMethod.GET, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testNoPathButQueryGETAbsolute() {
        String uri = "?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.GET, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePUTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PUT, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePOSTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.POST, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleDELETEAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.DELETE, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleHEADAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.HEAD, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleTRACEAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.TRACE, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleCONNECTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.CONNECT, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleOPTIONSAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.OPTIONS, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePATCHAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PATCH, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    private void testSimpleRequest(String uri, HttpMethod method, Handler<HttpClientResponse> handler) {
        this.testSimpleRequest(uri, method, false, handler);
    }

    private void testSimpleRequest(String uri, HttpMethod method, boolean absolute, Handler<HttpClientResponse> handler) {
        boolean ssl = this instanceof Http2Test;
        HttpClientRequest req = absolute ? this.client.requestAbs(method, this.testAddress, (ssl ? "https://" : "http://") + "localhost" + ":" + 8080 + uri, handler) : this.client.request(method, this.testAddress, 8080, "localhost", uri, handler);
        this.testSimpleRequest(uri, method, req, absolute);
    }

    private void testSimpleRequest(String uri, HttpMethod method, HttpClientRequest request, boolean absolute) {
        String query;
        String path;
        int index = uri.indexOf(63);
        if (index == -1) {
            path = uri;
            query = null;
        } else {
            path = uri.substring(0, index);
            query = uri.substring(index + 1);
        }
        String resource = absolute && path.isEmpty() ? "/" + path : path;
        this.server.requestHandler(req -> {
            String expectedPath = req.method() == HttpMethod.CONNECT && req.version() == HttpVersion.HTTP_2 ? null : resource;
            String expectedQuery = req.method() == HttpMethod.CONNECT && req.version() == HttpVersion.HTTP_2 ? null : query;
            this.assertEquals(expectedPath, req.path());
            this.assertEquals(method, req.method());
            this.assertEquals(expectedQuery, req.query());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> request.end()));
        this.await();
    }

    @Test
    public void testServerChaining() {
        this.server.requestHandler(req -> {
            this.assertTrue(req.response().setChunked(true) == req.response());
            this.assertTrue(req.response().write("foo", "UTF-8") == req.response());
            this.assertTrue(req.response().write("foo") == req.response());
            this.testComplete();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.PUT, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler()).end()));
        this.await();
    }

    @Test
    public void testServerChainingSendFile() throws Exception {
        File file = this.setupFile("test-server-chaining.dat", "blah");
        this.server.requestHandler(req -> {
            this.assertTrue(req.response().sendFile(file.getAbsolutePath(), null) == req.response());
            file.delete();
            this.testComplete();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.PUT, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler()).end()));
        this.await();
    }

    @Test
    public void testResponseEndHandlers1() {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(0L, req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().end();
        }).listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/", res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            this.complete();
        }).end()));
        this.await();
    }

    @Test
    public void testResponseEndHandlers2() {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        String content = "blah";
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(content.length(), req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().end(content);
        }).listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/", res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            res.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)content), buff);
                this.complete();
            });
        }).end()));
        this.await();
    }

    @Test
    public void testResponseEndHandlersChunkedResponse() {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        String chunk = "blah";
        int numChunks = 6;
        StringBuilder content = new StringBuilder(chunk.length() * numChunks);
        IntStream.range(0, numChunks).forEach(i -> content.append(chunk));
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(content.length(), req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().setChunked(true);
            IntStream.range(0, numChunks - 1).forEach(x -> req.response().write(chunk));
            req.response().end(chunk);
        }).listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/", res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            res.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)content.toString()), buff);
                this.complete();
            });
        }).end()));
        this.await();
    }

    @Test
    public void testResponseEndHandlersSendFile() throws Exception {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        String content = "iqdioqwdqwiojqwijdwqd";
        File toSend = this.setupFile("somefile.txt", content);
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(content.length(), req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().sendFile(toSend.getAbsolutePath());
        }).listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/", res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            res.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)content), buff);
                this.complete();
            });
        }).end()));
        this.await();
    }

    @Test
    public void testAbsoluteURI() {
        this.testURIAndPath("http://localhost:8080/this/is/a/path/foo.html", "/this/is/a/path/foo.html");
    }

    @Test
    public void testRelativeURI() {
        this.testURIAndPath("/this/is/a/path/foo.html", "/this/is/a/path/foo.html");
    }

    @Test
    public void testAbsoluteURIWithHttpSchemaInQuery() {
        this.testURIAndPath("http://localhost:8080/correct/path?url=http://localhost:8008/wrong/path", "/correct/path");
    }

    @Test
    public void testRelativeURIWithHttpSchemaInQuery() {
        this.testURIAndPath("/correct/path?url=http://localhost:8008/wrong/path", "/correct/path");
    }

    @Test
    public void testAbsoluteURIEmptyPath() {
        this.testURIAndPath("http://localhost:8080/", "/");
    }

    private void testURIAndPath(String uri, String path) {
        this.server.requestHandler(req -> {
            this.assertEquals(uri, req.uri());
            this.assertEquals(path, req.path());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", uri, resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testParamUmlauteDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("\u00e4\u00fc\u00f6");
    }

    @Test
    public void testParamPlusDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("+");
    }

    @Test
    public void testParamPercentDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("%");
    }

    @Test
    public void testParamSpaceDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding(" ");
    }

    @Test
    public void testParamNormalDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("hello");
    }

    @Test
    public void testParamAltogetherDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("\u00e4\u00fc\u00f6+% hello");
    }

    private void testParamDecoding(String value) throws UnsupportedEncodingException {
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            req.endHandler(v -> {
                MultiMap formAttributes = req.formAttributes();
                this.assertEquals(value, formAttributes.get("param"));
            });
            req.response().end();
        });
        String postData = "param=" + URLEncoder.encode(value, "UTF-8");
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "/", resp -> this.testComplete()).putHeader(HttpHeaders.CONTENT_TYPE, HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED).putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(postData.length())).handler(resp -> this.testComplete()).write(postData).end()));
        this.await();
    }

    @Test
    public void testParamsAmpersand() {
        this.testParams('&');
    }

    @Test
    public void testParamsSemiColon() {
        this.testParams(';');
    }

    private void testParams(char delim) {
        Map<String, String> params = HttpTest.genMap(10);
        String query = HttpTest.generateQueryString(params, delim);
        this.server.requestHandler(req -> {
            this.assertEquals(query, req.query());
            this.assertEquals(params.size(), req.params().size());
            for (Map.Entry entry : req.params()) {
                this.assertEquals(entry.getValue(), params.get(entry.getKey()));
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri/?" + query, resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testNoParams() {
        this.server.requestHandler(req -> {
            this.assertNull(req.query());
            this.assertTrue(req.params().isEmpty());
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testMissingContentTypeMultipartRequest() throws Exception {
        this.testInvalidMultipartRequest(null, HttpMethod.POST);
    }

    @Test
    public void testInvalidContentTypeMultipartRequest() throws Exception {
        this.testInvalidMultipartRequest("application/json", HttpMethod.POST);
    }

    @Test
    public void testInvalidMethodMultipartRequest() throws Exception {
        this.testInvalidMultipartRequest("multipart/form-data", HttpMethod.GET);
    }

    private void testInvalidMultipartRequest(String contentType, HttpMethod method) throws Exception {
        this.server.requestHandler(req -> {
            try {
                req.setExpectMultipart(true);
                this.fail();
            }
            catch (IllegalStateException ignore) {
                req.response().end();
            }
        });
        this.startServer(this.testAddress);
        HttpClientRequest request = this.client.request(method, this.testAddress, 8080, "localhost", "/", resp -> this.testComplete());
        if (contentType != null) {
            request.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
        }
        request.end("param=hello");
        this.await();
    }

    @Test
    public void testAttributeSizeOverflow() {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setMaxFormAttributeSize(9));
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                AtomicReference err = new AtomicReference();
                req.setExpectMultipart(true).exceptionHandler(err::set).endHandler(v -> {
                    this.assertNotNull(err.get());
                    this.assertTrue(err.get() instanceof DecoderException);
                    this.assertTrue(((Throwable)err.get()).getMessage().contains("Size exceed allowed maximum capacity"));
                    this.assertEquals(0L, req.formAttributes().size());
                    req.response().end();
                });
            }
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            Buffer buffer = Buffer.buffer();
            buffer.appendString("origin=0123456789");
            HttpClientRequest req = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "/form", resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            });
            req.putHeader("content-length", String.valueOf(buffer.length())).putHeader("content-type", "application/x-www-form-urlencoded").end(buffer);
        }));
        this.await();
    }

    @Test
    public void testDefaultRequestHeaders() {
        this.server.requestHandler(req -> {
            if (req.version() == HttpVersion.HTTP_1_1) {
                this.assertEquals(1L, req.headers().size());
                this.assertEquals("localhost:8080", req.headers().get("host"));
            } else {
                this.assertEquals(0L, req.headers().size());
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testRequestHeadersWithCharSequence() {
        HashMap<CharSequence, String> expectedHeaders = new HashMap<CharSequence, String>();
        expectedHeaders.put(HttpHeaders.TEXT_HTML, "text/html");
        expectedHeaders.put(HttpHeaders.USER_AGENT, "User-Agent");
        expectedHeaders.put(HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED, "application/x-www-form-urlencoded");
        this.server.requestHandler(req -> {
            MultiMap headers = req.headers();
            headers.remove("host");
            this.assertEquals(expectedHeaders.size(), headers.size());
            expectedHeaders.forEach((k, v) -> this.assertEquals(v, headers.get(k)));
            expectedHeaders.forEach((k, v) -> this.assertEquals(v, req.getHeader(k)));
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.testComplete());
            expectedHeaders.forEach((k, v) -> req.headers().add(k, (CharSequence)v));
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestHeadersPutAll() {
        this.testRequestHeaders(false);
    }

    @Test
    public void testRequestHeadersIndividually() {
        this.testRequestHeaders(true);
    }

    private void testRequestHeaders(boolean individually) {
        MultiMap expectedHeaders = HttpTest.getHeaders(10);
        this.server.requestHandler(req -> {
            MultiMap headers = req.headers();
            headers.remove("host");
            this.assertEquals(expectedHeaders.size(), expectedHeaders.size());
            for (Map.Entry entry : expectedHeaders) {
                this.assertEquals(entry.getValue(), req.headers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), req.getHeader((String)entry.getKey()));
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.testComplete());
            if (individually) {
                for (Map.Entry header : expectedHeaders) {
                    req.headers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.headers().setAll(expectedHeaders);
            }
            req.end();
        }));
        this.await();
    }

    @Test
    public void testResponseHeadersPutAll() {
        this.testResponseHeaders(false);
    }

    @Test
    public void testResponseHeadersIndividually() {
        this.testResponseHeaders(true);
    }

    private void testResponseHeaders(boolean individually) {
        MultiMap headers = HttpTest.getHeaders(10);
        this.server.requestHandler(req -> {
            if (individually) {
                for (Map.Entry header : headers) {
                    req.response().headers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.response().headers().setAll(headers);
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertTrue(headers.size() < resp.headers().size());
            for (Map.Entry entry : headers) {
                this.assertEquals(entry.getValue(), resp.headers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), resp.getHeader((String)entry.getKey()));
            }
            this.testComplete();
        }).end()));
        this.await();
    }

    @Test
    public void testResponseHeadersWithCharSequence() {
        HashMap<AsciiString, String> headers = new HashMap<AsciiString, String>();
        headers.put(HttpHeaderNames.CONTENT_TYPE, "text/html; charset=utf-8");
        headers.put(HttpHeaderNames.CONTENT_ENCODING, "gzip");
        headers.put(HttpHeaderNames.USER_AGENT, "Mozilla/5.0");
        this.server.requestHandler(req -> {
            headers.forEach((k, v) -> req.response().headers().add(k, (CharSequence)v));
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertTrue(headers.size() < resp.headers().size());
            headers.forEach((k, v) -> this.assertEquals(v, resp.headers().get(k)));
            headers.forEach((k, v) -> this.assertEquals(v, resp.getHeader(k)));
            this.testComplete();
        }).end()));
        this.await();
    }

    @Test
    public void testResponseMultipleSetCookieInHeader() {
        this.testResponseMultipleSetCookie(true, false);
    }

    @Test
    public void testResponseMultipleSetCookieInTrailer() {
        this.testResponseMultipleSetCookie(false, true);
    }

    @Test
    public void testResponseMultipleSetCookieInHeaderAndTrailer() {
        this.testResponseMultipleSetCookie(true, true);
    }

    private void testResponseMultipleSetCookie(boolean inHeader, boolean inTrailer) {
        ArrayList cookies = new ArrayList();
        this.server.requestHandler(req -> {
            if (inHeader) {
                ArrayList<String> headers = new ArrayList<String>();
                headers.add("h1=h1v1");
                headers.add("h2=h2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT");
                cookies.addAll(headers);
                req.response().headers().set("Set-Cookie", headers);
            }
            if (inTrailer) {
                req.response().setChunked(true);
                ArrayList<String> trailers = new ArrayList<String>();
                trailers.add("t1=t1v1");
                trailers.add("t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT");
                cookies.addAll(trailers);
                req.response().trailers().set("Set-Cookie", trailers);
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
            this.assertEquals(cookies.size(), resp.cookies().size());
            for (int i = 0; i < cookies.size(); ++i) {
                this.assertEquals(cookies.get(i), resp.cookies().get(i));
            }
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testUseRequestAfterComplete() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler());
            req.end();
            Buffer buff = Buffer.buffer();
            TestUtils.assertIllegalStateException(() -> req.end());
            TestUtils.assertIllegalStateException(() -> req.continueHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> req.drainHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> req.end("foo"));
            TestUtils.assertIllegalStateException(() -> req.end(buff));
            TestUtils.assertIllegalStateException(() -> req.end("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> req.sendHead());
            TestUtils.assertIllegalStateException(() -> req.setChunked(false));
            TestUtils.assertIllegalStateException(() -> req.setWriteQueueMaxSize(123));
            TestUtils.assertIllegalStateException(() -> req.write(buff));
            TestUtils.assertIllegalStateException(() -> req.write("foo"));
            TestUtils.assertIllegalStateException(() -> req.write("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> req.write(buff));
            TestUtils.assertIllegalStateException(() -> req.writeQueueFull());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testRequestBodyBufferAtEnd() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals(body, buffer);
            req.response().end();
        }));
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "some-uri", resp -> this.testComplete()).end(body)));
        this.await();
    }

    @Test
    public void testRequestBodyStringDefaultEncodingAtEnd() {
        this.testRequestBodyStringAtEnd(null);
    }

    @Test
    public void testRequestBodyStringUTF8AtEnd() {
        this.testRequestBodyStringAtEnd("UTF-8");
    }

    @Test
    public void testRequestBodyStringUTF16AtEnd() {
        this.testRequestBodyStringAtEnd("UTF-16");
    }

    private void testRequestBodyStringAtEnd(String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals(bodyBuff, buffer);
            this.testComplete();
        }));
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler());
            if (encoding == null) {
                req.end(body);
            } else {
                req.end(body, encoding);
            }
        }));
        this.await();
    }

    @Test
    public void testRequestBodyWriteChunked() {
        this.testRequestBodyWrite(true);
    }

    @Test
    public void testRequestBodyWriteNonChunked() {
        this.testRequestBodyWrite(false);
    }

    private void testRequestBodyWrite(boolean chunked) {
        Buffer body = Buffer.buffer();
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals(body, buffer);
            req.response().end();
        }));
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "some-uri", resp -> this.testComplete());
            int numWrites = 10;
            int chunkSize = 100;
            if (chunked) {
                req.setChunked(true);
            } else {
                req.headers().set("Content-Length", String.valueOf(numWrites * chunkSize));
            }
            for (int i = 0; i < numWrites; ++i) {
                Buffer b = TestUtils.randomBuffer(chunkSize);
                body.appendBuffer(b);
                req.write(b);
            }
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestBodyWriteStringChunkedDefaultEncoding() {
        this.testRequestBodyWriteString(true, null);
    }

    @Test
    public void testRequestBodyWriteStringChunkedUTF8() {
        this.testRequestBodyWriteString(true, "UTF-8");
    }

    @Test
    public void testRequestBodyWriteStringChunkedUTF16() {
        this.testRequestBodyWriteString(true, "UTF-16");
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedDefaultEncoding() {
        this.testRequestBodyWriteString(false, null);
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedUTF8() {
        this.testRequestBodyWriteString(false, "UTF-8");
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedUTF16() {
        this.testRequestBodyWriteString(false, "UTF-16");
    }

    private void testRequestBodyWriteString(boolean chunked, String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> req.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        }));
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler());
            if (chunked) {
                req.setChunked(true);
            } else {
                req.headers().set("Content-Length", String.valueOf(bodyBuff.length()));
            }
            if (encoding == null) {
                req.write(body);
            } else {
                req.write(body, encoding);
            }
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestWrite() {
        int times = 3;
        Buffer chunk = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.bodyHandler(buff -> {
            Buffer expected = Buffer.buffer();
            for (int i = 0; i < times; ++i) {
                expected.appendBuffer(chunk);
            }
            this.assertEquals(expected, buff);
            this.testComplete();
        }));
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler());
            req.setChunked(true);
            int padding = 5;
            for (int i = 0; i < times; ++i) {
                Buffer paddedChunk = TestUtils.leftPad(padding, chunk);
                this.assertEquals(paddedChunk.getByteBuf().readerIndex(), padding);
                req.write(paddedChunk);
            }
            req.end();
        }));
        this.await();
    }

    @Test
    public void testConnectWithoutResponseHandler() throws Exception {
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end("whatever");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end("whatever", "UTF-8");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end(Buffer.buffer((String)"whatever"));
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").sendHead();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").write(Buffer.buffer((String)"whatever"));
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").write("whatever");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").write("whatever", "UTF-8");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testClientExceptionHandlerCalledWhenFailingToConnect() {
        this.waitFor(1);
        this.client.request(HttpMethod.GET, this.testAddress, 9998, "255.255.255.255", "some-uri", resp -> this.fail()).exceptionHandler(error -> this.complete()).end();
        this.await();
    }

    @Test
    public void testClientExceptionHandlerCalledWhenServerTerminatesConnection() throws Exception {
        int numReqs = 10;
        this.waitFor(numReqs);
        this.server.requestHandler(request -> request.response().close()).listen(this.testAddress, this.onSuccess(s -> {
            for (int i = 0; i < numReqs; ++i) {
                this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.fail("Connect should not be called")).exceptionHandler(error -> this.complete()).endHandler(done -> this.fail()).end();
            }
        }));
        this.await();
    }

    @Test
    public void testClientExceptionHandlerCalledWhenServerTerminatesConnectionAfterPartialResponse() throws Exception {
        this.server.requestHandler(request -> request.response().setChunked(true).write("foo").close()).listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.exceptionHandler(t -> this.testComplete())).exceptionHandler(error -> this.fail()).end()));
        this.await();
    }

    @Test
    public void testClientExceptionHandlerCalledWhenExceptionOnDataHandler() throws Exception {
        this.server.requestHandler(request -> request.response().end("foo")).listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            RuntimeException cause = new RuntimeException("should be caught");
            resp.exceptionHandler(err -> {
                if (err == cause) {
                    this.testComplete();
                }
            });
            resp.handler(data -> {
                throw new RuntimeException("should be caught");
            });
            resp.exceptionHandler(t -> this.testComplete());
        }).exceptionHandler(error -> this.fail()).end()));
        this.await();
    }

    @Test
    public void testClientExceptionHandlerCalledWhenExceptionOnBodyHandler() throws Exception {
        this.server.requestHandler(request -> request.response().end("foo")).listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            RuntimeException cause = new RuntimeException("should be caught");
            resp.exceptionHandler(err -> {
                if (err == cause) {
                    this.testComplete();
                }
            });
            resp.bodyHandler(data -> {
                throw new RuntimeException("should be caught");
            });
            resp.exceptionHandler(t -> this.testComplete());
        }).exceptionHandler(error -> this.fail()).end()));
        this.await();
    }

    @Test
    public void testNoExceptionHandlerCalledWhenResponseEnded() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            req.exceptionHandler(this::fail);
            resp.exceptionHandler(err -> this.fail((Throwable)err));
            resp.end();
        }).listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            resp.endHandler(v -> this.vertx.setTimer(100L, tid -> this.testComplete()));
            resp.exceptionHandler(t -> this.fail("Should not be called"));
        }).exceptionHandler(t -> this.fail("Should not be called")).end()));
        this.await();
    }

    @Test
    public void testServerExceptionHandlerOnClose() {
        this.waitFor(3);
        this.vertx.createHttpServer().requestHandler(req -> {
            HttpServerResponse resp = req.response();
            AtomicInteger reqExceptionHandlerCount = new AtomicInteger();
            AtomicInteger respExceptionHandlerCount = new AtomicInteger();
            AtomicInteger respEndHandlerCount = new AtomicInteger();
            req.exceptionHandler(err -> {
                this.assertEquals(1L, reqExceptionHandlerCount.incrementAndGet());
                this.assertEquals(1L, respExceptionHandlerCount.get());
                this.assertEquals(1L, respEndHandlerCount.get());
                this.assertTrue(resp.closed());
                this.assertFalse(resp.ended());
                try {
                    resp.end();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
            resp.exceptionHandler(err -> {
                this.assertEquals(0L, reqExceptionHandlerCount.get());
                this.assertEquals(1L, respExceptionHandlerCount.incrementAndGet());
                this.assertEquals(0L, respEndHandlerCount.get());
                this.complete();
            });
            resp.endHandler(v -> {
                this.assertEquals(0L, reqExceptionHandlerCount.get());
                this.assertEquals(1L, respExceptionHandlerCount.get());
                this.assertEquals(1L, respEndHandlerCount.incrementAndGet());
                this.complete();
            });
            req.connection().closeHandler(v -> {
                this.assertEquals(1L, reqExceptionHandlerCount.get());
                this.assertEquals(1L, respExceptionHandlerCount.get());
                this.assertEquals(1L, respEndHandlerCount.get());
                this.complete();
            });
        }).listen(this.testAddress, ar -> {
            HttpClient client = this.vertx.createHttpClient();
            HttpClientRequest req = client.request(HttpMethod.PUT, this.testAddress, 8080, "localhost", "/somerui", handler -> {}).setChunked(true);
            req.sendHead(v -> req.connection().close());
        });
        this.await();
    }

    @Test
    public void testClientRequestExceptionHandlerCalledWhenConnectionClosed() throws Exception {
        this.server.requestHandler(req -> req.handler(buff -> req.connection().close()));
        this.startServer();
        HttpClientRequest req2 = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "/somepath", resp -> resp.handler(chunk -> resp.request().connection().close())).setChunked(true);
        req2.exceptionHandler(err -> this.testComplete());
        req2.write("chunk");
        this.await();
    }

    @Test
    public void testClientResponseExceptionHandlerCalledWhenConnectionClosed() throws Exception {
        AtomicReference conn = new AtomicReference();
        this.server.requestHandler(req -> {
            conn.set(req.connection());
            req.response().setChunked(true).write("chunk");
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> {
            resp.handler(buff -> ((HttpConnection)conn.get()).close());
            resp.exceptionHandler(err -> this.testComplete());
        }).end();
        this.await();
    }

    @Test
    public void testClientRequestExceptionHandlerCalledWhenRequestEnded() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.connection().close());
        this.startServer(this.testAddress);
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> this.fail());
        req2.exceptionHandler(err -> this.complete());
        req2.end();
        try {
            req2.exceptionHandler(err -> this.fail());
            this.fail();
        }
        catch (Exception e) {
            this.complete();
        }
        this.await();
    }

    @Test
    public void testDefaultStatus() {
        this.testStatusCode(-1, null);
    }

    @Test
    public void testDefaultOther() {
        this.testStatusCode(405, null);
    }

    @Test
    public void testOverrideStatusMessage() {
        this.testStatusCode(404, "some message");
    }

    @Test
    public void testOverrideDefaultStatusMessage() {
        this.testStatusCode(-1, "some other message");
    }

    private void testStatusCode(int code, String statusMessage) {
        this.server.requestHandler(req -> {
            if (code != -1) {
                req.response().setStatusCode(code);
            }
            if (statusMessage != null) {
                req.response().setStatusMessage(statusMessage);
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            int theCode;
            if (code == -1) {
                this.assertEquals(200L, resp.statusCode());
                theCode = 200;
            } else {
                theCode = code;
            }
            if (statusMessage != null && resp.version() != HttpVersion.HTTP_2) {
                this.assertEquals(statusMessage, resp.statusMessage());
            } else {
                this.assertEquals(HttpResponseStatus.valueOf((int)theCode).reasonPhrase(), resp.statusMessage());
            }
            this.testComplete();
        }).end()));
        this.await();
    }

    @Test
    public void testResponseTrailersPutAll() {
        this.testResponseTrailers(false);
    }

    @Test
    public void testResponseTrailersPutIndividually() {
        this.testResponseTrailers(true);
    }

    private void testResponseTrailers(boolean individually) {
        MultiMap trailers = HttpTest.getHeaders(10);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            if (individually) {
                for (Map.Entry header : trailers) {
                    req.response().trailers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.response().trailers().setAll(trailers);
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
            this.assertEquals(trailers.size(), resp.trailers().size());
            for (Map.Entry entry : trailers) {
                this.assertEquals(entry.getValue(), resp.trailers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), resp.getTrailer((String)entry.getKey()));
            }
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseNoTrailers() {
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
            this.assertTrue(resp.trailers().isEmpty());
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testUseAfterServerResponseHeadSent() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)"128");
            resp.write("01234567");
            this.assertTrue(resp.headWritten());
            TestUtils.assertIllegalStateException(() -> resp.setChunked(false));
            TestUtils.assertIllegalStateException(() -> resp.setStatusCode(200));
            TestUtils.assertIllegalStateException(() -> resp.setStatusMessage("OK"));
            TestUtils.assertIllegalStateException(() -> resp.putHeader("foo", "bar"));
            TestUtils.assertIllegalStateException(() -> resp.addCookie(Cookie.cookie((String)"the_cookie", (String)"wibble")));
            TestUtils.assertIllegalStateException(() -> resp.removeCookie("the_cookie"));
            this.testComplete();
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler()).end();
        this.await();
    }

    @Test
    public void testUseAfterServerResponseSent() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            this.assertFalse(resp.ended());
            resp.end();
            this.assertTrue(resp.ended());
            Buffer buff = Buffer.buffer();
            TestUtils.assertIllegalStateException(() -> resp.drainHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> resp.exceptionHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> resp.setChunked(false));
            TestUtils.assertIllegalStateException(() -> resp.setWriteQueueMaxSize(123));
            TestUtils.assertIllegalStateException(() -> resp.writeQueueFull());
            TestUtils.assertIllegalStateException(() -> resp.putHeader("foo", "bar"));
            TestUtils.assertIllegalStateException(() -> resp.sendFile("webroot/somefile.html"));
            TestUtils.assertIllegalStateException(() -> resp.end());
            TestUtils.assertIllegalStateException(() -> resp.end("foo"));
            TestUtils.assertIllegalStateException(() -> resp.end(buff));
            TestUtils.assertIllegalStateException(() -> resp.end("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> resp.write(buff));
            TestUtils.assertIllegalStateException(() -> resp.write("foo"));
            TestUtils.assertIllegalStateException(() -> resp.write("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> resp.write(buff));
            TestUtils.assertIllegalStateException(() -> resp.sendFile("webroot/somefile.html", ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.end(ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.end("foo", ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.end(buff, ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.end("foo", "UTF-8", ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.write(buff, ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.write("foo", ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.write("foo", "UTF-8", ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.write(buff, ar -> {}));
            this.testComplete();
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler()).end();
        this.await();
    }

    @Test
    public void testResponseBodyBufferAtEnd() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.response().end(body));
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseBodyWriteChunked() {
        this.testResponseBodyWrite(true);
    }

    @Test
    public void testResponseBodyWriteNonChunked() {
        this.testResponseBodyWrite(false);
    }

    private void testResponseBodyWrite(boolean chunked) {
        Buffer body = Buffer.buffer();
        int numWrites = 10;
        int chunkSize = 100;
        this.server.requestHandler(req -> {
            this.assertFalse(req.response().headWritten());
            if (chunked) {
                req.response().setChunked(true);
            } else {
                req.response().headers().set("Content-Length", String.valueOf(numWrites * chunkSize));
            }
            this.assertFalse(req.response().headWritten());
            for (int i = 0; i < numWrites; ++i) {
                Buffer b = TestUtils.randomBuffer(chunkSize);
                body.appendBuffer(b);
                req.response().write(b);
                this.assertTrue(req.response().headWritten());
            }
            req.response().end();
            this.assertTrue(req.response().headWritten());
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseBodyWriteStringChunkedDefaultEncoding() {
        this.testResponseBodyWriteString(true, null);
    }

    @Test
    public void testResponseBodyWriteStringChunkedUTF8() {
        this.testResponseBodyWriteString(true, "UTF-8");
    }

    @Test
    public void testResponseBodyWriteStringChunkedUTF16() {
        this.testResponseBodyWriteString(true, "UTF-16");
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedDefaultEncoding() {
        this.testResponseBodyWriteString(false, null);
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedUTF8() {
        this.testResponseBodyWriteString(false, "UTF-8");
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedUTF16() {
        this.testResponseBodyWriteString(false, "UTF-16");
    }

    private void testResponseBodyWriteString(boolean chunked, String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> {
            if (chunked) {
                req.response().setChunked(true);
            } else {
                req.response().headers().set("Content-Length", String.valueOf(bodyBuff.length()));
            }
            if (encoding == null) {
                req.response().write(body);
            } else {
                req.response().write(body, encoding);
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseWrite() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().write(body);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    @DetectFileDescriptorLeaks
    public void testSendFile() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        this.sendFile("test-send-file.html", content, false, handler -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", handler));
    }

    @Test
    public void testSendFileWithHandler() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        this.sendFile("test-send-file.html", content, true, handler -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", handler));
    }

    protected void sendFile(String fileName, String contentExpected, boolean useHandler, Function<Handler<HttpClientResponse>, HttpClientRequest> requestFact) throws Exception {
        this.waitFor(2);
        File fileToSend = this.setupFile(fileName, contentExpected);
        this.server.requestHandler(req -> {
            if (useHandler) {
                Handler<AsyncResult<Void>> completionHandler = this.onSuccess(v -> this.complete());
                req.response().sendFile(fileToSend.getAbsolutePath(), completionHandler);
            } else {
                req.response().sendFile(fileToSend.getAbsolutePath());
                this.complete();
            }
        });
        this.startServer(this.testAddress);
        requestFact.apply((Handler<HttpClientResponse>)((Handler)resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("text/html", resp.headers().get("Content-Type"));
            resp.exceptionHandler(this::fail);
            resp.bodyHandler(buff -> {
                this.assertEquals(contentExpected, buff.toString());
                this.assertEquals(fileToSend.length(), Long.parseLong(resp.headers().get("content-length")));
                this.complete();
            });
        })).exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testSendNonExistingFile() throws Exception {
        this.server.requestHandler(req -> {
            Context ctx = this.vertx.getOrCreateContext();
            req.response().sendFile("/not/existing/path", event -> {
                this.assertEquals(ctx, this.vertx.getOrCreateContext());
                if (event.failed()) {
                    req.response().end("failed");
                }
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals("failed", buff.toString());
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testSendFileOverrideHeaders() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        File file = this.setupFile("test-send-file.html", content);
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile(file.getAbsolutePath());
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(file.length(), Long.parseLong(resp.headers().get("content-length")));
            this.assertEquals("wibble", resp.headers().get("content-type"));
            resp.bodyHandler(buff -> {
                this.assertEquals(content, buff.toString());
                file.delete();
                this.testComplete();
            });
        }).end()));
        this.await();
    }

    @Test
    public void testSendFileNotFound() throws Exception {
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile("nosuchfile.html");
        });
        this.server.listen(this.onSuccess(s -> {
            this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.fail("Should not receive response")).end();
            this.vertx.setTimer(100L, tid -> this.testComplete());
        }));
        this.await();
    }

    @Test
    public void testSendFileNotFoundWithHandler() throws Exception {
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile("nosuchfile.html", this.onFailure(t -> {
                this.assertTrue(t instanceof FileNotFoundException);
                this.testComplete();
            }));
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.fail("Should not receive response")).end()));
        this.await();
    }

    @Test
    public void testSendFileDirectoryWithHandler() throws Exception {
        File dir = this.testFolder.newFolder();
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile(dir.getAbsolutePath(), this.onFailure(t -> {
                this.assertTrue(t instanceof FileNotFoundException);
                this.testComplete();
            }));
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.fail("Should not receive response")).end()));
        this.await();
    }

    @Test
    public void testSendOpenRangeFileFromClasspath() {
        this.server.requestHandler(res -> res.response().sendFile("webroot/somefile.html", 6L)).listen(this.testAddress, this.onSuccess(res -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertTrue(buff.toString().startsWith("<body>blah</body></html>"));
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testSendRangeFileFromClasspath() {
        this.server.requestHandler(res -> res.response().sendFile("webroot/somefile.html", 6L, 6L)).listen(this.testAddress, this.onSuccess(res -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals("<body>", buff.toString());
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void test100ContinueHandledAutomatically() {
        Buffer toSend = TestUtils.randomBuffer(1000);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setHandle100ContinueAutomatically(true));
        this.server.requestHandler(req -> req.bodyHandler(data -> {
            this.assertEquals(toSend, data);
            req.response().end();
        }));
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.PUT, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete()));
            req.headers().set("Expect", "100-continue");
            req.setChunked(true);
            req.continueHandler(v -> {
                req.write(toSend);
                req.end();
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void test100ContinueHandledManually() {
        Buffer toSend = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> {
            this.assertEquals("100-continue", req.getHeader("expect"));
            req.response().writeContinue();
            req.bodyHandler(data -> {
                this.assertEquals(toSend, data);
                req.response().end();
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.PUT, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete()));
            req.headers().set("Expect", "100-continue");
            req.setChunked(true);
            req.continueHandler(v -> {
                req.write(toSend);
                req.end();
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void test100ContinueRejectedManually() {
        this.server.requestHandler(req -> {
            req.response().setStatusCode(405).end();
            req.bodyHandler(data -> this.fail("body should not be received"));
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.PUT, this.testAddress, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals(405L, resp.statusCode());
                this.testComplete();
            });
            req.headers().set("Expect", "100-continue");
            req.setChunked(true);
            req.continueHandler(v -> this.fail("should not be called"));
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void test100ContinueTimeout() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().writeContinue());
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setIdleTimeout(1));
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.PUT, this.testAddress, 8080, "localhost", "some-uri", resp -> this.fail()).exceptionHandler(err -> this.complete()).putHeader("Expect", "100-continue").continueHandler(v -> this.complete()).end();
        this.await();
    }

    @Test
    public void testClientDrainHandler() {
        this.pausingServer(resumeFuture -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler());
            req.setChunked(true);
            this.assertFalse(req.writeQueueFull());
            req.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                req.write(buff);
                if (req.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    req.drainHandler(v -> {
                        this.assertFalse(req.writeQueueFull());
                        this.testComplete();
                    });
                    resumeFuture.complete();
                }
            });
        });
        this.await();
    }

    @Test
    public void testClientRequestExceptionHandlerCalledWhenExceptionOnDrainHandler() {
        this.pausingServer(resumeFuture -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler());
            req.setChunked(true);
            this.assertFalse(req.writeQueueFull());
            req.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            AtomicBoolean failed = new AtomicBoolean();
            this.vertx.setPeriodic(1L, id -> {
                req.write(buff);
                if (req.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    req.drainHandler(v -> {
                        throw new RuntimeException("error");
                    }).exceptionHandler(t -> {
                        if (failed.compareAndSet(false, true)) {
                            this.testComplete();
                        }
                    });
                    resumeFuture.complete();
                }
            });
        });
        this.await();
    }

    private void pausingServer(Consumer<Promise<Void>> consumer) {
        Promise resumeFuture = Promise.promise();
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.pause();
            Context ctx = this.vertx.getOrCreateContext();
            resumeFuture.future().onComplete(v1 -> ctx.runOnContext(v2 -> req.resume()));
            req.handler(buff -> req.response().write(buff));
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> consumer.accept(resumeFuture)));
    }

    @Test
    public void testServerDrainHandler() {
        this.drainingServer(resumeFuture -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            resp.pause();
            resumeFuture.onComplete(ar -> resp.resume());
        }).end());
        this.await();
    }

    private void drainingServer(Consumer<Future<Void>> consumer) {
        Promise resumeFuture = Promise.promise();
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            this.assertFalse(req.response().writeQueueFull());
            req.response().setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                req.response().write(buff);
                if (req.response().writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    req.response().drainHandler(v -> {
                        this.assertFalse(req.response().writeQueueFull());
                        this.testComplete();
                    });
                    resumeFuture.complete();
                }
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> consumer.accept(resumeFuture.future())));
    }

    @Test
    public void testConnectionErrorsGetReportedToRequest() throws InterruptedException {
        AtomicInteger req1Exceptions = new AtomicInteger();
        AtomicInteger req2Exceptions = new AtomicInteger();
        AtomicInteger req3Exceptions = new AtomicInteger();
        CountDownLatch latch = new CountDownLatch(3);
        HttpClientRequest req1 = this.client.request(HttpMethod.GET, this.testAddress, 9998, "localhost", "someurl1", resp -> this.fail("Should never get a response on a bad port, if you see this message than you are running an http server on port 9998"));
        req1.exceptionHandler(t -> {
            this.assertEquals("More than one call to req1 exception handler was not expected", 1L, req1Exceptions.incrementAndGet());
            latch.countDown();
        });
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, this.testAddress, 9998, "localhost", "someurl2", resp -> this.fail("Should never get a response on a bad port, if you see this message than you are running an http server on port 9998"));
        req2.exceptionHandler(t -> {
            this.assertEquals("More than one call to req2 exception handler was not expected", 1L, req2Exceptions.incrementAndGet());
            latch.countDown();
        });
        HttpClientRequest req3 = this.client.request(HttpMethod.GET, this.testAddress, 9998, "localhost", "someurl2", resp -> this.fail("Should never get a response on a bad port, if you see this message than you are running an http server on port 9998"));
        req3.exceptionHandler(t -> {
            this.assertEquals("More than one call to req2 exception handler was not expected", 1L, req3Exceptions.incrementAndGet());
            latch.countDown();
        });
        req1.end();
        req2.end();
        req3.end();
        this.awaitLatch(latch);
        this.testComplete();
    }

    @Test
    public void testRequestTimesoutWhenIndicatedPeriodExpiresWithoutAResponseFromRemoteServer() {
        this.server.requestHandler(this.noOpHandler());
        AtomicBoolean failed = new AtomicBoolean();
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.fail("End should not be called because the request should timeout"));
            req.exceptionHandler(t -> {
                if (failed.compareAndSet(false, true)) {
                    this.assertTrue("Expected to end with timeout exception but ended with other exception: " + t, t instanceof TimeoutException);
                    this.testComplete();
                }
            });
            req.setTimeout(1000L);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestTimeoutCanceledWhenRequestHasAnOtherError() {
        AtomicReference exception = new AtomicReference();
        HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("End should not be called because the request should fail to connect"));
        req.exceptionHandler(exception::set);
        req.setTimeout(800L);
        req.end();
        this.vertx.setTimer(1500L, id -> {
            this.assertNotNull("Expected an exception to be set", exception.get());
            this.assertFalse("Expected to not end with timeout exception, but did: " + exception.get(), exception.get() instanceof TimeoutException);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testRequestTimeoutCanceledWhenRequestEndsNormally() {
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            AtomicReference exception = new AtomicReference();
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", this.noOpHandler());
            req.exceptionHandler(exception::set);
            req.setTimeout(500L);
            req.end();
            this.vertx.setTimer(1000L, id -> {
                this.assertNull("Did not expect any exception", exception.get());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testHttpClientRequestTimeoutResetsTheConnection() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            AtomicBoolean errored = new AtomicBoolean();
            req.exceptionHandler(err -> {
                if (errored.compareAndSet(false, true)) {
                    this.complete();
                }
            });
        });
        this.startServer(this.testAddress);
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.fail("Response should not be handled"));
        req2.exceptionHandler(err -> this.complete());
        CountDownLatch latch = new CountDownLatch(1);
        req2.sendHead(version -> latch.countDown());
        this.awaitLatch(latch);
        req2.setTimeout(100L);
        this.await();
    }

    @Test
    public void testLazyTimeout() throws Exception {
        this.server.requestHandler(req -> {});
        this.startServer(this.testAddress);
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.fail("Response should not be handled"));
        req2.setTimeout(1L);
        Thread.sleep(5L);
        req2.exceptionHandler(err -> {
            if (err instanceof TimeoutException) {
                this.testComplete();
            }
        });
        req2.sendHead();
        this.await();
    }

    @Test
    public void testConnectInvalidPort() {
        this.client.request(HttpMethod.GET, 9998, "localhost", "some-uri", resp -> this.fail()).exceptionHandler(t -> this.complete()).end();
        this.await();
    }

    @Test
    public void testConnectInvalidHost() {
        this.client.request(HttpMethod.GET, 9998, "255.255.255.255", "some-uri", resp -> this.fail()).exceptionHandler(t -> this.complete()).end();
        this.await();
    }

    @Test
    public void testSetHandlersAfterListening() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            TestUtils.assertIllegalStateException(() -> this.server.requestHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> this.server.websocketHandler(this.noOpHandler()));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetHandlersAfterListening2() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.testAddress, this.onSuccess(v -> this.testComplete()));
        TestUtils.assertIllegalStateException(() -> this.server.requestHandler(this.noOpHandler()));
        TestUtils.assertIllegalStateException(() -> this.server.websocketHandler(this.noOpHandler()));
        this.await();
    }

    @Test
    public void testListenNoHandlers() {
        TestUtils.assertIllegalStateException(() -> this.server.listen(ar -> {}));
    }

    @Test
    public void testListenNoHandlers2() {
        TestUtils.assertIllegalStateException(() -> this.server.listen());
    }

    @Test
    public void testListenTwice() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.testAddress, this.onSuccess(v -> this.testComplete()));
        TestUtils.assertIllegalStateException(() -> this.server.listen());
        this.await();
    }

    @Test
    public void testListenTwice2() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            TestUtils.assertIllegalStateException(() -> this.server.listen());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testHeadCanSetContentLength() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.HEAD, req.method());
            req.response().headers().set("Content-Length", String.valueOf(41));
            req.response().end();
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.HEAD, this.testAddress, new RequestOptions().setHost("localhost").setPort(8080).setURI("some-uri"), resp -> {
            this.assertEquals("41", resp.headers().get("Content-Length"));
            resp.endHandler(v -> this.testComplete());
            this.assertEquals("41", resp.headers().get("Content-Length"));
            resp.endHandler(v -> this.testComplete());
        }).end();
        this.await();
    }

    @Test
    public void testHeadDoesNotSetAutomaticallySetContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.HEAD, 200, MultiMap.caseInsensitiveMultiMap());
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testHeadAllowsContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.HEAD, 200, MultiMap.caseInsensitiveMultiMap().set("content-length", "34"));
        this.assertEquals("34", respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testHeadRemovesTransferEncodingHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.HEAD, 200, MultiMap.caseInsensitiveMultiMap().set("transfer-encoding", "chunked"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testNoContentRemovesContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 204, MultiMap.caseInsensitiveMultiMap().set("content-length", "34"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testNoContentRemovesTransferEncodingHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 204, MultiMap.caseInsensitiveMultiMap().set("transfer-encoding", "chunked"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testResetContentSetsContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 205, MultiMap.caseInsensitiveMultiMap());
        this.assertEquals("0", respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testResetContentRemovesTransferEncodingHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 205, MultiMap.caseInsensitiveMultiMap().set("transfer-encoding", "chunked"));
        this.assertEquals("0", respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testNotModifiedDoesNotSetAutomaticallySetContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 304, MultiMap.caseInsensitiveMultiMap());
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testNotModifiedAllowsContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 304, MultiMap.caseInsensitiveMultiMap().set("content-length", "34"));
        this.assertEquals("34", respHeaders.get("Content-Length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testNotModifiedRemovesTransferEncodingHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 304, MultiMap.caseInsensitiveMultiMap().set("transfer-encoding", "chunked"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void test1xxRemovesContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 102, MultiMap.caseInsensitiveMultiMap().set("content-length", "34"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void test1xxRemovesTransferEncodingHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 102, MultiMap.caseInsensitiveMultiMap().set("transfer-encoding", "chunked"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MultiMap checkEmptyHttpResponse(HttpMethod method, int sc, MultiMap reqHeaders) throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setStatusCode(sc);
            reqHeaders.remove("transfer-encoding");
            resp.headers().addAll(reqHeaders);
            resp.end();
        });
        this.startServer(this.testAddress);
        try {
            CompletableFuture result = new CompletableFuture();
            this.client.request(method, this.testAddress, 8080, "localhost", "/", resp -> {
                Buffer body = Buffer.buffer();
                resp.exceptionHandler(result::completeExceptionally);
                resp.handler(arg_0 -> ((Buffer)body).appendBuffer(arg_0));
                resp.endHandler(v -> {
                    if (body.length() > 0) {
                        result.completeExceptionally(new Exception());
                    } else {
                        result.complete(resp.headers());
                    }
                });
            }).setFollowRedirects(false).exceptionHandler(result::completeExceptionally).end();
            MultiMap multiMap = (MultiMap)result.get(20L, TimeUnit.SECONDS);
            return multiMap;
        }
        finally {
            this.client.close();
        }
    }

    @Test
    public void testHeadHasNoContentLengthByDefault() {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.HEAD, req.method());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.HEAD, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertNull(resp.headers().get(HttpHeaders.CONTENT_LENGTH));
            resp.endHandler(v -> this.testComplete());
        }).end()));
        this.await();
    }

    @Test
    public void testHeadButCanSetContentLength() {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.HEAD, req.method());
            req.response().putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)"41").end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.HEAD, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals("41", resp.headers().get(HttpHeaders.CONTENT_LENGTH));
            resp.endHandler(v -> this.testComplete());
        }).end()));
        this.await();
    }

    @Test
    public void testRemoteAddress() {
        this.server.requestHandler(req -> {
            if (this.testAddress.host() != null) {
                this.assertEquals("127.0.0.1", req.remoteAddress().host());
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete())).end()));
        this.await();
    }

    @Test
    public void testGetAbsoluteURI() {
        this.server.requestHandler(req -> {
            this.assertEquals(req.scheme() + "://localhost:" + 8080 + "/foo/bar", req.absoluteURI());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/foo/bar", resp -> resp.endHandler(v -> this.testComplete())).end()));
        this.await();
    }

    @Test
    public void testListenInvalidPort() throws Exception {
        this.server.close();
        try (ServerSocket occupied = null;){
            occupied = new ServerSocket(0);
            occupied.setReuseAddress(false);
            this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(occupied.getLocalPort()));
            this.server.requestHandler(this.noOpHandler()).listen(this.onFailure(server -> this.testComplete()));
            this.await();
        }
    }

    @Test
    public void testListenInvalidHost() {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("iqwjdoqiwjdoiqwdiojwd"));
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onFailure(s -> this.testComplete()));
    }

    @Test
    public void testPauseResumeClientResponseWontCallEndHandlePrematurely() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(8192));
        this.server.requestHandler(req -> req.response().end(expected));
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            resp.bodyHandler(body -> {
                this.assertEquals(expected, body);
                this.testComplete();
            });
            resp.pause();
            resp.resume();
        }).end();
        this.await();
    }

    @Test
    public void testPauseClientResponse() {
        int numWrites = 10;
        int numBytes = 100;
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            for (int i = 0; i < numWrites; ++i) {
                req.response().write(TestUtils.randomBuffer(numBytes));
            }
            req.response().end();
        });
        AtomicBoolean paused = new AtomicBoolean();
        Buffer totBuff = Buffer.buffer();
        HttpClientRequest clientRequest = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            resp.pause();
            paused.set(true);
            resp.handler(chunk -> {
                if (paused.get()) {
                    this.fail("Shouldn't receive chunks when paused");
                } else {
                    totBuff.appendBuffer(chunk);
                }
            });
            resp.endHandler(v -> {
                if (paused.get()) {
                    this.fail("Shouldn't receive chunks when paused");
                } else {
                    this.assertEquals(numWrites * numBytes, totBuff.length());
                    this.testComplete();
                }
            });
            this.vertx.setTimer(500L, id -> {
                paused.set(false);
                resp.resume();
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> clientRequest.end()));
        this.await();
    }

    @Test
    public void testDeliverPausedBufferWhenResume() throws Exception {
        this.testDeliverPausedBufferWhenResume(block -> this.vertx.setTimer(10L, id -> block.run()));
    }

    @Test
    public void testDeliverPausedBufferWhenResumeOnOtherThread() throws Exception {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            this.testDeliverPausedBufferWhenResume(block -> exec.execute(() -> {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.fail(e);
                    Thread.currentThread().interrupt();
                }
                block.run();
            }));
        }
        finally {
            exec.shutdown();
        }
    }

    private void testDeliverPausedBufferWhenResume(Consumer<Runnable> scheduler) throws Exception {
        int i;
        Buffer data = TestUtils.randomBuffer(2048);
        int num = 10;
        this.waitFor(num);
        List resumes = Collections.synchronizedList(new ArrayList());
        for (i = 0; i < num; ++i) {
            resumes.add(new CompletableFuture());
        }
        this.server.requestHandler(req -> {
            int idx = Integer.parseInt(req.path().substring(1));
            HttpServerResponse resp = req.response();
            ((CompletableFuture)resumes.get(idx)).thenAccept(v -> resp.end());
            resp.setChunked(true).write(data);
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setKeepAlive(true));
        for (i = 0; i < num; ++i) {
            int idx = i;
            this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/" + i, resp -> {
                Buffer body = Buffer.buffer();
                Thread t = Thread.currentThread();
                resp.handler(buff -> {
                    this.assertSame(t, Thread.currentThread());
                    ((CompletableFuture)resumes.get(idx)).complete(null);
                    body.appendBuffer(buff);
                });
                resp.endHandler(v -> this.complete());
                resp.pause();
                scheduler.accept(() -> ((HttpClientResponse)resp).resume());
            }).end();
        }
        this.await();
    }

    @Test
    public void testClearPausedBuffersWhenResponseEnds() throws Exception {
        Buffer data = TestUtils.randomBuffer(20);
        int num = 10;
        this.waitFor(num);
        this.server.requestHandler(req -> req.response().end(data));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setKeepAlive(true));
        for (int i = 0; i < num; ++i) {
            this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
                resp.bodyHandler(buff -> {
                    this.assertEquals(data, buff);
                    this.complete();
                });
                resp.pause();
                this.vertx.setTimer(10L, id -> resp.resume());
            }).end();
        }
        this.await();
    }

    @Test
    public void testPausedHttpServerRequest() throws Exception {
        CompletableFuture<Object> resumeCF = new CompletableFuture<Object>();
        Buffer expected = Buffer.buffer();
        this.server.requestHandler(req -> {
            req.pause();
            AtomicBoolean paused = new AtomicBoolean(true);
            Buffer body = Buffer.buffer();
            req.handler(buff -> {
                this.assertFalse(paused.get());
                body.appendBuffer(buff);
            });
            resumeCF.thenAccept(v -> {
                paused.set(false);
                req.resume();
            });
            req.endHandler(v -> {
                this.assertEquals(expected, body);
                req.response().end();
            });
        });
        this.startServer(this.testAddress);
        HttpClientRequest req2 = this.client.request(HttpMethod.PUT, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete())).exceptionHandler(this::fail).setChunked(true);
        while (!req2.writeQueueFull()) {
            Buffer buff = Buffer.buffer((String)TestUtils.randomAlphaString(1024));
            expected.appendBuffer(buff);
            req2.write(buff);
        }
        resumeCF.complete(null);
        req2.end();
        this.await();
    }

    @Test
    public void testHttpServerRequestPausedDuringLastChunk1() throws Exception {
        this.testHttpServerRequestPausedDuringLastChunk(false);
    }

    @Test
    public void testHttpServerRequestPausedDuringLastChunk2() throws Exception {
        this.testHttpServerRequestPausedDuringLastChunk(true);
    }

    private void testHttpServerRequestPausedDuringLastChunk(boolean fetching) throws Exception {
        this.server.requestHandler(req -> {
            AtomicBoolean ended = new AtomicBoolean();
            AtomicBoolean paused = new AtomicBoolean();
            req.handler(buff -> {
                this.assertEquals("small", buff.toString());
                req.pause();
                paused.set(true);
                this.vertx.setTimer(20L, id -> {
                    this.assertFalse(ended.get());
                    paused.set(false);
                    if (fetching) {
                        req.fetch(1L);
                    } else {
                        req.resume();
                    }
                });
            });
            req.endHandler(v -> {
                this.assertFalse(paused.get());
                ended.set(true);
                req.response().end();
            });
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1));
        this.client.request(HttpMethod.PUT, this.testAddress, 8080, "localhost", "/someuri", resp -> this.complete()).end("small");
        this.await();
    }

    @Test
    public void testHttpClientResponsePausedDuringLastChunk1() throws Exception {
        this.testHttpClientResponsePausedDuringLastChunk(false);
    }

    @Test
    public void testHttpClientResponsePausedDuringLastChunk2() throws Exception {
        this.testHttpClientResponsePausedDuringLastChunk(true);
    }

    private void testHttpClientResponsePausedDuringLastChunk(boolean fetching) throws Exception {
        this.server.requestHandler(req -> req.response().end("small"));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1));
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/someuri", resp -> {
            AtomicBoolean ended = new AtomicBoolean();
            AtomicBoolean paused = new AtomicBoolean();
            resp.handler(buff -> {
                this.assertEquals("small", buff.toString());
                resp.pause();
                paused.set(true);
                this.vertx.setTimer(20L, id -> {
                    this.assertFalse(ended.get());
                    paused.set(false);
                    if (fetching) {
                        resp.fetch(1L);
                    } else {
                        resp.resume();
                    }
                });
            });
            resp.endHandler(v -> {
                this.assertFalse(paused.get());
                ended.set(true);
                this.complete();
            });
        }).end();
        this.await();
    }

    @Test
    public void testFormUploadEmptyFile() {
        this.testFormUploadFile("", false, false);
    }

    @Test
    public void testFormUploadSmallFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), false, false);
    }

    @Test
    public void testFormUploadMediumFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(20000), false, false);
    }

    @Test
    public void testFormUploadLargeFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(0x400000), false, false);
    }

    @Test
    public void testFormUploadEmptyFileStreamToDisk() {
        this.testFormUploadFile("", true, false);
    }

    @Test
    public void testFormUploadSmallFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), true, false);
    }

    @Test
    public void testFormUploadMediumFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(20480), true, false);
    }

    @Test
    public void testFormUploadLargeFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(0x400000), true, false);
    }

    @Test
    public void testFormUploadWithExtFilename() {
        this.testFormUploadFile(null, "%c2%a3%20and%20%e2%82%ac%20rates", "the-content", true, false);
    }

    @Test
    public void testBrokenFormUploadEmptyFile() {
        this.testFormUploadFile("", true, true);
    }

    @Test
    public void testBrokenFormUploadSmallFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), true, true);
    }

    @Test
    public void testBrokenFormUploadMediumFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(20480), true, true);
    }

    @Test
    public void testBrokenFormUploadLargeFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(0x400000), true, true);
    }

    @Test
    public void testBrokenFormUploadEmptyFileStreamToDisk() {
        this.testFormUploadFile("", true, true);
    }

    @Test
    public void testBrokenFormUploadSmallFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), true, true);
    }

    @Test
    public void testBrokenFormUploadMediumFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(20480), true, true);
    }

    @Test
    public void testBrokenFormUploadLargeFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(0x400000), true, true);
    }

    private void testFormUploadFile(String contentStr, boolean streamToDisk, boolean abortClient) {
        this.testFormUploadFile("tmp-0.txt", "tmp-0.txt", contentStr, streamToDisk, abortClient);
    }

    private void testFormUploadFile(String filename, String extFilename, String contentStr, boolean streamToDisk, boolean abortClient) {
        String expectedFilename;
        try {
            expectedFilename = extFilename != null ? URLDecoder.decode(extFilename, "UTF-8") : filename;
        }
        catch (UnsupportedEncodingException e) {
            this.fail(e);
            return;
        }
        this.waitFor(2);
        Buffer content = Buffer.buffer((String)contentStr);
        AtomicInteger attributeCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.response().setChunked(true);
                req.setExpectMultipart(true);
                this.assertTrue(req.isExpectMultipart());
                req.setExpectMultipart(true);
                this.assertTrue(req.isExpectMultipart());
                req.uploadHandler(upload -> {
                    String uploadedFileName;
                    Buffer tot = Buffer.buffer();
                    this.assertEquals("file", upload.name());
                    this.assertEquals(expectedFilename, upload.filename());
                    this.assertEquals("image/gif", upload.contentType());
                    if (!streamToDisk) {
                        upload.handler(arg_0 -> ((Buffer)tot).appendBuffer(arg_0));
                        uploadedFileName = null;
                    } else {
                        uploadedFileName = new File(this.testDir, UUID.randomUUID().toString()).getPath();
                        upload.streamToFileSystem(uploadedFileName);
                    }
                    AtomicInteger failures = new AtomicInteger();
                    upload.exceptionHandler(err -> failures.incrementAndGet());
                    upload.endHandler(v -> {
                        if (abortClient) {
                            this.assertEquals(1L, failures.get());
                        } else {
                            this.assertEquals(0L, failures.get());
                            if (streamToDisk) {
                                Buffer uploaded = this.vertx.fileSystem().readFileBlocking(uploadedFileName);
                                this.assertEquals(content.length(), uploaded.length());
                                this.assertEquals(content, uploaded);
                            } else {
                                this.assertEquals(content, tot);
                            }
                            this.assertTrue(upload.isSizeAvailable());
                            this.assertEquals(content.length(), upload.size());
                        }
                        AsyncFile file = upload.file();
                        if (streamToDisk) {
                            this.assertNotNull(file);
                            try {
                                file.flush();
                                this.fail("Was expecting uploaded file to be closed");
                            }
                            catch (IllegalStateException illegalStateException) {}
                        } else {
                            this.assertNull(file);
                        }
                        this.complete();
                    });
                });
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    req.response().end();
                });
            }
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            AtomicBoolean failed = new AtomicBoolean();
            HttpClientRequest req = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "/form", resp -> {
                this.assertFalse(abortClient);
                this.assertEquals(200L, resp.statusCode());
                resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
                this.assertEquals(0L, attributeCount.get());
                this.complete();
            }).exceptionHandler(err -> {
                if (failed.compareAndSet(false, true)) {
                    this.assertTrue(abortClient);
                    this.complete();
                }
            });
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            String epi = "\r\n--" + boundary + "--\r\n";
            String pro = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"file\"" + (filename == null ? "" : "; filename=\"" + filename + "\"") + (extFilename == null ? "" : "; filename*=\"UTF-8''" + extFilename) + "\"\r\nContent-Type: image/gif\r\n\r\n";
            req.headers().set("content-length", "" + (pro + contentStr + epi).length());
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            if (abortClient) {
                req.connectionHandler(conn -> this.vertx.setTimer(100L, id -> conn.close()));
                req.write(pro + contentStr.substring(0, contentStr.length() / 2));
            } else {
                req.end(pro + contentStr + epi);
            }
        }));
        this.await();
    }

    @Test
    public void testFormUploadAttributes() {
        AtomicInteger attributeCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.response().setChunked(true);
                req.setExpectMultipart(true);
                req.uploadHandler(upload -> upload.handler(buffer -> this.fail("Should get here")));
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    this.assertEquals("vert x", attrs.get("framework"));
                    this.assertEquals("vert x", req.getFormAttribute("framework"));
                    this.assertEquals("jvm", attrs.get("runson"));
                    this.assertEquals("jvm", req.getFormAttribute("runson"));
                    req.response().end();
                });
            }
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "/form", resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
                this.assertEquals(2L, attributeCount.get());
                this.testComplete();
            });
            try {
                Buffer buffer = Buffer.buffer();
                buffer.appendString("framework=" + URLEncoder.encode("vert x", "UTF-8") + "&runson=jvm", "UTF-8");
                req.headers().set("content-length", String.valueOf(buffer.length()));
                req.headers().set("content-type", "application/x-www-form-urlencoded");
                req.write(buffer).end();
            }
            catch (UnsupportedEncodingException e) {
                this.fail(e.getMessage());
            }
        }));
        this.await();
    }

    @Test
    public void testFormUploadAttributes2() {
        AtomicInteger attributeCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.setExpectMultipart(true);
                req.uploadHandler(event -> event.handler(buffer -> this.fail("Should not get here")));
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    this.assertEquals("junit-testUserAlias", attrs.get("origin"));
                    this.assertEquals("admin@foo.bar", attrs.get("login"));
                    this.assertEquals("admin", attrs.get("pass word"));
                    req.response().end();
                });
            }
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "/form", resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
                this.assertEquals(3L, attributeCount.get());
                this.testComplete();
            });
            Buffer buffer = Buffer.buffer();
            buffer.appendString("origin=junit-testUserAlias&login=admin%40foo.bar&pass+word=admin");
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "application/x-www-form-urlencoded");
            req.write(buffer).end();
        }));
        this.await();
    }

    @Test
    public void testHostHeaderOverridePossible() {
        this.server.requestHandler(req -> {
            this.assertEquals("localhost:4444", req.host());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> this.testComplete());
            req.setHost("localhost:4444");
            req.end();
        }));
        this.await();
    }

    @Test
    public void testResponseBodyWriteFixedString() {
        String body = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
        Buffer bodyBuff = Buffer.buffer((String)body);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().write(body);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseDataTimeout() {
        this.waitFor(2);
        Buffer expected = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.response().setChunked(true).write(expected));
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            Buffer received = Buffer.buffer();
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
                AtomicInteger count = new AtomicInteger();
                resp.exceptionHandler(t -> {
                    if (count.getAndIncrement() == 0) {
                        this.assertTrue(t instanceof TimeoutException);
                        this.assertEquals(expected, received);
                        this.complete();
                    }
                });
                resp.request().setTimeout(500L);
                resp.handler(buff -> {
                    received.appendBuffer(buff);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            });
            AtomicInteger count = new AtomicInteger();
            req.exceptionHandler(t -> {
                if (count.getAndIncrement() == 0) {
                    this.assertTrue("Expected " + t.getClass().getName() + " extend or implement TimeoutException", t instanceof TimeoutException);
                    this.assertEquals(expected, received);
                    this.complete();
                }
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void testClientMultiThreaded() throws Exception {
        int numThreads = 10;
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch latch = new CountDownLatch(numThreads);
        this.server.requestHandler(req -> {
            req.response().putHeader("count", req.headers().get("count"));
            req.response().end();
        }).listen(this.testAddress, this.onSuccess(s -> {
            for (int i = 0; i < numThreads; ++i) {
                final int index = i;
                threads[i] = new Thread(){

                    @Override
                    public void run() {
                        HttpTest.this.client.request(HttpMethod.GET, HttpTest.this.testAddress, 8080, "localhost", "/", res -> {
                            HttpTest.this.assertEquals(200L, res.statusCode());
                            HttpTest.this.assertEquals(String.valueOf(index), res.headers().get("count"));
                            latch.countDown();
                        }).putHeader("count", String.valueOf(index)).end();
                    }
                };
                threads[i].start();
            }
        }));
        this.awaitLatch(latch);
        for (int i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
    }

    @Test
    public void testInVerticle() throws Exception {
        this.testInVerticle(false);
    }

    private void testInVerticle(final boolean worker) {
        this.client.close();
        this.server.close();
        class MyVerticle
        extends AbstractVerticle {
            Context ctx;

            MyVerticle() {
            }

            public void start() {
                this.ctx = Vertx.currentContext();
                if (worker) {
                    HttpTest.this.assertTrue(this.ctx.isWorkerContext());
                } else {
                    HttpTest.this.assertTrue(this.ctx.isEventLoopContext());
                }
                Thread thr = Thread.currentThread();
                HttpTest.this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
                HttpTest.this.server.requestHandler(req -> {
                    req.response().end();
                    HttpTest.this.assertSame(this.ctx, Vertx.currentContext());
                    if (!worker) {
                        HttpTest.this.assertSame(thr, Thread.currentThread());
                    }
                });
                HttpTest.this.server.listen(HttpTest.this.testAddress, HttpTest.this.onSuccess(s -> {
                    HttpTest.this.assertSame(this.ctx, Vertx.currentContext());
                    if (!worker) {
                        HttpTest.this.assertSame(thr, Thread.currentThread());
                    }
                    HttpTest.this.client = this.vertx.createHttpClient(new HttpClientOptions());
                    HttpTest.this.client.request(HttpMethod.GET, HttpTest.this.testAddress, 8080, "localhost", "/", res -> {
                        HttpTest.this.assertSame(this.ctx, Vertx.currentContext());
                        if (!worker) {
                            HttpTest.this.assertSame(thr, Thread.currentThread());
                        }
                        HttpTest.this.assertEquals(200L, res.statusCode());
                        HttpTest.this.testComplete();
                    }).end();
                }));
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(worker));
        this.await();
    }

    @Test
    public void testUseInMultithreadedWorker() throws Exception {
        class MyVerticle
        extends AbstractVerticle {
            MyVerticle() {
            }

            public void start() {
                TestUtils.assertIllegalStateException(() -> {
                    HttpTest.this.server = this.vertx.createHttpServer(new HttpServerOptions());
                });
                TestUtils.assertIllegalStateException(() -> {
                    HttpTest.this.client = this.vertx.createHttpClient(new HttpClientOptions());
                });
                HttpTest.this.testComplete();
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(true).setMultiThreaded(true));
        this.await();
    }

    @Test
    public void testMultipleServerClose() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        AtomicInteger times = new AtomicInteger();
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        this.server.requestStream().endHandler(v -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            times.incrementAndGet();
        });
        this.server.close(ar1 -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.server.close(ar2 -> this.server.close(ar3 -> {
                this.assertEquals(1L, times.get());
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testClearHandlersOnEnd() {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions());
        this.server.requestHandler(req -> req.endHandler(v -> {
            try {
                req.endHandler(null);
                req.exceptionHandler(null);
                req.handler(null);
                req.bodyHandler(null);
                req.uploadHandler(null);
            }
            catch (Exception e) {
                this.fail("Was expecting to set to null the handlers when the request is completed");
                return;
            }
            HttpServerResponse resp = req.response();
            resp.setStatusCode(200).end();
            try {
                resp.endHandler(null);
                resp.exceptionHandler(null);
                resp.drainHandler(null);
                resp.bodyEndHandler(null);
                resp.closeHandler(null);
                resp.headersEndHandler(null);
            }
            catch (Exception e) {
                this.fail("Was expecting to set to null the handlers when the response is completed");
            }
        }));
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", path);
            AtomicInteger count = new AtomicInteger();
            req.handler(resp -> resp.endHandler(v -> {
                try {
                    resp.endHandler(null);
                    resp.exceptionHandler(null);
                    resp.handler(null);
                    resp.bodyHandler(null);
                }
                catch (Exception e) {
                    this.fail("Was expecting to set to null the handlers when the response is completed");
                    return;
                }
                if (count.incrementAndGet() == 2) {
                    this.testComplete();
                }
            }));
            req.endHandler(done -> {
                try {
                    req.handler(null);
                    req.exceptionHandler(null);
                    req.endHandler(null);
                    req.drainHandler(null);
                    req.connectionHandler(null);
                    req.continueHandler(null);
                }
                catch (Exception e) {
                    this.fail("Was expecting to set to null the handlers when the response is completed");
                    return;
                }
                if (count.incrementAndGet() == 2) {
                    this.testComplete();
                }
            });
            req.end();
        });
        this.await();
    }

    @Test
    public void testSetHandlersOnEnd() throws Exception {
        String path = "/some/path";
        this.server.requestHandler(req -> req.response().setStatusCode(200).end());
        this.startServer();
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, 8080, "localhost", path);
        req2.handler(resp -> {});
        req2.endHandler(done -> {
            try {
                req2.handler(arg -> {});
                this.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                req2.exceptionHandler(arg -> {});
                this.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                req2.endHandler(arg -> {});
                this.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.testComplete();
        });
        req2.end();
        this.await();
    }

    @Test
    public void testRequestEnded() {
        this.server.requestHandler(req -> {
            this.assertFalse(req.isEnded());
            req.endHandler(v -> {
                this.assertTrue(req.isEnded());
                try {
                    req.endHandler(v2 -> {});
                    this.fail("Shouldn't be able to set end handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.setExpectMultipart(true);
                    this.fail("Shouldn't be able to set expect multipart");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.bodyHandler(v2 -> {});
                    this.fail("Shouldn't be able to set body handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.handler(v2 -> {});
                    this.fail("Shouldn't be able to set handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                req.response().setStatusCode(200).end();
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/blah", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).end()));
        this.await();
    }

    @Test
    public void testRequestEndedNoEndHandler() {
        this.server.requestHandler(req -> {
            this.assertFalse(req.isEnded());
            req.response().setStatusCode(200).end();
            this.vertx.setTimer(500L, v -> {
                this.assertTrue(req.isEnded());
                try {
                    req.endHandler(v2 -> {});
                    this.fail("Shouldn't be able to set end handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.setExpectMultipart(true);
                    this.fail("Shouldn't be able to set expect multipart");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.bodyHandler(v2 -> {});
                    this.fail("Shouldn't be able to set body handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.handler(v2 -> {});
                    this.fail("Shouldn't be able to set handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.testComplete();
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/blah", resp -> this.assertEquals(200L, resp.statusCode())).end()));
        this.await();
    }

    @Test
    public void testInMultithreadedWorker() throws Exception {
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                HttpTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                HttpTest.this.assertTrue(Vertx.currentContext().isMultiThreadedWorkerContext());
                HttpTest.this.assertTrue(Context.isOnWorkerThread());
                try {
                    this.vertx.createHttpServer();
                    HttpTest.this.fail("Should throw exception");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    this.vertx.createHttpClient();
                    HttpTest.this.fail("Should throw exception");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                HttpTest.this.testComplete();
            }
        }, new DeploymentOptions().setWorker(true).setMultiThreaded(true));
        this.await();
    }

    @Test
    public void testAbsoluteURIServer() {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setHost("0.0.0.0"));
        this.server.requestHandler(req -> {
            String absURI = req.absoluteURI();
            this.assertEquals(req.scheme() + "://localhost:8080/path", absURI);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            String host = "localhost";
            String path = "/path";
            int port = 8080;
            this.client.request(HttpMethod.GET, this.testAddress, port, host, path, resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            }).end();
        }));
        this.await();
    }

    @Test
    public void testDumpManyRequestsOnQueue() throws Exception {
        int sendRequests = 10000;
        AtomicInteger receivedRequests = new AtomicInteger();
        HttpClientOptions ops = this.createBaseClientOptions().setDefaultPort(8080).setPipelining(true).setKeepAlive(true);
        this.client.close();
        this.client = this.vertx.createHttpClient(ops);
        this.vertx.createHttpServer(this.createBaseServerOptions()).requestHandler(r -> {
            r.response().end();
            if (receivedRequests.incrementAndGet() == sendRequests) {
                this.testComplete();
            }
        }).listen(this.testAddress, this.onSuccess(s -> IntStream.range(0, sendRequests).forEach(x -> this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", r -> {}).end())));
        this.await();
    }

    @Test
    public void testOtherMethodWithRawMethod() {
        try {
            this.client.request(HttpMethod.OTHER, this.testAddress, 8080, "localhost", "/somepath", resp -> {}).end();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testOtherMethodRequest() {
        this.server.requestHandler(r -> {
            this.assertEquals(HttpMethod.OTHER, r.method());
            this.assertEquals("COPY", r.rawMethod());
            r.response().end();
        }).listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.OTHER, this.testAddress, 8080, "localhost", "/somepath", resp -> this.testComplete()).setRawMethod("COPY").end()));
        this.await();
    }

    @Test
    public void testClientLocalConnectionHandler() throws Exception {
        this.testClientConnectionHandler(true, false);
    }

    @Test
    public void testClientGlobalConnectionHandler() throws Exception {
        this.testClientConnectionHandler(false, true);
    }

    @Test
    public void testClientConnectionHandler() throws Exception {
        this.testClientConnectionHandler(true, true);
    }

    private void testClientConnectionHandler(boolean local, boolean global) throws Exception {
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        AtomicInteger status = new AtomicInteger();
        Handler handler = conn -> status.getAndIncrement();
        if (global) {
            this.client.connectionHandler(handler);
        }
        HttpClientRequest req2 = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "/somepath", resp -> {
            this.assertEquals((local ? 1 : 0) + (global ? 1 : 0), status.getAndIncrement());
            this.testComplete();
        });
        if (local) {
            req2.connectionHandler(handler);
        }
        req2.end();
        this.await();
    }

    @Test
    public void testServerConnectionHandler() throws Exception {
        AtomicInteger status = new AtomicInteger();
        AtomicReference connRef = new AtomicReference();
        Context serverCtx = this.vertx.getOrCreateContext();
        this.server.connectionHandler(conn -> {
            this.assertSame(serverCtx, Vertx.currentContext());
            this.assertEquals(0L, status.getAndIncrement());
            this.assertNull(connRef.getAndSet(conn));
        });
        this.server.requestHandler(req -> {
            this.assertEquals(1L, status.getAndIncrement());
            this.assertSame(connRef.get(), req.connection());
            req.response().end();
        });
        this.startServer(this.testAddress, serverCtx, this.server);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> this.testComplete()).end();
        this.await();
    }

    @Test
    public void testServerConnectionHandlerClose() throws Exception {
        this.waitFor(2);
        Context serverCtx = this.vertx.getOrCreateContext();
        this.server.connectionHandler(conn -> {
            conn.close();
            conn.closeHandler(v -> this.complete());
        });
        this.server.requestHandler(req -> this.fail());
        this.startServer(this.testAddress, serverCtx, this.server);
        this.client.connectionHandler(conn -> conn.closeHandler(v -> this.complete()));
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> this.fail()).end();
        this.await();
    }

    @Test
    public void testClientConnectionClose() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            AtomicInteger len = new AtomicInteger();
            req.handler(buff -> {
                if (len.addAndGet(buff.length()) == 1024) {
                    latch.countDown();
                }
            });
            req.connection().closeHandler(v -> this.testComplete());
        });
        this.startServer(this.testAddress);
        HttpClientRequest req2 = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "/somepath", resp -> this.fail());
        req2.setChunked(true);
        req2.write(TestUtils.randomBuffer(1024));
        this.awaitLatch(latch);
        req2.connection().close();
        this.await();
    }

    @Test
    public void testServerConnectionClose() throws Exception {
        this.server.requestHandler(req -> req.connection().close());
        this.startServer(this.testAddress);
        HttpClientRequest req2 = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "/somepath", resp -> this.fail());
        req2.connectionHandler(conn -> conn.closeHandler(v -> this.testComplete()));
        req2.sendHead();
        this.await();
    }

    @Test
    public void testNoLogging() throws Exception {
        TestLoggerFactory factory = this.testLogging();
        this.assertFalse(factory.hasName("io.netty.handler.codec.http2.Http2FrameLogger"));
    }

    @Test
    public void testServerLogging() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        if (this instanceof Http1xTest) {
            this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
        } else {
            this.assertTrue(factory.hasName("io.netty.handler.codec.http2.Http2FrameLogger"));
        }
    }

    @Test
    public void testClientLogging() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        if (this instanceof Http1xTest) {
            this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
        } else {
            this.assertTrue(factory.hasName("io.netty.handler.codec.http2.Http2FrameLogger"));
        }
    }

    @Test
    public void testClientLocalAddress() throws Exception {
        String expectedAddress = TestUtils.loopbackAddress();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setLocalAddress(expectedAddress));
        this.server.requestHandler(req -> {
            this.assertEquals(expectedAddress, req.remoteAddress().host());
            req.response().end();
        });
        this.startServer();
        this.client.request(HttpMethod.GET, 8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).end();
        this.await();
    }

    @Test
    public void testFollowRedirectGetOn301() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 301, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn301() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.GET, 301, 301, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectPutOn301() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.GET, 301, 301, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectGetOn302() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 302, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn302() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.GET, 302, 302, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectPutOn302() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.GET, 302, 302, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectGetOn303() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 303, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn303() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.GET, 303, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPutOn303() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.GET, 303, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectNotOn304() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 304, 304, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectGetOn307() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 307, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn307() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.POST, 307, 307, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectPutOn307() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.PUT, 307, 307, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectWithRelativeLocation() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 301, 200, 2, "/another", "http://localhost:8080/another");
    }

    @Test
    public void testFollowRedirectGetOn308() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 308, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn308() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.POST, 308, 308, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectPutOn308() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.PUT, 308, 308, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    private void testFollowRedirect(HttpMethod method, HttpMethod expectedMethod, int statusCode, int expectedStatus, int expectedRequests, String location, String expectedURI) throws Exception {
        String s = this.createBaseServerOptions().isSsl() && location.startsWith("http://") ? "https://" + location.substring("http://".length()) : location;
        String t = this.createBaseServerOptions().isSsl() && expectedURI.startsWith("http://") ? "https://" + expectedURI.substring("http://".length()) : expectedURI;
        AtomicInteger numRequests = new AtomicInteger();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            if (numRequests.getAndIncrement() == 0) {
                resp.setStatusCode(statusCode);
                if (s != null) {
                    resp.putHeader(HttpHeaders.LOCATION, (CharSequence)s);
                }
                resp.end();
            } else {
                this.assertEquals(t, req.absoluteURI());
                this.assertEquals("foo_value", req.getHeader("foo"));
                this.assertEquals(expectedMethod, req.method());
                resp.end();
            }
        });
        this.startServer();
        this.client.request(method, 8080, "localhost", "/somepath", resp -> {
            this.assertEquals(resp.request().absoluteURI(), t);
            this.assertEquals(expectedRequests, numRequests.get());
            this.assertEquals(expectedStatus, resp.statusCode());
            this.testComplete();
        }).putHeader("foo", "foo_value").setFollowRedirects(true).end();
        this.await();
    }

    @Test
    public void testFollowRedirectWithBody() throws Exception {
        this.testFollowRedirectWithBody(Function.identity());
    }

    @Test
    public void testFollowRedirectWithPaddedBody() throws Exception {
        this.testFollowRedirectWithBody(buff -> TestUtils.leftPad(1, buff));
    }

    private void testFollowRedirectWithBody(Function<Buffer, Buffer> translator) throws Exception {
        Buffer expected = TestUtils.randomBuffer(2048);
        AtomicBoolean redirected = new AtomicBoolean();
        this.server.requestHandler(req -> {
            if (redirected.compareAndSet(false, true)) {
                this.assertEquals(HttpMethod.PUT, req.method());
                req.bodyHandler(body -> {
                    this.assertEquals(body, expected);
                    String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                    req.response().setStatusCode(303).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever")).end();
                });
            } else {
                this.assertEquals(HttpMethod.GET, req.method());
                this.assertNull(req.getHeader(HttpHeaders.CONTENT_LENGTH));
                req.response().end();
            }
        });
        this.startServer();
        this.client.put(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).setFollowRedirects(true).end(translator.apply(expected));
        this.await();
    }

    @Test
    public void testFollowRedirectWithChunkedBody() throws Exception {
        Buffer buff1 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer buff2 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer expected = Buffer.buffer().appendBuffer(buff1).appendBuffer(buff2);
        AtomicBoolean redirected = new AtomicBoolean();
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            boolean redirect = redirected.compareAndSet(false, true);
            if (redirect) {
                latch.countDown();
            }
            if (redirect) {
                this.assertEquals(HttpMethod.PUT, req.method());
                req.bodyHandler(body -> {
                    this.assertEquals(body, expected);
                    String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                    req.response().setStatusCode(303).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever")).end();
                });
            } else {
                this.assertEquals(HttpMethod.GET, req.method());
                req.response().end();
            }
        });
        this.startServer();
        HttpClientRequest req2 = this.client.put(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).setFollowRedirects(true).setChunked(true).write(buff1);
        this.awaitLatch(latch);
        req2.end(buff2);
        this.await();
    }

    @Test
    public void testFollowRedirectWithRequestNotEnded() throws Exception {
        this.testFollowRedirectWithRequestNotEnded(false);
    }

    @Test
    public void testFollowRedirectWithRequestNotEndedFailing() throws Exception {
        this.testFollowRedirectWithRequestNotEnded(true);
    }

    private void testFollowRedirectWithRequestNotEnded(boolean expectFail) throws Exception {
        Buffer buff1 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer buff2 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer expected = Buffer.buffer().appendBuffer(buff1).appendBuffer(buff2);
        AtomicBoolean redirected = new AtomicBoolean();
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            boolean redirect = redirected.compareAndSet(false, true);
            if (redirect) {
                Buffer body = Buffer.buffer();
                req.handler(buff -> {
                    if (body.length() == 0) {
                        HttpServerResponse resp = req.response();
                        String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                        resp.setStatusCode(303).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever"));
                        if (expectFail) {
                            resp.setChunked(true).write("whatever");
                            this.vertx.runOnContext(v -> resp.close());
                        } else {
                            resp.end();
                        }
                        latch.countDown();
                    }
                    body.appendBuffer(buff);
                });
                req.endHandler(v -> this.assertEquals(expected, body));
            } else {
                req.response().end();
            }
        });
        this.startServer();
        AtomicBoolean called = new AtomicBoolean();
        HttpClientRequest req2 = this.client.put(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).setFollowRedirects(true).exceptionHandler(err -> {
            if (expectFail) {
                if (called.compareAndSet(false, true)) {
                    this.testComplete();
                }
            } else {
                this.fail((Throwable)err);
            }
        }).setChunked(true).write(buff1);
        this.awaitLatch(latch);
        if (!expectFail) {
            Thread.sleep(500L);
            req2.end(buff2);
        }
        this.await();
    }

    @Test
    public void testFollowRedirectSendHeadThenBody() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        AtomicBoolean redirected = new AtomicBoolean();
        this.server.requestHandler(req -> {
            if (redirected.compareAndSet(false, true)) {
                this.assertEquals(HttpMethod.PUT, req.method());
                req.bodyHandler(body -> {
                    this.assertEquals(body, expected);
                    req.response().setStatusCode(303).putHeader(HttpHeaders.LOCATION, (CharSequence)"/whatever").end();
                });
            } else {
                this.assertEquals(HttpMethod.GET, req.method());
                req.response().end();
            }
        });
        this.startServer();
        HttpClientRequest req2 = this.client.put(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).setFollowRedirects(true);
        req2.putHeader("Content-Length", "" + expected.length());
        req2.exceptionHandler(this::fail);
        req2.sendHead(v -> req2.end(expected));
        this.await();
    }

    @Test
    public void testFollowRedirectLimit() throws Exception {
        AtomicInteger redirects = new AtomicInteger();
        this.server.requestHandler(req -> {
            int val = redirects.incrementAndGet();
            if (val > 16) {
                this.fail();
            } else {
                String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                req.response().setStatusCode(301).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/otherpath")).end();
            }
        });
        this.startServer();
        this.client.get(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(16L, redirects.get());
            this.assertEquals(301L, resp.statusCode());
            this.assertEquals("/otherpath", resp.request().path());
            this.testComplete();
        }).setFollowRedirects(true).end();
        this.await();
    }

    @Test
    public void testFollowRedirectPropagatesTimeout() throws Exception {
        AtomicInteger redirections = new AtomicInteger();
        this.server.requestHandler(req -> {
            switch (redirections.getAndIncrement()) {
                case 0: {
                    String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                    req.response().setStatusCode(307).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever")).end();
                }
            }
        });
        this.startServer();
        AtomicBoolean done = new AtomicBoolean();
        this.client.get(8080, "localhost", "/somepath", resp -> this.fail()).setFollowRedirects(true).exceptionHandler(err -> {
            if (done.compareAndSet(false, true)) {
                this.assertEquals(2L, redirections.get());
                this.testComplete();
            }
        }).setTimeout(500L).end();
        this.await();
    }

    @Test
    public void testFollowRedirectHost() throws Exception {
        String scheme = this.createBaseClientOptions().isSsl() ? "https" : "http";
        this.waitFor(2);
        HttpServerOptions options = this.createBaseServerOptions();
        int port = options.getPort() + 1;
        options.setPort(port);
        AtomicInteger redirects = new AtomicInteger();
        this.server.requestHandler(req -> {
            redirects.incrementAndGet();
            req.response().setStatusCode(301).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:" + port + "/whatever")).end();
        });
        this.startServer();
        HttpServer server2 = this.vertx.createHttpServer(options);
        server2.requestHandler(req -> {
            this.assertEquals(1L, redirects.get());
            this.assertEquals(scheme + "://localhost:" + port + "/whatever", req.absoluteURI());
            req.response().end();
            this.complete();
        });
        this.startServer(server2);
        this.client.get(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(scheme + "://localhost:" + port + "/whatever", resp.request().absoluteURI());
            this.complete();
        }).setFollowRedirects(true).setHost("localhost:" + options.getPort()).end();
        this.await();
    }

    @Test
    public void testFollowRedirectWithCustomHandler() throws Exception {
        String scheme = this.createBaseClientOptions().isSsl() ? "https" : "http";
        this.waitFor(2);
        HttpServerOptions options = this.createBaseServerOptions();
        int port = options.getPort() + 1;
        options.setPort(port);
        AtomicInteger redirects = new AtomicInteger();
        this.server.requestHandler(req -> {
            redirects.incrementAndGet();
            req.response().setStatusCode(301).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:" + port + "/whatever")).end();
        });
        this.startServer();
        HttpServer server2 = this.vertx.createHttpServer(options);
        server2.requestHandler(req -> {
            this.assertEquals(1L, redirects.get());
            this.assertEquals(scheme + "://localhost:" + port + "/custom", req.absoluteURI());
            req.response().end();
            this.complete();
        });
        this.startServer(server2);
        this.client.redirectHandler(resp -> {
            Promise fut = Promise.promise();
            this.vertx.setTimer(25L, id -> {
                HttpClientRequest req = this.client.getAbs(scheme + "://localhost:" + port + "/custom");
                req.putHeader("foo", "foo_another");
                req.setHost("localhost:" + port);
                fut.complete((Object)req);
            });
            return fut.future();
        });
        this.client.get(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(scheme + "://localhost:" + port + "/custom", resp.request().absoluteURI());
            this.complete();
        }).setFollowRedirects(true).putHeader("foo", "foo_value").setHost("localhost:" + options.getPort()).end();
        this.await();
    }

    @Test
    public void testDefaultRedirectHandler() throws Exception {
        this.testFoo("http://example.com", "http://example.com");
        this.testFoo("http://example.com/somepath", "http://example.com/somepath");
        this.testFoo("http://example.com:8000", "http://example.com:8000");
        this.testFoo("http://example.com:8000/somepath", "http://example.com:8000/somepath");
        this.testFoo("https://example.com", "https://example.com");
        this.testFoo("https://example.com/somepath", "https://example.com/somepath");
        this.testFoo("https://example.com:8000", "https://example.com:8000");
        this.testFoo("https://example.com:8000/somepath", "https://example.com:8000/somepath");
        this.testFoo("whatever://example.com", null);
        this.testFoo("http://", null);
        this.testFoo("http://:8080/somepath", null);
    }

    private void testFoo(String location, String expected) throws Exception {
        final int status = 301;
        final Map<String, String> headers = Collections.singletonMap(HttpHeaders.LOCATION.toString(), location);
        final HttpMethod method = HttpMethod.GET;
        final String baseURI = "https://localhost:8080";
        class MockReq
        implements HttpClientRequest {
            MockReq() {
            }

            public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest write(Buffer data) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest drainHandler(Handler<Void> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest handler(Handler<HttpClientResponse> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest pause() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest resume() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest fetch(long amount) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest endHandler(Handler<Void> endHandler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setFollowRedirects(boolean followRedirects) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setMaxRedirects(int maxRedirects) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setChunked(boolean chunked) {
                throw new UnsupportedOperationException();
            }

            public boolean isChunked() {
                return false;
            }

            public HttpMethod method() {
                return method;
            }

            public String getRawMethod() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setRawMethod(String method2) {
                throw new UnsupportedOperationException();
            }

            public String absoluteURI() {
                return baseURI;
            }

            public String uri() {
                throw new UnsupportedOperationException();
            }

            public String path() {
                throw new UnsupportedOperationException();
            }

            public String query() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setHost(String host) {
                throw new UnsupportedOperationException();
            }

            public String getHost() {
                throw new UnsupportedOperationException();
            }

            public MultiMap headers() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest putHeader(String name, String value) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest putHeader(String name, Iterable<String> values) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest write(String chunk) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest write(String chunk, String enc) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest write(Buffer data, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest write(String chunk, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest continueHandler(@Nullable Handler<Void> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest sendHead() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest sendHead(Handler<HttpVersion> completionHandler) {
                throw new UnsupportedOperationException();
            }

            public void end(String chunk) {
                throw new UnsupportedOperationException();
            }

            public void end(String chunk, String enc) {
                throw new UnsupportedOperationException();
            }

            public void end(String chunk, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public void end(Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public void end() {
                throw new UnsupportedOperationException();
            }

            public void end(Buffer chunk) {
                throw new UnsupportedOperationException();
            }

            public void end(Buffer chunk, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setTimeout(long timeoutMs) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
                throw new UnsupportedOperationException();
            }

            public boolean reset(long code) {
                return false;
            }

            public HttpConnection connection() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest connectionHandler(@Nullable Handler<HttpConnection> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
                throw new UnsupportedOperationException();
            }

            public boolean writeQueueFull() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
                return this;
            }

            public StreamPriority getStreamPriority() {
                return null;
            }
        }
        final MockReq req = new MockReq();
        class MockResp
        implements HttpClientResponse {
            MockResp() {
            }

            public HttpClientResponse resume() {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse handler(Handler<Buffer> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse pause() {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse fetch(long amount) {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse endHandler(Handler<Void> endHandler) {
                throw new UnsupportedOperationException();
            }

            public HttpVersion version() {
                throw new UnsupportedOperationException();
            }

            public int statusCode() {
                return status;
            }

            public String statusMessage() {
                throw new UnsupportedOperationException();
            }

            public MultiMap headers() {
                throw new UnsupportedOperationException();
            }

            public String getHeader(String headerName) {
                return (String)headers.get(headerName);
            }

            public String getHeader(CharSequence headerName) {
                return this.getHeader(headerName.toString());
            }

            public String getTrailer(String trailerName) {
                throw new UnsupportedOperationException();
            }

            public MultiMap trailers() {
                throw new UnsupportedOperationException();
            }

            public List<String> cookies() {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
                throw new UnsupportedOperationException();
            }

            public NetSocket netSocket() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest request() {
                return req;
            }

            public HttpClientResponse streamPriorityHandler(Handler<StreamPriority> handler) {
                return this;
            }
        }
        MockResp resp = new MockResp();
        Function handler = this.client.redirectHandler();
        Future redirection = (Future)handler.apply(resp);
        if (expected != null) {
            this.assertEquals(location, ((HttpClientRequest)redirection.result()).absoluteURI());
        } else {
            this.assertTrue(redirection == null || redirection.failed());
        }
    }

    @Test
    public void testFollowRedirectEncodedParams() throws Exception {
        String value1 = "\ud55c\uae00";
        String value2 = "A B+C";
        String value3 = "123 \u20ac";
        this.server.requestHandler(req -> {
            switch (req.path()) {
                case "/first/call/from/client": {
                    StringBuilder location = null;
                    try {
                        location = new StringBuilder().append(req.scheme()).append("://").append("localhost").append(':').append(8080).append("/redirected/from/client?").append("encoded1=").append(URLEncoder.encode(value1, "UTF-8")).append('&').append("encoded2=").append(URLEncoder.encode(value2, "UTF-8")).append('&').append("encoded3=").append(URLEncoder.encode(value3, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.fail(e);
                    }
                    req.response().setStatusCode(302).putHeader("location", location.toString()).end();
                    break;
                }
                case "/redirected/from/client": {
                    this.assertEquals(value1, req.params().get("encoded1"));
                    this.assertEquals(value2, req.params().get("encoded2"));
                    this.assertEquals(value3, req.params().get("encoded3"));
                    req.response().end();
                    break;
                }
                default: {
                    this.fail("Unknown path: " + req.path());
                }
            }
        });
        this.startServer();
        this.client.get(8080, "localhost", "/first/call/from/client", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).setFollowRedirects(true).end();
        this.await();
    }

    @Test
    public void testEventHandlersNotHoldingLock() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            HttpConnection conn = req.connection();
            switch (req.path()) {
                case "/0": {
                    req.handler(chunk -> this.assertFalse(Thread.holdsLock(conn)));
                    req.endHandler(v -> {
                        this.assertFalse(Thread.holdsLock(conn));
                        req.response().end(TestUtils.randomAlphaString(256));
                    });
                    break;
                }
                case "/1": {
                    AtomicBoolean paused = new AtomicBoolean();
                    req.pause();
                    paused.set(true);
                    this.vertx.runOnContext(v -> {
                        paused.set(false);
                        req.resume();
                    });
                    req.handler(chunk -> {
                        this.assertFalse(Thread.holdsLock(conn));
                        this.assertFalse(paused.get());
                        paused.set(true);
                        req.pause();
                        this.vertx.runOnContext(v -> {
                            paused.set(false);
                            req.resume();
                        });
                    });
                    req.endHandler(v -> {
                        this.assertFalse(Thread.holdsLock(conn));
                        this.assertFalse(paused.get());
                        req.response().end(TestUtils.randomAlphaString(256));
                    });
                }
            }
        });
        this.startServer(this.testAddress);
        for (int i = 0; i < 2; ++i) {
            this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "/" + i, resp -> {
                this.assertEquals(200L, resp.statusCode());
                HttpConnection conn = resp.request().connection();
                switch (resp.request().path()) {
                    case "/0": {
                        resp.handler(chunk -> this.assertFalse(Thread.holdsLock(conn)));
                        resp.endHandler(v -> {
                            this.assertFalse(Thread.holdsLock(conn));
                            this.complete();
                        });
                        break;
                    }
                    case "/1": {
                        AtomicBoolean paused = new AtomicBoolean();
                        resp.pause();
                        paused.set(true);
                        this.vertx.runOnContext(v -> {
                            paused.set(false);
                            resp.resume();
                        });
                        resp.handler(chunk -> {
                            this.assertFalse(Thread.holdsLock(conn));
                            this.assertFalse(paused.get());
                            paused.set(true);
                            resp.pause();
                            this.vertx.runOnContext(v -> {
                                paused.set(false);
                                resp.resume();
                            });
                        });
                        resp.endHandler(v -> {
                            this.assertFalse(Thread.holdsLock(conn));
                            this.assertFalse(paused.get());
                            this.complete();
                        });
                    }
                }
            }).end(TestUtils.randomAlphaString(256));
        }
        this.await();
    }

    @Test
    public void testEventHandlersNotHoldingLockOnClose() throws Exception {
        this.waitFor(7);
        this.server.requestHandler(req -> {
            HttpConnection conn = req.connection();
            req.exceptionHandler(err -> {
                this.assertFalse(Thread.holdsLock(conn));
                this.complete();
            });
            HttpServerResponse resp = req.response();
            resp.exceptionHandler(err -> {
                this.assertFalse(Thread.holdsLock(conn));
                this.complete();
            });
            resp.closeHandler(v -> {
                this.assertFalse(Thread.holdsLock(conn));
                this.complete();
            });
            conn.closeHandler(err -> {
                this.assertFalse(Thread.holdsLock(conn));
                this.complete();
            });
            resp.setChunked(true).write("hello");
        });
        this.startServer(this.testAddress);
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            HttpConnection conn = resp.request().connection();
            resp.exceptionHandler(err -> {
                this.assertFalse(Thread.holdsLock(conn));
                this.complete();
            });
            conn.closeHandler(v -> {
                this.assertFalse(Thread.holdsLock(conn));
                this.complete();
            });
            conn.close();
        });
        req2.exceptionHandler(err -> {
            this.assertFalse(Thread.holdsLock(req2.connection()));
            this.complete();
        });
        req2.setChunked(true).sendHead();
        this.await();
    }

    @Test
    public void testCloseHandlerWhenConnectionEnds() throws Exception {
        this.server.requestHandler(req -> {
            req.response().closeHandler(v -> this.testComplete());
            req.response().setChunked(true).write("some-data");
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> resp.handler(v -> resp.request().connection().close())).end();
        this.await();
    }

    @Test
    public void testUseResponseAfterClose() throws Exception {
        this.testAfterServerResponseClose((Handler<HttpServerResponse>)((Handler)resp -> {
            Buffer buff = Buffer.buffer();
            resp.drainHandler(this.noOpHandler());
            resp.exceptionHandler(this.noOpHandler());
            resp.setChunked(false);
            resp.setWriteQueueMaxSize(123);
            resp.writeQueueFull();
            resp.putHeader("foo", "bar");
            resp.setChunked(true);
            resp.write(buff);
            resp.write("foo");
            resp.write("foo", "UTF-8");
            resp.write(buff, this.onFailure(err1 -> resp.write("foo", this.onFailure(err2 -> resp.write("foo", "UTF-8", this.onFailure(err3 -> resp.end(this.onFailure(err4 -> this.testComplete()))))))));
        }));
    }

    @Test
    public void testSendFileAfterServerResponseClose() throws Exception {
        this.testAfterServerResponseClose((Handler<HttpServerResponse>)((Handler)resp -> {
            resp.sendFile("webroot/somefile.html");
            this.testComplete();
        }));
    }

    @Test
    public void testSendFileAsyncAfterServerResponseClose() throws Exception {
        this.testAfterServerResponseClose((Handler<HttpServerResponse>)((Handler)resp -> resp.sendFile("webroot/somefile.html", this.onFailure(err -> this.testComplete()))));
    }

    private void testAfterServerResponseClose(Handler<HttpServerResponse> test) throws Exception {
        AtomicReference clientConn = new AtomicReference();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.closeHandler(v1 -> test.handle((Object)resp));
            ((HttpConnection)clientConn.get()).close();
        });
        this.startServer();
        this.client.get(8080, "localhost", "/somepath", resp -> {}).connectionHandler(clientConn::set).end();
        this.await();
    }

    @Test
    public abstract void testCloseHandlerNotCalledWhenConnectionClosedAfterEnd() throws Exception;

    protected void testCloseHandlerNotCalledWhenConnectionClosedAfterEnd(int expected) throws Exception {
        AtomicInteger closeCount = new AtomicInteger();
        AtomicInteger endCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            req.response().closeHandler(v -> closeCount.incrementAndGet());
            req.response().endHandler(v -> endCount.incrementAndGet());
            req.connection().closeHandler(v -> {
                this.assertEquals(expected, closeCount.get());
                this.assertEquals(1L, endCount.get());
                this.testComplete();
            });
            req.response().end("some-data");
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "/somepath", resp -> resp.endHandler(v -> resp.request().connection().close())).end();
        this.await();
    }

    private TestLoggerFactory testLogging() throws Exception {
        return TestUtils.testLogging(() -> {
            try {
                this.server.requestHandler(req -> req.response().end());
                this.startServer();
                this.client.getNow(8080, "localhost", "/somepath", resp -> this.testComplete());
                this.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testClientDecompressionError() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().putHeader("Content-Encoding", "gzip").end("long response with mismatched encoding causes connection leaks"));
        this.startServer(this.testAddress);
        AtomicInteger exceptionCount = new AtomicInteger();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setTryUseCompression(true));
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.exceptionHandler(err -> {
            if (exceptionCount.incrementAndGet() == 1) {
                if (err instanceof Http2Exception) {
                    this.complete();
                    resp.request().connection().close();
                } else if (err instanceof DecompressionException) {
                    this.complete();
                }
            }
        })).connectionHandler(conn -> conn.closeHandler(v -> this.complete())).end();
        this.await();
    }

    @Test
    public void testContainsValueString() {
        this.server.requestHandler(req -> {
            this.assertTrue(req.headers().contains("Foo", "foo", false));
            this.assertFalse(req.headers().contains("Foo", "fOo", false));
            req.response().putHeader("quux", "quux");
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
                this.assertTrue(resp.headers().contains("Quux", "quux", false));
                this.assertFalse(resp.headers().contains("Quux", "quUx", false));
                this.testComplete();
            });
            req.putHeader("foo", "foo");
            req.end();
        }));
        this.await();
    }

    @Test
    public void testContainsValueStringIgnoreCase() {
        this.server.requestHandler(req -> {
            this.assertTrue(req.headers().contains("Foo", "foo", true));
            this.assertTrue(req.headers().contains("Foo", "fOo", true));
            req.response().putHeader("quux", "quux");
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
                this.assertTrue(resp.headers().contains("Quux", "quux", true));
                this.assertTrue(resp.headers().contains("Quux", "quUx", true));
                this.testComplete();
            });
            req.putHeader("foo", "foo");
            req.end();
        }));
        this.await();
    }

    @Test
    public void testContainsValueCharSequence() {
        CharSequence Foo = HttpHeaders.createOptimized((String)"Foo");
        CharSequence foo = HttpHeaders.createOptimized((String)"foo");
        CharSequence fOo = HttpHeaders.createOptimized((String)"fOo");
        CharSequence Quux = HttpHeaders.createOptimized((String)"Quux");
        CharSequence quux = HttpHeaders.createOptimized((String)"quux");
        CharSequence quUx = HttpHeaders.createOptimized((String)"quUx");
        this.server.requestHandler(req -> {
            this.assertTrue(req.headers().contains(Foo, foo, false));
            this.assertFalse(req.headers().contains(Foo, fOo, false));
            req.response().putHeader(quux, quux);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
                this.assertTrue(resp.headers().contains(Quux, quux, false));
                this.assertFalse(resp.headers().contains(Quux, quUx, false));
                this.testComplete();
            });
            req.putHeader(foo, foo);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testContainsValueCharSequenceIgnoreCase() {
        CharSequence Foo = HttpHeaders.createOptimized((String)"Foo");
        CharSequence foo = HttpHeaders.createOptimized((String)"foo");
        CharSequence fOo = HttpHeaders.createOptimized((String)"fOo");
        CharSequence Quux = HttpHeaders.createOptimized((String)"Quux");
        CharSequence quux = HttpHeaders.createOptimized((String)"quux");
        CharSequence quUx = HttpHeaders.createOptimized((String)"quUx");
        this.server.requestHandler(req -> {
            this.assertTrue(req.headers().contains(Foo, foo, true));
            this.assertTrue(req.headers().contains(Foo, fOo, true));
            req.response().putHeader(quux, quux);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
                this.assertTrue(resp.headers().contains(Quux, quux, true));
                this.assertTrue(resp.headers().contains(Quux, quUx, true));
                this.testComplete();
            });
            req.putHeader(foo, foo);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testBytesReadRequest() throws Exception {
        int length = 2048;
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(length));
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals(req.bytesRead(), length);
            req.response().end();
        }));
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> this.testComplete())).exceptionHandler(this::fail).putHeader("content-length", String.valueOf(length)).write(expected).end();
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientSynchronousConnectFailures() {
        System.setProperty("vertx.disableDnsResolver", "true");
        Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setQueryTimeout(100L)));
        try {
            int poolSize = 2;
            HttpClient client = vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(poolSize));
            AtomicInteger failures = new AtomicInteger();
            vertx.runOnContext(v -> {
                for (int i = 0; i < poolSize + 1; ++i) {
                    HttpClientRequest clientRequest = client.getAbs("http://invalid-host-name.foo.bar", resp -> this.fail());
                    AtomicBoolean f = new AtomicBoolean();
                    clientRequest.exceptionHandler(e -> {
                        if (f.compareAndSet(false, true) && failures.incrementAndGet() == poolSize + 1) {
                            this.testComplete();
                        }
                    });
                    clientRequest.end();
                }
            });
            this.await();
        }
        finally {
            vertx.close();
            System.setProperty("vertx.disableDnsResolver", "false");
        }
    }

    @Test
    public void testClientConnectInvalidPort() {
        try {
            this.client.request(HttpMethod.GET, this.testAddress, -1, "localhost", "some-uri", ar -> this.fail());
        }
        catch (Exception e) {
            this.assertEquals(e.getClass(), IllegalArgumentException.class);
            this.assertEquals(e.getMessage(), "port p must be in range 0 <= p <= 65535");
        }
    }

    protected File setupFile(String fileName, String content) throws Exception {
        File file = new File(this.testDir, fileName);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        out.write(content);
        out.close();
        return file;
    }

    protected static String generateQueryString(Map<String, String> params, char delim) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, String> param : params.entrySet()) {
            sb.append(param.getKey()).append("=").append(param.getValue());
            if (++count == params.size()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    protected static Map<String, String> genMap(int num) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < num; ++i) {
            String key;
            while (map.containsKey(key = TestUtils.randomAlphaString(1 + (int)(19.0 * Math.random())).toLowerCase())) {
            }
            map.put(key, TestUtils.randomAlphaString(1 + (int)(19.0 * Math.random())));
        }
        return map;
    }

    protected static MultiMap getHeaders(int num) {
        Map<String, String> map = HttpTest.genMap(num);
        HeadersAdaptor headers = new HeadersAdaptor((io.netty.handler.codec.http.HttpHeaders)new DefaultHttpHeaders());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            headers.add(entry.getKey(), entry.getValue());
        }
        return headers;
    }

    @Test
    public void testHttpClientRequestHeadersDontContainCROrLF() throws Exception {
        this.server.requestHandler(req -> {
            req.headers().forEach(header -> {
                String name = (String)header.getKey();
                switch (name.toLowerCase()) {
                    case "host": 
                    case ":method": 
                    case ":path": 
                    case ":scheme": 
                    case ":authority": {
                        break;
                    }
                    default: {
                        this.fail("Unexpected header " + name);
                    }
                }
            });
            this.testComplete();
        });
        this.startServer(this.testAddress);
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {});
        BiConsumer[] biConsumerArray = new BiConsumer[3];
        biConsumerArray[0] = (arg_0, arg_1) -> ((HttpClientRequest)req2).putHeader(arg_0, arg_1);
        biConsumerArray[1] = (arg_0, arg_1) -> ((MultiMap)req2.headers()).set(arg_0, arg_1);
        biConsumerArray[2] = (arg_0, arg_1) -> ((MultiMap)req2.headers()).add(arg_0, arg_1);
        List<BiConsumer> list = Arrays.asList(biConsumerArray);
        list.forEach(cs -> {
            try {
                req2.putHeader("header-name: header-value\r\nanother-header", "another-value");
                this.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        this.assertEquals(0L, req2.headers().size());
        req2.end();
        this.await();
    }

    @Test
    public void testHttpServerResponseHeadersDontContainCROrLF() throws Exception {
        this.server.requestHandler(req -> {
            BiConsumer[] biConsumerArray = new BiConsumer[3];
            biConsumerArray[0] = (arg_0, arg_1) -> ((HttpServerResponse)req.response()).putHeader(arg_0, arg_1);
            biConsumerArray[1] = (arg_0, arg_1) -> ((MultiMap)req.response().headers()).set(arg_0, arg_1);
            biConsumerArray[2] = (arg_0, arg_1) -> ((MultiMap)req.response().headers()).add(arg_0, arg_1);
            List<BiConsumer> list = Arrays.asList(biConsumerArray);
            list.forEach(cs -> {
                try {
                    cs.accept("header-name: header-value\r\nanother-header", "another-value");
                    this.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            });
            this.assertEquals(Collections.emptySet(), req.response().headers().names());
            req.response().end();
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            resp.headers().forEach(header -> {
                String name = (String)header.getKey();
                switch (name.toLowerCase()) {
                    case "content-length": {
                        break;
                    }
                    default: {
                        this.fail("Unexpected header " + name);
                    }
                }
            });
            this.testComplete();
        }).end();
        this.await();
    }

    @Test
    public void testDisableIdleTimeoutInPool() throws Exception {
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setIdleTimeout(1).setMaxPoolSize(1).setKeepAliveTimeout(10));
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.endHandler(v1 -> {
            AtomicBoolean closed = new AtomicBoolean();
            resp.request().connection().closeHandler(v2 -> closed.set(true));
            this.vertx.setTimer(2000L, id -> {
                this.assertFalse(closed.get());
                this.testComplete();
            });
        })).end();
        this.await();
    }

    @Test
    public void testKeepAliveTimeout() throws Exception {
        this.server.requestHandler(req -> req.response().end());
        HttpClientOptions options = this.createBaseClientOptions().setKeepAliveTimeout(3).setHttp2KeepAliveTimeout(3);
        this.testKeepAliveTimeout(options, 1);
    }

    protected void testKeepAliveTimeout(HttpClientOptions options, int numReqs) throws Exception {
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(options.setPoolCleanerPeriod(1));
        AtomicInteger respCount = new AtomicInteger();
        for (int i = 0; i < numReqs; ++i) {
            int current = 1 + i;
            this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
                respCount.incrementAndGet();
                if (current == numReqs) {
                    long now = System.currentTimeMillis();
                    resp.request().connection().closeHandler(v -> {
                        long timeout = System.currentTimeMillis() - now;
                        int delta = 500;
                        int low = 3000 - delta;
                        int high = 3000 + delta;
                        this.assertTrue("Expected actual close timeout " + timeout + " to be > " + low, (long)low < timeout);
                        this.assertTrue("Expected actual close timeout " + timeout + " + to be < " + high, timeout < (long)high);
                        this.testComplete();
                    });
                }
            }).end();
        }
        this.await();
    }

    @Test
    public void testPoolNotExpiring1() throws Exception {
        this.testPoolNotExpiring(this.createBaseClientOptions().setPoolCleanerPeriod(0).setKeepAliveTimeout(100).setHttp2KeepAliveTimeout(100));
    }

    @Test
    public void testPoolNotExpiring2() throws Exception {
        this.testPoolNotExpiring(this.createBaseClientOptions().setPoolCleanerPeriod(10).setKeepAliveTimeout(0).setHttp2KeepAliveTimeout(0));
    }

    private void testPoolNotExpiring(HttpClientOptions options) throws Exception {
        AtomicLong now = new AtomicLong();
        this.server.requestHandler(req -> {
            req.response().end();
            now.set(System.currentTimeMillis());
            this.vertx.setTimer(2000L, id -> req.connection().close());
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(options);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.endHandler(v1 -> resp.request().connection().closeHandler(v2 -> {
            long time = System.currentTimeMillis() - now.get();
            this.assertTrue("Was expecting " + time + " to be > 2000", time >= 2000L);
            this.testComplete();
        }))).end();
        this.await();
    }

    @Test
    public void testHttpConnect() {
        Buffer buffer = TestUtils.randomBuffer(128);
        Buffer received = Buffer.buffer();
        CompletableFuture closeSocket = new CompletableFuture();
        this.vertx.createNetServer(new NetServerOptions().setPort(1235).setHost("localhost")).connectHandler(socket -> {
            socket.handler(arg_0 -> ((NetSocket)socket).write(arg_0));
            closeSocket.thenAccept(v -> socket.close());
        }).listen(this.onSuccess(netServer -> {
            this.server.requestHandler(req -> this.vertx.createNetClient(new NetClientOptions()).connect(1235, "localhost", this.onSuccess(dst -> {
                req.response().setStatusCode(200);
                req.response().setStatusMessage("Connection established");
                NetSocket src = req.netSocket();
                Pump pump1 = Pump.pump((ReadStream)src, (WriteStream)dst).start();
                Pump pump2 = Pump.pump((ReadStream)dst, (WriteStream)src).start();
                dst.closeHandler(v -> {
                    pump1.stop();
                    pump2.stop();
                    src.close();
                });
            })));
            this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.CONNECT, this.testAddress, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals(200L, resp.statusCode());
                NetSocket socket = resp.netSocket();
                socket.handler(buff -> {
                    received.appendBuffer(buff);
                    if (received.length() == buffer.length()) {
                        closeSocket.complete(null);
                    }
                });
                socket.closeHandler(v -> {
                    this.assertEquals(buffer, received);
                    this.testComplete();
                });
                socket.write(buffer);
            }).sendHead()));
        }));
        this.await();
    }

    @Test
    public void testAccessNetSocketPendingResponseDataPaused() {
        this.testAccessNetSocketPendingResponseData(true);
    }

    @Test
    public void testAccessNetSocketPendingResponseDataNotPaused() {
        this.testAccessNetSocketPendingResponseData(false);
    }

    private void testAccessNetSocketPendingResponseData(boolean pause) {
        this.server.requestHandler(req -> {
            NetSocket so = req.netSocket();
            so.write("hello");
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.CONNECT, this.testAddress, 8080, "localhost", "some-uri", resp -> {
                NetSocket so = resp.netSocket();
                this.assertNotNull(so);
                so.handler(buff -> {
                    this.assertEquals("hello", buff.toString());
                    this.testComplete();
                });
                if (pause) {
                    so.pause();
                    this.vertx.setTimer(100L, id -> so.resume());
                }
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void testServerNetSocketCloseWithHandler() {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            NetSocket so = req.netSocket();
            so.close(this.onSuccess(v -> this.complete()));
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.CONNECT, 8080, "localhost", "some-uri", resp -> {
                NetSocket so = resp.netSocket();
                so.closeHandler(v -> this.complete());
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void testClientNetSocketCloseWithHandler() {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            NetSocket so = req.netSocket();
            so.closeHandler(v -> this.complete());
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.CONNECT, 8080, "localhost", "some-uri", resp -> {
                NetSocket so = resp.netSocket();
                so.close(this.onSuccess(v -> this.complete()));
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void testHttpInvalidConnectResponseEnded() {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            req.response().end();
            try {
                req.netSocket();
                this.fail();
            }
            catch (IllegalStateException e) {
                this.complete();
            }
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.CONNECT, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }).end()));
        this.await();
    }

    @Test
    public void testHttpInvalidConnectResponseChunked() {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            req.response().setChunked(true).write("some-chunk");
            try {
                req.netSocket();
                this.fail();
            }
            catch (IllegalStateException e) {
                this.complete();
            }
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(HttpMethod.CONNECT, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }).end()));
        this.await();
    }

    @Test
    public void testEndFromAnotherThread() throws Exception {
        this.waitFor(2);
        this.disableThreadChecks();
        this.server.requestHandler(req -> {
            req.response().endHandler(v -> this.complete());
            new Thread(() -> req.response().end()).start();
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }).end();
        this.await();
    }

    @Repeat(times=30)
    @Test
    public void testClientRequestEndDeadlock() throws Exception {
        this.server.requestHandler(req -> req.endHandler(v -> req.response().end()));
        this.startServer(this.testAddress);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v1 -> {
            HttpClientRequest request = this.client.request(HttpMethod.POST, this.testAddress, 8080, "localhost", "some-uri", resp -> resp.endHandler(v2 -> this.testComplete())).exceptionHandler(this::fail).setChunked(true);
            new Thread(() -> {
                Buffer s = TestUtils.randomBuffer(256);
                while (!request.writeQueueFull()) {
                    request.write(s);
                }
                ctx.runOnContext(v2 -> request.end());
            }).start();
        });
        this.await();
    }

    @Test
    public void testServerResponseWriteSuccess() throws Exception {
        this.testServerResponseWriteSuccess((resp, handler) -> resp.write(TestUtils.randomBuffer(1024), handler));
    }

    @Test
    public void testServerResponseEndSuccess() throws Exception {
        this.testServerResponseWriteSuccess((resp, handler) -> resp.end(TestUtils.randomBuffer(1024), handler));
    }

    private void testServerResponseWriteSuccess(BiConsumer<HttpServerResponse, Handler<AsyncResult<Void>>> op) throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            op.accept(resp, this.onSuccess(v -> this.complete()));
        });
        this.startServer();
        this.client.getNow(8080, "localhost", "some-uri", resp -> this.complete());
        this.await();
    }

    @Test
    public void testServerResponseWriteFailure() throws Exception {
        this.server.requestHandler(req -> {
            Runnable[] task;
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            Buffer chunk = TestUtils.randomBuffer(1024);
            task = new Runnable[]{() -> resp.write(chunk, ar1 -> {
                if (ar1.succeeded()) {
                    task[0].run();
                } else {
                    resp.end(ar2 -> this.testComplete());
                }
            })};
            task[0].run();
        });
        this.startServer();
        this.client.getNow(8080, "localhost", "some-uri", resp -> resp.request().connection().close());
        this.await();
    }

    @Test
    public void testClientRequestWriteSuccess() throws Exception {
        this.testClientRequestWriteSuccess((resp, handler) -> resp.write(TestUtils.randomBuffer(1024), handler));
    }

    @Test
    public void testClientRequestEndSuccess() throws Exception {
        this.testServerResponseWriteSuccess((resp, handler) -> resp.end(TestUtils.randomBuffer(1024), handler));
    }

    private void testClientRequestWriteSuccess(BiConsumer<HttpClientRequest, Handler<AsyncResult<Void>>> op) throws Exception {
        this.waitFor(2);
        CompletableFuture fut = new CompletableFuture();
        this.server.requestHandler(req -> {
            fut.complete(null);
            req.handler(v -> {
                HttpServerResponse resp = req.response();
                if (!resp.ended()) {
                    resp.end();
                }
            });
        });
        this.startServer();
        HttpClientRequest req2 = this.client.put(8080, "localhost", "some-uri", resp -> this.complete());
        req2.setChunked(true);
        req2.sendHead();
        fut.whenComplete((v1, err) -> op.accept(req2, this.onSuccess(v2 -> this.complete())));
        this.await();
    }

    @Test
    public void testClientRequestLazyWriteSuccess() throws Exception {
        this.testClientRequestLazyWriteSuccess((resp, handler) -> resp.write(TestUtils.randomBuffer(1024), handler));
    }

    @Test
    public void testClientRequestLazyEndSuccess() throws Exception {
        this.testServerResponseWriteSuccess((resp, handler) -> resp.end(TestUtils.randomBuffer(1024), handler));
    }

    private void testClientRequestLazyWriteSuccess(BiConsumer<HttpClientRequest, Handler<AsyncResult<Void>>> op) throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        HttpClientRequest req2 = this.client.put(8080, "localhost", "some-uri", resp -> this.complete());
        req2.setChunked(true);
        op.accept(req2, this.onSuccess(v -> this.complete()));
        this.await();
    }

    @Test
    public void testClientResponseWriteFailure() throws Exception {
        Runnable[] task;
        this.server.requestHandler(req -> req.connection().close());
        this.startServer();
        HttpClientRequest req2 = this.client.put(8080, "localhost", "some-uri", err -> {});
        req2.setChunked(true);
        Buffer chunk = TestUtils.randomBuffer(1024);
        task = new Runnable[]{() -> req2.write(chunk, ar1 -> {
            if (ar1.succeeded()) {
                task[0].run();
            } else {
                req2.end(ar2 -> this.testComplete());
            }
        })};
        task[0].run();
        this.await();
    }

    @Test
    public void testResetClientRequestBeforeActualSend() throws Exception {
        this.server.requestHandler(req -> {});
        this.startServer(this.testAddress);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, new RequestOptions().setPort(8080).setHost("localhost").setURI("some-uri"), resp -> this.fail());
            req.exceptionHandler(err -> {
                if (err instanceof StreamResetException) {
                    this.assertTrue(err instanceof StreamResetException);
                    this.testComplete();
                }
            });
            req.sendHead(version -> this.fail());
            req.reset();
        });
        this.await();
    }

    @Test
    public void testResetClientRequestInProgress() throws Exception {
        this.waitFor(1);
        this.server.requestHandler(req -> {});
        this.startServer(this.testAddress);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, new RequestOptions().setPort(8080).setHost("localhost").setURI("some-uri"), resp -> this.fail());
            req.exceptionHandler(err -> {
                if (err instanceof StreamResetException) {
                    this.assertTrue(err instanceof StreamResetException);
                    this.complete();
                }
            });
            req.sendHead(version -> req.reset(0L));
        });
        this.await();
    }

    @Test
    public void testResetClientRequestAwaitingResponse() throws Exception {
        CompletableFuture fut = new CompletableFuture();
        this.server.requestHandler(req -> fut.complete(null));
        this.startServer(this.testAddress);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, this.testAddress, new RequestOptions().setPort(8080).setHost("localhost").setURI("some-uri"), resp -> this.fail());
            req.exceptionHandler(err -> {
                if (err instanceof StreamResetException) {
                    this.testComplete();
                }
            });
            req.end();
            fut.thenAccept(v2 -> ctx.runOnContext(v3 -> req.reset(0L)));
        });
        this.await();
    }

    @Test
    public void testSimpleCookie() throws Exception {
        this.testCookies("foo=bar", req -> {
            this.assertEquals(1L, req.cookieCount());
            Cookie cookie = req.getCookie("foo");
            this.assertNotNull(cookie);
            this.assertEquals("bar", cookie.getValue());
            req.response().end();
        }, response -> {});
    }

    @Test
    public void testGetCookies() throws Exception {
        this.testCookies("foo=bar; wibble=blibble; plop=flop", req -> {
            this.assertEquals(3L, req.cookieCount());
            Map cookies = req.cookieMap();
            this.assertTrue(cookies.containsKey("foo"));
            this.assertTrue(cookies.containsKey("wibble"));
            this.assertTrue(cookies.containsKey("plop"));
            Cookie removed = req.response().removeCookie("foo");
            cookies = req.cookieMap();
            this.assertTrue(cookies.containsKey("foo"));
            this.assertTrue(cookies.containsKey("wibble"));
            this.assertTrue(cookies.containsKey("plop"));
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
            this.assertTrue(((String)cookies.get(0)).contains("Max-Age=0"));
            this.assertTrue(((String)cookies.get(0)).contains("Expires="));
        });
    }

    @Test
    public void testCookiesChanged() throws Exception {
        this.testCookies("foo=bar; wibble=blibble; plop=flop", req -> {
            this.assertEquals(3L, req.cookieCount());
            this.assertEquals("bar", req.getCookie("foo").getValue());
            this.assertEquals("blibble", req.getCookie("wibble").getValue());
            this.assertEquals("flop", req.getCookie("plop").getValue());
            req.response().removeCookie("plop");
            this.assertEquals(3L, req.cookieCount());
            this.assertEquals("bar", req.getCookie("foo").getValue());
            this.assertEquals("blibble", req.getCookie("wibble").getValue());
            this.assertNotNull(req.getCookie("plop"));
            req.response().addCookie(Cookie.cookie((String)"fleeb", (String)"floob"));
            this.assertEquals(4L, req.cookieCount());
            this.assertNull(req.response().removeCookie("blarb"));
            this.assertEquals(4L, req.cookieCount());
            Cookie foo = req.getCookie("foo");
            foo.setValue("blah");
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(3L, cookies.size());
            this.assertTrue(cookies.contains("foo=blah"));
            this.assertTrue(cookies.contains("fleeb=floob"));
            boolean found = false;
            for (String s : cookies) {
                if (!s.startsWith("plop")) continue;
                found = true;
                this.assertTrue(s.contains("Max-Age=0"));
                this.assertTrue(s.contains("Expires="));
                break;
            }
            this.assertTrue(found);
        });
    }

    @Test
    public void testCookieFields() throws Exception {
        Cookie cookie = Cookie.cookie((String)"foo", (String)"bar");
        this.assertEquals("foo", cookie.getName());
        this.assertEquals("bar", cookie.getValue());
        this.assertEquals("foo=bar", cookie.encode());
        this.assertNull(cookie.getPath());
        cookie.setPath("/somepath");
        this.assertEquals("/somepath", cookie.getPath());
        this.assertEquals("foo=bar; Path=/somepath", cookie.encode());
        this.assertNull(cookie.getDomain());
        cookie.setDomain("foo.com");
        this.assertEquals("foo.com", cookie.getDomain());
        this.assertEquals("foo=bar; Path=/somepath; Domain=foo.com", cookie.encode());
        long maxAge = 1800L;
        cookie.setMaxAge(maxAge);
        long now = System.currentTimeMillis();
        String encoded = cookie.encode();
        int startPos = encoded.indexOf("Expires=");
        int endPos = encoded.indexOf(59, startPos);
        String expiresDate = encoded.substring(startPos + 8, endPos);
        SimpleDateFormat dtf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
        dtf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date d = dtf.parse(expiresDate);
        this.assertTrue(d.getTime() - now >= maxAge);
        cookie.setMaxAge(Long.MIN_VALUE);
        cookie.setSecure(true);
        this.assertTrue(cookie.isSecure());
        this.assertEquals("foo=bar; Path=/somepath; Domain=foo.com; Secure", cookie.encode());
        cookie.setHttpOnly(true);
        this.assertTrue(cookie.isHttpOnly());
        this.assertEquals("foo=bar; Path=/somepath; Domain=foo.com; Secure; HTTPOnly", cookie.encode());
    }

    @Test
    public void testCookieSameSiteFieldEncoding() {
        Cookie cookie = Cookie.cookie((String)"foo", (String)"bar").setSameSite(CookieSameSite.LAX);
        this.assertEquals("foo", cookie.getName());
        this.assertEquals("bar", cookie.getValue());
        this.assertEquals(CookieSameSite.LAX, cookie.getSameSite());
        this.assertEquals("foo=bar; SameSite=Lax", cookie.encode());
        cookie.setSecure(true);
        this.assertEquals("foo=bar; Secure; SameSite=Lax", cookie.encode());
        cookie.setHttpOnly(true);
        this.assertEquals("foo=bar; Secure; HTTPOnly; SameSite=Lax", cookie.encode());
    }

    @Test
    public void testCookieSameSiteFieldValidation() throws Exception {
        Cookie cookie = Cookie.cookie((String)"foo", (String)"bar");
        try {
            cookie.setSameSite(CookieSameSite.LAX);
            cookie.setSameSite(CookieSameSite.STRICT);
            cookie.setSameSite(CookieSameSite.NONE);
            cookie.setSameSite(null);
        }
        catch (RuntimeException e) {
            this.fail();
        }
    }

    @Test
    public void testRemoveCookies() throws Exception {
        this.testCookies("foo=bar", req -> {
            Cookie removed = req.response().removeCookie("foo");
            this.assertNotNull(removed);
            this.assertEquals("foo", removed.getName());
            this.assertEquals("bar", removed.getValue());
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
            this.assertTrue(((String)cookies.get(0)).contains("foo=bar"));
            this.assertTrue(((String)cookies.get(0)).contains("Max-Age=0"));
            this.assertTrue(((String)cookies.get(0)).contains("Expires="));
        });
    }

    @Test
    public void testNoCookiesRemoveCookie() throws Exception {
        this.testCookies(null, req -> {
            req.response().removeCookie("foo");
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        });
    }

    @Test
    public void testNoCookiesCookieCount() throws Exception {
        this.testCookies(null, req -> {
            this.assertEquals(0L, req.cookieCount());
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        });
    }

    @Test
    public void testNoCookiesGetCookie() throws Exception {
        this.testCookies(null, req -> {
            this.assertNull(req.getCookie("foo"));
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        });
    }

    @Test
    public void testNoCookiesAddCookie() throws Exception {
        this.testCookies(null, req -> {
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar")));
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
        });
    }

    private void testCookies(String cookieHeader, Consumer<HttpServerRequest> serverChecker, Consumer<HttpClientResponse> clientChecker) throws Exception {
        this.server.requestHandler(serverChecker::accept);
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, this.testAddress, new RequestOptions().setPort(8080).setHost("localhost").setURI("some-uri"), resp -> {
            clientChecker.accept((HttpClientResponse)resp);
            this.testComplete();
        }).putHeader(HttpHeaders.COOKIE.toString(), cookieHeader).end();
        this.await();
    }
}

