/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.MultiMap;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class RequestOptionsTest {
    @Test
    public void testDefaults() {
        RequestOptions options = new RequestOptions();
        Assert.assertEquals((Object)"localhost", (Object)options.getHost());
        Assert.assertEquals((long)80L, (long)options.getPort());
        Assert.assertEquals((Object)RequestOptions.DEFAULT_SSL, (Object)options.isSsl());
        Assert.assertEquals((Object)"", (Object)options.getURI());
    }

    @Test
    public void testCopy() {
        RequestOptions options = new RequestOptions().setPort(8443).setSsl(Boolean.valueOf(true));
        RequestOptions copy = new RequestOptions(options);
        Assert.assertEquals((long)options.getPort(), (long)copy.getPort());
        Assert.assertEquals((Object)options.isSsl(), (Object)copy.isSsl());
    }

    @Test
    public void testToJson() {
        RequestOptions options = new RequestOptions().setPort(8443).setSsl(Boolean.valueOf(true)).addHeader("key", "value").addHeader("foo", "bar").addHeader("foo", "baz");
        JsonObject expected = new JsonObject().put("host", "localhost").put("uri", "").put("port", Integer.valueOf(8443)).put("ssl", Boolean.valueOf(true)).put("headers", new JsonObject().put("key", "value").put("foo", new JsonArray().add("bar").add("baz")));
        Assert.assertEquals((Object)expected, (Object)options.toJson());
    }

    @Test
    public void testFromJson() {
        JsonObject json = new JsonObject().put("method", "PUT").put("port", Integer.valueOf(8443)).put("ssl", Boolean.valueOf(true)).put("headers", new JsonObject().put("key", "value").put("foo", new JsonArray().add("bar").add("baz")));
        RequestOptions options = new RequestOptions(json);
        Assert.assertEquals((long)8443L, (long)options.getPort());
        Assert.assertTrue((boolean)options.isSsl());
        MultiMap headers = options.getHeaders();
        Assert.assertEquals((String)headers.toString(), (long)2L, (long)headers.size());
        Assert.assertEquals(Collections.singletonList("value"), (Object)headers.getAll("key"));
        Assert.assertEquals(Arrays.asList("bar", "baz"), (Object)headers.getAll("foo"));
    }
}

