/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.impl.KeyStoreHelper;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class KeyStoreHelperTest {
    private static final VertxInternal vertx = (VertxInternal)VertxInternal.factory.vertx();

    @Test
    public void testKeyStoreHelperSupportsRSAPrivateKeys() throws Exception {
        VertxInternal vertxInternal = (VertxInternal)VertxInternal.factory.vertx();
        PemKeyCertOptions options = new PemKeyCertOptions().addKeyPath("target/test-classes/tls/server-key.pem").addCertPath("target/test-classes/tls/server-cert.pem");
        KeyStoreHelper helper = options.getHelper((Vertx)vertx);
        this.assertKeyType(helper.store(), RSAPrivateKey.class);
    }

    @Test
    public void testKeyStoreHelperSupportsECPrivateKeys() throws Exception {
        Assume.assumeTrue((String)"ECC is not supported by VM's security providers", (boolean)this.isECCSupportedByVM());
        PemKeyCertOptions options = new PemKeyCertOptions().addKeyPath("target/test-classes/tls/server-key-ec.pem").addCertPath("target/test-classes/tls/server-cert-ec.pem");
        KeyStoreHelper helper = options.getHelper((Vertx)vertx);
        this.assertKeyType(helper.store(), ECPrivateKey.class);
    }

    private void assertKeyType(KeyStore store, Class<?> expectedKeyType) throws KeyStoreException, GeneralSecurityException {
        Assert.assertTrue((store.size() > 0 ? 1 : 0) != 0);
        Enumeration<String> e = store.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            Assert.assertThat((Object)store.getKey(alias, "dummy".toCharArray()), (Matcher)CoreMatchers.instanceOf(expectedKeyType));
            Assert.assertThat((Object)store.getCertificate(alias), (Matcher)CoreMatchers.instanceOf(X509Certificate.class));
        }
    }

    private boolean isECCSupportedByVM() {
        try {
            KeyFactory.getInstance("EC");
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }
}

