/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class ProxyOptionsTest
extends VertxTestBase {
    ProxyType randType;
    String randHost;
    int randPort;
    String randUsername;
    String randPassword;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.randType = TestUtils.randomElement(ProxyType.values());
        this.randHost = TestUtils.randomAlphaString(10);
        this.randPort = TestUtils.randomPortInt();
        this.randUsername = TestUtils.randomAlphaString(10);
        this.randPassword = TestUtils.randomAlphaString(10);
    }

    @Test
    public void testProxyOptions() {
        ProxyOptions options = new ProxyOptions();
        this.assertEquals(ProxyOptions.DEFAULT_TYPE, options.getType());
        this.assertEquals(options, options.setType(this.randType));
        this.assertEquals(this.randType, options.getType());
        TestUtils.assertNullPointerException(() -> options.setType(null));
        this.assertEquals("localhost", options.getHost());
        this.assertEquals(options, options.setHost(this.randHost));
        this.assertEquals(this.randHost, options.getHost());
        TestUtils.assertNullPointerException(() -> options.setHost(null));
        this.assertEquals(3128L, options.getPort());
        this.assertEquals(options, options.setPort(this.randPort));
        this.assertEquals(this.randPort, options.getPort());
        TestUtils.assertIllegalArgumentException(() -> options.setPort(-1));
        TestUtils.assertIllegalArgumentException(() -> options.setPort(65536));
        this.assertEquals(null, options.getUsername());
        this.assertEquals(options, options.setUsername(this.randUsername));
        this.assertEquals(this.randUsername, options.getUsername());
        this.assertEquals(null, options.getPassword());
        this.assertEquals(options, options.setPassword(this.randPassword));
        this.assertEquals(this.randPassword, options.getPassword());
    }

    @Test
    public void testCopyProxyOptions() {
        ProxyOptions options = new ProxyOptions();
        options.setType(this.randType);
        options.setHost(this.randHost);
        options.setPort(this.randPort);
        options.setUsername(this.randUsername);
        options.setPassword(this.randPassword);
        ProxyOptions copy = new ProxyOptions(options);
        this.assertEquals(this.randType, copy.getType());
        this.assertEquals(this.randPort, copy.getPort());
        this.assertEquals(this.randHost, copy.getHost());
        this.assertEquals(this.randUsername, copy.getUsername());
        this.assertEquals(this.randPassword, copy.getPassword());
    }

    @Test
    public void testDefaultOptionsJson() {
        ProxyOptions def = new ProxyOptions();
        ProxyOptions options = new ProxyOptions(new JsonObject());
        this.assertEquals(def.getType(), options.getType());
        this.assertEquals(def.getPort(), options.getPort());
        this.assertEquals(def.getHost(), options.getHost());
        this.assertEquals(def.getUsername(), options.getUsername());
        this.assertEquals(def.getPassword(), options.getPassword());
    }

    @Test
    public void testOptionsJson() {
        JsonObject json = new JsonObject();
        json.put("type", this.randType.toString()).put("host", this.randHost).put("port", Integer.valueOf(this.randPort)).put("username", this.randUsername).put("password", this.randPassword);
        ProxyOptions options = new ProxyOptions(json);
        this.assertEquals(this.randType, options.getType());
        this.assertEquals(this.randPort, options.getPort());
        this.assertEquals(this.randHost, options.getHost());
        this.assertEquals(this.randUsername, options.getUsername());
        this.assertEquals(this.randPassword, options.getPassword());
    }
}

