/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.executor;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.executor.ExecutorServiceFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExternalLoadableExecutorServiceFactory
implements ExecutorServiceFactory {
    static final Logger log = LoggerFactory.getLogger(ExecutorServiceFactory.class);

    ExecutorService getBaseExecutorService(ThreadFactory threadFactory, Integer maxConcurrency) {
        return new ThreadPoolExecutor((int)maxConcurrency, maxConcurrency, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(), threadFactory){};
    }

    public ExecutorService createExecutor(ThreadFactory threadFactory, Integer concurrency, Integer maxConcurrency) {
        log.debug((Object)(this.getClass() + "::createExecutor(" + threadFactory + ", " + concurrency + ", " + maxConcurrency + ")"));
        return LoggingProxy.proxy(this.getBaseExecutorService(threadFactory, maxConcurrency));
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.hashCode();
    }

    public static class LoggingProxy
    implements InvocationHandler {
        private final Object delegate;

        public LoggingProxy(ExecutorService coreExecutorService) {
            this.delegate = coreExecutorService;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            log.debug((Object)(this.delegate.getClass() + "::" + method.getName() + "(" + args + ")"));
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }

        public static ExecutorService proxy(ExecutorService delegate) {
            return (ExecutorService)Proxy.newProxyInstance(ExecutorService.class.getClassLoader(), new Class[]{ExecutorService.class}, (InvocationHandler)new LoggingProxy(delegate));
        }
    }
}

