/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.streams.Pipe;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.fakestream.FakeStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class PipeTest
extends AsyncTestBase {
    private FakeStream<Object> dst;
    private List<Object> emitted;
    private Object o1 = new Object();
    private Object o2 = new Object();
    private Object o3 = new Object();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dst = new FakeStream();
        this.emitted = new ArrayList<Object>();
        this.dst.handler(this.emitted::add);
    }

    @Test
    public void testSimple() {
        FakeStream src = new FakeStream();
        src.pipeTo(this.dst, this.onSuccess(v -> {
            this.assertTrue(this.dst.isEnded());
            this.assertNull(src.handler());
            this.assertNull(src.exceptionHandler());
            this.assertNull(src.endHandler());
            this.assertEquals(Arrays.asList(this.o1, this.o2, this.o3), this.emitted);
            this.testComplete();
        }));
        src.write(this.o1).write(this.o2).write(this.o3).end();
        this.await();
    }

    @Test
    public void testEndStreamPrematurely() {
        FakeStream src = new FakeStream();
        Pipe pipe = src.pipe();
        src.write(this.o1);
        src.end();
        pipe.to(this.dst, this.onSuccess(v -> {
            this.assertTrue(this.dst.isEnded());
            this.assertEquals(Collections.singletonList(this.o1), this.emitted);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testFailStreamPrematurely() {
        FakeStream src = new FakeStream();
        Pipe pipe = src.pipe();
        src.write(this.o1);
        Throwable failure = new Throwable();
        src.fail(failure);
        pipe.to(this.dst, this.onFailure(err -> {
            this.assertSame(failure, err);
            this.assertTrue(this.dst.isEnded());
            this.assertEquals(Collections.singletonList(this.o1), this.emitted);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testEndWriteStreamOnReadStreamFailure() {
        Throwable expected = new Throwable();
        FakeStream src = new FakeStream();
        Pipe pipe = src.pipe();
        pipe.to(this.dst, this.onFailure(err -> {
            this.assertSame(expected, err);
            this.assertTrue(this.dst.isEnded());
            this.testComplete();
        }));
        src.fail(expected);
        this.await();
    }

    @Test
    public void testDoNotEndWriteStreamOnReadStreamFailure() {
        Throwable expected = new Throwable();
        FakeStream src = new FakeStream();
        Pipe pipe = src.pipe();
        pipe.endOnFailure(false);
        pipe.to(this.dst, this.onFailure(err -> {
            this.assertSame(expected, err);
            this.assertFalse(this.dst.isEnded());
            this.testComplete();
        }));
        src.fail(expected);
        this.await();
    }

    @Test
    public void testEndWriteStreamOnWriteStreamFailure() {
        RuntimeException expected = new RuntimeException();
        FakeStream src = new FakeStream();
        Pipe pipe = src.pipe();
        this.dst.pause();
        pipe.to(this.dst, this.onFailure(err -> {
            this.assertFalse(src.isPaused());
            this.assertSame(expected, err);
            this.assertFalse(this.dst.isEnded());
            this.testComplete();
        }));
        while (!src.isPaused()) {
            src.write(this.o1);
        }
        this.dst.handler(item -> {
            throw expected;
        });
        this.dst.fetch(1L);
        this.await();
    }

    @Test
    public void testDoNotEndWriteStreamOnSuccess() {
        FakeStream src = new FakeStream();
        Pipe pipe = src.pipe();
        pipe.endOnSuccess(false);
        pipe.to(this.dst, this.onSuccess(v -> {
            this.assertEquals(Arrays.asList(this.o1, this.o2, this.o3), this.emitted);
            this.assertFalse(this.dst.isEnded());
            this.testComplete();
        }));
        src.write(this.o1);
        src.write(this.o2);
        src.write(this.o3);
        src.end();
        this.await();
    }

    @Test
    public void testPauseResume() {
        FakeStream src = new FakeStream();
        this.dst.setWriteQueueMaxSize(5);
        this.dst.pause();
        src.pipeTo(this.dst);
        for (int i = 0; i < 10; ++i) {
            ArrayList<Object> inp = new ArrayList<Object>();
            for (int j = 0; j < 5; ++j) {
                Object o = new Object();
                inp.add(o);
                src.write(o);
                this.assertFalse(src.isPaused());
                this.assertEquals(i, src.pauseCount());
                this.assertEquals(1 + i, src.resumeCount());
            }
            Object o = new Object();
            inp.add(o);
            src.write(o);
            this.assertTrue(src.isPaused());
            this.assertEquals(1 + i, src.pauseCount());
            this.assertEquals(1 + i, src.resumeCount());
            this.dst.resume();
            this.dst.pause();
            this.assertEquals(inp, this.emitted);
            this.emitted.clear();
            this.assertFalse(src.isPaused());
            this.assertEquals(i + 1, src.pauseCount());
            this.assertEquals(i + 2, src.resumeCount());
        }
    }

    @Test
    public void testClosePipeBeforeStart() {
        FakeStream src = new FakeStream();
        Pipe pipe = src.pipe();
        this.assertTrue(src.isPaused());
        pipe.close();
        this.assertFalse(src.isPaused());
    }

    @Test
    public void testClosePipeBeforeEnd() {
        FakeStream src = new FakeStream();
        Pipe pipe = src.pipe();
        pipe.to(this.dst);
        this.dst.pause();
        while (!src.isPaused()) {
            src.write(this.o1);
        }
        this.assertTrue(src.isPaused());
        pipe.close();
        this.assertNull(src.handler());
        this.assertNull(src.exceptionHandler());
        this.assertNull(this.dst.drainHandler());
        this.assertNull(this.dst.exceptionHandler());
        this.assertFalse(src.isPaused());
    }

    @Test
    public void testClosePipeAfterEnd() {
        FakeStream src = new FakeStream();
        Pipe pipe = src.pipe();
        pipe.to(this.dst);
        this.dst.pause();
        while (!src.isPaused()) {
            src.write(this.o1);
        }
        src.end();
        this.assertTrue(src.isPaused());
        pipe.close();
    }

    @Test
    public void testEndWriteStreamSuccess() {
        Promise completion = Promise.promise();
        this.dst.setEnd((Future<Void>)completion.future());
        FakeStream src = new FakeStream();
        Pipe pipe = src.pipe();
        AtomicReference ended = new AtomicReference();
        pipe.to(this.dst, ended::set);
        src.end();
        this.assertNull(ended.get());
        completion.complete();
        this.assertTrue(((AsyncResult)ended.get()).succeeded());
    }

    @Test
    public void testEndWriteStreamFail() {
        Promise completion = Promise.promise();
        this.dst.setEnd((Future<Void>)completion.future());
        FakeStream src = new FakeStream();
        Pipe pipe = src.pipe();
        AtomicReference ended = new AtomicReference();
        pipe.to(this.dst, ended::set);
        src.end();
        this.assertNull(ended.get());
        Exception failure = new Exception();
        completion.fail((Throwable)failure);
        this.assertTrue(((AsyncResult)ended.get()).failed());
        this.assertEquals(failure, ((AsyncResult)ended.get()).cause());
    }
}

