/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.core.impl.utils.ConcurrentCyclicSequence;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;

@State(value=Scope.Benchmark)
@Threads(value=8)
public class ConcurrentCyclicSequenceBenchmark
extends BenchmarkBase {
    private ConcurrentCyclicSequence<String> seq1;
    private ConcurrentCyclicSequence<String> seq2;
    private ConcurrentCyclicSequence<String> seq4;
    private ConcurrentCyclicSequence<String> seq8;
    private ConcurrentCyclicSequence<String> seq16;

    private static ConcurrentCyclicSequence<String> gen(int size) {
        return new ConcurrentCyclicSequence((Object[])IntStream.range(0, size + 1).mapToObj(i -> "" + i).toArray(String[]::new));
    }

    @Setup
    public void setup() {
        this.seq1 = ConcurrentCyclicSequenceBenchmark.gen(1);
        this.seq2 = ConcurrentCyclicSequenceBenchmark.gen(2);
        this.seq4 = ConcurrentCyclicSequenceBenchmark.gen(4);
        this.seq8 = ConcurrentCyclicSequenceBenchmark.gen(8);
        this.seq16 = ConcurrentCyclicSequenceBenchmark.gen(16);
    }

    @Benchmark
    public String size1() {
        return (String)this.seq1.next();
    }

    @Benchmark
    public String size2() {
        return (String)this.seq2.next();
    }

    @Benchmark
    public String size4() {
        return (String)this.seq4.next();
    }

    @Benchmark
    public String size8() {
        return (String)this.seq8.next();
    }

    @Benchmark
    public String size16() {
        return (String)this.seq16.next();
    }
}

