/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.benchmarks.HeadersUtils;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class HeadersEncodeBenchmark
extends BenchmarkBase {
    private PublicEncoder encoder;
    private ByteBuf byteBuf;
    private HttpHeaders emptyHeaders;
    private HttpHeaders nettySmallHeaders;
    private HttpHeaders vertxSmallHeaders;

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public static void consume(ByteBuf buf) {
    }

    @Setup
    public void setup() {
        this.byteBuf = Unpooled.buffer((int)1024);
        this.encoder = new PublicEncoder();
        this.emptyHeaders = EmptyHttpHeaders.INSTANCE;
        this.nettySmallHeaders = new DefaultHttpHeaders();
        this.vertxSmallHeaders = new VertxHttpHeaders();
        HeadersUtils.setBaseHeaders(this.nettySmallHeaders);
        HeadersUtils.setBaseHeaders(this.vertxSmallHeaders);
    }

    @Benchmark
    public void baseline() throws Exception {
        this.byteBuf.resetWriterIndex();
        this.encoder.encodeHeaders(this.emptyHeaders, this.byteBuf);
        HeadersEncodeBenchmark.consume(this.byteBuf);
    }

    @Benchmark
    public void nettySmall() throws Exception {
        this.byteBuf.resetWriterIndex();
        this.encoder.encodeHeaders(this.nettySmallHeaders, this.byteBuf);
        HeadersEncodeBenchmark.consume(this.byteBuf);
    }

    @Benchmark
    public void vertxSmall() throws Exception {
        this.byteBuf.resetWriterIndex();
        this.encoder.encodeHeaders(this.vertxSmallHeaders, this.byteBuf);
        HeadersEncodeBenchmark.consume(this.byteBuf);
    }

    static class PublicEncoder
    extends HttpResponseEncoder {
        PublicEncoder() {
        }

        public void encodeHeaders(HttpHeaders headers, ByteBuf buf) {
            super.encodeHeaders(headers, buf);
        }
    }
}

