/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.transport;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.test.core.BlockedThreadWarning;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.ThreadFactory;
import org.junit.Rule;
import org.junit.Test;

public class TransportTest
extends VertxTestBase {
    @Rule
    public BlockedThreadWarning blockedThreadWarning = new BlockedThreadWarning();
    private Transport transport;

    @Override
    public void setUp() throws Exception {
        this.transport = new Transport(){

            public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
                return super.eventLoopGroup(type, nThreads, null, ioRatio);
            }
        };
        super.setUp();
        this.disableThreadChecks();
    }

    @Override
    protected Vertx vertx(VertxOptions options) {
        return Vertx.factory.vertx(options, this.transport);
    }

    @Test
    public void testContext() {
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            this.assertSame(ctx, Vertx.currentContext());
            Thread th = Thread.currentThread();
            this.assertFalse(th instanceof VertxThread);
            this.assertTrue(th instanceof FastThreadLocalThread);
            ctx.runOnContext(v2 -> {
                this.assertSame(ctx, Vertx.currentContext());
                this.assertSame(th, Thread.currentThread());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testExecuteBlocking() {
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            Thread th = Thread.currentThread();
            ctx.executeBlocking(p -> {
                this.assertTrue(Context.isOnWorkerThread());
                p.complete();
            }, ar -> {
                this.assertSame(th, Thread.currentThread());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testBlockedThreadChecker() {
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            try {
                Thread.sleep(6000L);
                this.testComplete();
            }
            catch (InterruptedException e) {
                this.fail(e);
            }
        });
        this.await();
        this.blockedThreadWarning.expectMessage("nioEventLoopGroup", VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME, VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME_UNIT);
    }

    @Test
    public void testSetTimer() {
        this.vertx.setTimer(100L, id -> this.testComplete());
        this.await();
    }

    @Test
    public void testHttpServer() {
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            Thread th = Thread.currentThread();
            this.vertx.createHttpServer().requestHandler(req -> {
                this.assertSame(th, Thread.currentThread());
                Context current = Vertx.currentContext();
                current.runOnContext(v2 -> {
                    this.assertSame(th, Thread.currentThread());
                    this.assertSame(current, Vertx.currentContext());
                    req.response().end();
                });
            }).listen(8080, this.onSuccess(s -> {
                HttpClient client = this.vertx.createHttpClient();
                client.get(8080, "localhost", "/", resp -> this.testComplete()).exceptionHandler(this::fail).end();
            }));
        });
        this.await();
    }

    @Test
    public void testCreateContextFromEventLoop() {
        EventLoop eventLoop = this.vertx.nettyEventLoopGroup().next();
        ContextInternal ctx = ((VertxInternal)this.vertx).createEventLoopContext(eventLoop, null, null);
        ctx.runOnContext(v -> this.vertx.setTimer(10L, id -> {
            this.assertSame(ctx, Vertx.currentContext());
            this.testComplete();
        }));
        this.await();
    }
}

