/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class JacksonDatabindTest
extends VertxTestBase {
    @Test
    public void testGetSetMapper() {
        ObjectMapper newMapper;
        ObjectMapper mapper = Json.mapper;
        this.assertNotNull(mapper);
        Json.mapper = newMapper = new ObjectMapper();
        this.assertSame(newMapper, Json.mapper);
        Json.mapper = mapper;
    }

    @Test
    public void testGetSetPrettyMapper() {
        ObjectMapper newMapper;
        ObjectMapper mapper = Json.prettyMapper;
        this.assertNotNull(mapper);
        Json.prettyMapper = newMapper = new ObjectMapper();
        this.assertSame(newMapper, Json.prettyMapper);
        Json.prettyMapper = mapper;
    }

    @Test
    public void testGenericDecoding() {
        Pojo original = new Pojo();
        original.value = "test";
        String json = Json.encode(Collections.singletonList(original));
        List correct = (List)JacksonCodec.decodeValue((String)json, (TypeReference)new TypeReference<List<Pojo>>(){});
        this.assertTrue(correct.get(0) instanceof Pojo);
        this.assertEquals(original.value, ((Pojo)correct.get((int)0)).value);
        correct = (List)JacksonCodec.decodeValue((Buffer)Buffer.buffer((String)json, (String)"UTF8"), (TypeReference)new TypeReference<List<Pojo>>(){});
        this.assertTrue(correct.get(0) instanceof Pojo);
        this.assertEquals(original.value, ((Pojo)correct.get((int)0)).value);
        List incorrect = (List)Json.decodeValue((String)json, List.class);
        this.assertFalse(incorrect.get(0) instanceof Pojo);
        this.assertTrue(incorrect.get(0) instanceof Map);
        this.assertEquals(original.value, ((Map)incorrect.get(0)).get("value"));
    }

    @Test
    public void testInstantDecoding() {
        Pojo original = new Pojo();
        original.instant = Instant.from(DateTimeFormatter.ISO_INSTANT.parse("2018-06-20T07:25:38.397Z"));
        Pojo decoded = (Pojo)Json.decodeValue((String)"{\"instant\":\"2018-06-20T07:25:38.397Z\"}", Pojo.class);
        this.assertEquals(original.instant, decoded.instant);
    }

    @Test
    public void testNullInstantDecoding() {
        Pojo original = new Pojo();
        Pojo decoded = (Pojo)Json.decodeValue((String)"{\"instant\":null}", Pojo.class);
        this.assertEquals(original.instant, decoded.instant);
    }

    @Test
    public void testBytesDecoding() {
        Pojo original = new Pojo();
        original.bytes = TestUtils.randomByteArray(12);
        Pojo decoded = (Pojo)Json.decodeValue((String)("{\"bytes\":\"" + Base64.getEncoder().encodeToString(original.bytes) + "\"}"), Pojo.class);
        this.assertArrayEquals(original.bytes, decoded.bytes);
    }

    @Test
    public void testNullBytesDecoding() {
        Pojo original = new Pojo();
        Pojo decoded = (Pojo)Json.decodeValue((String)"{\"bytes\":null}", Pojo.class);
        this.assertEquals((Object)original.bytes, (Object)decoded.bytes);
    }

    private static class Pojo {
        @JsonProperty
        String value;
        @JsonProperty
        Instant instant;
        @JsonProperty
        byte[] bytes;

        private Pojo() {
        }
    }
}

