/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HeadersTestBase;
import io.vertx.core.http.impl.Http2HeadersAdaptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class Http2HeadersAdaptorsTest
extends HeadersTestBase {
    DefaultHttp2Headers headers;
    MultiMap map;

    @Before
    public void setUp() {
        this.headers = new DefaultHttp2Headers();
        this.map = new Http2HeadersAdaptor((Http2Headers)this.headers);
        this.separator = "=";
    }

    @Override
    protected MultiMap newMultiMap() {
        return new Http2HeadersAdaptor((Http2Headers)new DefaultHttp2Headers());
    }

    @Test
    public void testGetConvertUpperCase() {
        this.map.set("foo", "foo_value");
        Assert.assertEquals((Object)"foo_value", (Object)this.map.get("Foo"));
        Assert.assertEquals((Object)"foo_value", (Object)this.map.get((CharSequence)"Foo"));
    }

    @Test
    public void testGetAllConvertUpperCase() {
        this.map.set("foo", "foo_value");
        Assert.assertEquals(Collections.singletonList("foo_value"), (Object)this.map.getAll("Foo"));
        Assert.assertEquals(Collections.singletonList("foo_value"), (Object)this.map.getAll((CharSequence)"Foo"));
    }

    @Test
    public void testContainsConvertUpperCase() {
        this.map.set("foo", "foo_value");
        Assert.assertTrue((boolean)this.map.contains("Foo"));
        Assert.assertTrue((boolean)this.map.contains((CharSequence)"Foo"));
    }

    @Test
    public void testSetConvertUpperCase() {
        this.map.set("Foo", "foo_value");
        this.map.set((CharSequence)"Bar", (CharSequence)"bar_value");
        this.map.set("Juu", Collections.singletonList("juu_value"));
        this.map.set((CharSequence)"Daa", Collections.singletonList("daa_value"));
        this.assertHeaderNames("foo", "bar", "juu", "daa");
    }

    @Test
    public void testAddConvertUpperCase() {
        this.map.add("Foo", "foo_value");
        this.map.add((CharSequence)"Bar", (CharSequence)"bar_value");
        this.map.add("Juu", Collections.singletonList("juu_value"));
        this.map.add((CharSequence)"Daa", Collections.singletonList("daa_value"));
        this.assertHeaderNames("foo", "bar", "juu", "daa");
    }

    @Test
    public void testRemoveConvertUpperCase() {
        this.map.set("foo", "foo_value");
        this.map.remove("Foo");
        this.map.set("bar", "bar_value");
        this.map.remove((CharSequence)"Bar");
        this.assertHeaderNames(new String[0]);
    }

    @Ignore
    @Test
    public void testEntries() {
        this.map.set("foo", Arrays.asList("foo_value_1", "foo_value_2"));
        List entries = this.map.entries();
        Assert.assertEquals((long)entries.size(), (long)1L);
        Assert.assertEquals((Object)"foo", ((Map.Entry)entries.get(0)).getKey());
        Assert.assertEquals((Object)"foo_value_1", ((Map.Entry)entries.get(0)).getValue());
        this.map.set("bar", "bar_value");
        Map<String, String> collected = this.map.entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Assert.assertEquals((Object)"foo_value_1", (Object)collected.get("foo"));
        Assert.assertEquals((Object)"bar_value", (Object)collected.get("bar"));
    }

    private void assertHeaderNames(String ... expected) {
        Assert.assertEquals(new HashSet<String>(Arrays.asList(expected)), this.headers.names().stream().map(CharSequence::toString).collect(Collectors.toSet()));
    }
}

