/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.Http2TestBase;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http1xOrH2CHandler;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.DetectFileDescriptorLeaks;
import io.vertx.test.core.TestUtils;
import io.vertx.test.tls.Trust;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.junit.Test;

public class Http2ServerTest
extends Http2TestBase {
    private List<EventLoopGroup> eventLoopGroups = new ArrayList<EventLoopGroup>();
    private static final ByteBuf HTTP_1_1_POST = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"POST /whatever HTTP/1.1\r\n\r\n", (Charset)StandardCharsets.UTF_8));

    private static Http2Headers headers(String method, String scheme, String path) {
        return new DefaultHttp2Headers().method((CharSequence)method).scheme((CharSequence)scheme).path((CharSequence)path);
    }

    private static Http2Headers GET(String scheme, String path) {
        return Http2ServerTest.headers("GET", scheme, path);
    }

    private static Http2Headers GET(String path) {
        return Http2ServerTest.headers("GET", "https", path);
    }

    private static Http2Headers POST(String path) {
        return Http2ServerTest.headers("POST", "https", path);
    }

    @Override
    public void setUp() throws Exception {
        this.eventLoopGroups.clear();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        for (EventLoopGroup eventLoopGroup : this.eventLoopGroups) {
            eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testConnectionHandler() throws Exception {
        this.waitFor(2);
        Context ctx = this.vertx.getOrCreateContext();
        this.server.close();
        this.server.connectionHandler(conn -> {
            this.assertOnIOContext(ctx);
            this.complete();
        });
        this.server.requestHandler(req -> this.fail());
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> this.vertx.runOnContext(v -> this.complete()));
        fut.sync();
        this.await();
    }

    @Test
    public void testServerInitialSettings() throws Exception {
        final Http2Settings settings = TestUtils.randomHttp2Settings();
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setInitialSettings(settings));
        this.server.requestHandler(req -> this.fail());
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter(){

            public void onSettingsRead(ChannelHandlerContext ctx, io.netty.handler.codec.http2.Http2Settings newSettings) throws Http2Exception {
                Http2ServerTest.this.vertx.runOnContext(v -> {
                    Http2ServerTest.this.assertEquals(settings.getHeaderTableSize(), newSettings.headerTableSize());
                    Http2ServerTest.this.assertEquals(settings.getMaxConcurrentStreams(), newSettings.maxConcurrentStreams());
                    Http2ServerTest.this.assertEquals(settings.getInitialWindowSize(), newSettings.initialWindowSize());
                    Http2ServerTest.this.assertEquals(settings.getMaxFrameSize(), newSettings.maxFrameSize());
                    Http2ServerTest.this.assertEquals(settings.getMaxHeaderListSize(), newSettings.maxHeaderListSize());
                    Http2ServerTest.this.assertEquals(settings.get(7), newSettings.get('\u0007'));
                    Http2ServerTest.this.testComplete();
                });
            }
        }));
        fut.sync();
        this.await();
    }

    @Test
    public void testServerSettings() throws Exception {
        this.waitFor(2);
        final Http2Settings expectedSettings = TestUtils.randomHttp2Settings();
        expectedSettings.setHeaderTableSize(4096L);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions);
        Context otherContext = this.vertx.getOrCreateContext();
        this.server.connectionHandler(conn -> {
            Context ctx = Vertx.currentContext();
            otherContext.runOnContext(v -> conn.updateSettings(expectedSettings, ar -> {
                this.assertSame(ctx, Vertx.currentContext());
                Http2Settings ackedSettings = conn.settings();
                this.assertEquals(expectedSettings.getMaxHeaderListSize(), ackedSettings.getMaxHeaderListSize());
                this.assertEquals(expectedSettings.getMaxFrameSize(), ackedSettings.getMaxFrameSize());
                this.assertEquals(expectedSettings.getInitialWindowSize(), ackedSettings.getInitialWindowSize());
                this.assertEquals(expectedSettings.getMaxConcurrentStreams(), ackedSettings.getMaxConcurrentStreams());
                this.assertEquals(expectedSettings.getHeaderTableSize(), ackedSettings.getHeaderTableSize());
                this.assertEquals(expectedSettings.get(7), ackedSettings.get(7));
                this.complete();
            }));
        });
        this.server.requestHandler(req -> this.fail());
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter(){
            AtomicInteger count = new AtomicInteger();
            Context context = Http2ServerTest.access$16600(Http2ServerTest.this).getOrCreateContext();

            public void onSettingsRead(ChannelHandlerContext ctx, io.netty.handler.codec.http2.Http2Settings newSettings) throws Http2Exception {
                this.context.runOnContext(v -> {
                    switch (this.count.getAndIncrement()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            Http2ServerTest.this.assertEquals(expectedSettings.getMaxHeaderListSize(), newSettings.maxHeaderListSize());
                            Http2ServerTest.this.assertEquals(expectedSettings.getMaxFrameSize(), newSettings.maxFrameSize());
                            Http2ServerTest.this.assertEquals(expectedSettings.getInitialWindowSize(), newSettings.initialWindowSize());
                            Http2ServerTest.this.assertEquals(expectedSettings.getMaxConcurrentStreams(), newSettings.maxConcurrentStreams());
                            Http2ServerTest.this.assertEquals(null, newSettings.headerTableSize());
                            Http2ServerTest.this.complete();
                            break;
                        }
                        default: {
                            Http2ServerTest.this.fail();
                        }
                    }
                });
            }
        }));
        fut.sync();
        this.await();
    }

    @Test
    public void testClientSettings() throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        Http2Settings updatedSettings = TestUtils.randomHttp2Settings();
        AtomicInteger count = new AtomicInteger();
        this.server.connectionHandler(conn -> {
            Http2Settings settings = conn.remoteSettings();
            this.assertEquals(initialSettings.isPushEnabled(), settings.isPushEnabled());
            this.assertEquals(initialSettings.getMaxFrameSize(), settings.getMaxFrameSize());
            this.assertEquals(initialSettings.getInitialWindowSize(), settings.getInitialWindowSize());
            this.assertEquals((Object)initialSettings.getMaxConcurrentStreams(), (Object)settings.getMaxConcurrentStreams());
            this.assertEquals(initialSettings.getHeaderTableSize(), settings.getHeaderTableSize());
            conn.remoteSettingsHandler(update -> {
                this.assertOnIOContext(ctx);
                switch (count.getAndIncrement()) {
                    case 0: {
                        this.assertEquals(updatedSettings.isPushEnabled(), update.isPushEnabled());
                        this.assertEquals(updatedSettings.getMaxHeaderListSize(), update.getMaxHeaderListSize());
                        this.assertEquals(updatedSettings.getMaxFrameSize(), update.getMaxFrameSize());
                        this.assertEquals(updatedSettings.getInitialWindowSize(), update.getInitialWindowSize());
                        this.assertEquals(updatedSettings.getMaxConcurrentStreams(), update.getMaxConcurrentStreams());
                        this.assertEquals(updatedSettings.getHeaderTableSize(), update.getHeaderTableSize());
                        this.assertEquals(updatedSettings.get(7), update.get(7));
                        this.testComplete();
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
        });
        this.server.requestHandler(req -> this.fail());
        this.startServer(ctx);
        TestClient client = new TestClient();
        client.settings.putAll((Map)HttpUtils.fromVertxSettings((Http2Settings)initialSettings));
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            request.encoder.writeSettings(request.context, HttpUtils.fromVertxSettings((Http2Settings)updatedSettings), request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testGet() throws Exception {
        final String expected = TestUtils.randomAlphaString(1000);
        AtomicBoolean requestEnded = new AtomicBoolean();
        Context ctx = this.vertx.getOrCreateContext();
        AtomicInteger expectedStreamId = new AtomicInteger();
        this.server.requestHandler(req -> {
            this.assertOnIOContext(ctx);
            req.endHandler(v -> {
                this.assertOnIOContext(ctx);
                requestEnded.set(true);
            });
            HttpServerResponse resp = req.response();
            this.assertEquals(HttpMethod.GET, req.method());
            this.assertEquals("localhost:4043", req.host());
            this.assertEquals("/", req.path());
            this.assertTrue(req.isSSL());
            this.assertEquals(expectedStreamId.get(), req.streamId());
            this.assertEquals("https", req.scheme());
            this.assertEquals("/", req.uri());
            this.assertEquals("foo_request_value", req.getHeader("Foo_request"));
            this.assertEquals("bar_request_value", req.getHeader("bar_request"));
            this.assertEquals(2L, req.headers().getAll("juu_request").size());
            this.assertEquals("juu_request_value_1", req.headers().getAll("juu_request").get(0));
            this.assertEquals("juu_request_value_2", req.headers().getAll("juu_request").get(1));
            this.assertEquals(Collections.singletonList("cookie_1; cookie_2; cookie_3"), req.headers().getAll("cookie"));
            resp.putHeader("content-type", "text/plain");
            resp.putHeader("Foo_response", "foo_response_value");
            resp.putHeader("bar_response", "bar_response_value");
            resp.putHeader("juu_response", Arrays.asList("juu_response_value_1", "juu_response_value_2"));
            resp.end(expected);
        });
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            final int id = request.nextStreamId();
            expectedStreamId.set(id);
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(id, streamId);
                        Http2ServerTest.this.assertEquals("200", headers.status().toString());
                        Http2ServerTest.this.assertEquals("text/plain", ((CharSequence)headers.get((Object)"content-type")).toString());
                        Http2ServerTest.this.assertEquals("foo_response_value", ((CharSequence)headers.get((Object)"foo_response")).toString());
                        Http2ServerTest.this.assertEquals("bar_response_value", ((CharSequence)headers.get((Object)"bar_response")).toString());
                        Http2ServerTest.this.assertEquals(2L, headers.getAll((Object)"juu_response").size());
                        Http2ServerTest.this.assertEquals("juu_response_value_1", ((CharSequence)headers.getAll((Object)"juu_response").get(0)).toString());
                        Http2ServerTest.this.assertEquals("juu_response_value_2", ((CharSequence)headers.getAll((Object)"juu_response").get(1)).toString());
                        Http2ServerTest.this.assertFalse(endStream);
                    });
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    String actual = data.toString(StandardCharsets.UTF_8);
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(id, streamId);
                        Http2ServerTest.this.assertEquals(expected, actual);
                        Http2ServerTest.this.assertTrue(endOfStream);
                        Http2ServerTest.this.testComplete();
                    });
                    return super.onDataRead(ctx, streamId, data, padding, endOfStream);
                }
            });
            Http2Headers headers = Http2ServerTest.GET("/").authority((CharSequence)"localhost:4043");
            headers.set((Object)"foo_request", (Object)"foo_request_value");
            headers.set((Object)"bar_request", (Object)"bar_request_value");
            headers.set((Object)"juu_request", (Object[])new CharSequence[]{"juu_request_value_1", "juu_request_value_2"});
            headers.set((Object)"cookie", Arrays.asList("cookie_1", "cookie_2", "cookie_3"));
            request.encoder.writeHeaders(request.context, id, headers, 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testStatusMessage() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setStatusCode(404);
            this.assertEquals("Not Found", resp.getStatusMessage());
            resp.setStatusMessage("whatever");
            this.assertEquals("whatever", resp.getStatusMessage());
            this.testComplete();
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testURI() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals("/some/path", req.path());
            this.assertEquals("foo=foo_value&bar=bar_value_1&bar=bar_value_2", req.query());
            this.assertEquals("/some/path?foo=foo_value&bar=bar_value_1&bar=bar_value_2", req.uri());
            this.assertEquals("http://whatever.com/some/path?foo=foo_value&bar=bar_value_1&bar=bar_value_2", req.absoluteURI());
            this.assertEquals("whatever.com", req.host());
            MultiMap params = req.params();
            Set names = params.names();
            this.assertEquals(2L, names.size());
            this.assertTrue(names.contains("foo"));
            this.assertTrue(names.contains("bar"));
            this.assertEquals("foo_value", params.get("foo"));
            this.assertEquals(Collections.singletonList("foo_value"), params.getAll("foo"));
            this.assertEquals("bar_value_1", params.get("bar"));
            this.assertEquals(Arrays.asList("bar_value_1", "bar_value_2"), params.getAll("bar"));
            this.testComplete();
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)"GET").scheme((CharSequence)"http").authority((CharSequence)"whatever.com").path((CharSequence)"/some/path?foo=foo_value&bar=bar_value_1&bar=bar_value_2");
            request.encoder.writeHeaders(request.context, id, headers, 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testHeadersEndHandler() throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            resp.putHeader("some", "some-header");
            resp.headersEndHandler(v -> {
                this.assertOnIOContext(ctx);
                this.assertFalse(resp.headWritten());
                resp.putHeader("extra", "extra-header");
            });
            resp.write("something");
            this.assertTrue(resp.headWritten());
            resp.end();
        });
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals("some-header", ((CharSequence)headers.get((Object)"some")).toString());
                        Http2ServerTest.this.assertEquals("extra-header", ((CharSequence)headers.get((Object)"extra")).toString());
                        Http2ServerTest.this.testComplete();
                    });
                }
            });
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testBodyEndHandler() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            AtomicInteger count = new AtomicInteger();
            resp.bodyEndHandler(v -> {
                this.assertEquals(0L, count.getAndIncrement());
                this.assertTrue(resp.ended());
            });
            resp.write("something");
            this.assertEquals(0L, count.get());
            resp.end();
            this.assertEquals(1L, count.get());
            this.testComplete();
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testPost() throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        Buffer expectedContent = TestUtils.randomBuffer(1000);
        Buffer postContent = Buffer.buffer();
        this.server.requestHandler(req -> {
            this.assertOnIOContext(ctx);
            req.handler(buff -> {
                this.assertOnIOContext(ctx);
                postContent.appendBuffer(buff);
            });
            req.endHandler(v -> {
                this.assertOnIOContext(ctx);
                req.response().putHeader("content-type", "text/plain").end("");
                this.assertEquals(expectedContent, postContent);
                this.testComplete();
            });
        });
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, (Http2Headers)Http2ServerTest.POST("/").set((Object)"content-type", (Object)"text/plain"), 0, false, request.context.newPromise());
            request.encoder.writeData(request.context, id, expectedContent.getByteBuf(), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testPostFileUpload() throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        this.server.requestHandler(req -> {
            Buffer tot = Buffer.buffer();
            req.setExpectMultipart(true);
            req.uploadHandler(upload -> {
                this.assertOnIOContext(ctx);
                this.assertEquals("file", upload.name());
                this.assertEquals("tmp-0.txt", upload.filename());
                this.assertEquals("image/gif", upload.contentType());
                upload.handler(arg_0 -> ((Buffer)tot).appendBuffer(arg_0));
                upload.endHandler(v -> {
                    this.assertEquals(tot, Buffer.buffer((String)"some-content"));
                    this.testComplete();
                });
            });
            req.endHandler(v -> {
                this.assertEquals(0L, req.formAttributes().size());
                req.response().putHeader("content-type", "text/plain").end("done");
            });
        });
        this.startServer(ctx);
        String contentType = "multipart/form-data; boundary=a4e41223-a527-49b6-ac1c-315d76be757e";
        String contentLength = "225";
        String body = "--a4e41223-a527-49b6-ac1c-315d76be757e\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp-0.txt\"\r\nContent-Type: image/gif; charset=utf-8\r\nContent-Length: 12\r\n\r\nsome-content\r\n--a4e41223-a527-49b6-ac1c-315d76be757e--\r\n";
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, (Http2Headers)((Http2Headers)Http2ServerTest.POST("/form").set((Object)"content-type", (Object)contentType)).set((Object)"content-length", (Object)contentLength), 0, false, request.context.newPromise());
            request.encoder.writeData(request.context, id, Buffer.buffer((String)body).getByteBuf(), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testInvalidPostFileUpload() throws Exception {
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            AtomicInteger errCount = new AtomicInteger();
            req.exceptionHandler(err -> errCount.incrementAndGet());
            req.endHandler(v -> {
                this.assertTrue(errCount.get() > 0);
                this.testComplete();
            });
        });
        this.startServer();
        String contentType = "multipart/form-data; boundary=a4e41223-a527-49b6-ac1c-315d76be757e";
        String contentLength = "225";
        String body = "--a4e41223-a527-49b6-ac1c-315d76be757e\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp-0.txt\"\r\nContent-Type: image/gif; charset=ABCD\r\nContent-Length: 12\r\n\r\nsome-content\r\n--a4e41223-a527-49b6-ac1c-315d76be757e--\r\n";
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, (Http2Headers)((Http2Headers)Http2ServerTest.POST("/form").set((Object)"content-type", (Object)contentType)).set((Object)"content-length", (Object)contentLength), 0, false, request.context.newPromise());
            request.encoder.writeData(request.context, id, Buffer.buffer((String)body).getByteBuf(), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testConnect() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.CONNECT, req.method());
            this.assertEquals("whatever.com", req.host());
            this.assertNull(req.path());
            this.assertNull(req.query());
            this.assertNull(req.scheme());
            this.assertNull(req.uri());
            this.assertNull(req.absoluteURI());
            this.testComplete();
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)"CONNECT").authority((CharSequence)"whatever.com");
            request.encoder.writeHeaders(request.context, id, headers, 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testServerRequestPauseResume() throws Exception {
        this.testStreamPauseResume(req -> req);
    }

    private void testStreamPauseResume(Function<HttpServerRequest, ReadStream<Buffer>> streamProvider) throws Exception {
        Buffer expected = Buffer.buffer();
        String chunk = TestUtils.randomAlphaString(1000);
        AtomicBoolean done = new AtomicBoolean();
        AtomicBoolean paused = new AtomicBoolean();
        Buffer received = Buffer.buffer();
        this.server.requestHandler(req -> {
            ReadStream stream = (ReadStream)streamProvider.apply((HttpServerRequest)req);
            this.vertx.setPeriodic(1L, timerID -> {
                if (paused.get()) {
                    this.vertx.cancelTimer(timerID.longValue());
                    done.set(true);
                    this.vertx.setTimer(100L, id -> stream.resume());
                }
            });
            stream.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
            stream.endHandler(v -> {
                this.assertEquals(expected, received);
                this.testComplete();
            });
            stream.pause();
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, (Http2Headers)Http2ServerTest.POST("/form").set((Object)"content-type", (Object)"text/plain"), 0, false, request.context.newPromise());
            request.context.flush();
            Http2Stream stream = request.connection.stream(id);
            class Anonymous {
                final /* synthetic */ TestClient.Connection val$request;
                final /* synthetic */ Http2Stream val$stream;
                final /* synthetic */ String val$chunk;
                final /* synthetic */ Buffer val$expected;
                final /* synthetic */ int val$id;
                final /* synthetic */ AtomicBoolean val$paused;

                Anonymous() {
                    this.val$request = connection;
                    this.val$stream = http2Stream;
                    this.val$chunk = string;
                    this.val$expected = buffer;
                    this.val$id = n;
                    this.val$paused = atomicBoolean;
                }

                void send() {
                    boolean writable = this.val$request.encoder.flowController().isWritable(this.val$stream);
                    if (writable) {
                        Buffer buf = Buffer.buffer((String)this.val$chunk);
                        this.val$expected.appendBuffer(buf);
                        this.val$request.encoder.writeData(this.val$request.context, this.val$id, buf.getByteBuf(), 0, false, this.val$request.context.newPromise());
                        this.val$request.context.flush();
                        this.val$request.context.executor().execute(this::send);
                    } else {
                        this.val$request.encoder.writeData(this.val$request.context, this.val$id, Unpooled.EMPTY_BUFFER, 0, true, this.val$request.context.newPromise());
                        this.val$request.context.flush();
                        this.val$paused.set(true);
                    }
                }
            }
            new Anonymous().send();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testServerResponseWritability() throws Exception {
        this.testStreamWritability(req -> {
            HttpServerResponse resp = req.response();
            resp.putHeader("content-type", "text/plain");
            resp.setChunked(true);
            return resp;
        });
    }

    private void testStreamWritability(Function<HttpServerRequest, WriteStream<Buffer>> streamProvider) throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        String content = TestUtils.randomAlphaString(1024);
        final StringBuilder expected = new StringBuilder();
        Promise whenFull = Promise.promise();
        final AtomicBoolean drain = new AtomicBoolean();
        this.server.requestHandler(req -> {
            WriteStream stream = (WriteStream)streamProvider.apply((HttpServerRequest)req);
            this.vertx.setPeriodic(1L, timerID -> {
                if (stream.writeQueueFull()) {
                    stream.drainHandler(v -> {
                        this.assertOnIOContext(ctx);
                        expected.append("last");
                        stream.end((Object)Buffer.buffer((String)"last"));
                    });
                    this.vertx.cancelTimer(timerID.longValue());
                    drain.set(true);
                    whenFull.complete();
                } else {
                    expected.append(content);
                    Buffer buf = Buffer.buffer((String)content);
                    stream.write((Object)buf);
                }
            });
        });
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            final AtomicInteger toAck = new AtomicInteger();
            int id = request.nextStreamId();
            Http2ConnectionEncoder encoder = request.encoder;
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter(){
                StringBuilder received = new StringBuilder();

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    this.received.append(data.toString(StandardCharsets.UTF_8));
                    int delta = super.onDataRead(ctx, streamId, data, padding, endOfStream);
                    if (endOfStream) {
                        Http2ServerTest.this.vertx.runOnContext(v -> {
                            Http2ServerTest.this.assertEquals(expected.toString(), this.received.toString());
                            Http2ServerTest.this.testComplete();
                        });
                        return delta;
                    }
                    if (drain.get()) {
                        return delta;
                    }
                    toAck.getAndAdd(delta);
                    return 0;
                }
            });
            whenFull.future().onComplete(ar -> request.context.executor().execute(() -> {
                try {
                    request.decoder.flowController().consumeBytes(request.connection.stream(id), toAck.intValue());
                    request.context.flush();
                }
                catch (Http2Exception e) {
                    e.printStackTrace();
                    this.fail(e);
                }
            }));
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testTrailers() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            resp.write("some-content");
            resp.putTrailer("Foo", "foo_value");
            resp.putTrailer("bar", "bar_value");
            resp.putTrailer("juu", Arrays.asList("juu_value_1", "juu_value_2"));
            resp.end();
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){
                int count;

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    switch (this.count++) {
                        case 0: {
                            Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.assertFalse(endStream));
                            break;
                        }
                        case 1: {
                            Http2ServerTest.this.vertx.runOnContext(v -> {
                                Http2ServerTest.this.assertEquals("foo_value", ((CharSequence)headers.get((Object)"foo")).toString());
                                Http2ServerTest.this.assertEquals(1L, headers.getAll((Object)"foo").size());
                                Http2ServerTest.this.assertEquals("foo_value", ((CharSequence)headers.getAll((Object)"foo").get(0)).toString());
                                Http2ServerTest.this.assertEquals("bar_value", ((CharSequence)headers.getAll((Object)"bar").get(0)).toString());
                                Http2ServerTest.this.assertEquals(2L, headers.getAll((Object)"juu").size());
                                Http2ServerTest.this.assertEquals("juu_value_1", ((CharSequence)headers.getAll((Object)"juu").get(0)).toString());
                                Http2ServerTest.this.assertEquals("juu_value_2", ((CharSequence)headers.getAll((Object)"juu").get(1)).toString());
                                Http2ServerTest.this.assertTrue(endStream);
                                Http2ServerTest.this.testComplete();
                            });
                            break;
                        }
                        default: {
                            Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.fail());
                        }
                    }
                }
            });
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testServerResetClientStream() throws Exception {
        this.server.requestHandler(req -> req.handler(buf -> req.response().reset(8L)));
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){

                public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(8L, errorCode);
                        Http2ServerTest.this.testComplete();
                    });
                }
            });
            Http2ConnectionEncoder encoder = request.encoder;
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, false, request.context.newPromise());
            encoder.writeData(request.context, id, Buffer.buffer((String)"hello").getByteBuf(), 0, false, request.context.newPromise());
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testClientResetServerStream() throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        Promise bufReceived = Promise.promise();
        AtomicInteger resetCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            req.handler(buf -> bufReceived.complete());
            req.exceptionHandler(err -> {
                this.assertEquals(ctx, Vertx.currentContext());
                if (err instanceof StreamResetException) {
                    this.assertEquals(10L, ((StreamResetException)err).getCode());
                    this.assertEquals(0L, resetCount.getAndIncrement());
                }
            });
            req.response().exceptionHandler(err -> {
                this.assertEquals(ctx, Vertx.currentContext());
                if (err instanceof StreamResetException) {
                    this.assertEquals(10L, ((StreamResetException)err).getCode());
                    this.assertEquals(1L, resetCount.getAndIncrement());
                    this.testComplete();
                }
            });
        });
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            Http2ConnectionEncoder encoder = request.encoder;
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, false, request.context.newPromise());
            encoder.writeData(request.context, id, Buffer.buffer((String)"hello").getByteBuf(), 0, false, request.context.newPromise());
            bufReceived.future().onComplete(ar -> {
                encoder.writeRstStream(request.context, id, 10L, request.context.newPromise());
                request.context.flush();
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testConnectionClose() throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        this.server.requestHandler(req -> {
            HttpConnection conn = req.connection();
            conn.closeHandler(v -> {
                this.assertSame(ctx, Vertx.currentContext());
                this.testComplete();
            });
            req.response().putHeader("Content-Type", "text/plain").end();
        });
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            Http2ConnectionEncoder encoder = request.encoder;
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter((TestClient.Connection)request){
                final /* synthetic */ TestClient.Connection val$request;
                {
                    this.val$request = connection;
                }

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    this.val$request.context.close();
                }
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testPushPromise() throws Exception {
        this.testPushPromise(Http2ServerTest.GET("/").authority((CharSequence)"whatever.com"), (resp, handler) -> resp.push(HttpMethod.GET, "/wibble", handler), headers -> {
            this.assertEquals("GET", headers.method().toString());
            this.assertEquals("https", headers.scheme().toString());
            this.assertEquals("/wibble", headers.path().toString());
            this.assertEquals("whatever.com", headers.authority().toString());
        });
    }

    @Test
    public void testPushPromiseHeaders() throws Exception {
        this.testPushPromise(Http2ServerTest.GET("/").authority((CharSequence)"whatever.com"), (resp, handler) -> resp.push(HttpMethod.GET, "/wibble", MultiMap.caseInsensitiveMultiMap().set("foo", "foo_value").set((CharSequence)"bar", Arrays.asList("bar_value_1", "bar_value_2")), handler), headers -> {
            this.assertEquals("GET", headers.method().toString());
            this.assertEquals("https", headers.scheme().toString());
            this.assertEquals("/wibble", headers.path().toString());
            this.assertEquals(null, headers.authority());
            this.assertEquals("foo_value", ((CharSequence)headers.get((Object)"foo")).toString());
            this.assertEquals(Arrays.asList("bar_value_1", "bar_value_2"), headers.getAll((Object)"bar").stream().map(CharSequence::toString).collect(Collectors.toList()));
        });
    }

    @Test
    public void testPushPromiseNoAuthority() throws Exception {
        Http2Headers get = Http2ServerTest.GET("/");
        get.remove((Object)"authority");
        this.testPushPromise(get, (resp, handler) -> resp.push(HttpMethod.GET, "/wibble", handler), headers -> {
            this.assertEquals("GET", headers.method().toString());
            this.assertEquals("https", headers.scheme().toString());
            this.assertEquals("/wibble", headers.path().toString());
            this.assertEquals("localhost:4043", headers.authority().toString());
        });
    }

    @Test
    public void testPushPromiseOverrideAuthority() throws Exception {
        this.testPushPromise(Http2ServerTest.GET("/").authority((CharSequence)"whatever.com"), (resp, handler) -> resp.push(HttpMethod.GET, "override.com", "/wibble", handler), headers -> {
            this.assertEquals("GET", headers.method().toString());
            this.assertEquals("https", headers.scheme().toString());
            this.assertEquals("/wibble", headers.path().toString());
            this.assertEquals("override.com", headers.authority().toString());
        });
    }

    @Test
    public void testPushPromiseOverrideAuthorityWithNull() throws Exception {
        this.testPushPromise(Http2ServerTest.GET("/").authority((CharSequence)"whatever.com"), (resp, handler) -> resp.push(HttpMethod.GET, null, "/wibble", handler), headers -> {
            this.assertEquals("GET", headers.method().toString());
            this.assertEquals("https", headers.scheme().toString());
            this.assertEquals("/wibble", headers.path().toString());
            this.assertEquals(null, headers.authority());
        });
    }

    private void testPushPromise(Http2Headers requestHeaders, BiConsumer<HttpServerResponse, Handler<AsyncResult<HttpServerResponse>>> pusher, final Consumer<Http2Headers> headerChecker) throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        this.server.requestHandler(req -> {
            Handler handler = ar -> {
                this.assertSame(ctx, Vertx.currentContext());
                this.assertTrue(ar.succeeded());
                HttpServerResponse response = (HttpServerResponse)ar.result();
                response.end("the_content");
                TestUtils.assertIllegalStateException(() -> response.push(HttpMethod.GET, "/wibble2", resp -> {}));
            };
            pusher.accept(req.response(), handler);
        });
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            Http2ConnectionEncoder encoder = request.encoder;
            encoder.writeHeaders(request.context, id, requestHeaders, 0, true, request.context.newPromise());
            final HashMap pushed = new HashMap();
            request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter(){

                public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
                    pushed.put(promisedStreamId, headers);
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    int delta = super.onDataRead(ctx, streamId, data, padding, endOfStream);
                    String content = data.toString(StandardCharsets.UTF_8);
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(Collections.singleton(streamId), pushed.keySet());
                        Http2ServerTest.this.assertEquals("the_content", content);
                        Http2Headers pushedHeaders = (Http2Headers)pushed.get(streamId);
                        headerChecker.accept(pushedHeaders);
                        Http2ServerTest.this.testComplete();
                    });
                    return delta;
                }
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testResetActivePushPromise() throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            this.assertTrue(ar.succeeded());
            this.assertOnIOContext(ctx);
            HttpServerResponse response = (HttpServerResponse)ar.result();
            AtomicInteger resets = new AtomicInteger();
            response.exceptionHandler(err -> {
                if (err instanceof StreamResetException) {
                    this.assertEquals(8L, ((StreamResetException)err).getCode());
                    resets.incrementAndGet();
                }
            });
            response.closeHandler(v -> {
                this.testComplete();
                this.assertEquals(1L, resets.get());
            });
            response.setChunked(true).write("some_content");
        }));
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            Http2ConnectionEncoder encoder = request.encoder;
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter((TestClient.Connection)request){
                final /* synthetic */ TestClient.Connection val$request;
                {
                    this.val$request = connection;
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    this.val$request.encoder.writeRstStream(ctx, streamId, Http2Error.CANCEL.code(), ctx.newPromise());
                    this.val$request.context.flush();
                    return super.onDataRead(ctx, streamId, data, padding, endOfStream);
                }
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testQueuePushPromise() throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        final int numPushes = 10;
        final HashSet pushSent = new HashSet();
        this.server.requestHandler(req -> {
            req.response().setChunked(true).write("abc");
            int i = 0;
            while (i < numPushes) {
                int val = i++;
                String path = "/wibble" + val;
                req.response().push(HttpMethod.GET, path, ar -> {
                    this.assertTrue(ar.succeeded());
                    this.assertSame(ctx, Vertx.currentContext());
                    pushSent.add(path);
                    this.vertx.setTimer(10L, id -> ((HttpServerResponse)ar.result()).end("wibble-" + val));
                });
            }
        });
        this.startServer(ctx);
        TestClient client = new TestClient();
        client.settings.maxConcurrentStreams(3L);
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            Http2ConnectionEncoder encoder = request.encoder;
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter(){
                int count;
                Set pushReceived;
                {
                    this.count = numPushes;
                    this.pushReceived = new HashSet();
                }

                public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
                    this.pushReceived.add(headers.path().toString());
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    if (this.count-- == 0) {
                        Http2ServerTest.this.vertx.runOnContext(v -> {
                            Http2ServerTest.this.assertEquals(numPushes, pushSent.size());
                            Http2ServerTest.this.assertEquals(this.pushReceived, pushSent);
                            Http2ServerTest.this.testComplete();
                        });
                    }
                    return super.onDataRead(ctx, streamId, data, padding, endOfStream);
                }
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testResetPendingPushPromise() throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            this.assertFalse(ar.succeeded());
            this.assertOnIOContext(ctx);
            this.testComplete();
        }));
        this.startServer(ctx);
        TestClient client = new TestClient();
        client.settings.maxConcurrentStreams(0L);
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            Http2ConnectionEncoder encoder = request.encoder;
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter((TestClient.Connection)request){
                final /* synthetic */ TestClient.Connection val$request;
                {
                    this.val$request = connection;
                }

                public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
                    this.val$request.encoder.writeRstStream(this.val$request.context, promisedStreamId, Http2Error.CANCEL.code(), this.val$request.context.newPromise());
                    this.val$request.context.flush();
                }
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testMissingMethodPseudoHeader() throws Exception {
        this.testMalformedRequestHeaders(new DefaultHttp2Headers().scheme((CharSequence)"http").path((CharSequence)"/"));
    }

    @Test
    public void testMissingSchemePseudoHeader() throws Exception {
        this.testMalformedRequestHeaders(new DefaultHttp2Headers().method((CharSequence)"GET").path((CharSequence)"/"));
    }

    @Test
    public void testMissingPathPseudoHeader() throws Exception {
        this.testMalformedRequestHeaders(new DefaultHttp2Headers().method((CharSequence)"GET").scheme((CharSequence)"http"));
    }

    @Test
    public void testInvalidAuthority() throws Exception {
        this.testMalformedRequestHeaders(new DefaultHttp2Headers().method((CharSequence)"GET").scheme((CharSequence)"http").authority((CharSequence)"foo@localhost:4043").path((CharSequence)"/"));
    }

    @Test
    public void testConnectInvalidPath() throws Exception {
        this.testMalformedRequestHeaders(new DefaultHttp2Headers().method((CharSequence)"CONNECT").path((CharSequence)"/").authority((CharSequence)"localhost:4043"));
    }

    @Test
    public void testConnectInvalidScheme() throws Exception {
        this.testMalformedRequestHeaders(new DefaultHttp2Headers().method((CharSequence)"CONNECT").scheme((CharSequence)"http").authority((CharSequence)"localhost:4043"));
    }

    @Test
    public void testConnectInvalidAuthority() throws Exception {
        this.testMalformedRequestHeaders(new DefaultHttp2Headers().method((CharSequence)"CONNECT").authority((CharSequence)"foo@localhost:4043"));
    }

    private void testMalformedRequestHeaders(Http2Headers headers) throws Exception {
        this.server.requestHandler(req -> this.fail());
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            Http2ConnectionEncoder encoder = request.encoder;
            encoder.writeHeaders(request.context, id, headers, 0, true, request.context.newPromise());
            request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter(){

                public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.testComplete());
                }
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testRequestHandlerFailure() throws Exception {
        this.testHandlerFailure(false, (err, server) -> server.requestHandler(req -> {
            throw err;
        }));
    }

    @Test
    public void testRequestEndHandlerFailure() throws Exception {
        this.testHandlerFailure(false, (err, server) -> server.requestHandler(req -> req.endHandler(v -> {
            throw err;
        })));
    }

    @Test
    public void testRequestEndHandlerFailureWithData() throws Exception {
        this.testHandlerFailure(true, (err, server) -> server.requestHandler(req -> req.endHandler(v -> {
            throw err;
        })));
    }

    @Test
    public void testRequestDataHandlerFailure() throws Exception {
        this.testHandlerFailure(true, (err, server) -> server.requestHandler(req -> req.handler(buf -> {
            throw err;
        })));
    }

    private void testHandlerFailure(boolean data, BiConsumer<RuntimeException, HttpServer> configurator) throws Exception {
        RuntimeException failure = new RuntimeException();
        Http2Settings settings = TestUtils.randomHttp2Settings();
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setInitialSettings(settings));
        configurator.accept(failure, this.server);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.exceptionHandler(err -> {
            this.assertSame(err, failure);
            this.testComplete();
        });
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, !data, request.context.newPromise());
            if (data) {
                request.encoder.writeData(request.context, id, Buffer.buffer((String)"hello").getByteBuf(), 0, true, request.context.newPromise());
            }
        });
        fut.sync();
        this.await();
    }

    private static File createTempFile(Buffer buffer) throws Exception {
        File f = File.createTempFile("vertx", ".bin");
        f.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(f);){
            out.write(buffer.getBytes());
        }
        return f;
    }

    @Test
    public void testSendFile() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(1000000));
        File tmp = Http2ServerTest.createTempFile(expected);
        this.testSendFile(expected, tmp.getAbsolutePath(), 0L, expected.length());
    }

    @Test
    public void testSendFileRange() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(1000000));
        File tmp = Http2ServerTest.createTempFile(expected);
        int from = 200000;
        int to = 700000;
        this.testSendFile(expected.slice(from, to), tmp.getAbsolutePath(), from, to - from);
    }

    @Test
    public void testSendEmptyFile() throws Exception {
        Buffer expected = Buffer.buffer();
        File tmp = Http2ServerTest.createTempFile(expected);
        this.testSendFile(expected, tmp.getAbsolutePath(), 0L, expected.length());
    }

    private void testSendFile(final Buffer expected, String path, long offset, final long length) throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.bodyEndHandler(v -> {
                this.assertEquals(resp.bytesWritten(), length);
                this.complete();
            });
            resp.sendFile(path, offset, length);
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){
                Buffer buffer = Buffer.buffer();
                Http2Headers responseHeaders;

                private void endStream() {
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals("" + length, ((CharSequence)this.responseHeaders.get((Object)"content-length")).toString());
                        Http2ServerTest.this.assertEquals(expected, this.buffer);
                        Http2ServerTest.this.complete();
                    });
                }

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    this.responseHeaders = headers;
                    if (endStream) {
                        this.endStream();
                    }
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    this.buffer.appendBuffer(Buffer.buffer((ByteBuf)data.duplicate()));
                    if (endOfStream) {
                        this.endStream();
                    }
                    return data.readableBytes() + padding;
                }
            });
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testStreamError() throws Exception {
        this.waitFor(2);
        Promise when = Promise.promise();
        Context ctx = this.vertx.getOrCreateContext();
        this.server.requestHandler(req -> {
            AtomicInteger reqErrors = new AtomicInteger();
            req.exceptionHandler(err -> {
                this.assertEquals(ctx, Vertx.currentContext());
                reqErrors.incrementAndGet();
            });
            AtomicInteger respErrors = new AtomicInteger();
            req.response().exceptionHandler(err -> {
                this.assertEquals(ctx, Vertx.currentContext());
                respErrors.incrementAndGet();
            });
            req.response().closeHandler(v -> {
                this.assertEquals(ctx, Vertx.currentContext());
                this.assertTrue("Was expecting reqErrors to be > 0", reqErrors.get() > 0);
                this.assertTrue("Was expecting respErrors to be > 0", respErrors.get() > 0);
                this.complete();
            });
            req.response().endHandler(v -> {
                this.assertEquals(ctx, Vertx.currentContext());
                this.complete();
            });
            when.complete();
        });
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            Http2ConnectionEncoder encoder = request.encoder;
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, false, request.context.newPromise());
            request.context.flush();
            when.future().onComplete(ar -> {
                request.channel.write((Object)Buffer.buffer((byte[])new byte[]{0, 0, 18, 0, 8, 0, 0, 0, (byte)(id & 0xFF), 31, 104, 101, 108, 108, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}).getByteBuf());
                request.context.flush();
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testPromiseStreamError() throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        this.waitFor(2);
        final Promise when = Promise.promise();
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            this.assertTrue(ar.succeeded());
            this.assertOnIOContext(ctx);
            when.complete();
            HttpServerResponse resp = (HttpServerResponse)ar.result();
            AtomicInteger erros = new AtomicInteger();
            resp.exceptionHandler(err -> {
                this.assertSame(ctx, Vertx.currentContext());
                erros.incrementAndGet();
            });
            resp.closeHandler(v -> {
                this.assertSame(ctx, Vertx.currentContext());
                this.assertTrue("Was expecting errors to be > 0", erros.get() > 0);
                this.complete();
            });
            resp.endHandler(v -> {
                this.assertSame(ctx, Vertx.currentContext());
                this.complete();
            });
            resp.setChunked(true).write("whatever");
        }));
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter((TestClient.Connection)request){
                final /* synthetic */ TestClient.Connection val$request;
                {
                    this.val$request = connection;
                }

                public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
                    when.future().onComplete(ar -> {
                        Http2ConnectionEncoder encoder = request.encoder;
                        encoder.frameWriter().writeHeaders(request.context, promisedStreamId, Http2ServerTest.GET("/"), 0, false, request.context.newPromise());
                        request.context.flush();
                    });
                }
            });
            int id = request.nextStreamId();
            Http2ConnectionEncoder encoder = request.encoder;
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, false, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testConnectionDecodeError() throws Exception {
        Context ctx = this.vertx.getOrCreateContext();
        this.waitFor(3);
        Promise when = Promise.promise();
        this.server.requestHandler(req -> {
            AtomicInteger reqFailures = new AtomicInteger();
            AtomicInteger respFailures = new AtomicInteger();
            req.exceptionHandler(err -> {
                this.assertSame(ctx, Vertx.currentContext());
                reqFailures.incrementAndGet();
            });
            req.response().exceptionHandler(err -> {
                this.assertSame(ctx, Vertx.currentContext());
                respFailures.incrementAndGet();
            });
            req.response().closeHandler(v -> {
                this.assertSame(ctx, Vertx.currentContext());
                this.complete();
            });
            req.response().endHandler(v -> {
                this.assertTrue(reqFailures.get() > 0);
                this.assertTrue(respFailures.get() > 0);
                this.assertSame(ctx, Vertx.currentContext());
                this.complete();
            });
            HttpConnection conn = req.connection();
            AtomicInteger connFailures = new AtomicInteger();
            conn.exceptionHandler(err -> {
                this.assertSame(ctx, Vertx.currentContext());
                connFailures.incrementAndGet();
            });
            conn.closeHandler(v -> {
                this.assertTrue(connFailures.get() > 0);
                this.assertSame(ctx, Vertx.currentContext());
                this.complete();
            });
            when.complete();
        });
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            Http2ConnectionEncoder encoder = request.encoder;
            when.future().onComplete(ar -> {
                encoder.frameWriter().writeRstStream(request.context, 10, 0L, request.context.newPromise());
                request.context.flush();
            });
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, false, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testServerSendGoAwayNoError() throws Exception {
        this.waitFor(2);
        AtomicReference first = new AtomicReference();
        AtomicInteger status = new AtomicInteger();
        AtomicInteger closed = new AtomicInteger();
        AtomicBoolean done = new AtomicBoolean();
        Context ctx = this.vertx.getOrCreateContext();
        Handler requestHandler = req -> {
            if (first.compareAndSet(null, req)) {
                req.exceptionHandler(err -> this.assertTrue(done.get()));
                req.response().exceptionHandler(err -> this.assertTrue(done.get()));
            } else {
                this.assertEquals(0L, status.getAndIncrement());
                req.exceptionHandler(err -> closed.incrementAndGet());
                req.response().exceptionHandler(err -> closed.incrementAndGet());
                HttpConnection conn = req.connection();
                conn.shutdownHandler(v -> this.assertTrue(done.get()));
                conn.closeHandler(v -> this.assertTrue(done.get()));
                ctx.runOnContext(v1 -> {
                    conn.goAway(0L, ((HttpServerRequest)first.get()).response().streamId());
                    this.vertx.setTimer(300L, timerID -> {
                        this.assertEquals(1L, status.getAndIncrement());
                        done.set(true);
                        this.complete();
                    });
                });
            }
        };
        this.testServerSendGoAway((Handler<HttpServerRequest>)requestHandler, 0);
    }

    @Test
    public void testServerSendGoAwayInteralError() throws Exception {
        this.waitFor(3);
        AtomicReference first = new AtomicReference();
        AtomicInteger status = new AtomicInteger();
        AtomicInteger closed = new AtomicInteger();
        Handler requestHandler = req -> {
            if (first.compareAndSet(null, req)) {
                req.exceptionHandler(err -> this.fail());
                req.response().closeHandler(err -> closed.incrementAndGet());
                req.response().endHandler(err -> closed.incrementAndGet());
            } else {
                this.assertEquals(0L, status.getAndIncrement());
                req.exceptionHandler(err -> this.fail());
                req.response().closeHandler(err -> closed.incrementAndGet());
                req.response().endHandler(err -> closed.incrementAndGet());
                HttpConnection conn = req.connection();
                conn.closeHandler(v -> {
                    this.assertEquals(4L, closed.get());
                    this.assertEquals(1L, status.get());
                    this.complete();
                });
                conn.shutdownHandler(v -> {
                    this.assertEquals(1L, status.get());
                    this.complete();
                });
                conn.goAway(2L, ((HttpServerRequest)first.get()).response().streamId());
            }
        };
        this.testServerSendGoAway((Handler<HttpServerRequest>)requestHandler, 2);
    }

    @Test
    public void testShutdownWithTimeout() throws Exception {
        this.waitFor(2);
        AtomicInteger closed = new AtomicInteger();
        AtomicReference first = new AtomicReference();
        AtomicInteger status = new AtomicInteger();
        Handler requestHandler = req -> {
            if (first.compareAndSet(null, req)) {
                req.exceptionHandler(err -> this.fail());
                req.response().closeHandler(err -> closed.incrementAndGet());
                req.response().endHandler(err -> closed.incrementAndGet());
            } else {
                this.assertEquals(0L, status.getAndIncrement());
                req.exceptionHandler(err -> this.fail());
                req.response().closeHandler(err -> closed.incrementAndGet());
                req.response().endHandler(err -> closed.incrementAndGet());
                HttpConnection conn = req.connection();
                conn.closeHandler(v -> {
                    this.assertEquals(4L, closed.get());
                    this.assertEquals(1L, status.getAndIncrement());
                    this.complete();
                });
                conn.shutdown(300L);
            }
        };
        this.testServerSendGoAway((Handler<HttpServerRequest>)requestHandler, 0);
    }

    @Test
    public void testShutdown() throws Exception {
        this.waitFor(2);
        AtomicReference first = new AtomicReference();
        AtomicInteger status = new AtomicInteger();
        Handler requestHandler = req -> {
            if (first.compareAndSet(null, req)) {
                req.exceptionHandler(err -> this.fail());
                req.response().exceptionHandler(err -> this.fail());
            } else {
                this.assertEquals(0L, status.getAndIncrement());
                req.exceptionHandler(err -> this.fail());
                req.response().exceptionHandler(err -> this.fail());
                HttpConnection conn = req.connection();
                conn.closeHandler(v -> {
                    this.assertEquals(2L, status.getAndIncrement());
                    this.complete();
                });
                conn.shutdown();
                this.vertx.setTimer(300L, timerID -> {
                    this.assertEquals(1L, status.getAndIncrement());
                    ((HttpServerRequest)first.get()).response().end();
                    req.response().end();
                });
            }
        };
        this.testServerSendGoAway((Handler<HttpServerRequest>)requestHandler, 0);
    }

    private void testServerSendGoAway(Handler<HttpServerRequest> requestHandler, final int expectedError) throws Exception {
        this.server.requestHandler(requestHandler);
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){

                public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(expectedError, errorCode);
                        Http2ServerTest.this.complete();
                    });
                }
            });
            Http2ConnectionEncoder encoder = request.encoder;
            int id1 = request.nextStreamId();
            encoder.writeHeaders(request.context, id1, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            int id2 = request.nextStreamId();
            encoder.writeHeaders(request.context, id2, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testServerClose() throws Exception {
        this.waitFor(2);
        AtomicInteger status = new AtomicInteger();
        Handler requestHandler = req -> {
            HttpConnection conn = req.connection();
            conn.shutdownHandler(v -> this.assertEquals(0L, status.getAndIncrement()));
            conn.closeHandler(v -> {
                this.assertEquals(1L, status.getAndIncrement());
                this.complete();
            });
            conn.close();
        };
        this.server.requestHandler(requestHandler);
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            request.channel.closeFuture().addListener(v1 -> this.vertx.runOnContext(v2 -> this.complete()));
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){

                public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.assertEquals(0L, errorCode));
                }
            });
            Http2ConnectionEncoder encoder = request.encoder;
            int id = request.nextStreamId();
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testClientSendGoAwayNoError() throws Exception {
        Promise abc = Promise.promise();
        Context ctx = this.vertx.getOrCreateContext();
        Handler requestHandler = req -> {
            HttpConnection conn = req.connection();
            AtomicInteger numShutdown = new AtomicInteger();
            AtomicBoolean completed = new AtomicBoolean();
            conn.shutdownHandler(v -> {
                this.assertOnIOContext(ctx);
                numShutdown.getAndIncrement();
                this.vertx.setTimer(100L, timerID -> {
                    completed.set(true);
                    this.testComplete();
                });
            });
            conn.goAwayHandler(ga -> {
                this.assertOnIOContext(ctx);
                this.assertEquals(0L, numShutdown.get());
                req.response().end();
            });
            conn.closeHandler(v -> this.assertTrue(completed.get()));
            abc.complete();
        };
        this.server.requestHandler(requestHandler);
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            Http2ConnectionEncoder encoder = request.encoder;
            int id = request.nextStreamId();
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
            abc.future().onComplete(ar -> {
                encoder.writeGoAway(request.context, id, 0L, Unpooled.EMPTY_BUFFER, request.context.newPromise());
                request.context.flush();
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testClientSendGoAwayInternalError() throws Exception {
        Promise abc = Promise.promise();
        Context ctx = this.vertx.getOrCreateContext();
        Handler requestHandler = req -> {
            HttpConnection conn = req.connection();
            AtomicInteger status = new AtomicInteger();
            conn.goAwayHandler(ga -> {
                this.assertOnIOContext(ctx);
                this.assertEquals(0L, status.getAndIncrement());
                req.response().end();
            });
            conn.shutdownHandler(v -> {
                this.assertOnIOContext(ctx);
                this.assertEquals(1L, status.getAndIncrement());
            });
            conn.closeHandler(v -> {
                this.assertEquals(2L, status.getAndIncrement());
                this.testComplete();
            });
            abc.complete();
        };
        this.server.requestHandler(requestHandler);
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            Http2ConnectionEncoder encoder = request.encoder;
            int id = request.nextStreamId();
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
            abc.future().onComplete(ar -> {
                encoder.writeGoAway(request.context, id, 3L, Unpooled.EMPTY_BUFFER, request.context.newPromise());
                request.context.flush();
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testShutdownOverride() throws Exception {
        AtomicLong shutdown = new AtomicLong();
        Handler requestHandler = req -> {
            HttpConnection conn = req.connection();
            shutdown.set(System.currentTimeMillis());
            conn.shutdown(10000L);
            this.vertx.setTimer(300L, v -> conn.shutdown(300L));
        };
        this.server.requestHandler(requestHandler);
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            request.channel.closeFuture().addListener(v1 -> this.vertx.runOnContext(v2 -> {
                this.assertTrue(shutdown.get() - System.currentTimeMillis() < 1200L);
                this.testComplete();
            }));
            Http2ConnectionEncoder encoder = request.encoder;
            int id = request.nextStreamId();
            encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testRequestResponseLifecycle() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            req.endHandler(v -> {
                TestUtils.assertIllegalStateException(() -> req.setExpectMultipart(false));
                TestUtils.assertIllegalStateException(() -> req.handler(buf -> {}));
                TestUtils.assertIllegalStateException(() -> req.uploadHandler(upload -> {}));
                TestUtils.assertIllegalStateException(() -> req.endHandler(v2 -> {}));
                this.complete();
            });
            HttpServerResponse resp = req.response();
            resp.setChunked(true).write(Buffer.buffer((String)"whatever"));
            this.assertTrue(resp.headWritten());
            TestUtils.assertIllegalStateException(() -> resp.setChunked(false));
            TestUtils.assertIllegalStateException(() -> resp.setStatusCode(100));
            TestUtils.assertIllegalStateException(() -> resp.setStatusMessage("whatever"));
            TestUtils.assertIllegalStateException(() -> resp.putHeader("a", "b"));
            TestUtils.assertIllegalStateException(() -> resp.putHeader((CharSequence)"a", (CharSequence)"b"));
            TestUtils.assertIllegalStateException(() -> resp.putHeader("a", Arrays.asList("a", "b")));
            TestUtils.assertIllegalStateException(() -> resp.putHeader((CharSequence)"a", Arrays.asList("a", "b")));
            TestUtils.assertIllegalStateException(() -> ((HttpServerResponse)resp).writeContinue());
            resp.end();
            TestUtils.assertIllegalStateException(() -> resp.write("a"));
            TestUtils.assertIllegalStateException(() -> resp.write("a", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> resp.write(Buffer.buffer((String)"a")));
            TestUtils.assertIllegalStateException(() -> ((HttpServerResponse)resp).end());
            TestUtils.assertIllegalStateException(() -> resp.end("a"));
            TestUtils.assertIllegalStateException(() -> resp.end("a", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> resp.end(Buffer.buffer((String)"a")));
            TestUtils.assertIllegalStateException(() -> resp.sendFile("the-file.txt"));
            TestUtils.assertIllegalStateException(() -> resp.reset(0L));
            TestUtils.assertIllegalStateException(() -> resp.closeHandler(v -> {}));
            TestUtils.assertIllegalStateException(() -> resp.endHandler(v -> {}));
            TestUtils.assertIllegalStateException(() -> resp.drainHandler(v -> {}));
            TestUtils.assertIllegalStateException(() -> resp.exceptionHandler(err -> {}));
            TestUtils.assertIllegalStateException(() -> ((HttpServerResponse)resp).writeQueueFull());
            TestUtils.assertIllegalStateException(() -> resp.setWriteQueueMaxSize(100));
            TestUtils.assertIllegalStateException(() -> resp.putTrailer("a", "b"));
            TestUtils.assertIllegalStateException(() -> resp.putTrailer((CharSequence)"a", (CharSequence)"b"));
            TestUtils.assertIllegalStateException(() -> resp.putTrailer("a", Arrays.asList("a", "b")));
            TestUtils.assertIllegalStateException(() -> resp.putTrailer((CharSequence)"a", Arrays.asList("a", "b")));
            TestUtils.assertIllegalStateException(() -> resp.push(HttpMethod.GET, "/whatever", ar -> {}));
            this.complete();
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testResponseCompressionDisabled() throws Exception {
        this.waitFor(2);
        final String expected = TestUtils.randomAlphaString(1000);
        this.server.requestHandler(req -> req.response().end(expected));
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(null, headers.get((Object)HttpHeaderNames.CONTENT_ENCODING));
                        Http2ServerTest.this.complete();
                    });
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    String s = data.toString(StandardCharsets.UTF_8);
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(expected, s);
                        Http2ServerTest.this.complete();
                    });
                    return super.onDataRead(ctx, streamId, data, padding, endOfStream);
                }
            });
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, (Http2Headers)Http2ServerTest.GET("/").add((Object)"accept-encoding", (Object)"gzip"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testResponseCompressionEnabled() throws Exception {
        this.waitFor(2);
        final String expected = TestUtils.randomAlphaString(1000);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setCompressionSupported(true));
        this.server.requestHandler(req -> req.response().end(expected));
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals("gzip", ((CharSequence)headers.get((Object)HttpHeaderNames.CONTENT_ENCODING)).toString());
                        Http2ServerTest.this.complete();
                    });
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    byte[] bytes = new byte[data.readableBytes()];
                    data.readBytes(bytes);
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        String decoded;
                        try {
                            int i;
                            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            while ((i = in.read()) != -1) {
                                baos.write(i);
                            }
                            decoded = baos.toString();
                        }
                        catch (IOException e) {
                            Http2ServerTest.this.fail(e);
                            return;
                        }
                        Http2ServerTest.this.assertEquals(expected, decoded);
                        Http2ServerTest.this.complete();
                    });
                    return super.onDataRead(ctx, streamId, data, padding, endOfStream);
                }
            });
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, (Http2Headers)Http2ServerTest.GET("/").add((Object)"accept-encoding", (Object)"gzip"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testRequestCompressionEnabled() throws Exception {
        String expected = TestUtils.randomAlphaString(1000);
        byte[] expectedGzipped = TestUtils.compressGzip(expected);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setDecompressionSupported(true));
        this.server.requestHandler(req -> {
            StringBuilder postContent = new StringBuilder();
            req.handler(buff -> postContent.append(buff.toString()));
            req.endHandler(v -> {
                req.response().putHeader("content-type", "text/plain").end("");
                this.assertEquals(expected, postContent.toString());
                this.testComplete();
            });
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, (Http2Headers)Http2ServerTest.POST("/").add((Object)"content-encoding", (Object)"gzip"), 0, false, request.context.newPromise());
            request.encoder.writeData(request.context, id, Buffer.buffer((byte[])expectedGzipped).getByteBuf(), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void test100ContinueHandledManually() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals("100-continue", req.getHeader("expect"));
            HttpServerResponse resp = req.response();
            resp.writeContinue();
            req.bodyHandler(body -> {
                this.assertEquals("the-body", body.toString());
                resp.putHeader("wibble", "wibble-value").end();
            });
        });
        this.test100Continue();
    }

    @Test
    public void test100ContinueHandledAutomatically() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setHandle100ContinueAutomatically(true));
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            req.bodyHandler(body -> {
                this.assertEquals("the-body", body.toString());
                resp.putHeader("wibble", "wibble-value").end();
            });
        });
        this.test100Continue();
    }

    private void test100Continue() throws Exception {
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter((TestClient.Connection)request, id){
                int count = 0;
                final /* synthetic */ TestClient.Connection val$request;
                final /* synthetic */ int val$id;
                {
                    this.val$request = connection;
                    this.val$id = n;
                }

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    switch (this.count++) {
                        case 0: {
                            Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.assertEquals("100", headers.status().toString()));
                            this.val$request.encoder.writeData(this.val$request.context, this.val$id, Buffer.buffer((String)"the-body").getByteBuf(), 0, true, this.val$request.context.newPromise());
                            this.val$request.context.flush();
                            break;
                        }
                        case 1: {
                            Http2ServerTest.this.vertx.runOnContext(v -> {
                                Http2ServerTest.this.assertEquals("200", headers.status().toString());
                                Http2ServerTest.this.assertEquals("wibble-value", ((CharSequence)headers.get((Object)"wibble")).toString());
                                Http2ServerTest.this.testComplete();
                            });
                            break;
                        }
                        default: {
                            Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.fail());
                        }
                    }
                }
            });
            request.encoder.writeHeaders(request.context, id, (Http2Headers)Http2ServerTest.GET("/").add((Object)"expect", (Object)"100-continue"), 0, false, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void test100ContinueRejectedManually() throws Exception {
        this.server.requestHandler(req -> {
            req.response().setStatusCode(405).end();
            req.handler(buf -> this.fail());
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){
                int count = 0;

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    switch (this.count++) {
                        case 0: {
                            Http2ServerTest.this.vertx.runOnContext(v -> {
                                Http2ServerTest.this.assertEquals("405", headers.status().toString());
                                Http2ServerTest.this.vertx.setTimer(100L, v2 -> Http2ServerTest.this.testComplete());
                            });
                            break;
                        }
                        default: {
                            Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.fail());
                        }
                    }
                }
            });
            request.encoder.writeHeaders(request.context, id, (Http2Headers)Http2ServerTest.GET("/").add((Object)"expect", (Object)"100-continue"), 0, false, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testNetSocketConnect() throws Exception {
        this.waitFor(2);
        List callbacks = Collections.synchronizedList(new ArrayList());
        this.server.requestHandler(req -> {
            NetSocket socket = req.netSocket();
            AtomicInteger status = new AtomicInteger();
            socket.handler(buff -> {
                switch (status.getAndIncrement()) {
                    case 0: {
                        this.assertEquals(Buffer.buffer((String)"some-data"), buff);
                        socket.write(buff, this.onSuccess(v2 -> callbacks.add(0)));
                        break;
                    }
                    case 1: {
                        this.assertEquals(Buffer.buffer((String)"last-data"), buff);
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
            socket.endHandler(v1 -> {
                this.assertEquals(2L, status.getAndIncrement());
                socket.write(Buffer.buffer((String)"last-data"), this.onSuccess(v2 -> callbacks.add(1)));
            });
            socket.closeHandler(v -> {
                this.assertEquals(2L, callbacks.size());
                this.assertEquals(Arrays.asList(0, 1), callbacks);
                this.complete();
            });
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter((TestClient.Connection)request, id){
                StringBuilder received = new StringBuilder();
                final /* synthetic */ TestClient.Connection val$request;
                final /* synthetic */ int val$id;
                {
                    this.val$request = connection;
                    this.val$id = n;
                }

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals("200", headers.status().toString());
                        Http2ServerTest.this.assertFalse(endStream);
                    });
                    this.val$request.encoder.writeData(this.val$request.context, this.val$id, Buffer.buffer((String)"some-data").getByteBuf(), 0, false, this.val$request.context.newPromise());
                    this.val$request.context.flush();
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    String s = data.toString(StandardCharsets.UTF_8);
                    this.received.append(s);
                    if (this.received.toString().equals("some-data")) {
                        this.received.setLength(0);
                        Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.assertFalse(endOfStream));
                        this.val$request.encoder.writeData(this.val$request.context, this.val$id, Buffer.buffer((String)"last-data").getByteBuf(), 0, true, this.val$request.context.newPromise());
                    } else if (endOfStream) {
                        Http2ServerTest.this.vertx.runOnContext(v -> {
                            Http2ServerTest.this.assertEquals("last-data", this.received.toString());
                            Http2ServerTest.this.complete();
                        });
                    }
                    return data.readableBytes() + padding;
                }
            });
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, false, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    @DetectFileDescriptorLeaks
    public void testNetSocketSendFile() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(1000000));
        File tmp = Http2ServerTest.createTempFile(expected);
        this.testNetSocketSendFile(expected, tmp.getAbsolutePath(), 0L, expected.length());
    }

    @Test
    public void testNetSocketSendFileRange() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(1000000));
        File tmp = Http2ServerTest.createTempFile(expected);
        int from = 200000;
        int to = 700000;
        this.testNetSocketSendFile(expected.slice(from, to), tmp.getAbsolutePath(), from, to - from);
    }

    private void testNetSocketSendFile(final Buffer expected, String path, long offset, long length) throws Exception {
        this.server.requestHandler(req -> {
            NetSocket socket = req.netSocket();
            socket.sendFile(path, offset, length, ar -> {
                this.assertTrue(ar.succeeded());
                socket.end();
            });
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){
                Buffer received = Buffer.buffer();

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals("200", headers.status().toString());
                        Http2ServerTest.this.assertFalse(endStream);
                    });
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    this.received.appendBuffer(Buffer.buffer((ByteBuf)data.copy()));
                    if (endOfStream) {
                        Http2ServerTest.this.vertx.runOnContext(v -> {
                            Http2ServerTest.this.assertEquals(this.received, expected);
                            Http2ServerTest.this.testComplete();
                        });
                    }
                    return data.readableBytes() + padding;
                }
            });
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testServerCloseNetSocket() throws Exception {
        this.waitFor(2);
        AtomicInteger writeAcks = new AtomicInteger(0);
        AtomicInteger status = new AtomicInteger();
        this.server.requestHandler(req -> {
            NetSocket socket = req.netSocket();
            socket.handler(buff -> {
                switch (status.getAndIncrement()) {
                    case 0: {
                        this.assertEquals(Buffer.buffer((String)"some-data"), buff);
                        socket.write(buff, this.onSuccess(v -> writeAcks.incrementAndGet()));
                        socket.close();
                        break;
                    }
                    case 1: {
                        this.assertEquals(Buffer.buffer((String)"last-data"), buff);
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
            socket.endHandler(v -> this.assertEquals(2L, status.getAndIncrement()));
            socket.closeHandler(v -> {
                this.assertEquals(3L, status.getAndIncrement());
                this.complete();
                this.assertEquals(1L, writeAcks.get());
            });
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter((TestClient.Connection)request, id){
                int count = 0;
                StringBuilder received = new StringBuilder();
                final /* synthetic */ TestClient.Connection val$request;
                final /* synthetic */ int val$id;
                {
                    this.val$request = connection;
                    this.val$id = n;
                }

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    int c = this.count++;
                    Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.assertEquals(0L, c));
                    this.val$request.encoder.writeData(this.val$request.context, this.val$id, Buffer.buffer((String)"some-data").getByteBuf(), 0, false, this.val$request.context.newPromise());
                    this.val$request.context.flush();
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    String s = data.toString(StandardCharsets.UTF_8);
                    this.received.append(s);
                    if (endOfStream) {
                        this.val$request.encoder.writeData(this.val$request.context, this.val$id, Buffer.buffer((String)"last-data").getByteBuf(), 0, true, this.val$request.context.newPromise());
                        Http2ServerTest.this.vertx.runOnContext(v -> {
                            Http2ServerTest.this.assertEquals("some-data", this.received.toString());
                            Http2ServerTest.this.complete();
                        });
                    }
                    return data.readableBytes() + padding;
                }
            });
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, false, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testNetSocketHandleReset() throws Exception {
        this.server.requestHandler(req -> {
            NetSocket socket = req.netSocket();
            AtomicInteger status = new AtomicInteger();
            socket.exceptionHandler(err -> {
                this.assertTrue(err instanceof StreamResetException);
                StreamResetException ex = (StreamResetException)err;
                this.assertEquals(0L, ex.getCode());
                this.assertEquals(0L, status.getAndIncrement());
            });
            socket.endHandler(v -> this.fail());
            socket.closeHandler(v -> {
                this.assertEquals(1L, status.getAndIncrement());
                this.testComplete();
            });
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter((TestClient.Connection)request){
                int count = 0;
                final /* synthetic */ TestClient.Connection val$request;
                {
                    this.val$request = connection;
                }

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    int c = this.count++;
                    Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.assertEquals(0L, c));
                    this.val$request.encoder.writeRstStream(ctx, streamId, 0L, ctx.newPromise());
                    this.val$request.context.flush();
                }
            });
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, false, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testNetSocketPauseResume() throws Exception {
        this.testStreamPauseResume(HttpServerRequest::netSocket);
    }

    @Test
    public void testNetSocketWritability() throws Exception {
        this.testStreamWritability(HttpServerRequest::netSocket);
    }

    @Test
    public void testUnknownFrame() throws Exception {
        Buffer expectedSend = TestUtils.randomBuffer(500);
        final Buffer expectedRecv = TestUtils.randomBuffer(500);
        Context ctx = this.vertx.getOrCreateContext();
        this.server.requestHandler(req -> req.customFrameHandler(frame -> {
            this.assertOnIOContext(ctx);
            this.assertEquals(10L, frame.type());
            this.assertEquals(253L, frame.flags());
            this.assertEquals(expectedSend, frame.payload());
            req.response().writeCustomFrame(12, 134, expectedRecv).end();
        }));
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){
                int status = 0;

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    int s = this.status++;
                    Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.assertEquals(0L, s));
                }

                public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
                    int s = this.status++;
                    Buffer recv = Buffer.buffer((ByteBuf)payload.copy());
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(1L, s);
                        Http2ServerTest.this.assertEquals(12L, frameType);
                        Http2ServerTest.this.assertEquals(134L, flags.value());
                        Http2ServerTest.this.assertEquals(expectedRecv, recv);
                    });
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    int len = data.readableBytes();
                    int s = this.status++;
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(2L, s);
                        Http2ServerTest.this.assertEquals(0L, len);
                        Http2ServerTest.this.assertTrue(endOfStream);
                        Http2ServerTest.this.testComplete();
                    });
                    return data.readableBytes() + padding;
                }
            });
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, false, request.context.newPromise());
            request.encoder.writeFrame(request.context, (byte)10, id, new Http2Flags(253), expectedSend.getByteBuf(), request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testUpgradeToClearTextGet() throws Exception {
        this.testUpgradeToClearText(HttpMethod.GET, Buffer.buffer());
    }

    @Test
    public void testUpgradeToClearTextPut() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(8192));
        this.testUpgradeToClearText(HttpMethod.PUT, expected);
    }

    private void testUpgradeToClearText(HttpMethod method, Buffer expected) throws Exception {
        this.server.close();
        AtomicInteger serverConnectionCount = new AtomicInteger();
        this.server = this.vertx.createHttpServer(this.serverOptions.setHost("localhost").setPort(8080).setUseAlpn(false).setSsl(false).setInitialSettings(new Http2Settings().setMaxConcurrentStreams(20000L))).connectionHandler(conn -> serverConnectionCount.incrementAndGet());
        this.server.requestHandler(req -> {
            this.assertEquals("http", req.scheme());
            this.assertEquals(method, req.method());
            this.assertEquals(HttpVersion.HTTP_2, req.version());
            this.assertEquals(10000L, req.connection().remoteSettings().getMaxConcurrentStreams());
            this.assertFalse(req.isSSL());
            req.bodyHandler(body -> {
                this.assertEquals(expected, body);
                req.response().end();
            });
        }).connectionHandler(conn -> {
            this.assertNotNull(conn);
            serverConnectionCount.incrementAndGet();
        });
        this.startServer();
        AtomicInteger clientConnectionCount = new AtomicInteger();
        this.client = this.vertx.createHttpClient(this.clientOptions.setUseAlpn(false).setSsl(false).setInitialSettings(new Http2Settings().setMaxConcurrentStreams(10000L)));
        Promise p1 = Promise.promise();
        p1.future().onComplete(this.onSuccess(resp -> {
            this.assertEquals(HttpVersion.HTTP_2, resp.version());
            this.assertEquals(1L, serverConnectionCount.get());
            this.assertEquals(1L, clientConnectionCount.get());
            Promise p2 = Promise.promise();
            p2.future().onComplete(this.onSuccess(resp2 -> this.testComplete()));
            this.doRequest(method, expected, null, (Promise<HttpClientResponse>)p2);
        }));
        this.doRequest(method, expected, (Handler<HttpConnection>)((Handler)conn -> clientConnectionCount.incrementAndGet()), (Promise<HttpClientResponse>)p1);
        this.await();
    }

    private void doRequest(HttpMethod method, Buffer expected, Handler<HttpConnection> connHandler, Promise<HttpClientResponse> fut) {
        HttpClientRequest req = this.client.request(method, 8080, "localhost", "/somepath", resp -> {
            this.assertEquals(HttpVersion.HTTP_2, resp.version());
            fut.tryComplete(resp);
        });
        if (connHandler != null) {
            req.connectionHandler(connHandler);
        }
        if (expected.length() > 0) {
            req.end(expected);
        } else {
            req.end();
        }
    }

    @Test
    public void testPushPromiseClearText() throws Exception {
        this.waitFor(2);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setHost("localhost").setPort(8080).setUseAlpn(false).setSsl(false));
        this.server.requestHandler(req -> {
            req.response().push(HttpMethod.GET, "/resource", ar -> {
                this.assertTrue(ar.succeeded());
                ((HttpServerResponse)ar.result()).end("the-pushed-response");
            });
            req.response().end();
        });
        this.startServer();
        this.client = this.vertx.createHttpClient(this.clientOptions.setUseAlpn(false).setSsl(false));
        HttpClientRequest req2 = this.client.get(8080, "localhost", "/somepath");
        req2.handler(resp -> {
            this.assertEquals(HttpVersion.HTTP_2, resp.version());
            this.complete();
        }).exceptionHandler(this::fail).pushHandler(pushedReq -> pushedReq.handler(pushResp -> pushResp.bodyHandler(buff -> {
            this.assertEquals("the-pushed-response", buff.toString());
            this.complete();
        }))).end();
        this.await();
    }

    @Test
    public void testUpgradeToClearTextInvalidConnectionHeader() throws Exception {
        this.testUpgradeFailure(this.vertx.getOrCreateContext(), client -> client.get(8080, "localhost", "/somepath").putHeader("Upgrade", "h2c").putHeader("Connection", "Upgrade").putHeader("HTTP2-Settings", ""));
    }

    @Test
    public void testUpgradeToClearTextMalformedSettings() throws Exception {
        this.testUpgradeFailure(this.vertx.getOrCreateContext(), client -> client.get(8080, "localhost", "/somepath").putHeader("Upgrade", "h2c").putHeader("Connection", "Upgrade,HTTP2-Settings").putHeader("HTTP2-Settings", "incorrect-settings"));
    }

    @Test
    public void testUpgradeToClearTextInvalidSettings() throws Exception {
        Buffer buffer = Buffer.buffer();
        buffer.appendUnsignedShort(5).appendUnsignedInt(0x1000000L);
        String s = new String(Base64.getUrlEncoder().encode(buffer.getBytes()), StandardCharsets.UTF_8);
        this.testUpgradeFailure(this.vertx.getOrCreateContext(), client -> client.get(8080, "localhost", "/somepath").putHeader("Upgrade", "h2c").putHeader("Connection", "Upgrade,HTTP2-Settings").putHeader("HTTP2-Settings", s));
    }

    @Test
    public void testUpgradeToClearTextMissingSettings() throws Exception {
        this.testUpgradeFailure(this.vertx.getOrCreateContext(), client -> client.get(8080, "localhost", "/somepath").putHeader("Upgrade", "h2c").putHeader("Connection", "Upgrade,HTTP2-Settings"));
    }

    @Test
    public void testUpgradeToClearTextWorkerContext() throws Exception {
        this.testUpgradeFailure(this.createWorker(), client -> client.get(8080, "localhost", "/somepath").putHeader("Upgrade", "h2c").putHeader("Connection", "Upgrade,HTTP2-Settings").putHeader("HTTP2-Settings", HttpUtils.encodeSettings((Http2Settings)new Http2Settings())));
    }

    private void testUpgradeFailure(Context context, Function<HttpClient, HttpClientRequest> doRequest) throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setHost("localhost").setPort(8080).setUseAlpn(false).setSsl(false));
        this.server.requestHandler(req -> this.fail());
        this.startServer(context);
        this.client = this.vertx.createHttpClient(this.clientOptions.setProtocolVersion(HttpVersion.HTTP_1_1).setUseAlpn(false).setSsl(false));
        doRequest.apply(this.client).handler(resp -> {
            this.assertEquals(400L, resp.statusCode());
            this.assertEquals(HttpVersion.HTTP_1_1, resp.version());
            this.testComplete();
        }).exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testUpgradeToClearTextPartialFailure() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setHost("localhost").setPort(8080).setUseAlpn(false).setSsl(false));
        CompletableFuture closeRequest = new CompletableFuture();
        this.server.requestHandler(req -> {
            closeRequest.complete(null);
            AtomicBoolean processed = new AtomicBoolean();
            req.exceptionHandler(err -> {
                if (processed.compareAndSet(false, true)) {
                    this.testComplete();
                }
            });
        });
        this.startServer();
        this.client = this.vertx.createHttpClient(this.clientOptions.setProtocolVersion(HttpVersion.HTTP_1_1).setUseAlpn(false).setSsl(false));
        HttpClientRequest request = this.client.put(8080, "localhost", "/somepath", resp -> {}).putHeader("Upgrade", "h2c").putHeader("Connection", "Upgrade,HTTP2-Settings").putHeader("HTTP2-Settings", HttpUtils.encodeSettings((Http2Settings)new Http2Settings())).setChunked(true).write("some-data");
        closeRequest.thenAccept(v -> request.connection().close());
        this.await();
    }

    @Test
    public void testIdleTimeout() throws Exception {
        this.waitFor(5);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setIdleTimeoutUnit(TimeUnit.MILLISECONDS).setIdleTimeout(2000));
        this.server.requestHandler(req -> {
            req.exceptionHandler(err -> {
                this.assertTrue(err instanceof ClosedChannelException);
                this.complete();
            });
            req.response().closeHandler(v -> this.complete());
            req.response().endHandler(v -> this.complete());
            req.connection().closeHandler(v -> this.complete());
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            int id = request.nextStreamId();
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){});
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, false, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        fut.channel().closeFuture().addListener(v1 -> this.vertx.runOnContext(v2 -> this.complete()));
        this.await();
    }

    @Test
    public void testFallbackOnHttp1ForWorkerContext() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            req.response().end();
        });
        this.startServer(this.createWorker());
        this.client = this.vertx.createHttpClient(this.clientOptions);
        this.client.get(4043, "localhost", "/somepath", resp -> {
            this.assertEquals(HttpVersion.HTTP_1_1, resp.version());
            this.testComplete();
        }).end();
        this.await();
    }

    @Test
    public void testSendPing() throws Exception {
        this.waitFor(2);
        final Buffer expected = TestUtils.randomBuffer(8);
        Context ctx = this.vertx.getOrCreateContext();
        this.server.close();
        this.server.connectionHandler(conn -> conn.ping(expected, ar -> {
            this.assertSame(ctx, Vertx.currentContext());
            this.assertTrue(ar.succeeded());
            this.assertEquals(expected, ar.result());
            this.complete();
        }));
        this.server.requestHandler(req -> this.fail());
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){

            public void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
                Buffer buffer = Buffer.buffer().appendLong(data);
                Http2ServerTest.this.vertx.runOnContext(v -> {
                    Http2ServerTest.this.assertEquals(expected, buffer);
                    Http2ServerTest.this.complete();
                });
            }
        }));
        fut.sync();
        this.await();
    }

    @Test
    public void testReceivePing() throws Exception {
        Buffer expected = TestUtils.randomBuffer(8);
        Context ctx = this.vertx.getOrCreateContext();
        this.server.close();
        this.server.connectionHandler(conn -> conn.pingHandler(buff -> {
            this.assertOnIOContext(ctx);
            this.assertEquals(expected, buff);
            this.testComplete();
        }));
        this.server.requestHandler(req -> this.fail());
        this.startServer(ctx);
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> request.encoder.writePing(request.context, false, expected.getLong(0), request.context.newPromise()));
        fut.sync();
        this.await();
    }

    @Test
    public void testPriorKnowledge() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost"));
        this.server.requestHandler(req -> req.response().end("Hello World"));
        this.startServer();
        TestClient client = new TestClient(){

            @Override
            protected ChannelInitializer channelInitializer(int port, String host, final Consumer<TestClient.Connection> handler) {
                return new ChannelInitializer(){

                    protected void initChannel(Channel ch) throws Exception {
                        ChannelPipeline p = ch.pipeline();
                        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
                        TestClient.TestClientHandlerBuilder clientHandlerBuilder = new TestClient.TestClientHandlerBuilder(handler);
                        TestClient.TestClientHandler clientHandler = clientHandlerBuilder.build((Http2Connection)connection);
                        p.addLast(new ChannelHandler[]{clientHandler});
                    }
                };
            }
        };
        ChannelFuture fut = client.connect(8080, "localhost", request -> {
            request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.testComplete());
                }
            });
            int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), 0, true, request.context.newPromise());
            request.context.flush();
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testConnectionWindowSize() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(Http2ServerTest.createHttp2ServerOptions(4043, "localhost").setHttp2ConnectionWindowSize(131070));
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){

            public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
                Http2ServerTest.this.vertx.runOnContext(v -> {
                    Http2ServerTest.this.assertEquals(65535L, windowSizeIncrement);
                    Http2ServerTest.this.testComplete();
                });
            }
        }));
        fut.sync();
        this.await();
    }

    @Test
    public void testUpdateConnectionWindowSize() throws Exception {
        this.server.connectionHandler(conn -> {
            this.assertEquals(65535L, conn.getWindowSize());
            conn.setWindowSize(75535);
            this.assertEquals(75535L, conn.getWindowSize());
            conn.setWindowSize(131070);
            this.assertEquals(131070L, conn.getWindowSize());
        }).requestHandler(req -> req.response().end());
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> request.decoder.frameListener((Http2FrameListener)new Http2EventAdapter(){

            public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
                Http2ServerTest.this.vertx.runOnContext(v -> {
                    Http2ServerTest.this.assertEquals(65535L, windowSizeIncrement);
                    Http2ServerTest.this.testComplete();
                });
            }
        }));
        fut.sync();
        this.await();
    }

    @Test
    public void testHttp1xOrH2CHandlerHttp1xRequest() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestHttp1xOrH2CHandler()});
        ByteBuf buff = HTTP_1_1_POST.copy(0, HTTP_1_1_POST.readableBytes());
        ch.writeInbound(new Object[]{buff});
        this.assertEquals(0L, buff.refCnt());
        this.assertEquals(1L, ch.outboundMessages().size());
        HttpRequest req = (HttpRequest)ch.outboundMessages().poll();
        this.assertEquals("POST", req.method().name());
        this.assertNull(ch.pipeline().get(TestHttp1xOrH2CHandler.class));
    }

    @Test
    public void testHttp1xOrH2CHandlerFragmentedHttp1xRequest() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestHttp1xOrH2CHandler()});
        ByteBuf buff = HTTP_1_1_POST.copy(0, 1);
        ch.writeInbound(new Object[]{buff});
        this.assertEquals(0L, buff.refCnt());
        this.assertEquals(0L, ch.outboundMessages().size());
        buff = HTTP_1_1_POST.copy(1, HTTP_1_1_POST.readableBytes() - 1);
        ch.writeInbound(new Object[]{buff});
        this.assertEquals(0L, buff.refCnt());
        this.assertEquals(1L, ch.outboundMessages().size());
        HttpRequest req = (HttpRequest)ch.outboundMessages().poll();
        this.assertEquals("POST", req.method().name());
        this.assertNull(ch.pipeline().get(TestHttp1xOrH2CHandler.class));
    }

    @Test
    public void testHttp1xOrH2CHandlerHttp2Request() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestHttp1xOrH2CHandler()});
        ByteBuf expected = Unpooled.copiedBuffer((CharSequence)"PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n", (Charset)StandardCharsets.UTF_8);
        ch.writeInbound(new Object[]{expected});
        this.assertEquals(1L, expected.refCnt());
        this.assertEquals(1L, ch.outboundMessages().size());
        ByteBuf res = (ByteBuf)ch.outboundMessages().poll();
        this.assertEquals("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n", res.toString(StandardCharsets.UTF_8));
        this.assertNull(ch.pipeline().get(TestHttp1xOrH2CHandler.class));
    }

    @Test
    public void testHttp1xOrH2CHandlerFragmentedHttp2Request() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestHttp1xOrH2CHandler()});
        ByteBuf expected = Unpooled.copiedBuffer((CharSequence)"PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n", (Charset)StandardCharsets.UTF_8);
        ByteBuf buff = expected.copy(0, 1);
        ch.writeInbound(new Object[]{buff});
        this.assertEquals(0L, buff.refCnt());
        this.assertEquals(0L, ch.outboundMessages().size());
        buff = expected.copy(1, expected.readableBytes() - 1);
        ch.writeInbound(new Object[]{buff});
        this.assertEquals(0L, buff.refCnt());
        this.assertEquals(1L, ch.outboundMessages().size());
        ByteBuf res = (ByteBuf)ch.outboundMessages().poll();
        this.assertEquals(1L, res.refCnt());
        this.assertEquals("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n", res.toString(StandardCharsets.UTF_8));
        this.assertNull(ch.pipeline().get(TestHttp1xOrH2CHandler.class));
    }

    @Test
    public void testStreamPriority() throws Exception {
        StreamPriority requestStreamPriority = new StreamPriority().setDependency(123).setWeight((short)45).setExclusive(true);
        final StreamPriority responseStreamPriority = new StreamPriority().setDependency(153).setWeight((short)75).setExclusive(false);
        this.waitFor(3);
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            this.assertEquals(requestStreamPriority, req.streamPriority());
            resp.setStatusCode(200);
            resp.setStreamPriority(responseStreamPriority);
            resp.end("data");
            this.complete();
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            final int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), requestStreamPriority.getDependency(), requestStreamPriority.getWeight(), requestStreamPriority.isExclusive(), 0, true, request.context.newPromise());
            request.context.flush();
            request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter(){

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    super.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(id, streamId);
                        Http2ServerTest.this.assertEquals(responseStreamPriority.getDependency(), streamDependency);
                        Http2ServerTest.this.assertEquals(responseStreamPriority.getWeight(), weight);
                        Http2ServerTest.this.assertEquals(responseStreamPriority.isExclusive(), exclusive);
                        Http2ServerTest.this.complete();
                    });
                }

                public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.fail("Priority frame should not be sent"));
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    if (endOfStream) {
                        Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.complete());
                    }
                    return super.onDataRead(ctx, streamId, data, padding, endOfStream);
                }
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testStreamPriorityChange() throws Exception {
        StreamPriority requestStreamPriority = new StreamPriority().setDependency(123).setWeight((short)45).setExclusive(true);
        StreamPriority requestStreamPriority2 = new StreamPriority().setDependency(223).setWeight((short)145).setExclusive(false);
        final StreamPriority responseStreamPriority = new StreamPriority().setDependency(153).setWeight((short)75).setExclusive(false);
        final StreamPriority responseStreamPriority2 = new StreamPriority().setDependency(253).setWeight((short)175).setExclusive(true);
        this.waitFor(5);
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            this.assertEquals(requestStreamPriority, req.streamPriority());
            req.bodyHandler(b -> {
                this.assertEquals(requestStreamPriority2, req.streamPriority());
                resp.setStatusCode(200);
                resp.setStreamPriority(responseStreamPriority);
                resp.write("hello");
                resp.setStreamPriority(responseStreamPriority2);
                resp.end("world");
                this.complete();
            });
            req.streamPriorityHandler(streamPriority -> {
                this.assertEquals(requestStreamPriority2, streamPriority);
                this.assertEquals(requestStreamPriority2, req.streamPriority());
                this.complete();
            });
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            final int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), requestStreamPriority.getDependency(), requestStreamPriority.getWeight(), requestStreamPriority.isExclusive(), 0, false, request.context.newPromise());
            request.context.flush();
            request.encoder.writePriority(request.context, id, requestStreamPriority2.getDependency(), requestStreamPriority2.getWeight(), requestStreamPriority2.isExclusive(), request.context.newPromise());
            request.context.flush();
            request.encoder.writeData(request.context, id, Buffer.buffer((String)"hello").getByteBuf(), 0, true, request.context.newPromise());
            request.context.flush();
            request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter(){

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    super.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(id, streamId);
                        Http2ServerTest.this.assertEquals(responseStreamPriority.getDependency(), streamDependency);
                        Http2ServerTest.this.assertEquals(responseStreamPriority.getWeight(), weight);
                        Http2ServerTest.this.assertEquals(responseStreamPriority.isExclusive(), exclusive);
                        Http2ServerTest.this.complete();
                    });
                }

                public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(id, streamId);
                        Http2ServerTest.this.assertEquals(responseStreamPriority2.getDependency(), streamDependency);
                        Http2ServerTest.this.assertEquals(responseStreamPriority2.getWeight(), weight);
                        Http2ServerTest.this.assertEquals(responseStreamPriority2.isExclusive(), exclusive);
                        Http2ServerTest.this.complete();
                    });
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    if (endOfStream) {
                        Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.complete());
                    }
                    return super.onDataRead(ctx, streamId, data, padding, endOfStream);
                }
            });
        });
        fut.sync();
        this.await();
    }

    @Test
    public void testStreamPriorityNoChange() throws Exception {
        StreamPriority requestStreamPriority = new StreamPriority().setDependency(123).setWeight((short)45).setExclusive(true);
        final StreamPriority responseStreamPriority = new StreamPriority().setDependency(153).setWeight((short)75).setExclusive(false);
        this.waitFor(3);
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            this.assertEquals(requestStreamPriority, req.streamPriority());
            req.bodyHandler(b -> {
                this.assertEquals(requestStreamPriority, req.streamPriority());
                resp.setStatusCode(200);
                resp.setStreamPriority(responseStreamPriority);
                resp.write("hello");
                resp.setStreamPriority(responseStreamPriority);
                resp.end("world");
                this.complete();
            });
            req.streamPriorityHandler(streamPriority -> this.fail("Stream priority handler should not be called"));
        });
        this.startServer();
        TestClient client = new TestClient();
        ChannelFuture fut = client.connect(4043, "localhost", request -> {
            final int id = request.nextStreamId();
            request.encoder.writeHeaders(request.context, id, Http2ServerTest.GET("/"), requestStreamPriority.getDependency(), requestStreamPriority.getWeight(), requestStreamPriority.isExclusive(), 0, false, request.context.newPromise());
            request.context.flush();
            request.encoder.writePriority(request.context, id, requestStreamPriority.getDependency(), requestStreamPriority.getWeight(), requestStreamPriority.isExclusive(), request.context.newPromise());
            request.context.flush();
            request.encoder.writeData(request.context, id, Buffer.buffer((String)"hello").getByteBuf(), 0, true, request.context.newPromise());
            request.context.flush();
            request.decoder.frameListener((Http2FrameListener)new Http2FrameAdapter(){

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    super.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
                    Http2ServerTest.this.vertx.runOnContext(v -> {
                        Http2ServerTest.this.assertEquals(id, streamId);
                        Http2ServerTest.this.assertEquals(responseStreamPriority.getDependency(), streamDependency);
                        Http2ServerTest.this.assertEquals(responseStreamPriority.getWeight(), weight);
                        Http2ServerTest.this.assertEquals(responseStreamPriority.isExclusive(), exclusive);
                        Http2ServerTest.this.complete();
                    });
                }

                public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
                    Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.fail("Priority frame should not be sent"));
                }

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    if (endOfStream) {
                        Http2ServerTest.this.vertx.runOnContext(v -> Http2ServerTest.this.complete());
                    }
                    return super.onDataRead(ctx, streamId, data, padding, endOfStream);
                }
            });
        });
        fut.sync();
        this.await();
    }

    static /* synthetic */ Vertx access$16600(Http2ServerTest x0) {
        return x0.vertx;
    }

    class TestHttp1xOrH2CHandler
    extends Http1xOrH2CHandler {
        TestHttp1xOrH2CHandler() {
        }

        protected void configure(ChannelHandlerContext ctx, boolean h2c) {
            if (h2c) {
                ChannelPipeline p = ctx.pipeline();
                p.addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        ctx.write(msg);
                    }

                    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                        ctx.flush();
                    }
                }});
            } else {
                ChannelPipeline p = ctx.pipeline();
                p.addLast(new ChannelHandler[]{new HttpServerCodec()});
                p.addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        ctx.write(msg);
                    }

                    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                        ctx.flush();
                    }
                }});
            }
        }
    }

    class TestClient {
        final io.netty.handler.codec.http2.Http2Settings settings = new io.netty.handler.codec.http2.Http2Settings();

        TestClient() {
        }

        protected ChannelInitializer channelInitializer(final int port, final String host, final Consumer<Connection> handler) {
            return new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    SSLHelper sslHelper = new SSLHelper(new HttpClientOptions().setUseAlpn(true).setSsl(true), null, (TrustOptions)Trust.SERVER_JKS.get());
                    SslHandler sslHandler = new SslHandler(sslHelper.setApplicationProtocols(Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1)).createEngine((VertxInternal)Http2ServerTest.this.vertx, host, port));
                    ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("whatever"){

                        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                            if ("h2".equals(protocol)) {
                                ChannelPipeline p = ctx.pipeline();
                                DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
                                TestClientHandlerBuilder clientHandlerBuilder = new TestClientHandlerBuilder(handler);
                                TestClientHandler clientHandler = clientHandlerBuilder.build((Http2Connection)connection);
                                p.addLast(new ChannelHandler[]{clientHandler});
                                return;
                            }
                            ctx.close();
                            throw new IllegalStateException("unknown protocol: " + protocol);
                        }
                    }});
                }
            };
        }

        public ChannelFuture connect(int port, String host, Consumer<Connection> handler) {
            Bootstrap bootstrap = new Bootstrap();
            NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
            Http2ServerTest.this.eventLoopGroups.add(eventLoopGroup);
            bootstrap.channel(NioSocketChannel.class);
            bootstrap.group((EventLoopGroup)eventLoopGroup);
            bootstrap.handler((ChannelHandler)this.channelInitializer(port, host, handler));
            return bootstrap.connect((SocketAddress)new InetSocketAddress(host, port));
        }

        class TestClientHandlerBuilder
        extends AbstractHttp2ConnectionHandlerBuilder<TestClientHandler, TestClientHandlerBuilder> {
            private final Consumer<Connection> requestHandler;

            public TestClientHandlerBuilder(Consumer<Connection> requestHandler) {
                this.requestHandler = requestHandler;
            }

            protected TestClientHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, io.netty.handler.codec.http2.Http2Settings initialSettings) throws Exception {
                return new TestClientHandler(this.requestHandler, decoder, encoder, initialSettings);
            }

            public TestClientHandler build(Http2Connection conn) {
                this.connection(conn);
                this.initialSettings(TestClient.this.settings);
                this.frameListener((Http2FrameListener)new Http2EventAdapter(){

                    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                        return super.onDataRead(ctx, streamId, data, padding, endOfStream);
                    }
                });
                return (TestClientHandler)super.build();
            }
        }

        class TestClientHandler
        extends Http2ConnectionHandler {
            private final Consumer<Connection> requestHandler;
            private boolean handled;

            public TestClientHandler(Consumer<Connection> requestHandler, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, io.netty.handler.codec.http2.Http2Settings initialSettings) {
                super(decoder, encoder, initialSettings);
                this.requestHandler = requestHandler;
            }

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                super.handlerAdded(ctx);
                if (ctx.channel().isActive()) {
                    this.checkHandle(ctx);
                }
            }

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                super.channelActive(ctx);
                this.checkHandle(ctx);
            }

            private void checkHandle(ChannelHandlerContext ctx) {
                if (!this.handled) {
                    this.handled = true;
                    Connection conn = new Connection(ctx, this.connection(), this.encoder(), this.decoder());
                    this.requestHandler.accept(conn);
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            }
        }

        public class Connection {
            public final Channel channel;
            public final ChannelHandlerContext context;
            public final Http2Connection connection;
            public final Http2ConnectionEncoder encoder;
            public final Http2ConnectionDecoder decoder;

            public Connection(ChannelHandlerContext context, Http2Connection connection, Http2ConnectionEncoder encoder, Http2ConnectionDecoder decoder) {
                this.channel = context.channel();
                this.context = context;
                this.connection = connection;
                this.encoder = encoder;
                this.decoder = decoder;
            }

            public int nextStreamId() {
                return this.connection.local().incrementAndGetNextStreamId();
            }
        }
    }
}

