/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.Vertx;
import io.vertx.core.impl.launcher.commands.BareCommand;
import io.vertx.core.impl.launcher.commands.CommandTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.io.IOException;
import java.util.function.BooleanSupplier;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;

public class BareCommandTest
extends CommandTestBase {
    @Override
    @After
    public void tearDown() throws InterruptedException {
        super.tearDown();
        this.close(this.getVertx());
        FakeClusterManager.reset();
    }

    @Override
    protected void assertWaitUntil(BooleanSupplier supplier) {
        this.assertWaitUntil(supplier, 20000L);
    }

    public void assertThatVertxInstanceHasBeenCreated() {
        Assertions.assertThat((Object)this.getVertx()).isNotNull();
    }

    private Vertx getVertx() {
        return ((BareCommand)this.cli.getExistingCommandInstance((String)"bare")).vertx;
    }

    @Test
    public void testRegularBareCommand() throws InterruptedException, IOException {
        this.record();
        this.cli.dispatch(new String[]{"bare"});
        this.assertWaitUntil(() -> this.error.toString().contains("A quorum has been obtained."));
        this.assertThatVertxInstanceHasBeenCreated();
        this.stop();
        Assertions.assertThat((String)this.error.toString()).contains(new CharSequence[]{"Starting clustering..."}).contains(new CharSequence[]{"No cluster-host specified"}).contains(new CharSequence[]{"Any deploymentIDs waiting on a quorum will now be deployed"});
    }

    @Test
    public void testOldBare() throws InterruptedException, IOException {
        this.record();
        this.cli.dispatch(new String[]{"-ha"});
        this.assertWaitUntil(() -> this.error.toString().contains("A quorum has been obtained."));
        this.stop();
        Assertions.assertThat((String)this.error.toString()).contains(new CharSequence[]{"Starting clustering..."}).contains(new CharSequence[]{"No cluster-host specified"}).contains(new CharSequence[]{"Any deploymentIDs waiting on a quorum will now be deployed"});
    }

    @Test
    public void testRegularBareCommandWithClusterHost() {
        this.record();
        this.cli.dispatch(new String[]{"bare", "-cluster-host", "127.0.0.1"});
        this.assertWaitUntil(() -> this.error.toString().contains("A quorum has been obtained."));
        this.assertThatVertxInstanceHasBeenCreated();
        this.stop();
        Assertions.assertThat((String)this.error.toString()).contains(new CharSequence[]{"Starting clustering..."}).doesNotContain((CharSequence)"No cluster-host specified").contains(new CharSequence[]{"Any deploymentIDs waiting on a quorum will now be deployed"});
    }

    @Test
    public void testOldBareWithClusterHost() throws InterruptedException, IOException {
        this.record();
        this.cli.dispatch(new String[]{"-ha", "-cluster-host", "127.0.0.1"});
        this.assertWaitUntil(() -> this.error.toString().contains("A quorum has been obtained."));
        this.stop();
        Assertions.assertThat((String)this.error.toString()).contains(new CharSequence[]{"Starting clustering..."}).doesNotContain((CharSequence)"No cluster-host specified").contains(new CharSequence[]{"Any deploymentIDs waiting on a quorum will now be deployed"});
    }
}

