/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.impl.pool.ConnectResult;
import io.vertx.core.http.impl.pool.ConnectionListener;
import io.vertx.core.http.impl.pool.ConnectionProvider;
import io.vertx.core.http.impl.pool.Pool;
import io.vertx.core.impl.ContextInternal;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class ConnectionPoolTest
extends VertxTestBase {
    @Test
    public void testConnectSuccess() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        final FakeConnectionManager mgr = new FakeConnectionManager(3, 4, connector);
        final AtomicReference handleLock = new AtomicReference();
        FakeWaiter waiter = new FakeWaiter(){

            @Override
            protected void onSuccess(FakeConnection conn) {
                ConnectionPoolTest.this.assertSame(conn.context, mgr.context);
                Pool<FakeConnection> pool = mgr.pool();
                handleLock.set(Thread.holdsLock(pool));
            }
        };
        mgr.getConnection(waiter);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter::isComplete);
        this.assertEquals(Boolean.FALSE, handleLock.get());
        waiter.assertSuccess(conn);
        conn.valid(false);
        waiter.recycle();
        ConnectionPoolTest.assertWaitUntil(() -> mgr.size() == 0);
        ConnectionPoolTest.assertWaitUntil(() -> mgr.closed());
    }

    @Test
    public void testConnectFailure() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        final FakeConnectionManager mgr = new FakeConnectionManager(3, 4, connector);
        final AtomicReference holdsLock = new AtomicReference();
        FakeWaiter waiter = new FakeWaiter(){

            @Override
            protected void onFailure() {
                ConnectionPoolTest.this.assertNull(Vertx.currentContext());
                Pool<FakeConnection> pool = mgr.pool();
                holdsLock.set(Thread.holdsLock(pool));
            }
        };
        mgr.getConnection(waiter);
        FakeConnection conn = connector.assertRequest();
        Throwable failure = new Throwable();
        conn.fail(failure);
        ConnectionPoolTest.assertWaitUntil(waiter::isComplete);
        this.assertEquals(Boolean.FALSE, holdsLock.get());
        waiter.assertFailure(failure);
    }

    @Test
    public void testConnectPoolEmptyWaiterCancelledAfterConnectRequest() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 3, connector);
        FakeWaiter waiter = new FakeWaiter();
        mgr.getConnection(waiter);
        FakeConnection conn = connector.assertRequest();
        waiter.cancel();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter::isComplete);
        this.assertFalse(waiter.isSuccess());
        this.assertFalse(waiter.isFailure());
        this.assertTrue(mgr.contains(conn));
    }

    @Test
    public void testConnectionFailure() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 3, connector);
        FakeWaiter waiter = new FakeWaiter();
        mgr.getConnection(waiter);
        FakeConnection conn = connector.assertRequest();
        Exception expected = new Exception();
        conn.fail(expected);
        ConnectionPoolTest.assertWaitUntil(waiter::isComplete);
        waiter.assertFailure(expected);
        this.assertTrue(waiter.isFailure());
        ConnectionPoolTest.assertWaitUntil(mgr::closed);
    }

    @Test
    public void testSynchronousConnectionFailure() {
        final Throwable cause = new Throwable();
        FakeConnectionProviderBase connector = new FakeConnectionProviderBase(){

            public void connect(ConnectionListener<FakeConnection> listener, ContextInternal context, Handler<AsyncResult<ConnectResult<FakeConnection>>> handler) {
                handler.handle((Object)Future.failedFuture((Throwable)cause));
            }
        };
        FakeConnectionManager mgr = new FakeConnectionManager(3, 3, connector);
        for (int i = 0; i < 4; ++i) {
            FakeWaiter waiter = new FakeWaiter();
            mgr.getConnection(waiter);
            ConnectionPoolTest.waitUntil(waiter::isFailure);
            waiter.assertFailure(cause);
            this.assertEquals(0L, mgr.pool().weight());
        }
        this.assertTrue(mgr.closed());
    }

    @Test
    public void testRecycleConnection() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isComplete);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        connector.assertRequests(0);
        waiter1.recycle();
        ConnectionPoolTest.assertWaitUntil(waiter2::isComplete);
        waiter2.assertSuccess(conn);
    }

    @Test
    public void testRecycleDiscardedConnection() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isComplete);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        conn.close();
        waiter1.recycle();
        ConnectionPoolTest.assertWaitUntil(() -> connector.requests() == 1);
        this.assertFalse(mgr.closed());
        FakeConnection conn2 = connector.assertRequest();
        conn2.connect();
        ConnectionPoolTest.assertWaitUntil(waiter2::isSuccess);
    }

    @Test
    public void testEndpointLifecycle() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        conn.close();
        ConnectionPoolTest.assertWaitUntil(mgr::closed);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        this.assertEquals(2L, mgr.sequence());
    }

    @Test
    public void testDontCloseEndpointWithInflightRequest() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 2, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isComplete);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        conn.close();
        ConnectionPoolTest.assertWaitUntil(() -> !mgr.contains(conn));
        this.assertFalse(mgr.closed());
    }

    @Test
    public void testInitialConcurrency() {
        int n = 10;
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 1, connector);
        ArrayList<FakeWaiter> waiters = new ArrayList<FakeWaiter>();
        for (int i = 0; i < n; ++i) {
            FakeWaiter waiter2 = new FakeWaiter();
            mgr.getConnection(waiter2);
            waiters.add(waiter2);
        }
        FakeConnection conn = connector.assertRequest();
        conn.concurrency(n).connect();
        waiters.forEach(waiter -> ConnectionPoolTest.assertWaitUntil(waiter::isSuccess));
        waiters.forEach(FakeWaiter::recycle);
    }

    @Test
    public void testInitialNoConcurrency() {
        int n = 10;
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 1, connector);
        ArrayList<FakeWaiter> waiters = new ArrayList<FakeWaiter>();
        for (int i = 0; i < n; ++i) {
            FakeWaiter waiter2 = new FakeWaiter();
            mgr.getConnection(waiter2);
            waiters.add(waiter2);
        }
        FakeConnection conn = connector.assertRequest();
        conn.concurrency(0L).connect().awaitConnected();
        conn.concurrency(n - 1);
        ConnectionPoolTest.assertWaitUntil(() -> waiters.stream().filter(FakeWaiter::isSuccess).count() == (long)(n - 1));
        waiters.stream().filter(FakeWaiter::isSuccess).findFirst().get().recycle();
        waiters.forEach(waiter -> ConnectionPoolTest.assertWaitUntil(waiter::isSuccess));
    }

    @Test
    public void testRecycleWithoutDispose() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        conn.recycle();
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        ConnectionPoolTest.assertWaitUntil(waiter2::isSuccess);
        waiter2.assertSuccess(conn);
        conn.recycle();
        conn.valid(false);
        mgr.removeExpired();
        ConnectionPoolTest.assertWaitUntil(() -> mgr.size() == 0);
    }

    @Test
    public void testRecycleFIFO() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 2, connector, true);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection firstInConnection = connector.assertRequest();
        firstInConnection.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        FakeConnection lastInConnection = connector.assertRequest();
        lastInConnection.connect();
        ConnectionPoolTest.assertWaitUntil(waiter2::isSuccess);
        waiter2.assertSuccess(lastInConnection);
        firstInConnection.recycle();
        lastInConnection.recycle();
        this.assertEquals(2L, mgr.size());
        FakeWaiter waiter3 = new FakeWaiter();
        mgr.getConnection(waiter3);
        ConnectionPoolTest.assertWaitUntil(waiter3::isSuccess);
        waiter3.assertSuccess(firstInConnection);
    }

    @Test
    public void testRecycleLIFO() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 2, connector, false);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection firstInConnection = connector.assertRequest();
        firstInConnection.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        FakeConnection lastInConnection = connector.assertRequest();
        lastInConnection.connect();
        ConnectionPoolTest.assertWaitUntil(waiter2::isSuccess);
        waiter2.assertSuccess(lastInConnection);
        firstInConnection.recycle();
        lastInConnection.recycle();
        this.assertEquals(2L, mgr.size());
        FakeWaiter waiter3 = new FakeWaiter();
        mgr.getConnection(waiter3);
        ConnectionPoolTest.assertWaitUntil(waiter3::isSuccess);
        waiter3.assertSuccess(lastInConnection);
    }

    @Test
    public void testDiscardWaiterWhenFull() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(2, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        FakeWaiter waiter3 = new FakeWaiter();
        mgr.getConnection(waiter3);
        FakeWaiter waiter4 = new FakeWaiter();
        mgr.getConnection(waiter4);
        ConnectionPoolTest.assertWaitUntil(waiter4::isFailure);
    }

    @Test
    public void testDiscardExpiredConnections() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(2, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        conn.recycle();
        this.assertEquals(1L, mgr.size());
        mgr.removeExpired();
        ConnectionPoolTest.assertWaitUntil(() -> mgr.size() == 1);
        conn.valid(false);
        mgr.removeExpired();
        ConnectionPoolTest.waitUntil(() -> mgr.size() == 0);
        this.assertEquals(0L, mgr.size());
        ConnectionPoolTest.assertWaitUntil(mgr::closed);
    }

    @Test
    public void testCloseRecycledConnection() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(2, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        conn.recycle();
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        conn.close();
        ConnectionPoolTest.assertWaitUntil(() -> waiter2.isComplete() || connector.hasRequests());
    }

    @Test
    public void testQueueMaxSize() {
        this.checkQueueMaxSize(2, 3);
        this.checkQueueMaxSize(0, 3);
    }

    @Test
    public void testRecycleInCallback() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 2, connector);
        FakeWaiter waiter1 = new FakeWaiter(){

            @Override
            protected void onSuccess(FakeConnection conn) {
                conn.valid(false).recycle();
            }
        };
        FakeWaiter waiter2 = new FakeWaiter(){

            @Override
            protected void onSuccess(FakeConnection conn) {
                conn.valid(false).recycle();
            }
        };
        mgr.getConnection(waiter1);
        mgr.getConnection(waiter2);
        FakeConnection req1 = connector.assertRequest();
        FakeConnection req2 = connector.assertRequest();
        this.assertNotSame(req1, req2);
        req1.connect();
        req2.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        ConnectionPoolTest.assertWaitUntil(waiter2::isSuccess);
        ConnectionPoolTest.assertWaitUntil(() -> mgr.closed());
    }

    private void checkQueueMaxSize(int queueMaxSize, int poolMaxSize) {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(queueMaxSize, poolMaxSize, connector);
        FakeWaiter[] waiters = new FakeWaiter[poolMaxSize + queueMaxSize];
        for (int i = 0; i < poolMaxSize + queueMaxSize; ++i) {
            FakeWaiter waiter;
            waiters[i] = waiter = new FakeWaiter();
            mgr.getConnection(waiter);
        }
        FakeWaiter waiter = new FakeWaiter();
        mgr.getConnection(waiter);
        ConnectionPoolTest.assertWaitUntil(waiter::isFailure);
        for (int i = 0; i < poolMaxSize + queueMaxSize; ++i) {
            this.assertFalse("Was not expecting connection no=" + i + " to be failed", waiters[i].isFailure());
        }
    }

    @Test
    public void testStress() {
        int i;
        int numActors = 16;
        int numConnections = 1000;
        FakeConnectionProvider connector = new FakeConnectionProvider(){

            @Override
            public void connect(ConnectionListener<FakeConnection> listener, ContextInternal context, Handler<AsyncResult<ConnectResult<FakeConnection>>> handler) {
                int i = ThreadLocalRandom.current().nextInt(100);
                Promise promise = Promise.promise();
                Future future = promise.future();
                future.onComplete(handler);
                FakeConnection conn = new FakeConnection(context, listener, (Promise<ConnectResult<FakeConnection>>)promise);
                if (i < 10) {
                    conn.fail(new Exception("Could not connect"));
                } else {
                    conn.connect();
                }
            }
        };
        FakeConnectionManager mgr = new FakeConnectionManager(-1, numActors, connector);
        Thread[] actors = new Thread[numActors];
        for (i = 0; i < numActors; ++i) {
            actors[i] = new Thread(() -> {
                final CountDownLatch latch = new CountDownLatch(numConnections);
                for (int i1 = 0; i1 < numConnections; ++i1) {
                    mgr.getConnection(new FakeWaiter(){

                        @Override
                        protected void onFailure() {
                            latch.countDown();
                        }

                        @Override
                        protected void onSuccess(FakeConnection conn) {
                            int action = ThreadLocalRandom.current().nextInt(100);
                            if (action < -1) {
                                conn.recycle();
                                latch.countDown();
                            } else {
                                ConnectionPoolTest.this.vertx.setTimer(10L, id -> {
                                    if (action < 15) {
                                        conn.close();
                                    } else {
                                        conn.recycle();
                                    }
                                    latch.countDown();
                                });
                            }
                        }
                    });
                }
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }, "actor-" + i);
            actors[i].start();
        }
        for (i = 0; i < actors.length; ++i) {
            try {
                actors[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        new HashSet(mgr.active).forEach(FakeConnection::close);
        try {
            ConnectionPoolTest.assertWaitUntil(mgr::closed);
        }
        catch (Exception e) {
            System.out.println(mgr.pool.toString());
            throw e;
        }
        this.assertEquals(1L, mgr.closeCount());
        this.assertEquals(0L, mgr.size());
        mgr.pool.checkInvariants();
        this.assertEquals(0L, mgr.pool.waitersInQueue());
        this.assertEquals(0L, mgr.pool.weight());
        this.assertEquals(0L, mgr.pool.capacity());
    }

    class FakeConnectionProvider
    extends FakeConnectionProviderBase {
        private final Deque<FakeConnection> pendingRequests;

        FakeConnectionProvider() {
            this.pendingRequests = new ConcurrentLinkedDeque<FakeConnection>();
        }

        void assertRequests(int expectedSize) {
            ConnectionPoolTest.this.assertEquals(expectedSize, this.pendingRequests.size());
        }

        int requests() {
            return this.pendingRequests.size();
        }

        boolean hasRequests() {
            return this.pendingRequests.size() > 0;
        }

        FakeConnection assertRequest() {
            AsyncTestBase.waitUntil(() -> this.pendingRequests.size() > 0);
            FakeConnection request = this.pendingRequests.poll();
            ConnectionPoolTest.this.assertNotNull(request);
            return request;
        }

        public void connect(ConnectionListener<FakeConnection> listener, ContextInternal context, Handler<AsyncResult<ConnectResult<FakeConnection>>> handler) {
            Promise promise = Promise.promise();
            promise.future().onComplete(handler);
            this.pendingRequests.add(new FakeConnection(context, listener, (Promise<ConnectResult<FakeConnection>>)promise));
        }
    }

    abstract class FakeConnectionProviderBase
    implements ConnectionProvider<FakeConnection> {
        FakeConnectionProviderBase() {
        }

        public void close(FakeConnection conn) {
            conn.listener.onEvict();
        }

        public boolean isValid(FakeConnection conn) {
            return conn.valid;
        }
    }

    private static class FakeConnection {
        private static final int DISCONNECTED = 0;
        private static final int CONNECTING = 1;
        private static final int CONNECTED = 2;
        private static final int CLOSED = 3;
        private final ContextInternal context;
        private final ConnectionListener<FakeConnection> listener;
        private final Promise<ConnectResult<FakeConnection>> future;
        private long inflight;
        private long concurrency = 1L;
        private int status = 0;
        private boolean valid;

        FakeConnection(ContextInternal context, ConnectionListener<FakeConnection> listener, Promise<ConnectResult<FakeConnection>> future) {
            this.context = context;
            this.listener = listener;
            this.future = future;
            this.valid = true;
        }

        synchronized void close() {
            if (this.status != 2) {
                throw new IllegalStateException();
            }
            this.status = 3;
            this.listener.onEvict();
        }

        synchronized long recycle() {
            --this.inflight;
            this.listener.onRecycle();
            return this.inflight;
        }

        synchronized FakeConnection valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        synchronized FakeConnection concurrency(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException("Invalid concurrency");
            }
            if (this.status == 2) {
                if (this.concurrency != value) {
                    this.concurrency = value;
                    this.listener.onConcurrencyChange(value);
                }
            } else {
                this.concurrency = value;
            }
            return this;
        }

        FakeConnection awaitConnected() {
            AsyncTestBase.waitUntil(() -> {
                FakeConnection fakeConnection = this;
                synchronized (fakeConnection) {
                    return this.status == 2;
                }
            });
            return this;
        }

        synchronized FakeConnection connect() {
            if (this.status != 0) {
                throw new IllegalStateException();
            }
            this.status = 1;
            this.context.nettyEventLoop().execute(() -> {
                FakeConnection fakeConnection = this;
                synchronized (fakeConnection) {
                    this.status = 2;
                    this.future.complete((Object)new ConnectResult((Object)this, this.concurrency, 1L));
                }
            });
            return this;
        }

        void fail(Throwable err) {
            this.context.nettyEventLoop().execute(() -> this.future.tryFail(err));
        }
    }

    class FakeWaiter {
        protected final ContextInternal context;
        private boolean cancelled;
        private boolean completed;
        private Object result;

        FakeWaiter() {
            this.context = (ContextInternal)ConnectionPoolTest.this.vertx.getOrCreateContext();
        }

        synchronized boolean cancel() {
            if (this.completed) {
                return false;
            }
            this.cancelled = true;
            return true;
        }

        synchronized void assertSuccess(FakeConnection conn) {
            ConnectionPoolTest.this.assertSame(conn, this.result);
        }

        synchronized void assertFailure(Throwable failure) {
            ConnectionPoolTest.this.assertSame(failure, this.result);
        }

        synchronized boolean isComplete() {
            return this.completed;
        }

        synchronized boolean isSuccess() {
            return this.completed && this.result instanceof FakeConnection;
        }

        synchronized boolean isFailure() {
            return this.completed && this.result instanceof Throwable;
        }

        protected void onSuccess(FakeConnection conn) {
        }

        protected void onFailure() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void handleFailure(Throwable failure) {
            FakeWaiter fakeWaiter = this;
            synchronized (fakeWaiter) {
                ConnectionPoolTest.this.assertFalse(this.completed);
                this.completed = true;
                this.result = failure;
            }
            this.onFailure();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void handleConnection(FakeConnection conn) {
            FakeWaiter fakeWaiter = this;
            synchronized (fakeWaiter) {
                ConnectionPoolTest.this.assertFalse(this.completed);
                this.completed = true;
                boolean c = this.cancelled;
                if (!this.cancelled) {
                    this.result = conn;
                }
            }
            if (this.cancelled) {
                conn.recycle();
            } else {
                this.onSuccess(conn);
            }
        }

        long recycle() {
            FakeConnection conn = (FakeConnection)this.result;
            return conn.recycle();
        }
    }

    class FakeConnectionManager {
        private final Context context;
        private final ConnectionProvider<FakeConnection> connector;
        private final int queueMaxSize;
        private final int poolMaxSize;
        private Pool<FakeConnection> pool;
        private Set<FakeConnection> active;
        private boolean closed;
        private int closeCount;
        private int seq;
        private final boolean fifo;

        FakeConnectionManager(int queueMaxSize, int poolMaxSize, ConnectionProvider<FakeConnection> connector) {
            this(queueMaxSize, poolMaxSize, connector, false);
        }

        FakeConnectionManager(int queueMaxSize, int poolMaxSize, ConnectionProvider<FakeConnection> connector, boolean fifo) {
            this.context = ConnectionPoolTest.this.vertx.getOrCreateContext();
            this.active = new HashSet<FakeConnection>();
            this.closed = true;
            this.queueMaxSize = queueMaxSize;
            this.poolMaxSize = poolMaxSize;
            this.connector = connector;
            this.fifo = fifo;
        }

        synchronized int sequence() {
            return this.seq;
        }

        synchronized boolean closed() {
            return this.closed;
        }

        synchronized boolean contains(FakeConnection conn) {
            return this.active.contains(conn);
        }

        synchronized int size() {
            return this.active.size();
        }

        void removeExpired() {
            this.pool.closeIdle();
        }

        synchronized Pool<FakeConnection> pool() {
            return this.pool;
        }

        synchronized int closeCount() {
            return this.closeCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void getConnection(FakeWaiter waiter) {
            FakeConnectionManager fakeConnectionManager = this;
            synchronized (fakeConnectionManager) {
                if (this.closed) {
                    ++this.seq;
                    this.closed = false;
                    this.pool = new Pool(this.context, this.connector, this.queueMaxSize, 1L, (long)this.poolMaxSize, v -> {
                        FakeConnectionManager fakeConnectionManager = this;
                        synchronized (fakeConnectionManager) {
                            this.closed = true;
                            ++this.closeCount;
                        }
                    }, conn -> {
                        FakeConnectionManager fakeConnectionManager = this;
                        synchronized (fakeConnectionManager) {
                            this.active.add((FakeConnection)conn);
                        }
                    }, conn -> {
                        FakeConnectionManager fakeConnectionManager = this;
                        synchronized (fakeConnectionManager) {
                            this.active.remove(conn);
                        }
                    }, this.fifo);
                }
            }
            this.pool.getConnection(ar -> {
                if (ar.succeeded()) {
                    FakeConnection conn;
                    FakeConnection fakeConnection = conn = (FakeConnection)ar.result();
                    synchronized (fakeConnection) {
                        conn.inflight++;
                    }
                    waiter.handleConnection(conn);
                } else {
                    waiter.handleFailure(ar.cause());
                }
            });
        }
    }
}

