/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslServerContext;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import io.netty.handler.ssl.SslContext;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.junit.Test;

public class SSLHelperTest
extends VertxTestBase {
    @Test
    public void testUseJdkCiphersWhenNotSpecified() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLEngine engine = context.createSSLEngine();
        String[] expected = engine.getEnabledCipherSuites();
        SSLHelper helper = new SSLHelper(new HttpClientOptions(), (KeyCertOptions)Cert.CLIENT_JKS.get(), (TrustOptions)Trust.SERVER_JKS.get());
        SslContext ctx = helper.getContext((VertxInternal)this.vertx);
        this.assertEquals(new HashSet<String>(Arrays.asList(expected)), new HashSet(ctx.cipherSuites()));
    }

    @Test
    public void testUseOpenSSLCiphersWhenNotSpecified() throws Exception {
        Set expected = OpenSsl.availableOpenSslCipherSuites();
        SSLHelper helper = new SSLHelper(new HttpClientOptions().setOpenSslEngineOptions(new OpenSSLEngineOptions()), (KeyCertOptions)Cert.CLIENT_PEM.get(), (TrustOptions)Trust.SERVER_PEM.get());
        SslContext ctx = helper.getContext((VertxInternal)this.vertx);
        this.assertEquals(expected, new HashSet(ctx.cipherSuites()));
    }

    @Test
    public void testDefaultOpenSslServerSessionContext() throws Exception {
        this.testOpenSslServerSessionContext(true);
    }

    @Test
    public void testUserSetOpenSslServerSessionContext() throws Exception {
        this.testOpenSslServerSessionContext(false);
    }

    private void testOpenSslServerSessionContext(boolean testDefault) {
        HttpServerOptions httpServerOptions = new HttpServerOptions().setOpenSslEngineOptions(new OpenSSLEngineOptions());
        if (!testDefault) {
            httpServerOptions.setOpenSslEngineOptions(new OpenSSLEngineOptions().setSessionCacheEnabled(false));
        }
        SSLHelper defaultHelper = new SSLHelper(httpServerOptions, (KeyCertOptions)Cert.SERVER_PEM.get(), (TrustOptions)Trust.SERVER_PEM.get());
        SslContext ctx = defaultHelper.getContext((VertxInternal)this.vertx);
        this.assertTrue(ctx instanceof OpenSslServerContext);
        SSLSessionContext sslSessionContext = ctx.sessionContext();
        this.assertTrue(sslSessionContext instanceof OpenSslServerSessionContext);
        if (sslSessionContext instanceof OpenSslServerSessionContext) {
            this.assertEquals(testDefault, ((OpenSslServerSessionContext)sslSessionContext).isSessionCacheEnabled());
        }
    }

    @Test
    public void testPreserveEnabledCipherSuitesOrder() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLEngine engine = context.createSSLEngine();
        HttpServerOptions options = new HttpServerOptions();
        for (String suite : engine.getEnabledCipherSuites()) {
            options.addEnabledCipherSuite(suite);
        }
        this.assertEquals(new ArrayList(options.getEnabledCipherSuites()), Arrays.asList(engine.getEnabledCipherSuites()));
        this.assertEquals(new ArrayList(new HttpServerOptions(options).getEnabledCipherSuites()), Arrays.asList(engine.getEnabledCipherSuites()));
        JsonObject json = options.toJson();
        this.assertEquals(new ArrayList(new HttpServerOptions(json).getEnabledCipherSuites()), Arrays.asList(engine.getEnabledCipherSuites()));
        SSLHelper helper = new SSLHelper(options, (KeyCertOptions)Cert.SERVER_JKS.get(), null);
        this.assertEquals(Arrays.asList(helper.createEngine((VertxInternal)this.vertx).getEnabledCipherSuites()), Arrays.asList(engine.getEnabledCipherSuites()));
    }

    @Test
    public void testPreserveEnabledSecureTransportProtocolOrder() throws Exception {
        HttpServerOptions options = new HttpServerOptions();
        ArrayList<String> expectedProtocols = new ArrayList<String>(options.getEnabledSecureTransportProtocols());
        options.removeEnabledSecureTransportProtocol("TLSv1");
        options.addEnabledSecureTransportProtocol("SSLv3");
        expectedProtocols.remove("TLSv1");
        expectedProtocols.add("SSLv3");
        this.assertEquals(new ArrayList(options.getEnabledSecureTransportProtocols()), expectedProtocols);
        this.assertEquals(new ArrayList(new HttpServerOptions(options).getEnabledSecureTransportProtocols()), expectedProtocols);
        JsonObject json = options.toJson();
        this.assertEquals(new ArrayList(new HttpServerOptions(json).getEnabledSecureTransportProtocols()), expectedProtocols);
    }
}

