/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.AsyncMapTest;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.fakecluster.FakeClusterManager;
import org.junit.Test;

public class ClusteredAsyncMapTest
extends AsyncMapTest {
    int pos;

    @Override
    protected Vertx getVertx() {
        Vertx vertx = this.vertices[this.pos];
        if (++this.pos == this.getNumNodes()) {
            this.pos = 0;
        }
        return vertx;
    }

    @Test
    public void testGetLocalAsyncMap() {
        Vertx node1 = this.getVertx();
        Vertx node2 = this.getVertx();
        this.assertNotSame(node1, node2);
        CompositeFuture.all((Future)Future.future(fut -> node1.sharedData().getLocalAsyncMap("map", (Handler)fut)), (Future)Future.future(fut -> node2.sharedData().getLocalAsyncMap("map", (Handler)fut))).compose(compFutureMaps -> {
            AsyncMap mapNode1 = (AsyncMap)((CompositeFuture)compFutureMaps.result()).resultAt(0);
            AsyncMap mapNode2 = (AsyncMap)((CompositeFuture)compFutureMaps.result()).resultAt(1);
            return CompositeFuture.all((Future)Future.future(fut -> mapNode1.put((Object)"Hodor", (Object)"Hodor", (Handler)fut)), (Future)Future.future(fut -> mapNode2.put((Object)"Hodor", (Object)"Hodor Hodor", (Handler)fut))).compose(compFuturePutted -> CompositeFuture.all((Future)Future.future(fut -> mapNode1.get((Object)"Hodor", (Handler)fut)), (Future)Future.future(fut -> mapNode2.get((Object)"Hodor", (Handler)fut))));
        }).onComplete(asyncCompFuture -> {
            this.assertTrue(asyncCompFuture.succeeded());
            String valueMapNode1 = (String)((CompositeFuture)asyncCompFuture.result()).resultAt(0);
            String valueMapNode2 = (String)((CompositeFuture)asyncCompFuture.result()).resultAt(1);
            this.assertEquals(valueMapNode1, "Hodor");
            this.assertEquals(valueMapNode2, "Hodor Hodor");
            this.testComplete();
        });
        this.await();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(this.getNumNodes());
    }

    protected int getNumNodes() {
        return 2;
    }

    @Override
    protected ClusterManager getClusterManager() {
        return new FakeClusterManager();
    }
}

