/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpClient;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class JsonTest
extends VertxTestBase {
    @Test
    public void testJsonObject() {
        JsonObject obj = new JsonObject();
        obj.put("foo", "bar");
        try {
            obj.toString();
            this.fail();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.assertTrue(obj.containsKey("foo"));
        this.assertEquals(obj, obj.copy());
    }

    @Test
    public void testJsonArray() {
        JsonArray array = new JsonArray();
        array.add("foo");
        try {
            array.toString();
            this.fail();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.assertTrue(array.contains((Object)"foo"));
        this.assertEquals(array, array.copy());
    }

    @Test
    public void testHttp() {
        try (Vertx vertx = Vertx.vertx();){
            vertx.createHttpServer().requestHandler(req -> req.response().end("hello")).listen(8080, "localhost", this.onSuccess(s -> {
                HttpClient client = vertx.createHttpClient();
                client.get(8080, "localhost", "/", resp -> {
                    resp.exceptionHandler(this::fail);
                    resp.bodyHandler(body -> {
                        this.assertEquals("hello", body.toString());
                        this.testComplete();
                    });
                }).exceptionHandler(this::fail).end();
            }));
            this.await();
        }
    }

    @Test
    public void testEventBus() {
        try (Vertx vertx = Vertx.vertx();){
            EventBus eb = vertx.eventBus();
            eb.consumer("the-address", msg -> {
                this.assertEquals("ping", msg.body());
                msg.reply((Object)"pong");
            });
            eb.request("the-address", (Object)"ping", this.onSuccess(resp -> {
                this.assertEquals("pong", resp.body());
                this.testComplete();
            }));
            this.await();
        }
    }
}

