/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakestream;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.Arguments;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Stream;

public class FakeStream<T>
implements ReadStream<T>,
WriteStream<T> {
    private static final Object END_SENTINEL = new Object();
    private boolean emitting;
    private long highWaterMark = 16L;
    private Handler<Throwable> exceptionHandler;
    private Handler<T> itemHandler;
    private Handler<Void> endHandler;
    private final Deque<Op<T>> pending = new ArrayDeque<Op<T>>();
    private long demand = Long.MAX_VALUE;
    private boolean ended;
    private Future<Void> end = Future.succeededFuture();
    private boolean overflow;
    private Handler<Void> drainHandler;
    private int pauseCount;
    private int resumeCount;

    public synchronized int pauseCount() {
        return this.pauseCount;
    }

    public synchronized int resumeCount() {
        return this.resumeCount;
    }

    public synchronized boolean isPaused() {
        return this.demand == 0L;
    }

    public synchronized boolean isEnded() {
        return this.ended;
    }

    public synchronized long demand() {
        return this.demand;
    }

    public synchronized FakeStream<T> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    public final boolean emit(T elt) {
        return this.emit(Stream.of(elt));
    }

    public boolean emit(Stream<T> stream) {
        return this.doEmit(stream.map(Op::new));
    }

    public final boolean doEmit(Op<T> elt) {
        return this.doEmit(Stream.of(elt));
    }

    private synchronized boolean doEmit(Stream<Op<T>> stream) {
        if (this.ended) {
            throw new IllegalStateException();
        }
        stream.forEach(this.pending::add);
        this.checkPending();
        boolean writable = (long)this.pending.size() <= this.highWaterMark;
        this.overflow |= !writable;
        return writable;
    }

    public void end() {
        this.end((Handler<AsyncResult<Void>>)((Handler)null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Handler<AsyncResult<Void>> h) {
        FakeStream fakeStream = this;
        synchronized (fakeStream) {
            if (this.ended) {
                throw new IllegalStateException();
            }
            this.ended = true;
            Promise promise = Promise.promise();
            promise.future().onComplete(ar -> {
                Handler<Void> handler;
                if (h != null) {
                    h.handle(ar);
                }
                if ((handler = this.endHandler()) != null) {
                    handler.handle(null);
                }
            });
            this.pending.add(new Op<Object>(END_SENTINEL, (Promise<Void>)promise));
        }
        this.checkPending();
    }

    public synchronized void fail(Throwable err) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler != null) {
            this.exceptionHandler.handle((Object)err);
        }
    }

    public synchronized FakeStream<T> handler(Handler<T> handler) {
        this.itemHandler = handler;
        return this;
    }

    public synchronized Handler<T> handler() {
        return this.itemHandler;
    }

    public synchronized FakeStream<T> pause() {
        ++this.pauseCount;
        this.demand = 0L;
        return this;
    }

    private void checkPending() {
        Object handler;
        Op<T> op;
        if (this.emitting) {
            return;
        }
        this.emitting = true;
        while (this.demand > 0L && (op = this.pending.poll()) != null) {
            if (this.demand != Long.MAX_VALUE) {
                --this.demand;
            }
            if (op.item == END_SENTINEL) {
                this.end.onComplete(op.ack);
                continue;
            }
            handler = this.itemHandler;
            try {
                if (handler != null) {
                    handler.handle(op.item);
                }
                op.ack.complete();
            }
            catch (Exception e) {
                op.ack.fail((Throwable)e);
            }
        }
        if (this.pending.isEmpty() && this.overflow) {
            this.overflow = false;
            handler = this.drainHandler;
            this.drainHandler = null;
            if (handler != null) {
                handler.handle(null);
            }
        }
        this.emitting = false;
    }

    public synchronized FakeStream<T> fetch(long amount) {
        Arguments.require((amount > 0L ? 1 : 0) != 0, (String)"Fetch amount must be > 0L");
        this.demand += amount;
        if (this.demand < 0L) {
            this.demand = Long.MAX_VALUE;
        }
        this.checkPending();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FakeStream<T> resume() {
        FakeStream fakeStream = this;
        synchronized (fakeStream) {
            ++this.resumeCount;
        }
        return this.fetch(Long.MAX_VALUE);
    }

    public synchronized FakeStream<T> endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    public synchronized Handler<Void> endHandler() {
        return this.endHandler;
    }

    public FakeStream<T> write(T data) {
        this.write((Object)data, (Handler)null);
        return this;
    }

    public FakeStream<T> write(T data, Handler<AsyncResult<Void>> handler) {
        Promise ack = Promise.promise();
        if (handler != null) {
            ack.future().onComplete(handler);
        }
        this.doEmit(new Op<T>(data, (Promise<Void>)ack));
        return this;
    }

    public synchronized FakeStream<T> setWriteQueueMaxSize(int maxSize) {
        this.highWaterMark = maxSize;
        return this;
    }

    public synchronized boolean writeQueueFull() {
        return (long)this.pending.size() > this.highWaterMark;
    }

    public synchronized FakeStream<T> drainHandler(@Nullable Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    public synchronized Handler<Void> drainHandler() {
        return this.drainHandler;
    }

    public synchronized FakeStream<T> setEnd(Future<Void> fut) {
        if (this.ended) {
            throw new IllegalStateException();
        }
        this.end = fut;
        return this;
    }

    static class Op<T> {
        final T item;
        final Promise<Void> ack;

        Op(T item) {
            this.item = item;
            this.ack = Promise.promise();
        }

        Op(T item, Promise<Void> ack) {
            this.item = item;
            this.ack = ack;
        }
    }
}

