/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakestream;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.fakestream.FakeStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Test;

public class FakeStreamTest
extends AsyncTestBase {
    private FakeStream<Integer> stream;
    private List<Integer> emitted;
    private int drained;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.emitted = new ArrayList<Integer>();
        this.stream = new FakeStream();
        this.stream.handler(this.emitted::add);
        this.stream.drainHandler(v -> ++this.drained);
        this.drained = 0;
    }

    @Test
    public void testEmit() {
        this.assertTrue(this.stream.emit(0));
        this.assertEquals(Collections.singletonList(0), this.emitted);
        this.assertTrue(this.stream.emit(1));
        this.assertTrue(this.stream.emit(2));
        this.assertEquals(Arrays.asList(0, 1, 2), this.emitted);
    }

    @Test
    public void testPause() {
        this.stream.pause();
        this.assertTrue(this.stream.emit(IntStream.range(0, 16).boxed()));
        this.assertFalse(this.stream.emit(16));
        this.assertEquals(Collections.emptyList(), this.emitted);
    }

    @Test
    public void testResume() {
        this.stream.pause();
        this.assertFalse(this.stream.emit(IntStream.range(0, 17).boxed()));
        this.stream.resume();
        this.assertEquals(1L, this.drained);
        this.assertEquals(IntStream.range(0, 17).boxed().collect(Collectors.toList()), this.emitted);
    }

    @Test
    public void testFetch() {
        this.stream.pause();
        this.assertFalse(this.stream.emit(IntStream.range(0, 17).boxed()));
        for (int i = 1; i < 17; ++i) {
            this.stream.fetch(1L);
            this.assertEquals(IntStream.range(0, i).boxed().collect(Collectors.toList()), this.emitted);
            this.assertEquals(0L, this.drained);
        }
        this.stream.fetch(1L);
        this.assertEquals(IntStream.range(0, 17).boxed().collect(Collectors.toList()), this.emitted);
        this.assertEquals(1L, this.drained);
    }

    @Test
    public void testWriteQueueFull() {
        this.stream.pause();
        int count = 0;
        while (this.stream.emit(count++)) {
            this.assertFalse(this.stream.writeQueueFull());
        }
        this.assertTrue(this.stream.writeQueueFull());
        this.stream.fetch(1L);
        this.assertFalse(this.stream.writeQueueFull());
    }

    @Test
    public void testEmitReentrancy() {
        AtomicInteger count = new AtomicInteger(2);
        AtomicBoolean emitting = new AtomicBoolean();
        this.stream.pause();
        this.stream.fetch(3L);
        this.stream.handler(item -> {
            this.assertFalse(emitting.getAndSet(true));
            this.emitted.add((Integer)item);
            this.stream.emit(count.getAndIncrement());
            emitting.set(false);
        });
        this.stream.emit(Stream.of(0, 1));
        this.assertEquals(Arrays.asList(0, 1, 2), this.emitted);
    }

    @Test
    public void testFetchReentrancy() {
        AtomicInteger count = new AtomicInteger(2);
        this.stream.pause();
        AtomicBoolean emitting = new AtomicBoolean();
        this.stream.handler(item -> {
            this.assertFalse(emitting.getAndSet(true));
            this.emitted.add((Integer)item);
            this.stream.emit(count.getAndIncrement());
            emitting.set(false);
        });
        this.stream.write((Object)0);
        this.stream.write((Object)1);
        this.stream.fetch(3L);
        this.assertEquals(Arrays.asList(0, 1, 2), this.emitted);
    }

    @Test
    public void testFetchAfterEnd() {
        AtomicInteger ended = new AtomicInteger();
        AtomicReference endRes = new AtomicReference();
        this.stream.endHandler(v -> ended.incrementAndGet());
        this.stream.end((Handler<AsyncResult<Void>>)((Handler)endRes::set));
        this.assertEquals(1L, ended.get());
        this.assertTrue(((AsyncResult)endRes.get()).succeeded());
        this.stream.fetch(1L);
        this.assertEquals(1L, ended.get());
        this.assertTrue(((AsyncResult)endRes.get()).succeeded());
    }

    @Test
    public void testAsyncEnd() {
        Promise end = Promise.promise();
        AtomicInteger ended = new AtomicInteger();
        AtomicReference endRes = new AtomicReference();
        this.stream.setEnd((Future<Void>)end.future());
        this.stream.endHandler(v -> ended.incrementAndGet());
        this.stream.end((Handler<AsyncResult<Void>>)((Handler)endRes::set));
        this.assertEquals(0L, ended.get());
        this.assertNull(endRes.get());
        end.complete();
        this.assertEquals(1L, ended.get());
        this.assertTrue(((AsyncResult)endRes.get()).succeeded());
    }

    @Test
    public void testAsyncEndDeferred() {
        Promise end = Promise.promise();
        AtomicInteger ended = new AtomicInteger();
        AtomicReference endRes = new AtomicReference();
        this.stream.setEnd((Future<Void>)end.future());
        this.stream.pause();
        this.stream.emit(3);
        this.stream.endHandler(v -> ended.incrementAndGet());
        this.stream.end((Handler<AsyncResult<Void>>)((Handler)endRes::set));
        this.assertEquals(0L, ended.get());
        this.assertNull(endRes.get());
        end.complete();
        this.assertEquals(0L, ended.get());
        this.assertNull(endRes.get());
        this.stream.fetch(1L);
        this.assertEquals(0L, ended.get());
        this.assertNull(endRes.get());
        this.stream.fetch(1L);
        this.assertEquals(1L, ended.get());
        this.assertTrue(((AsyncResult)endRes.get()).succeeded());
    }

    @Test
    public void testAck() {
        this.stream.pause();
        Future ack0 = Future.future(p -> this.stream.write((Object)0, (Handler)p));
        Future ack1 = Future.future(p -> this.stream.write((Object)1, (Handler)p));
        Future ack2 = Future.future(p -> this.stream.write((Object)2, (Handler)p));
        this.assertFalse(ack0.isComplete());
        this.assertFalse(ack1.isComplete());
        this.assertFalse(ack2.isComplete());
        this.stream.fetch(1L);
        this.assertTrue(ack0.isComplete());
        this.assertFalse(ack1.isComplete());
        this.assertFalse(ack2.isComplete());
        this.stream.fetch(2L);
        this.assertTrue(ack0.isComplete());
        this.assertTrue(ack1.isComplete());
        this.assertTrue(ack2.isComplete());
    }

    @Test
    public void testAckFailure() {
        RuntimeException failure = new RuntimeException();
        this.stream.pause();
        this.stream.handler(item -> {
            throw failure;
        });
        Future ack = Future.future(p -> this.stream.write((Object)0, (Handler)p));
        this.assertFalse(ack.isComplete());
        this.stream.fetch(1L);
        this.assertTrue(ack.failed());
        this.assertEquals(failure, ack.cause());
    }
}

