/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.VertxTestBase;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Test;

public class CompositeFutureTest
extends VertxTestBase {
    private static final int NUM_THREADS = 4;
    private static final BiConsumer<Integer, Promise<String>> MIXED = (x, p) -> {
        if (x % 2 == 0) {
            p.complete((Object)("success-" + x));
        } else {
            p.complete((Object)("failure-" + x));
        }
    };
    private static final BiConsumer<Integer, Promise<String>> SUCCESS = (x, p) -> p.complete((Object)("success-" + x));
    private static final BiConsumer<Integer, Promise<String>> FAILURE = (x, p) -> p.fail("failure-" + x);

    @Repeat(times=100)
    @Test
    public void testConcurrentAllSuccess() throws Exception {
        this.testConcurrentCompletion(SUCCESS, CompositeFuture::all, cf -> this.assertTrue(cf.succeeded()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentAllFailure() throws Exception {
        this.testConcurrentCompletion((x, p) -> p.fail("failure-" + x), CompositeFuture::all, cf -> this.assertTrue(cf.failed()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentAllMixed() throws Exception {
        this.testConcurrentCompletion(MIXED, CompositeFuture::all, cf -> this.assertTrue(cf.isComplete()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentAnySuccess() throws Exception {
        this.testConcurrentCompletion(SUCCESS, CompositeFuture::any, cf -> this.assertTrue(cf.succeeded()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentAnyFailure() throws Exception {
        this.testConcurrentCompletion(FAILURE, CompositeFuture::any, cf -> this.assertTrue(cf.failed()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentAnyMixed() throws Exception {
        this.testConcurrentCompletion(MIXED, CompositeFuture::any, cf -> this.assertTrue(cf.isComplete()));
    }

    @Repeat(times=100)
    @Test
    public void tesConcurrenttJoinSuccess() throws Exception {
        this.testConcurrentCompletion(SUCCESS, CompositeFuture::join, cf -> this.assertTrue(cf.succeeded()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentJoinFailure() throws Exception {
        this.testConcurrentCompletion((x, p) -> p.fail("failure-" + x), CompositeFuture::join, cf -> this.assertTrue(cf.failed()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentJoinMixed() throws Exception {
        this.testConcurrentCompletion(MIXED, CompositeFuture::join, cf -> this.assertTrue(cf.isComplete()));
    }

    private void testConcurrentCompletion(BiConsumer<Integer, Promise<String>> completer, Function<List<Future>, CompositeFuture> fact, Consumer<CompositeFuture> check) throws Exception {
        this.disableThreadChecks();
        List promises = IntStream.range(0, 4).mapToObj(i -> Promise.promise()).collect(Collectors.toList());
        List futures = promises.stream().map(Promise::future).collect(Collectors.toList());
        CompositeFuture compositeFuture = fact.apply(futures);
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        CyclicBarrier barrier = new CyclicBarrier(4);
        int i2 = 0;
        while (i2 < 4) {
            int x2 = i2++;
            executorService.submit(() -> {
                Promise promise = (Promise)promises.get(x2);
                try {
                    barrier.await();
                    completer.accept(x2, promise);
                }
                catch (Throwable t) {
                    this.fail(t);
                }
            });
        }
        compositeFuture.onComplete(x -> {
            check.accept(compositeFuture);
            this.testComplete();
        });
        executorService.shutdown();
        executorService.awaitTermination(30L, TimeUnit.SECONDS);
        this.await();
    }
}

