/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.Context;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class ExecuteBlockingTest
extends VertxTestBase {
    @Test
    public void testExecuteBlockingSuccess() {
        this.vertx.executeBlocking(future -> {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            future.complete((Object)"done!");
        }, this.onSuccess(res -> {
            this.assertEquals("done!", res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testExecuteBlockingFailed() {
        this.vertx.executeBlocking(future -> {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            future.fail("failed!");
        }, this.onFailure(t -> {
            this.assertEquals("failed!", t.getMessage());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testExecuteBlockingThrowsRTE() {
        this.vertx.executeBlocking(future -> {
            throw new RuntimeException("rte");
        }, this.onFailure(t -> {
            this.assertEquals("rte", t.getMessage());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testExecuteBlockingContext() {
        this.vertx.runOnContext(v -> {
            Context ctx = this.vertx.getOrCreateContext();
            this.assertTrue(ctx.isEventLoopContext());
            this.vertx.executeBlocking(future -> {
                this.assertSame(ctx, this.vertx.getOrCreateContext());
                this.assertTrue(Thread.currentThread().getName().startsWith("vert.x-worker-thread"));
                this.assertTrue(Context.isOnWorkerThread());
                this.assertFalse(Context.isOnEventLoopThread());
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.vertx.runOnContext(v2 -> {
                    this.assertSame(ctx, this.vertx.getOrCreateContext());
                    this.assertTrue(Thread.currentThread().getName().startsWith("vert.x-eventloop-thread"));
                    this.assertFalse(Context.isOnWorkerThread());
                    this.assertTrue(Context.isOnEventLoopThread());
                    future.complete((Object)"done!");
                });
            }, this.onSuccess(res -> {
                this.assertSame(ctx, this.vertx.getOrCreateContext());
                this.assertTrue(Thread.currentThread().getName().startsWith("vert.x-eventloop-thread"));
                this.assertFalse(Context.isOnWorkerThread());
                this.assertTrue(Context.isOnEventLoopThread());
                this.assertEquals("done!", res);
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testExecuteBlockingTTCL() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.assertNotNull(cl);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference blockingTCCL = new AtomicReference();
        this.vertx.executeBlocking(future -> {
            future.complete((Object)"whatever");
            blockingTCCL.set(Thread.currentThread().getContextClassLoader());
        }, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals("whatever", ar.result());
            latch.countDown();
        });
        this.assertSame(cl, Thread.currentThread().getContextClassLoader());
        this.awaitLatch(latch);
        this.assertSame(cl, blockingTCCL.get());
    }

    @Test
    public void testExecuteBlockingParallel() throws Exception {
        long start = System.currentTimeMillis();
        int numExecBlocking = 10;
        long pause = 1000L;
        CountDownLatch latch = new CountDownLatch(numExecBlocking);
        this.vertx.runOnContext(v -> {
            Context ctx = this.vertx.getOrCreateContext();
            this.assertTrue(ctx.isEventLoopContext());
            for (int i = 0; i < numExecBlocking; ++i) {
                this.vertx.executeBlocking(future -> {
                    this.assertSame(ctx, this.vertx.getOrCreateContext());
                    this.assertTrue(Thread.currentThread().getName().startsWith("vert.x-worker-thread"));
                    this.assertTrue(Context.isOnWorkerThread());
                    this.assertFalse(Context.isOnEventLoopThread());
                    try {
                        Thread.sleep(pause);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    future.complete((Object)"done!");
                }, false, this.onSuccess(res -> {
                    this.assertSame(ctx, this.vertx.getOrCreateContext());
                    this.assertTrue(Thread.currentThread().getName().startsWith("vert.x-eventloop-thread"));
                    this.assertFalse(Context.isOnWorkerThread());
                    this.assertTrue(Context.isOnEventLoopThread());
                    this.assertEquals("done!", res);
                    latch.countDown();
                }));
            }
        });
        this.awaitLatch(latch);
        long now = System.currentTimeMillis();
        long leeway = 1000L;
        this.assertTrue(now - start < pause + leeway);
    }
}

