/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.ClusteredEventBusTestBase;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.Http1xTest;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ClusteredEventBusWithSSLTest
extends ClusteredEventBusTestBase {
    private final EventBusOptions options = new EventBusOptions();

    public ClusteredEventBusWithSSLTest(Cert<?> cert, Trust<?> trust, boolean requireClientAuth, boolean clientTrustAll, boolean useCrl, List<String> enabledCipherSuites) {
        this.options.setSsl(true);
        if (clientTrustAll) {
            this.options.setTrustAll(true);
        }
        if (useCrl) {
            this.options.addCrlPath("tls/root-ca/crl.pem");
        }
        this.options.setTrustOptions((TrustOptions)trust.get());
        this.options.setKeyCertOptions((KeyCertOptions)cert.get());
        if (enabledCipherSuites != null) {
            enabledCipherSuites.forEach(arg_0 -> ((EventBusOptions)this.options).addEnabledCipherSuite(arg_0));
        }
        if (requireClientAuth) {
            this.options.setClientAuth(ClientAuth.REQUIRED);
        }
    }

    @Parameterized.Parameters(name="{index}: event bus SSL ({0} {1} {2} {3} {4} {5}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({Cert.SERVER_JKS, Trust.NONE, false, true, false, Collections.emptyList()}, {Cert.SERVER_JKS, Trust.SERVER_JKS, false, false, true, Collections.emptyList()}, {Cert.SERVER_PKCS12, Trust.SERVER_JKS, false, false, false, Collections.emptyList()}, {Cert.SERVER_PEM, Trust.SERVER_JKS, false, false, false, Collections.emptyList()}, {Cert.SERVER_PKCS12_ROOT_CA, Trust.SERVER_JKS_ROOT_CA, false, false, false, Collections.emptyList()}, {Cert.SERVER_PEM_ROOT_CA, Trust.SERVER_PKCS12_ROOT_CA, false, false, false, Collections.emptyList()}, {Cert.SERVER_JKS, Trust.SERVER_PEM_ROOT_CA, false, true, false, Arrays.asList(Http1xTest.ENABLED_CIPHER_SUITES)});
    }

    @Override
    protected void startNodes(int numNodes) {
        super.startNodes(numNodes, new VertxOptions().setEventBusOptions(this.options));
    }

    @Override
    @Test
    @Ignore
    public void testSendWhileUnsubscribing() throws Exception {
    }
}

