/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.impl.HttpUtils;
import java.net.URI;
import org.junit.Assert;
import org.junit.Test;

public class HttpUtilsTest {
    @Test
    public void testParseKeepAliveTimeout() {
        HttpUtilsTest.assertKeepAliveTimeout("timeout=5", 5);
        HttpUtilsTest.assertKeepAliveTimeout(" timeout=5", 5);
        HttpUtilsTest.assertKeepAliveTimeout("timeout=5 ", 5);
        HttpUtilsTest.assertKeepAliveTimeout("a=4,timeout=5", 5);
        HttpUtilsTest.assertKeepAliveTimeout(" a=4,timeout=5", 5);
        HttpUtilsTest.assertKeepAliveTimeout("a=4 ,timeout=5", 5);
        HttpUtilsTest.assertKeepAliveTimeout("a=4, timeout=5", 5);
        HttpUtilsTest.assertKeepAliveTimeout("a=4,timeout=5 ", 5);
        HttpUtilsTest.assertKeepAliveTimeout("", -1);
        HttpUtilsTest.assertKeepAliveTimeout("a=4", -1);
        HttpUtilsTest.assertKeepAliveTimeout("timeout", -1);
        HttpUtilsTest.assertKeepAliveTimeout("timeout=", -1);
        HttpUtilsTest.assertKeepAliveTimeout("timeout=a", -1);
        HttpUtilsTest.assertKeepAliveTimeout("timeout=-5", -1);
        HttpUtilsTest.assertKeepAliveTimeout("timeout=5_", -1);
    }

    private static void assertKeepAliveTimeout(CharSequence header, int expected) {
        Assert.assertEquals((long)expected, (long)HttpUtils.parseKeepAliveHeaderTimeout((CharSequence)header));
    }

    @Test
    public void testResolveUri() throws Exception {
        this.assertResolveUri("http://a/b/c/g", "http://a/b/c/d;p?q", "g");
        this.assertResolveUri("http://a/b/c/g", "http://a/b/c/d;p?q", "./g");
        this.assertResolveUri("http://a/b/c/g/", "http://a/b/c/d;p?q", "g/");
        this.assertResolveUri("http://a/g", "http://a/b/c/d;p?q", "/g");
        this.assertResolveUri("http://g", "http://a/b/c/d;p?q", "//g");
        this.assertResolveUri("http://a/b/c/d;p?y", "http://a/b/c/d;p?q", "?y");
        this.assertResolveUri("http://a/b/c/g?y", "http://a/b/c/d;p?q", "g?y");
        this.assertResolveUri("http://a/b/c/d;p?q#s", "http://a/b/c/d;p?q", "#s");
        this.assertResolveUri("http://a/b/c/g#s", "http://a/b/c/d;p?q", "g#s");
        this.assertResolveUri("http://a/b/c/;x", "http://a/b/c/d;p?q", ";x");
        this.assertResolveUri("http://a/b/c/g;x", "http://a/b/c/d;p?q", "g;x");
        this.assertResolveUri("http://a/b/c/g;x?y#s", "http://a/b/c/d;p?q", "g;x?y#s");
        this.assertResolveUri("http://a/b/c/d;p?q", "http://a/b/c/d;p?q", "");
        this.assertResolveUri("http://a/b/c/", "http://a/b/c/d;p?q", ".");
        this.assertResolveUri("http://a/b/c/", "http://a/b/c/d;p?q", "./");
        this.assertResolveUri("http://a/b/", "http://a/b/c/d;p?q", "..");
        this.assertResolveUri("http://a/", "http://a/b/c/d;p?q", "../..");
        this.assertResolveUri("http://a/", "http://a/b/c/d;p?q", "../../");
        this.assertResolveUri("http://a/g", "http://a/b/c/d;p?q", "../../g");
        this.assertResolveUri("http://a/g", "http://a/b/c/d;p?q", "../../../g");
        this.assertResolveUri("http://a/g", "http://a/b/c/d;p?q", "../../../../g");
        this.assertResolveUri("http://example.com/path", "https://example.com/path", "http://example.com/path");
        this.assertResolveUri("https://example.com/relativeUrl", "https://example.com/path?q=2", "/relativeUrl");
        this.assertResolveUri("https://example.com/path?q=2#test", "https://example.com/path?q=2", "#test");
        this.assertResolveUri("https://example.com/relativePath?q=3", "https://example.com/path?q=2", "/relativePath?q=3");
        this.assertResolveUri("https://example.com/path?q=3", "https://example.com/path?q=2", "?q=3");
    }

    @Test
    public void testNoLeadingSlash() throws Exception {
        Assert.assertEquals((Object)"/path/with/no/leading/slash", (Object)HttpUtils.normalizePath((String)"path/with/no/leading/slash"));
    }

    @Test
    public void testNullPath() throws Exception {
        Assert.assertNull((Object)HttpUtils.normalizePath(null));
    }

    @Test
    public void testPathWithSpaces1() throws Exception {
        Assert.assertEquals((Object)"/foo+blah/eek", (Object)HttpUtils.normalizePath((String)"/foo+blah/eek"));
    }

    @Test
    public void testPathWithSpaces2() throws Exception {
        Assert.assertEquals((Object)"/foo%20blah/eek", (Object)HttpUtils.normalizePath((String)"/foo%20blah/eek"));
    }

    @Test
    public void testDodgyPath1() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)HttpUtils.normalizePath((String)"/foo/../../blah"));
    }

    @Test
    public void testDodgyPath2() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)HttpUtils.normalizePath((String)"/foo/../../../blah"));
    }

    @Test
    public void testDodgyPath3() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)HttpUtils.normalizePath((String)"/foo/../blah"));
    }

    @Test
    public void testDodgyPath4() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)HttpUtils.normalizePath((String)"/../blah"));
    }

    @Test
    public void testMultipleSlashPath1() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)HttpUtils.normalizePath((String)"//blah"));
    }

    @Test
    public void testMultipleSlashPath2() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)HttpUtils.normalizePath((String)"///blah"));
    }

    @Test
    public void testMultipleSlashPath3() throws Exception {
        Assert.assertEquals((Object)"/foo/blah", (Object)HttpUtils.normalizePath((String)"/foo//blah"));
    }

    @Test
    public void testMultipleSlashPath4() throws Exception {
        Assert.assertEquals((Object)"/foo/blah/", (Object)HttpUtils.normalizePath((String)"/foo//blah///"));
    }

    @Test
    public void testSlashesAndDodgyPath1() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)HttpUtils.normalizePath((String)"//../blah"));
    }

    @Test
    public void testSlashesAndDodgyPath2() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)HttpUtils.normalizePath((String)"/..//blah"));
    }

    @Test
    public void testSlashesAndDodgyPath3() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)HttpUtils.normalizePath((String)"//..//blah"));
    }

    @Test
    public void testDodgyPathEncoded() throws Exception {
        Assert.assertEquals((Object)"/..%2Fblah", (Object)HttpUtils.normalizePath((String)"/%2E%2E%2Fblah"));
    }

    @Test
    public void testTrailingSlash() throws Exception {
        Assert.assertEquals((Object)"/blah/", (Object)HttpUtils.normalizePath((String)"/blah/"));
    }

    @Test
    public void testMultipleTrailingSlashes1() throws Exception {
        Assert.assertEquals((Object)"/blah/", (Object)HttpUtils.normalizePath((String)"/blah//"));
    }

    @Test
    public void testMultipleTrailingSlashes2() throws Exception {
        Assert.assertEquals((Object)"/blah/", (Object)HttpUtils.normalizePath((String)"/blah///"));
    }

    @Test
    public void testBadURL() throws Exception {
        try {
            HttpUtils.normalizePath((String)"/%7B%channel%%7D");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleDot() throws Exception {
        Assert.assertEquals((Object)"/foo/bar/abc..def", (Object)HttpUtils.normalizePath((String)"/foo/bar/abc..def"));
    }

    @Test
    public void testSpec() throws Exception {
        Assert.assertEquals((Object)"/a/g", (Object)HttpUtils.normalizePath((String)"/a/b/c/./../../g"));
        Assert.assertEquals((Object)"/mid/6", (Object)HttpUtils.normalizePath((String)"mid/content=5/../6"));
        Assert.assertEquals((Object)"/~username/", (Object)HttpUtils.normalizePath((String)"/%7Eusername/"));
        Assert.assertEquals((Object)"/b/", (Object)HttpUtils.normalizePath((String)"/b/c/.."));
    }

    private void assertResolveUri(String expected, String base, String rel) throws Exception {
        URI resolved = HttpUtils.resolveURIReference((String)base, (String)rel);
        Assert.assertEquals((Object)URI.create(expected), (Object)resolved);
    }

    @Test
    public void testResolveURIEncode() throws Exception {
        this.check("https://foo.com", "/%7E", "/%7E");
        this.check("https://foo.com", "/%7E/", "/%7E/");
        this.check("https://foo.com", "%7E/", "/%7E/");
        this.check("https://foo.com/A", "%7E/", "/%7E/");
        this.check("https://foo.com/%6E/", "%7E/", "/%6E/%7E/");
        this.check("https://foo.com", "https://bar.com/%7E", "/%7E");
        this.check("https://foo.com", "https://bar.com/%7E/", "/%7E/");
        this.check("https://foo.com/%6E", "", "/%6E");
        this.check("https://foo.com/%6E/", "", "/%6E/");
    }

    private void check(String base, String ref, String expected) throws Exception {
        URI uri = HttpUtils.resolveURIReference((String)base, (String)ref);
        Assert.assertEquals((Object)expected, (Object)uri.getPath());
    }
}

