/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.impl.KeyStoreHelper;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.junit.Assert;
import org.junit.Test;

public class KeyStoreTest
extends VertxTestBase {
    @Test
    public void testJKSOptions() throws Exception {
        JksOptions options = new JksOptions();
        this.assertNull(options.getPath());
        String randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setPath(randString));
        this.assertEquals(randString, options.getPath());
        this.assertNull(options.getPassword());
        randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setPassword(randString));
        this.assertEquals(randString, options.getPassword());
    }

    @Test
    public void testDefaultJKSOptionsJson() {
        JksOptions def = new JksOptions();
        JksOptions json = new JksOptions(new JsonObject());
        this.assertEquals(def.getPassword(), json.getPassword());
        this.assertEquals(def.getPath(), json.getPath());
        this.assertEquals(def.getValue(), json.getValue());
    }

    @Test
    public void testJKSOptionsJson() throws Exception {
        JksOptions options = new JksOptions(new JsonObject());
        this.assertEquals(null, options.getPassword());
        this.assertEquals(null, options.getPath());
        this.assertEquals(null, options.getValue());
        String password = TestUtils.randomAlphaString(100);
        String path = TestUtils.randomAlphaString(100);
        String value = TestUtils.randomAlphaString(100);
        options = new JksOptions(new JsonObject().put("password", password).put("path", path).put("value", value.getBytes()));
        this.assertEquals(password, options.getPassword());
        this.assertEquals(path, options.getPath());
        this.assertEquals(Buffer.buffer((String)value), options.getValue());
    }

    @Test
    public void testCopyJKSOptions() throws Exception {
        JksOptions options = new JksOptions();
        String password = TestUtils.randomAlphaString(100);
        String path = TestUtils.randomAlphaString(100);
        Buffer value = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        options.setPassword(password);
        options.setPath(path);
        options.setValue(value);
        options = new JksOptions(options);
        this.assertEquals(password, options.getPassword());
        this.assertEquals(path, options.getPath());
        this.assertEquals(value, options.getValue());
        options = new JksOptions(options.toJson());
        this.assertEquals(password, options.getPassword());
        this.assertEquals(path, options.getPath());
        this.assertEquals(value, options.getValue());
    }

    @Test
    public void testPKCS12Options() throws Exception {
        PfxOptions options = new PfxOptions();
        this.assertNull(options.getPath());
        String randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setPath(randString));
        this.assertEquals(randString, options.getPath());
        this.assertNull(options.getPassword());
        randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setPassword(randString));
        this.assertEquals(randString, options.getPassword());
    }

    @Test
    public void testDefaultPKCS12OptionsJson() {
        PfxOptions def = new PfxOptions();
        PfxOptions json = new PfxOptions(new JsonObject());
        this.assertEquals(def.getPassword(), json.getPassword());
        this.assertEquals(def.getPath(), json.getPath());
        this.assertEquals(def.getValue(), json.getValue());
    }

    @Test
    public void testPKCS12OptionsJson() throws Exception {
        PfxOptions options = new PfxOptions(new JsonObject());
        this.assertEquals(null, options.getPassword());
        this.assertEquals(null, options.getPath());
        this.assertEquals(null, options.getValue());
        String password = TestUtils.randomAlphaString(100);
        String path = TestUtils.randomAlphaString(100);
        String value = TestUtils.randomAlphaString(100);
        options = new PfxOptions(new JsonObject().put("password", password).put("path", path).put("value", value.getBytes()));
        this.assertEquals(password, options.getPassword());
        this.assertEquals(path, options.getPath());
        this.assertEquals(Buffer.buffer((String)value), options.getValue());
    }

    @Test
    public void testCopyPKCS12Options() throws Exception {
        PfxOptions options = new PfxOptions();
        String password = TestUtils.randomAlphaString(100);
        String path = TestUtils.randomAlphaString(100);
        Buffer value = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        options.setPassword(password);
        options.setPath(path);
        options.setValue(value);
        options = new PfxOptions(options);
        this.assertEquals(password, options.getPassword());
        this.assertEquals(path, options.getPath());
        this.assertEquals(value, options.getValue());
        options = new PfxOptions(options.toJson());
        this.assertEquals(password, options.getPassword());
        this.assertEquals(path, options.getPath());
        this.assertEquals(value, options.getValue());
    }

    @Test
    public void testKeyCertOptions() throws Exception {
        PemKeyCertOptions options = new PemKeyCertOptions();
        this.assertNull(options.getKeyPath());
        String randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setKeyPath(randString));
        this.assertEquals(randString, options.getKeyPath());
        this.assertNull(options.getCertPath());
        randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setCertPath(randString));
        this.assertEquals(randString, options.getCertPath());
    }

    @Test
    public void testDefaultKeyCertOptionsJson() throws Exception {
        PemKeyCertOptions def = new PemKeyCertOptions();
        PemKeyCertOptions json = new PemKeyCertOptions(new JsonObject());
        this.assertEquals(def.getKeyPath(), json.getKeyPath());
        this.assertEquals(def.getCertPath(), json.getCertPath());
        this.assertEquals(def.getKeyValue(), json.getKeyValue());
        this.assertEquals(def.getCertValue(), json.getCertValue());
    }

    @Test
    public void testPemKeyCertOptionsJson() throws Exception {
        PemKeyCertOptions options = new PemKeyCertOptions(new JsonObject());
        this.assertEquals(null, options.getKeyPath());
        this.assertEquals(null, options.getKeyValue());
        this.assertEquals(null, options.getCertPath());
        this.assertEquals(null, options.getCertValue());
        String keyPath1 = TestUtils.randomAlphaString(100);
        Buffer keyValue1 = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        String certPath1 = TestUtils.randomAlphaString(100);
        Buffer certValue1 = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        options = new PemKeyCertOptions(new JsonObject().put("keyPath", keyPath1).put("keyValue", keyValue1.getBytes()).put("certPath", certPath1).put("certValue", certValue1.getBytes()));
        this.assertEquals(keyPath1, options.getKeyPath());
        this.assertEquals(keyValue1, options.getKeyValue());
        this.assertEquals(certPath1, options.getCertPath());
        this.assertEquals(certValue1, options.getCertValue());
        this.assertEquals(Collections.singletonList(keyPath1), options.getKeyPaths());
        this.assertEquals(Collections.singletonList(keyValue1), options.getKeyValues());
        this.assertEquals(Collections.singletonList(certPath1), options.getCertPaths());
        this.assertEquals(Collections.singletonList(certValue1), options.getCertValues());
        String keyPath2 = TestUtils.randomAlphaString(100);
        Buffer keyValue2 = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        String certPath2 = TestUtils.randomAlphaString(100);
        Buffer certValue2 = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        options = new PemKeyCertOptions(new JsonObject().put("keyPaths", new JsonArray().add(keyPath1).add(keyPath2)).put("keyValues", new JsonArray().add(keyValue1.getBytes()).add(keyValue2.getBytes())).put("certPaths", new JsonArray().add(certPath1).add(certPath2)).put("certValues", new JsonArray().add(certValue1.getBytes()).add(certValue2.getBytes())));
        this.assertEquals(keyPath1, options.getKeyPath());
        this.assertEquals(keyValue1, options.getKeyValue());
        this.assertEquals(certPath1, options.getCertPath());
        this.assertEquals(certValue1, options.getCertValue());
        this.assertEquals(Arrays.asList(keyPath1, keyPath2), options.getKeyPaths());
        this.assertEquals(Arrays.asList(keyValue1, keyValue2), options.getKeyValues());
        this.assertEquals(Arrays.asList(certPath1, certPath2), options.getCertPaths());
        this.assertEquals(Arrays.asList(certValue1, certValue2), options.getCertValues());
    }

    @Test
    public void testCopyPemKeyCertOptions() throws Exception {
        PemKeyCertOptions options = new PemKeyCertOptions(new JsonObject());
        String keyPath1 = TestUtils.randomAlphaString(100);
        Buffer keyValue1 = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        String certPath1 = TestUtils.randomAlphaString(100);
        Buffer certValue1 = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        options.setKeyPath(keyPath1);
        options.setKeyValue(keyValue1);
        options.setCertPath(certPath1);
        options.setCertValue(certValue1);
        options = new PemKeyCertOptions(options);
        this.assertEquals(keyPath1, options.getKeyPath());
        this.assertEquals(keyValue1, options.getKeyValue());
        this.assertEquals(certPath1, options.getCertPath());
        this.assertEquals(certValue1, options.getCertValue());
        this.assertEquals(Collections.singletonList(keyPath1), options.getKeyPaths());
        this.assertEquals(Collections.singletonList(keyValue1), options.getKeyValues());
        this.assertEquals(Collections.singletonList(certPath1), options.getCertPaths());
        this.assertEquals(Collections.singletonList(certValue1), options.getCertValues());
        options = new PemKeyCertOptions(options.toJson());
        this.assertEquals(keyPath1, options.getKeyPath());
        this.assertEquals(keyValue1, options.getKeyValue());
        this.assertEquals(certPath1, options.getCertPath());
        this.assertEquals(certValue1, options.getCertValue());
        this.assertEquals(Collections.singletonList(keyPath1), options.getKeyPaths());
        this.assertEquals(Collections.singletonList(keyValue1), options.getKeyValues());
        this.assertEquals(Collections.singletonList(certPath1), options.getCertPaths());
        this.assertEquals(Collections.singletonList(certValue1), options.getCertValues());
        String keyPath2 = TestUtils.randomAlphaString(100);
        Buffer keyValue2 = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        String certPath2 = TestUtils.randomAlphaString(100);
        Buffer certValue2 = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        options.addKeyPath(keyPath2);
        options.addKeyValue(keyValue2);
        options.addCertPath(certPath2);
        options.addCertValue(certValue2);
        options = new PemKeyCertOptions(options);
        this.assertEquals(keyPath1, options.getKeyPath());
        this.assertEquals(keyValue1, options.getKeyValue());
        this.assertEquals(certPath1, options.getCertPath());
        this.assertEquals(certValue1, options.getCertValue());
        this.assertEquals(Arrays.asList(keyPath1, keyPath2), options.getKeyPaths());
        this.assertEquals(Arrays.asList(keyValue1, keyValue2), options.getKeyValues());
        this.assertEquals(Arrays.asList(certPath1, certPath2), options.getCertPaths());
        this.assertEquals(Arrays.asList(certValue1, certValue2), options.getCertValues());
        options = new PemKeyCertOptions(options.toJson());
        this.assertEquals(keyPath1, options.getKeyPath());
        this.assertEquals(keyValue1, options.getKeyValue());
        this.assertEquals(certPath1, options.getCertPath());
        this.assertEquals(certValue1, options.getCertValue());
        this.assertEquals(Arrays.asList(keyPath1, keyPath2), options.getKeyPaths());
        this.assertEquals(Arrays.asList(keyValue1, keyValue2), options.getKeyValues());
        this.assertEquals(Arrays.asList(certPath1, certPath2), options.getCertPaths());
        this.assertEquals(Arrays.asList(certValue1, certValue2), options.getCertValues());
    }

    @Test
    public void testTrustOptions() throws Exception {
        PemTrustOptions options = new PemTrustOptions();
        this.assertEquals(Collections.emptyList(), options.getCertPaths());
        TestUtils.assertNullPointerException(() -> options.addCertPath(null));
        TestUtils.assertIllegalArgumentException(() -> options.addCertPath(""));
        String randString = TestUtils.randomAlphaString(100);
        options.addCertPath(randString);
        this.assertEquals(Collections.singletonList(randString), options.getCertPaths());
        this.assertEquals(Collections.emptyList(), options.getCertValues());
        TestUtils.assertNullPointerException(() -> options.addCertValue(null));
        randString = TestUtils.randomAlphaString(100);
        options.addCertValue(Buffer.buffer((String)randString));
        this.assertEquals(Collections.singletonList(Buffer.buffer((String)randString)), options.getCertValues());
    }

    @Test
    public void testTrustOptionsJson() throws Exception {
        PemTrustOptions options = new PemTrustOptions(new JsonObject());
        this.assertEquals(Collections.emptyList(), options.getCertPaths());
        this.assertEquals(Collections.emptyList(), options.getCertValues());
        String certPath = TestUtils.randomAlphaString(100);
        String certValue = TestUtils.randomAlphaString(100);
        JsonObject json = new JsonObject().put("certPaths", new JsonArray().add(certPath)).put("certValues", new JsonArray().add(certValue.getBytes()));
        options = new PemTrustOptions(json);
        this.assertEquals(Collections.singletonList(certPath), options.getCertPaths());
        this.assertEquals(Collections.singletonList(Buffer.buffer((String)certValue)), options.getCertValues());
    }

    @Test
    public void testDefaultTrustOptionsJson() {
        PemTrustOptions def = new PemTrustOptions();
        PemTrustOptions json = new PemTrustOptions(new JsonObject());
        this.assertEquals(def.getCertPaths(), json.getCertPaths());
        this.assertEquals(def.getCertValues(), json.getCertValues());
    }

    @Test
    public void testCopyTrustOptions() throws Exception {
        PemTrustOptions options = new PemTrustOptions(new JsonObject());
        String certPath = TestUtils.randomAlphaString(100);
        Buffer certValue = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        options.addCertPath(certPath);
        options.addCertValue(certValue);
        options = new PemTrustOptions(options);
        this.assertEquals(Collections.singletonList(certPath), options.getCertPaths());
        this.assertEquals(Collections.singletonList(certValue), options.getCertValues());
        options = new PemTrustOptions(options.toJson());
        this.assertEquals(Collections.singletonList(certPath), options.getCertPaths());
        this.assertEquals(Collections.singletonList(certValue), options.getCertValues());
    }

    @Test
    public void testTrustOptionsEquality() {
        String certPath1 = TestUtils.randomAlphaString(100);
        String certPath2 = TestUtils.randomAlphaString(100);
        Buffer certValue1 = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        Buffer certValue2 = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        PemTrustOptions options = new PemTrustOptions();
        PemTrustOptions otherOptions = new PemTrustOptions();
        this.assertEquals(options, otherOptions);
        this.assertEquals(options.hashCode(), otherOptions.hashCode());
        options.addCertPath(certPath1);
        options.addCertPath(certPath2);
        options.addCertValue(certValue1);
        options.addCertValue(certValue2);
        otherOptions.addCertPath(certPath1);
        otherOptions.addCertPath(certPath2);
        otherOptions.addCertValue(certValue1);
        otherOptions.addCertValue(certValue2);
        this.assertEquals(options, otherOptions);
        this.assertEquals(options.hashCode(), otherOptions.hashCode());
        otherOptions.addCertPath(TestUtils.randomAlphaString(100));
        Assert.assertNotEquals((Object)options, (Object)otherOptions);
        PemTrustOptions reverseOrderOptions = new PemTrustOptions();
        reverseOrderOptions.addCertPath(certPath2);
        reverseOrderOptions.addCertPath(certPath1);
        reverseOrderOptions.addCertValue(certValue2);
        reverseOrderOptions.addCertValue(certValue1);
        Assert.assertNotEquals((Object)options, (Object)reverseOrderOptions);
    }

    @Test
    public void testJKSPath() throws Exception {
        this.testKeyStore(((JksOptions)Cert.SERVER_JKS.get()).getHelper(this.vertx));
    }

    @Test
    public void testJKSValue() throws Exception {
        JksOptions options = (JksOptions)Cert.SERVER_JKS.get();
        Buffer store = this.vertx.fileSystem().readFileBlocking(options.getPath());
        options.setPath(null).setValue(store);
        this.testKeyStore(options.getHelper(this.vertx));
    }

    @Test
    public void testKeyStoreValue() throws Exception {
        JksOptions jks = (JksOptions)Cert.SERVER_JKS.get();
        KeyStoreOptions options = new KeyStoreOptions();
        KeyStore ks = KeyStore.getInstance("JKS");
        options.setType("JKS");
        options.setProvider(ks.getProvider().getName());
        Buffer store = this.vertx.fileSystem().readFileBlocking(jks.getPath());
        options.setPath(null).setValue(store).setPassword(jks.getPassword());
        this.testKeyStore(options.getHelper(this.vertx));
    }

    @Test
    public void testPKCS12Path() throws Exception {
        this.testKeyStore(((PfxOptions)Cert.SERVER_PKCS12.get()).getHelper(this.vertx));
    }

    @Test
    public void testPKCS12Value() throws Exception {
        PfxOptions options = (PfxOptions)Cert.SERVER_PKCS12.get();
        Buffer store = this.vertx.fileSystem().readFileBlocking(options.getPath());
        options.setPath(null).setValue(store);
        this.testKeyStore(options.getHelper(this.vertx));
    }

    @Test
    public void testKeyCertPath() throws Exception {
        this.testKeyStore(((PemKeyCertOptions)Cert.SERVER_PEM.get()).getHelper(this.vertx));
    }

    @Test
    public void testRsaKeyCertPath() throws Exception {
        this.testKeyStore(((PemKeyCertOptions)Cert.SERVER_PEM_RSA.get()).getHelper(this.vertx));
    }

    @Test
    public void testKeyCertValue() throws Exception {
        PemKeyCertOptions options = (PemKeyCertOptions)Cert.SERVER_PEM.get();
        Buffer key = this.vertx.fileSystem().readFileBlocking(options.getKeyPath());
        options.setKeyValue(null).setKeyValue(key);
        Buffer cert = this.vertx.fileSystem().readFileBlocking(options.getCertPath());
        options.setCertValue(null).setCertValue(cert);
        this.testKeyStore(options.getHelper(this.vertx));
    }

    @Test
    public void testCaPath() throws Exception {
        this.testTrustStore(((PemTrustOptions)Trust.SERVER_PEM.get()).getHelper(this.vertx));
    }

    @Test
    public void testCaPathValue() throws Exception {
        PemTrustOptions options = (PemTrustOptions)Trust.SERVER_PEM.get();
        options.getCertPaths().stream().map(arg_0 -> ((FileSystem)this.vertx.fileSystem()).readFileBlocking(arg_0)).forEach(arg_0 -> ((PemTrustOptions)options).addCertValue(arg_0));
        options.getCertPaths().clear();
        this.testTrustStore(options.getHelper(this.vertx));
    }

    @Test
    public void testKeyOptionsEquality() {
        JksOptions jksOptions = (JksOptions)Cert.SERVER_JKS.get();
        JksOptions jksOptionsCopy = new JksOptions(jksOptions);
        PfxOptions pfxOptions = (PfxOptions)Cert.SERVER_PKCS12.get();
        PfxOptions pfxOptionsCopy = new PfxOptions(pfxOptions);
        PemKeyCertOptions pemKeyCertOptions = (PemKeyCertOptions)Cert.SERVER_PEM.get();
        PemKeyCertOptions pemKeyCertOptionsCopy = new PemKeyCertOptions(pemKeyCertOptions);
        this.assertEquals(jksOptions, jksOptionsCopy);
        this.assertEquals(jksOptions.hashCode(), jksOptionsCopy.hashCode());
        this.assertEquals(pfxOptions, pfxOptionsCopy);
        this.assertEquals(pfxOptions.hashCode(), pfxOptionsCopy.hashCode());
        this.assertEquals(pemKeyCertOptions, pemKeyCertOptionsCopy);
        this.assertEquals(pemKeyCertOptions.hashCode(), pemKeyCertOptionsCopy.hashCode());
    }

    private void testKeyStore(KeyStoreHelper helper) throws Exception {
        KeyStore keyStore = helper.store();
        Enumeration<String> aliases = keyStore.aliases();
        this.assertTrue(aliases.hasMoreElements());
        KeyManager[] keyManagers = helper.getKeyMgr();
        this.assertTrue(keyManagers.length > 0);
    }

    private void testTrustStore(KeyStoreHelper helper) throws Exception {
        TrustManager[] keyManagers = helper.getTrustMgrs((VertxInternal)this.vertx);
        this.assertTrue(keyManagers.length > 0);
    }
}

