/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.junit.Test;

public abstract class AsyncMapTest
extends VertxTestBase {
    protected abstract Vertx getVertx();

    @Test
    public void testMapPutGetByte() {
        this.testMapPutGet((byte)1, (byte)2);
    }

    @Test
    public void testMapPutGetShort() {
        this.testMapPutGet((short)1, (short)2);
    }

    @Test
    public void testMapPutGetInt() {
        this.testMapPutGet(1, 2);
    }

    @Test
    public void testMapPutGetLong() {
        this.testMapPutGet(1L, 2L);
    }

    @Test
    public void testMapPutGetChar() {
        this.testMapPutGet(Character.valueOf('X'), Character.valueOf('Y'));
    }

    @Test
    public void testMapPutGetFloat() {
        this.testMapPutGet(Float.valueOf(1.2f), Float.valueOf(2.2f));
    }

    @Test
    public void testMapPutGetBuffer() {
        this.testMapPutGet(TestUtils.randomBuffer(4), TestUtils.randomBuffer(12));
    }

    @Test
    public void testMapPutGetDouble() {
        this.testMapPutGet(1.2, 2.2);
    }

    @Test
    public void testMapPutGetBoolean() {
        this.testMapPutGet("foo", true);
    }

    @Test
    public void testMapPutGetString() {
        this.testMapPutGet("foo", "bar");
    }

    @Test
    public void testMapPutGetJsonObject() {
        this.testMapPutGet(new JsonObject().put("foo", "bar"), new JsonObject().put("uihwqduh", "qiwiojw"));
    }

    @Test
    public void testMapPutGetJsonArray() {
        this.testMapPutGet(new JsonArray().add("foo").add(Integer.valueOf(2)), new JsonArray().add("uihwqduh").add(Boolean.valueOf(false)));
    }

    @Test
    public void testMapPutGetSerializableObject() {
        this.testMapPutGet(new SomeSerializableObject("bar"), new SomeSerializableObject("bar"));
    }

    @Test
    public void testMapPutGetClusterSerializableObject() {
        this.testMapPutGet(new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("bar"));
    }

    @Test
    public void testMapPutTtl() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.put((Object)"pipo", (Object)"molo", 10L, this.onSuccess(vd -> this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map2 -> this.assertWaitUntil((AsyncMap<String, String>)map2, "pipo", 15L, Objects::isNull)))))));
        this.await();
    }

    private void assertWaitUntil(AsyncMap<String, String> map, String key, long delay, Function<String, Boolean> checks) {
        this.vertx.setTimer(delay, l -> map.get((Object)key, this.onSuccess(value -> {
            if (((Boolean)checks.apply((String)value)).booleanValue()) {
                this.testComplete();
            } else {
                this.assertWaitUntil(map, key, delay, checks);
            }
        })));
    }

    @Test
    public void testMapPutTtlThenPut() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.put((Object)"pipo", (Object)"molo", 10L, this.onSuccess(vd -> map.put((Object)"pipo", (Object)"mili", this.onSuccess(vd2 -> this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map2 -> this.assertWaitUntil((AsyncMap<String, String>)map2, "pipo", 20L, s -> "mili".equals(s))))))))));
        this.await();
    }

    @Test
    public void testMapPutIfAbsentGetByte() {
        this.testMapPutIfAbsentGet((byte)1, (byte)2);
    }

    @Test
    public void testMapPutIfAbsentGetShort() {
        this.testMapPutIfAbsentGet((short)1, (short)2);
    }

    @Test
    public void testMapPutIfAbsentGetInt() {
        this.testMapPutIfAbsentGet(1, 2);
    }

    @Test
    public void testMapPutIfAbsentGetLong() {
        this.testMapPutIfAbsentGet(1L, 2L);
    }

    @Test
    public void testMapPutIfAbsentGetChar() {
        this.testMapPutIfAbsentGet(Character.valueOf('X'), Character.valueOf('Y'));
    }

    @Test
    public void testMapPutIfAbsentGetFloat() {
        this.testMapPutIfAbsentGet(Float.valueOf(1.2f), Float.valueOf(2.2f));
    }

    @Test
    public void testMapPutIfAbsentGetBuffer() {
        this.testMapPutIfAbsentGet(TestUtils.randomBuffer(4), TestUtils.randomBuffer(12));
    }

    @Test
    public void testMapPutIfAbsentGetDouble() {
        this.testMapPutIfAbsentGet(1.2, 2.2);
    }

    @Test
    public void testMapPutIfAbsentGetBoolean() {
        this.testMapPutIfAbsentGet("foo", true);
    }

    @Test
    public void testMapPutIfAbsentGetString() {
        this.testMapPutIfAbsentGet("foo", "bar");
    }

    @Test
    public void testMapPutIfAbsentGetJsonObject() {
        this.testMapPutIfAbsentGet(new JsonObject().put("foo", "bar"), new JsonObject().put("uihwqduh", "qiwiojw"));
    }

    @Test
    public void testMapPutIfAbsentGetJsonArray() {
        this.testMapPutIfAbsentGet(new JsonArray().add("foo").add(Integer.valueOf(2)), new JsonArray().add("uihwqduh").add(Boolean.valueOf(false)));
    }

    @Test
    public void testMapPutIfAbsentGetSerializableObject() {
        this.testMapPutIfAbsentGet(new SomeSerializableObject("bar"), new SomeSerializableObject("bar"));
    }

    @Test
    public void testMapPutIfAbsentGetClusterSerializableObject() {
        this.testMapPutIfAbsentGet(new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("bar"));
    }

    @Test
    public void testMapPutIfAbsentTtl() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.putIfAbsent((Object)"pipo", (Object)"molo", 10L, this.onSuccess(vd -> {
            this.assertNull(vd);
            this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map2 -> this.assertWaitUntil((AsyncMap<String, String>)map2, "pipo", 15L, Objects::isNull)));
        }))));
        this.await();
    }

    @Test
    public void testMapRemoveByte() {
        this.testMapRemove((byte)1, (byte)2);
    }

    @Test
    public void testMapRemoveShort() {
        this.testMapRemove((short)1, (short)2);
    }

    @Test
    public void testMapRemoveInt() {
        this.testMapRemove(1, 2);
    }

    @Test
    public void testMapRemoveLong() {
        this.testMapRemove(1L, 2L);
    }

    @Test
    public void testMapRemoveChar() {
        this.testMapRemove(Character.valueOf('X'), Character.valueOf('Y'));
    }

    @Test
    public void testMapRemoveFloat() {
        this.testMapRemove(Float.valueOf(1.2f), Float.valueOf(2.2f));
    }

    @Test
    public void testMapRemoveBuffer() {
        this.testMapRemove(TestUtils.randomBuffer(4), TestUtils.randomBuffer(12));
    }

    @Test
    public void testMapRemoveDouble() {
        this.testMapRemove(1.2, 2.2);
    }

    @Test
    public void testMapRemoveBoolean() {
        this.testMapRemove("foo", true);
    }

    @Test
    public void testMapRemoveString() {
        this.testMapRemove("foo", "bar");
    }

    @Test
    public void testMapRemoveJsonObject() {
        this.testMapRemove(new JsonObject().put("foo", "bar"), new JsonObject().put("uihwqduh", "qiwiojw"));
    }

    @Test
    public void testMapRemoveJsonArray() {
        this.testMapRemove(new JsonArray().add("foo").add(Integer.valueOf(2)), new JsonArray().add("uihwqduh").add(Boolean.valueOf(false)));
    }

    @Test
    public void testMapRemoveSerializableObject() {
        this.testMapRemove(new SomeSerializableObject("bar"), new SomeSerializableObject("bar"));
    }

    @Test
    public void testMapRemoveClusterSerializableObject() {
        this.testMapRemove(new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("bar"));
    }

    @Test
    public void testMapRemoveIfPresentByte() {
        this.testMapRemoveIfPresent((byte)1, (byte)2, (byte)3, (byte)4);
    }

    @Test
    public void testMapRemoveIfPresentShort() {
        this.testMapRemoveIfPresent((short)1, (short)2, (short)3, (short)4);
    }

    @Test
    public void testMapRemoveIfPresentInt() {
        this.testMapRemoveIfPresent(1, 2, 3, 4);
    }

    @Test
    public void testMapRemoveIfPresentLong() {
        this.testMapRemoveIfPresent(1L, 2L, 3L, 4L);
    }

    @Test
    public void testMapRemoveIfPresentChar() {
        this.testMapRemoveIfPresent(Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));
    }

    @Test
    public void testMapRemoveIfPresentFloat() {
        this.testMapRemoveIfPresent(Float.valueOf(1.2f), Float.valueOf(2.2f), Float.valueOf(3.2f), Float.valueOf(4.2f));
    }

    @Test
    public void testMapRemoveIfPresentBuffer() {
        this.testMapRemoveIfPresent(TestUtils.randomBuffer(4), TestUtils.randomBuffer(4), TestUtils.randomBuffer(12), TestUtils.randomBuffer(14));
    }

    @Test
    public void testMapRemoveIfPresentDouble() {
        this.testMapRemoveIfPresent(1.2, 2.2, 3.2, 4.2);
    }

    @Test
    public void testMapRemoveIfPresentBoolean() {
        this.testMapRemoveIfPresent("foo", "bar", true, false);
    }

    @Test
    public void testMapRemoveIfPresentString() {
        this.testMapRemoveIfPresent("foo", "bar", "baz", "quux");
    }

    @Test
    public void testMapRemoveIfPresentJsonObject() {
        this.testMapRemoveIfPresent(new JsonObject().put("foo", "bar"), new JsonObject().put("baz", "quux"), new JsonObject().put("uihwqduh", "qiwiojw"), new JsonObject().put("regerg", "wfwef"));
    }

    @Test
    public void testMapRemoveIfPresentJsonArray() {
        this.testMapRemoveIfPresent(new JsonArray().add("foo").add(Integer.valueOf(2)), new JsonArray().add("bar").add(Integer.valueOf(4)), new JsonArray().add("uihwqduh").add(Boolean.valueOf(false)), new JsonArray().add("qqddq").add(Boolean.valueOf(true)));
    }

    @Test
    public void testMapRemoveIfPresentSerializableObject() {
        this.testMapRemoveIfPresent(new SomeSerializableObject("foo"), new SomeSerializableObject("bar"), new SomeSerializableObject("baz"), new SomeSerializableObject("quux"));
    }

    @Test
    public void testMapRemoveIfPresentClusterSerializableObject() {
        this.testMapRemoveIfPresent(new SomeClusterSerializableObject("foo"), new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("baz"), new SomeClusterSerializableObject("quux"));
    }

    @Test
    public void testMapReplaceByte() {
        this.testMapReplace((byte)1, (byte)2, (byte)3);
    }

    @Test
    public void testMapReplaceShort() {
        this.testMapReplace((short)1, (short)2, (short)3);
    }

    @Test
    public void testMapReplaceInt() {
        this.testMapReplace(1, 2, 3);
    }

    @Test
    public void testMapReplaceLong() {
        this.testMapReplace(1L, 2L, 3L);
    }

    @Test
    public void testMapReplaceChar() {
        this.testMapReplace(Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));
    }

    @Test
    public void testMapReplaceFloat() {
        this.testMapReplace(Float.valueOf(1.2f), Float.valueOf(2.2f), Float.valueOf(3.3f));
    }

    @Test
    public void testMapReplaceBuffer() {
        this.testMapReplace(TestUtils.randomBuffer(4), TestUtils.randomBuffer(12), TestUtils.randomBuffer(14));
    }

    @Test
    public void testMapReplaceDouble() {
        this.testMapReplace(1.2, 2.2, 3.3);
    }

    @Test
    public void testMapReplaceBoolean() {
        this.testMapReplace("foo", true, false);
    }

    @Test
    public void testMapReplaceString() {
        this.testMapReplace("foo", "bar", "quux");
    }

    @Test
    public void testMapReplaceJsonObject() {
        this.testMapReplace(new JsonObject().put("foo", "bar"), new JsonObject().put("uihwqduh", "qiwiojw"), new JsonObject().put("regerg", "wfwef"));
    }

    @Test
    public void testMapReplaceJsonArray() {
        this.testMapReplace(new JsonArray().add("foo").add(Integer.valueOf(2)), new JsonArray().add("uihwqduh").add(Boolean.valueOf(false)), new JsonArray().add("qqddq").add(Boolean.valueOf(true)));
    }

    @Test
    public void testMapReplaceSerializableObject() {
        this.testMapReplace(new SomeSerializableObject("foo"), new SomeSerializableObject("bar"), new SomeSerializableObject("quux"));
    }

    @Test
    public void testMapReplaceClusterSerializableObject() {
        this.testMapReplace(new SomeClusterSerializableObject("foo"), new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("quux"));
    }

    @Test
    public void testMapReplaceIfPresentByte() {
        this.testMapReplaceIfPresent((byte)1, (byte)2, (byte)3);
    }

    @Test
    public void testMapReplaceIfPresentShort() {
        this.testMapReplaceIfPresent((short)1, (short)2, (short)3);
    }

    @Test
    public void testMapReplaceIfPresentInt() {
        this.testMapReplaceIfPresent(1, 2, 3);
    }

    @Test
    public void testMapReplaceIfPresentLong() {
        this.testMapReplaceIfPresent(1L, 2L, 3L);
    }

    @Test
    public void testMapReplaceIfPresentChar() {
        this.testMapReplaceIfPresent(Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));
    }

    @Test
    public void testMapReplaceIfPresentFloat() {
        this.testMapReplaceIfPresent(Float.valueOf(1.2f), Float.valueOf(2.2f), Float.valueOf(3.3f));
    }

    @Test
    public void testMapReplaceIfPresentBuffer() {
        this.testMapReplaceIfPresent(TestUtils.randomBuffer(4), TestUtils.randomBuffer(12), TestUtils.randomBuffer(14));
    }

    @Test
    public void testMapReplaceIfPresentDouble() {
        this.testMapReplaceIfPresent(1.2, 2.2, 3.3);
    }

    @Test
    public void testMapReplaceIfPresentBoolean() {
        this.testMapReplaceIfPresent("foo", true, false);
    }

    @Test
    public void testMapReplaceIfPresentString() {
        this.testMapReplaceIfPresent("foo", "bar", "quux");
    }

    @Test
    public void testMapReplaceIfPresentJsonObject() {
        this.testMapReplaceIfPresent(new JsonObject().put("foo", "bar"), new JsonObject().put("uihwqduh", "qiwiojw"), new JsonObject().put("regerg", "wfwef"));
    }

    @Test
    public void testMapReplaceIfPresentJsonArray() {
        this.testMapReplaceIfPresent(new JsonArray().add("foo").add(Integer.valueOf(2)), new JsonArray().add("uihwqduh").add(Boolean.valueOf(false)), new JsonArray().add("qqddq").add(Boolean.valueOf(true)));
    }

    @Test
    public void testMapReplaceIfPresentSerializableObject() {
        this.testMapReplaceIfPresent(new SomeSerializableObject("foo"), new SomeSerializableObject("bar"), new SomeSerializableObject("quux"));
    }

    @Test
    public void testMapReplaceIfPresentClusterSerializableObject() {
        this.testMapReplaceIfPresent(new SomeClusterSerializableObject("foo"), new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("quux"));
    }

    @Test
    public void testGetMapWithNullName() throws Exception {
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getAsyncMap(null, ar -> {}));
    }

    @Test
    public void testGetMapWithNullResultHandler() throws Exception {
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getAsyncMap("foo", null));
    }

    @Test
    public void testPutNullKey() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.put(null, (Object)"foo", ar2 -> {}));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPutNullValue() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.put((Object)"foo", null, ar2 -> {}));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPutInvalidKey() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.put((Object)new SomeObject(), (Object)"foo", ar2 -> {}));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPutInvalidValue() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.put((Object)"foo", (Object)new SomeObject(), ar2 -> {}));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPutIfAbsentInvalidKey() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.putIfAbsent((Object)new SomeObject(), (Object)"foo", ar2 -> {}));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPutIfAbsentInvalidValue() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.putIfAbsent((Object)"foo", (Object)new SomeObject(), ar2 -> {}));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMultipleMaps() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.put((Object)"foo", (Object)"bar", this.onSuccess(v -> this.getVertx().sharedData().getAsyncMap("bar", this.onSuccess(map2 -> map2.get((Object)"foo", this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }))))))));
        this.await();
    }

    @Test
    public void testClear() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.put((Object)"foo", (Object)"bar", this.onSuccess(v -> this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map2 -> map2.clear(this.onSuccess(v2 -> map.get((Object)"foo", this.onSuccess(res -> {
            this.assertNull(res);
            this.testComplete();
        }))))))))));
        this.await();
    }

    @Test
    public void testSize() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.size(this.onSuccess(size -> {
            this.assertEquals(0L, size.intValue());
            map.put((Object)"foo", (Object)"bar", this.onSuccess(v -> map.size(this.onSuccess(size2 -> {
                this.assertEquals(1L, size2.intValue());
                this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map2 -> map2.size(this.onSuccess(size3 -> {
                    this.assertEquals(1L, size3.intValue());
                    this.testComplete();
                }))));
            }))));
        }))));
        this.await();
    }

    @Test
    public void testKeys() {
        Map<JsonObject, Buffer> map = this.genJsonToBuffer(100);
        this.loadData(map, (vertx, asyncMap) -> asyncMap.keys(this.onSuccess(keys -> {
            this.assertEquals(map.keySet(), keys);
            this.testComplete();
        })));
        this.await();
    }

    @Test
    public void testValues() {
        Map<JsonObject, Buffer> map = this.genJsonToBuffer(100);
        this.loadData(map, (vertx, asyncMap) -> asyncMap.values(this.onSuccess(values -> {
            this.assertEquals(map.values().size(), values.size());
            this.assertTrue(map.values().containsAll((Collection<?>)values));
            this.assertTrue(values.containsAll(map.values()));
            this.testComplete();
        })));
        this.await();
    }

    @Test
    public void testEntries() {
        Map<JsonObject, Buffer> map = this.genJsonToBuffer(100);
        this.loadData(map, (vertx, asyncMap) -> asyncMap.entries(this.onSuccess(res -> {
            this.assertEquals(map.entrySet(), res.entrySet());
            this.testComplete();
        })));
        this.await();
    }

    protected Map<JsonObject, Buffer> genJsonToBuffer(int size) {
        HashMap<JsonObject, Buffer> map = new HashMap<JsonObject, Buffer>();
        for (int i = 0; i < size; ++i) {
            JsonObject key = new JsonObject().put("key", Integer.valueOf(i));
            map.put(key, key.toBuffer());
        }
        return map;
    }

    protected void loadData(Map<JsonObject, Buffer> map, BiConsumer<Vertx, AsyncMap<JsonObject, Buffer>> test) {
        ArrayList futures = new ArrayList(map.size());
        map.forEach((key, value) -> {
            Promise future = Promise.promise();
            this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(asyncMap -> asyncMap.put(key, value, (Handler)future)));
            futures.add(future.future());
        });
        CompositeFuture.all(futures).onComplete(this.onSuccess(cf -> {
            Vertx v = this.getVertx();
            v.sharedData().getAsyncMap("foo", this.onSuccess(asyncMap -> test.accept(v, (AsyncMap<JsonObject, Buffer>)asyncMap)));
        }));
    }

    private <K, V> void testMapPutGet(K k, V v) {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.put(k, v, this.onSuccess(vd -> this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map2 -> map2.get(k, this.onSuccess(res -> {
            this.assertEquals(v, res);
            this.testComplete();
        }))))))));
        this.await();
    }

    private <K, V> void testMapPutIfAbsentGet(K k, V v) {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.putIfAbsent(k, v, this.onSuccess(res -> {
            this.assertNull(res);
            this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map2 -> map2.get(k, this.onSuccess(res2 -> {
                this.assertEquals(v, res2);
                map.putIfAbsent(k, v, this.onSuccess(res3 -> {
                    this.assertEquals(v, res3);
                    this.testComplete();
                }));
            }))));
        }))));
        this.await();
    }

    private <K, V> void testMapRemove(K k, V v) {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.put(k, v, this.onSuccess(res -> {
            this.assertNull(res);
            this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map2 -> map2.remove(k, this.onSuccess(res2 -> {
                this.assertEquals(v, res2);
                this.testComplete();
            }))));
        }))));
        this.await();
    }

    private <K, V> void testMapRemoveIfPresent(K k, K otherKey, V v, V otherValue) {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.put(k, v, this.onSuccess(res -> {
            this.assertNull(res);
            this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map2 -> map2.removeIfPresent(otherKey, v, this.onSuccess(res2 -> {
                this.assertFalse((boolean)res2);
                map2.removeIfPresent(k, otherValue, this.onSuccess(res3 -> {
                    this.assertFalse((boolean)res3);
                    map2.removeIfPresent(k, v, this.onSuccess(res4 -> {
                        this.assertTrue((boolean)res4);
                        this.testComplete();
                    }));
                }));
            }))));
        }))));
        this.await();
    }

    private <K, V> void testMapReplace(K k, V v, V other) {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.put(k, v, this.onSuccess(res -> {
            this.assertNull(res);
            this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map2 -> map2.replace(k, other, this.onSuccess(res2 -> {
                this.assertEquals(v, res2);
                map2.get(k, this.onSuccess(res3 -> {
                    this.assertEquals(other, res3);
                    map2.remove(k, this.onSuccess(res4 -> map2.replace(k, other, this.onSuccess(res5 -> {
                        this.assertNull(res5);
                        map2.get(k, this.onSuccess(res6 -> {
                            this.assertNull(res6);
                            this.testComplete();
                        }));
                    }))));
                }));
            }))));
        }))));
        this.await();
    }

    private <K, V> void testMapReplaceIfPresent(K k, V v, V other) {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.put(k, v, this.onSuccess(res -> {
            this.assertNull(res);
            this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map2 -> map2.replaceIfPresent(k, v, other, this.onSuccess(res2 -> map2.replaceIfPresent(k, v, other, this.onSuccess(res3 -> {
                this.assertFalse((boolean)res3);
                map2.get(k, this.onSuccess(res4 -> {
                    this.assertEquals(other, res4);
                    this.testComplete();
                }));
            }))))));
        }))));
        this.await();
    }

    public static final class SomeClusterSerializableObject
    implements ClusterSerializable {
        private String str;

        public SomeClusterSerializableObject() {
        }

        public SomeClusterSerializableObject(String str) {
            this.str = str;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SomeClusterSerializableObject)) {
                return false;
            }
            SomeClusterSerializableObject that = (SomeClusterSerializableObject)o;
            return !(this.str != null ? !this.str.equals(that.str) : that.str != null);
        }

        public int hashCode() {
            return this.str != null ? this.str.hashCode() : 0;
        }

        public void writeToBuffer(Buffer buffer) {
            buffer.appendInt(this.str.length());
            buffer.appendString(this.str);
        }

        public int readFromBuffer(int pos, Buffer buffer) {
            int length = buffer.getInt(pos);
            this.str = buffer.getString(pos + 4, pos + 4 + length);
            return pos + 4 + length;
        }
    }

    public static final class SomeSerializableObject
    implements Serializable {
        private String str;
        private final Object object = new Object();

        public SomeSerializableObject(String str) {
            this.str = str;
        }

        public SomeSerializableObject() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SomeSerializableObject)) {
                return false;
            }
            SomeSerializableObject that = (SomeSerializableObject)o;
            return !(this.str != null ? !this.str.equals(that.str) : that.str != null);
        }

        public int hashCode() {
            return this.str != null ? this.str.hashCode() : 0;
        }
    }

    public static final class SomeObject {
    }
}

