/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.executor;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.spi.executor.ExternalLoadableExecutorServiceFactory;
import io.vertx.core.spi.executor.Utils;
import io.vertx.test.core.BlockedThreadWarning;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class ExecutorFactoryOptionsTest
extends VertxTestBase {
    private static final Class<ExternalLoadableExecutorServiceFactory> FACTORY = ExternalLoadableExecutorServiceFactory.class;
    private static final String EXECUTOR = FACTORY.getSimpleName() + "$1";
    @ClassRule
    public static TestRule chain = Utils.setupAndCheckSpiImpl(FACTORY, EXECUTOR, Utils.EXECUTE, Utils.SHUTDOWN_NOW);
    @Rule
    public BlockedThreadWarning blockedThreadWarning = new BlockedThreadWarning();

    @Test
    public void testSpiDeployOptionsDefaultWorkerPoolName() {
        DeploymentOptions options = new DeploymentOptions();
        final String poolName = "spiExecutorTest";
        options.setWorkerPoolName(poolName);
        AbstractVerticle v = new AbstractVerticle(){

            public void start(Promise<Void> resultHandler) throws Exception {
                this.vertx.executeBlocking(finished -> {
                    Assert.assertTrue((boolean)Thread.currentThread().getName().contains(poolName));
                    finished.complete();
                }, resultHandler);
            }
        };
        this.vertx.deployVerticle((Verticle)v, options, this.onSuccess(did -> this.testComplete()));
        this.await();
    }

    @Test
    public void testSpiSpecificWorkerPoolName() {
        String specific = "namedPool";
        WorkerExecutor es = this.vertx.createSharedWorkerExecutor(specific);
        es.executeBlocking(fut -> {
            Assert.assertTrue((boolean)Thread.currentThread().getName().contains(specific));
            fut.complete(null);
        }, false, ar -> this.complete());
        this.await();
    }

    @Test
    public void testVerticleDeploymentOptionsMaxTimeSoft() {
        DeploymentOptions options = new DeploymentOptions();
        options.setMaxWorkerExecuteTime(2L).setMaxWorkerExecuteTimeUnit(TimeUnit.SECONDS);
        String poolName = "testDeploymentMaxTimeSoft";
        options.setWorkerPoolName(poolName);
        AbstractVerticle sleep = new AbstractVerticle(){

            public void start(Promise<Void> resultHandler) throws Exception {
                this.vertx.executeBlocking(finished -> {
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                        finished.complete();
                    }
                    catch (InterruptedException e) {
                        finished.fail((Throwable)e);
                    }
                }, resultHandler);
            }
        };
        this.vertx.deployVerticle((Verticle)sleep, options, this.onSuccess(did -> this.testComplete()));
        this.await();
        this.blockedThreadWarning.expectMessage(poolName, 2000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testVertxOptionsMaxTimeSoft() {
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setMaxWorkerExecuteTime(100L);
        vertxOptions.setMaxWorkerExecuteTimeUnit(TimeUnit.MILLISECONDS);
        vertxOptions.setBlockedThreadCheckInterval(100L);
        vertxOptions.setBlockedThreadCheckIntervalUnit(TimeUnit.MILLISECONDS);
        Vertx newVertx = this.vertx(vertxOptions);
        Thread mainThread = Thread.currentThread();
        newVertx.executeBlocking(fut -> {
            Thread current = Thread.currentThread();
            this.assertNotSame(mainThread, current);
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
                fut.complete();
            }
            catch (InterruptedException e) {
                fut.fail((Throwable)e);
            }
        }, true, this.onSuccess(v -> this.complete()));
        this.await();
        this.blockedThreadWarning.expectMessage("vert.x-worker-thread", 100L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testMaxExecuteWorkerTime() throws Exception {
        String poolName = TestUtils.randomAlphaString(10);
        long maxWorkerExecuteTime = TimeUnit.NANOSECONDS.convert(3L, TimeUnit.SECONDS);
        DeploymentOptions deploymentOptions = new DeploymentOptions().setWorkerPoolName(poolName).setMaxWorkerExecuteTime(maxWorkerExecuteTime);
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start(Promise<Void> startFuture) throws Exception {
                this.vertx.executeBlocking(fut -> {
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                        fut.complete();
                    }
                    catch (InterruptedException e) {
                        fut.fail((Throwable)e);
                    }
                }, startFuture);
            }
        }, deploymentOptions, this.onSuccess(did -> this.testComplete()));
        this.await();
        this.blockedThreadWarning.expectMessage(poolName, maxWorkerExecuteTime, TimeUnit.NANOSECONDS);
    }
}

