/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.executor;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.executor.ExecutorServiceFactory;
import io.vertx.test.core.LogContainsRule;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceFactory.class);
    static final String SERVICES_SRC_DIR = "src/test/classpath/servicehelper/META-INF/services/";
    static final String TEST_CLASSPATH = "target/test-classes/";
    static final String SERVICE_LOADER_SUFFIX = "META-INF/services/";
    static final String SERVICE = "io.vertx.core.spi.executor.ExecutorServiceFactory";
    static final String SERVICE_CFG_FILE = "target/test-classes/META-INF/services/io.vertx.core.spi.executor.ExecutorServiceFactory";
    static final String TESTS_PACKAGE = Utils.class.getPackage().getName();
    static Method EXECUTE;
    static Method SHUTDOWN_NOW;

    static LogContainsRule executorMethodLogged(String executor, String method) {
        return new LogContainsRule(ExecutorServiceFactory.class, Level.ALL, TESTS_PACKAGE + "." + executor + "::" + method);
    }

    public static TestRule setupAndCheckSpiImpl(Class factory, String executor, Method ... meth) {
        RuleChain chain = RuleChain.emptyRuleChain();
        for (Method method : meth) {
            Assert.assertNotNull((Object)method);
            LogContainsRule rule = Utils.executorMethodLogged(executor, method.getName());
            chain = chain.around((TestRule)rule);
        }
        chain = chain.around((TestRule)new SpiPopulator(factory));
        return chain;
    }

    static {
        try {
            EXECUTE = ExecutorService.class.getMethod("execute", Runnable.class);
            SHUTDOWN_NOW = ExecutorService.class.getMethod("shutdownNow", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            EXECUTE = null;
            SHUTDOWN_NOW = null;
        }
    }

    static class SpiPopulator
    extends ExternalResource {
        private final Class factory;

        SpiPopulator(Class factory) {
            this.factory = factory;
        }

        protected void before() throws Throwable {
            File source = new File(Utils.SERVICES_SRC_DIR + this.factory.getSimpleName());
            File out = new File(Utils.SERVICE_CFG_FILE);
            out.getParentFile().mkdirs();
            Files.deleteIfExists(out.toPath());
            Files.copy(source.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            log.debug((Object)("Placed " + this.factory + " as service loadable for " + Utils.SERVICE));
        }

        protected void after() {
            new File(Utils.SERVICE_CFG_FILE).delete();
        }
    }
}

