/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.test.core.LogContainsRule;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class BlockedThreadWarning
extends LogContainsRule {
    private String poolName;
    private long maxExecuteTime;
    private TimeUnit maxExecuteTimeUnit;

    public BlockedThreadWarning() {
        this.logger = Logger.getLogger(BlockedThreadChecker.class.getName());
    }

    public synchronized void expectMessage(String poolName, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        this.poolName = poolName;
        this.maxExecuteTime = maxExecuteTime;
        this.maxExecuteTimeUnit = maxExecuteTimeUnit;
        this.doTest = true;
        this.matchers = null;
    }

    @Override
    public Matcher[] constructMatchers() {
        Matcher blocked = CoreMatchers.containsString((String)" has been blocked for ");
        Matcher timeLimit = CoreMatchers.containsString((String)(" time limit is " + this.maxExecuteTimeUnit.toMillis(this.maxExecuteTime) + " ms"));
        Matcher pool = CoreMatchers.containsString((String)("Thread[" + this.poolName + "-"));
        return new Matcher[]{blocked, timeLimit, pool};
    }
}

