/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LogContainsRule
implements TestRule {
    protected Logger logger;
    protected Level level;
    protected String[] msgsRequired;
    protected boolean doTest;
    protected Matcher<String>[] matchers = null;
    private List<String> logStrings = new ArrayList<String>();

    public LogContainsRule() {
    }

    public LogContainsRule(Class loggingClass, Level level, String ... logMustContain) {
        this.logger = Logger.getLogger(loggingClass.getName());
        this.level = level;
        this.msgsRequired = logMustContain;
        this.doTest = true;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                LogContainsRule logContainsRule = LogContainsRule.this;
                synchronized (logContainsRule) {
                    LogContainsRule.this.logStrings.clear();
                    if (LogContainsRule.this.level != null) {
                        LogContainsRule.this.logger.setLevel(LogContainsRule.this.level);
                    }
                }
                Handler handler = new Handler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void publish(LogRecord record) {
                        LogContainsRule logContainsRule = LogContainsRule.this;
                        synchronized (logContainsRule) {
                            LogContainsRule.this.logStrings.add(record.getMessage());
                        }
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void close() throws SecurityException {
                    }
                };
                LogContainsRule.this.logger.addHandler(handler);
                try {
                    base.evaluate();
                    LogContainsRule.this.doTest();
                }
                finally {
                    LogContainsRule.this.logger.removeHandler(handler);
                }
            }
        };
    }

    private synchronized void doTest() {
        if (!this.doTest) {
            return;
        }
        if (this.matchers == null) {
            this.matchers = this.constructMatchers();
        }
        Assert.assertThat(this.logStrings, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.allOf(this.matchers)));
    }

    protected Matcher[] constructMatchers() {
        return (Matcher[])Arrays.stream(this.msgsRequired).map(s -> CoreMatchers.containsString((String)s)).toArray(Matcher[]::new);
    }
}

