/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.clientconnection;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.ContextInternal;
import java.util.Set;

public abstract class Endpoint<C> {
    private final Set<C> connectionMap = new ConcurrentHashSet<C>();
    private final Runnable dispose;
    private boolean closed;
    private boolean disposed;
    private long pendingRequestCount;
    private long openConnectionCount;

    public Endpoint(Runnable dispose) {
        this.dispose = dispose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConnection(ContextInternal ctx, Handler<AsyncResult<C>> handler) {
        Endpoint endpoint = this;
        synchronized (endpoint) {
            if (this.disposed) {
                return false;
            }
            ++this.pendingRequestCount;
        }
        this.requestConnection(ctx, ar -> {
            boolean dispose;
            Endpoint endpoint = this;
            synchronized (endpoint) {
                --this.pendingRequestCount;
                dispose = this.checkDispose();
            }
            handler.handle((AsyncResult<C>)ar);
            if (dispose) {
                this.disposeInternal();
            }
        });
        return true;
    }

    public abstract void requestConnection(ContextInternal var1, Handler<AsyncResult<C>> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionAdded(C conn) {
        Endpoint endpoint = this;
        synchronized (endpoint) {
            if (this.connectionMap.add(conn)) {
                ++this.openConnectionCount;
            } else {
                System.out.println("BUG!!!");
            }
            if (!this.closed) {
                return;
            }
        }
        this.close(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionRemoved(C conn) {
        Endpoint endpoint = this;
        synchronized (endpoint) {
            if (this.connectionMap.remove(conn)) {
                --this.openConnectionCount;
            } else {
                System.out.println("BUG!!!!");
            }
            if (!this.checkDispose()) {
                return;
            }
        }
        this.disposeInternal();
    }

    private void disposeInternal() {
        this.dispose.run();
        this.dispose();
    }

    private boolean checkDispose() {
        if (!this.disposed && this.openConnectionCount == 0L && this.pendingRequestCount == 0L) {
            this.disposed = true;
            return true;
        }
        return false;
    }

    protected void dispose() {
    }

    protected void close(C connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Endpoint endpoint = this;
        synchronized (endpoint) {
            if (this.closed) {
                throw new IllegalStateException();
            }
            this.closed = true;
        }
        for (Object conn : this.connectionMap) {
            this.close(conn);
        }
    }
}

