/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.ClientHttpStreamEndpoint;
import io.vertx.core.http.impl.EndpointKey;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.HttpChannelConnector;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.WebSocketEndpoint;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.clientconnection.ConnectionManager;
import io.vertx.core.net.impl.clientconnection.Endpoint;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.streams.ReadStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;

public class HttpClientImpl
implements HttpClient,
MetricsProvider,
Closeable {
    private static final Pattern ABS_URI_START_PATTERN = Pattern.compile("^\\p{Alpha}[\\p{Alpha}\\p{Digit}+.\\-]*:");
    private static final Function<HttpClientResponse, Future<RequestOptions>> DEFAULT_HANDLER = resp -> {
        try {
            int statusCode = resp.statusCode();
            String location = resp.getHeader(HttpHeaders.LOCATION);
            if (location != null && (statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307 || statusCode == 308)) {
                String query;
                String requestURI;
                boolean ssl;
                HttpMethod m = resp.request().method();
                if (statusCode == 303) {
                    m = HttpMethod.GET;
                } else if (m != HttpMethod.GET && m != HttpMethod.HEAD) {
                    return null;
                }
                URI uri = HttpUtils.resolveURIReference(resp.request().absoluteURI(), location);
                int port = uri.getPort();
                String protocol = uri.getScheme();
                char chend = protocol.charAt(protocol.length() - 1);
                if (chend == 'p') {
                    ssl = false;
                    if (port == -1) {
                        port = 80;
                    }
                } else if (chend == 's') {
                    ssl = true;
                    if (port == -1) {
                        port = 443;
                    }
                } else {
                    return null;
                }
                if ((requestURI = uri.getPath()) == null || requestURI.isEmpty()) {
                    requestURI = "/";
                }
                if ((query = uri.getQuery()) != null) {
                    requestURI = requestURI + "?" + query;
                }
                RequestOptions options = new RequestOptions();
                options.setMethod(m);
                options.setHost(uri.getHost());
                options.setPort(port);
                options.setSsl(ssl);
                options.setURI(requestURI);
                return Future.succeededFuture(options);
            }
            return null;
        }
        catch (Exception e) {
            return Future.failedFuture(e);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(HttpClientImpl.class);
    private static final Consumer<Endpoint<HttpClientConnection>> EXPIRED_CHECKER = endpoint -> ((ClientHttpStreamEndpoint)endpoint).checkExpired();
    private final VertxInternal vertx;
    private final ChannelGroup channelGroup;
    private final HttpClientOptions options;
    private final ConnectionManager<EndpointKey, HttpClientConnection> webSocketCM;
    private final ConnectionManager<EndpointKey, HttpClientConnection> httpCM;
    private final ProxyType proxyType;
    private final SSLHelper sslHelper;
    private final HttpClientMetrics metrics;
    private final boolean keepAlive;
    private final boolean pipelining;
    private final CloseFuture closeFuture;
    private long timerID;
    private volatile Handler<HttpConnection> connectionHandler;
    private volatile Function<HttpClientResponse, Future<RequestOptions>> redirectHandler = DEFAULT_HANDLER;

    public HttpClientImpl(VertxInternal vertx, HttpClientOptions options, CloseFuture closeFuture) {
        this.vertx = vertx;
        this.metrics = vertx.metricsSPI() != null ? vertx.metricsSPI().createHttpClientMetrics(options) : null;
        this.options = new HttpClientOptions(options);
        this.channelGroup = new DefaultChannelGroup((EventExecutor)vertx.getAcceptorEventLoopGroup().next());
        this.closeFuture = closeFuture;
        List<HttpVersion> alpnVersions = options.getAlpnVersions();
        if (alpnVersions == null || alpnVersions.isEmpty()) {
            switch (options.getProtocolVersion()) {
                case HTTP_2: {
                    alpnVersions = Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1);
                    break;
                }
                default: {
                    alpnVersions = Collections.singletonList(options.getProtocolVersion());
                }
            }
        }
        this.keepAlive = options.isKeepAlive();
        this.pipelining = options.isPipelining();
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions()).setApplicationProtocols(alpnVersions);
        this.sslHelper.validate(vertx);
        if (options.getProtocolVersion() == HttpVersion.HTTP_2 && Context.isOnWorkerThread()) {
            throw new IllegalStateException("Cannot use HttpClient with HTTP_2 in a worker");
        }
        if (!this.keepAlive && this.pipelining) {
            throw new IllegalStateException("Cannot have pipelining with no keep alive");
        }
        this.webSocketCM = this.webSocketConnectionManager();
        this.httpCM = this.httpConnectionManager();
        ProxyType proxyType = this.proxyType = options.getProxyOptions() != null ? options.getProxyOptions().getType() : null;
        if (options.getPoolCleanerPeriod() > 0 && ((long)options.getKeepAliveTimeout() > 0L || (long)options.getHttp2KeepAliveTimeout() > 0L)) {
            PoolChecker checker = new PoolChecker(this);
            this.timerID = vertx.setTimer(options.getPoolCleanerPeriod(), checker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpired(Handler<Long> checker) {
        this.httpCM.forEach(EXPIRED_CHECKER);
        HttpClientImpl httpClientImpl = this;
        synchronized (httpClientImpl) {
            if (!this.closeFuture.isClosed()) {
                this.timerID = this.vertx.setTimer(this.options.getPoolCleanerPeriod(), checker);
            }
        }
    }

    private ConnectionManager<EndpointKey, HttpClientConnection> httpConnectionManager() {
        long maxSize = this.options.getMaxPoolSize() * this.options.getHttp2MaxPoolSize();
        int maxPoolSize = Math.max(this.options.getMaxPoolSize(), this.options.getHttp2MaxPoolSize());
        return new ConnectionManager<EndpointKey, HttpClientConnection>((key, ctx, dispose) -> {
            int port;
            String host;
            if (key.serverAddr.isInetSocket()) {
                host = key.serverAddr.host();
                port = key.serverAddr.port();
            } else {
                host = key.serverAddr.path();
                port = 0;
            }
            ClientMetrics metrics = this.metrics != null ? this.metrics.createEndpointMetrics(key.serverAddr, maxPoolSize) : null;
            HttpChannelConnector connector = new HttpChannelConnector(this, this.channelGroup, ctx, metrics, this.options.getProtocolVersion(), key.ssl, key.peerAddr, key.serverAddr);
            return new ClientHttpStreamEndpoint(metrics, metrics, this.options.getMaxWaitQueueSize(), maxSize, host, port, ctx, connector, dispose);
        });
    }

    private ConnectionManager<EndpointKey, HttpClientConnection> webSocketConnectionManager() {
        int maxPoolSize = this.options.getMaxPoolSize();
        return new ConnectionManager<EndpointKey, HttpClientConnection>((key, ctx, dispose) -> {
            int port;
            String host;
            if (key.serverAddr.isInetSocket()) {
                host = key.serverAddr.host();
                port = key.serverAddr.port();
            } else {
                host = key.serverAddr.path();
                port = 0;
            }
            ClientMetrics metrics = this.metrics != null ? this.metrics.createEndpointMetrics(key.serverAddr, maxPoolSize) : null;
            HttpChannelConnector connector = new HttpChannelConnector(this, this.channelGroup, ctx, metrics, HttpVersion.HTTP_1_1, key.ssl, key.peerAddr, key.serverAddr);
            return new WebSocketEndpoint(null, port, host, metrics, maxPoolSize, connector, dispose);
        });
    }

    private int getPort(Integer port) {
        return port != null ? port.intValue() : this.options.getDefaultPort();
    }

    private String getHost(String host) {
        return host != null ? host : this.options.getDefaultHost();
    }

    HttpClientMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void webSocket(WebSocketConnectOptions connectOptions, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(connectOptions, this.vertx.promise(handler));
    }

    private void webSocket(WebSocketConnectOptions connectOptions, PromiseInternal<WebSocket> promise) {
        int port = this.getPort(connectOptions.getPort());
        String host = this.getHost(connectOptions.getHost());
        SocketAddress addr = SocketAddress.inetSocketAddress(port, host);
        EndpointKey key = new EndpointKey(connectOptions.isSsl() != null ? connectOptions.isSsl().booleanValue() : this.options.isSsl(), addr, addr);
        this.webSocketCM.getConnection((ContextInternal)promise.future().context(), key, ar -> {
            if (ar.succeeded()) {
                Http1xClientConnection conn = (Http1xClientConnection)ar.result();
                conn.toWebSocket(connectOptions.getURI(), connectOptions.getHeaders(), connectOptions.getVersion(), connectOptions.getSubProtocols(), this.options.getMaxWebSocketFrameSize(), promise);
            } else {
                promise.fail(ar.cause());
            }
        });
    }

    @Override
    public Future<WebSocket> webSocket(int port, String host, String requestURI) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(port, host, requestURI, promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocket(String host, String requestURI) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(host, requestURI, promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocket(String requestURI) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(requestURI, promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocket(WebSocketConnectOptions options) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(options, (Handler<AsyncResult<WebSocket>>)promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocketAbs(url, headers, version, subProtocols, promise);
        return promise.future();
    }

    @Override
    public void webSocket(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(new WebSocketConnectOptions().setURI(requestURI).setHost(host).setPort(port), handler);
    }

    @Override
    public void webSocket(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(this.options.getDefaultPort(), host, requestURI, handler);
    }

    @Override
    public void webSocket(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, handler);
    }

    @Override
    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, Handler<AsyncResult<WebSocket>> handler) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String scheme = uri.getScheme();
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("Scheme: " + scheme);
        }
        boolean ssl = scheme.length() == 3;
        int port = uri.getPort();
        if (port == -1) {
            port = ssl ? 443 : 80;
        }
        StringBuilder relativeUri = new StringBuilder();
        if (uri.getRawPath() != null) {
            relativeUri.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            relativeUri.append('?').append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            relativeUri.append('#').append(uri.getRawFragment());
        }
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost(uri.getHost()).setPort(port).setSsl(ssl).setURI(relativeUri.toString()).setHeaders(headers).setVersion(version).setSubProtocols(subProtocols);
        this.webSocket(options, handler);
    }

    @Override
    public void send(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(options, (Buffer)null, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(RequestOptions options) {
        return this.send(options, (Buffer)null);
    }

    @Override
    public void send(RequestOptions options, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(options.getServer(), options.getMethod(), this.getHost(options.getHost()), this.getPort(options.getPort()), options.getURI(), options.getHeaders(), options.isSsl(), options.getFollowRedirects(), options.getTimeout(), options.getAuthority(), body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(RequestOptions options, ReadStream<Buffer> body) {
        return this.send__(options.getServer(), options.getMethod(), this.getHost(options.getHost()), this.getPort(options.getPort()), options.getURI(), options.getHeaders(), options.isSsl(), options.getFollowRedirects(), options.getTimeout(), options.getAuthority(), body);
    }

    @Override
    public void send(RequestOptions options, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(options.getServer(), options.getMethod(), this.getHost(options.getHost()), this.getPort(options.getPort()), options.getURI(), options.getHeaders(), options.isSsl(), options.getFollowRedirects(), options.getTimeout(), options.getAuthority(), body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(RequestOptions options, Buffer body) {
        return this.send__(options.getServer(), options.getMethod(), this.getHost(options.getHost()), this.getPort(options.getPort()), options.getURI(), options.getHeaders(), options.isSsl(), options.getFollowRedirects(), options.getTimeout(), options.getAuthority(), body);
    }

    @Override
    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(method, port, host, requestURI, headers, (Buffer)null, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, int port, String host, String requestURI, MultiMap headers) {
        return this.send(method, port, host, requestURI, headers, (Buffer)null);
    }

    @Override
    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, host, port, requestURI, headers, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Buffer body) {
        return this.send__(null, method, host, port, requestURI, headers, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, host, port, requestURI, headers, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return this.send__(null, method, host, port, requestURI, headers, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(method, port, host, requestURI, (Buffer)null, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, int port, String host, String requestURI) {
        return this.send(method, port, host, requestURI, (Buffer)null);
    }

    @Override
    public void send(HttpMethod method, int port, String host, String requestURI, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, host, port, requestURI, null, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, int port, String host, String requestURI, ReadStream<Buffer> body) {
        return this.send__(null, method, host, port, requestURI, null, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, int port, String host, String requestURI, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, host, port, requestURI, null, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, int port, String host, String requestURI, Buffer body) {
        return this.send__(null, method, host, port, requestURI, null, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(method, host, requestURI, headers, (Buffer)null, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String host, String requestURI, MultiMap headers) {
        return this.send(method, host, requestURI, headers, (Buffer)null);
    }

    @Override
    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, host, this.options.getDefaultPort(), requestURI, headers, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String host, String requestURI, MultiMap headers, Buffer body) {
        return this.send__(null, method, host, this.options.getDefaultPort(), requestURI, headers, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, host, this.options.getDefaultPort(), requestURI, headers, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return this.send__(null, method, host, this.options.getDefaultPort(), requestURI, headers, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, String host, String requestURI, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, host, this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String host, String requestURI, Buffer body) {
        return this.send__(null, method, host, this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, String host, String requestURI, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, host, this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String host, String requestURI, ReadStream<Buffer> body) {
        return this.send__(null, method, host, this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, host, this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, null, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String host, String requestURI) {
        return this.send__(null, method, host, this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, null);
    }

    @Override
    public void send(HttpMethod method, String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(method, requestURI, headers, (Buffer)null, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String requestURI, MultiMap headers) {
        return this.send(method, requestURI, headers, (Buffer)null);
    }

    @Override
    public void send(HttpMethod method, String requestURI, MultiMap headers, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, this.options.getDefaultHost(), this.options.getDefaultPort(), requestURI, headers, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String requestURI, MultiMap headers, Buffer body) {
        return this.send__(null, method, this.options.getDefaultHost(), this.options.getDefaultPort(), requestURI, headers, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, String requestURI, MultiMap headers, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, this.options.getDefaultHost(), this.options.getDefaultPort(), requestURI, headers, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return this.send__(null, method, this.options.getDefaultHost(), this.options.getDefaultPort(), requestURI, headers, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, String requestURI, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, this.options.getDefaultHost(), this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String requestURI, Buffer body) {
        return this.send__(null, method, this.options.getDefaultHost(), this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, String requestURI, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, this.options.getDefaultHost(), this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String requestURI, ReadStream<Buffer> body) {
        return this.send__(null, method, this.options.getDefaultHost(), this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, body);
    }

    @Override
    public void send(HttpMethod method, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(null, method, this.options.getDefaultHost(), this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, null, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> send(HttpMethod method, String requestURI) {
        return this.send__(null, method, this.options.getDefaultHost(), this.options.getDefaultPort(), requestURI, null, null, false, 0L, null, null);
    }

    private void send(SocketAddress server, HttpMethod method, String host, int port, String requestURI, MultiMap headers, Boolean ssl, boolean followRedirects, long timeout, String authority, Object body, Handler<AsyncResult<HttpClientResponse>> handler) {
        this.send_(server, method, host, port, requestURI, headers, ssl, followRedirects, timeout, body, authority, this.vertx.promise(handler));
    }

    private Future<HttpClientResponse> send__(SocketAddress server, HttpMethod method, String host, int port, String requestURI, MultiMap headers, Boolean ssl, boolean followRedirects, long timeout, String authority, Object body) {
        PromiseInternal<HttpClientResponse> promise = this.vertx.promise();
        this.send(server, method, host, port, requestURI, headers, ssl, followRedirects, timeout, authority, body, promise);
        return promise.future();
    }

    private void send_(SocketAddress server, HttpMethod method, String host, int port, String requestURI, MultiMap headers, Boolean ssl, boolean followRedirects, long timeout, Object body, String authority, PromiseInternal<HttpClientResponse> responsePromise) {
        ContextInternal ctx = (ContextInternal)responsePromise.future().context();
        PromiseInternal<HttpClientRequest> promise = ctx.promise();
        this.request(method, server, host, port, ssl, requestURI, headers, authority, 0L, followRedirects, promise);
        promise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                HttpClientRequest req = (HttpClientRequest)ar.result();
                req.onComplete((Handler)responsePromise);
                if (body instanceof Buffer) {
                    req.end((Buffer)body);
                } else if (body instanceof ReadStream) {
                    ReadStream stream = (ReadStream)body;
                    if (headers == null || !headers.contains(HttpHeaders.CONTENT_LENGTH)) {
                        req.setChunked(true);
                    }
                    stream.pipeTo(req);
                } else {
                    req.end();
                }
                if (timeout > 0L) {
                    req.setTimeout(timeout);
                }
            } else {
                responsePromise.fail(ar.cause());
            }
        });
    }

    @Override
    public void request(RequestOptions options, Handler<AsyncResult<HttpClientRequest>> handler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal<HttpClientRequest> promise = ctx.promise(handler);
        this.request(options, promise);
    }

    @Override
    public Future<HttpClientRequest> request(RequestOptions options) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal<HttpClientRequest> promise = ctx.promise();
        this.request(options, promise);
        return promise.future();
    }

    private void request(RequestOptions options, PromiseInternal<HttpClientRequest> promise) {
        this.request(options.getMethod(), options.getServer(), this.getHost(options.getHost()), this.getPort(options.getPort()), options.isSsl(), options.getURI(), options.getHeaders(), options.getAuthority(), options.getTimeout(), options.getFollowRedirects(), promise);
    }

    @Override
    public void request(HttpMethod method, int port, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal<HttpClientRequest> promise = ctx.promise(handler);
        this.request(method, port, host, requestURI, promise);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, int port, String host, String requestURI) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal<HttpClientRequest> promise = ctx.promise();
        this.request(method, port, host, requestURI, promise);
        return promise.future();
    }

    private void request(HttpMethod method, int port, String host, String requestURI, PromiseInternal<HttpClientRequest> promise) {
        this.request(method, null, host, port, null, requestURI, null, null, 0L, null, promise);
    }

    @Override
    public void request(HttpMethod method, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.request(method, this.options.getDefaultPort(), host, requestURI, handler);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, String host, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public void request(HttpMethod method, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, handler);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI);
    }

    @Override
    public void get(int port, String host, String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.GET, port, host, requestURI, headers, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> get(int port, String host, String requestURI, MultiMap headers) {
        return this.send(HttpMethod.GET, port, host, requestURI, headers);
    }

    @Override
    public void get(String host, String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.GET, host, requestURI, headers, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> get(String host, String requestURI, MultiMap headers) {
        return this.send(HttpMethod.GET, host, requestURI, headers);
    }

    @Override
    public void get(String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.GET, requestURI, headers, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> get(String requestURI, MultiMap headers) {
        return this.send(HttpMethod.GET, requestURI, headers);
    }

    @Override
    public void get(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(options.setMethod(HttpMethod.GET), responseHandler);
    }

    @Override
    public Future<HttpClientResponse> get(RequestOptions options) {
        return this.send(options.setMethod(HttpMethod.GET));
    }

    @Override
    public void get(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.GET, port, host, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> get(int port, String host, String requestURI) {
        return this.send(HttpMethod.GET, port, host, requestURI);
    }

    @Override
    public void get(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.GET, host, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> get(String host, String requestURI) {
        return this.send(HttpMethod.GET, host, requestURI);
    }

    @Override
    public void get(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.GET, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> get(String requestURI) {
        return this.send(HttpMethod.GET, requestURI);
    }

    @Override
    public void post(int port, String host, String requestURI, MultiMap headers, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, port, host, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(int port, String host, String requestURI, MultiMap headers, Buffer body) {
        return this.send(HttpMethod.POST, port, host, requestURI, headers, body);
    }

    @Override
    public void post(int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, port, host, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return this.send(HttpMethod.POST, port, host, requestURI, headers, body);
    }

    @Override
    public void post(String host, String requestURI, MultiMap headers, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, host, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(String host, String requestURI, MultiMap headers, Buffer body) {
        return this.send(HttpMethod.POST, host, requestURI, headers, body);
    }

    @Override
    public void post(String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, host, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return this.send(HttpMethod.POST, host, requestURI, headers, body);
    }

    @Override
    public void post(String requestURI, MultiMap headers, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(String requestURI, MultiMap headers, Buffer body) {
        return this.send(HttpMethod.POST, requestURI, headers, body);
    }

    @Override
    public void post(String requestURI, MultiMap headers, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return this.send(HttpMethod.POST, requestURI, headers, body);
    }

    @Override
    public void post(RequestOptions options, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(options.setMethod(HttpMethod.POST), body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(RequestOptions options, Buffer body) {
        return this.send(options.setMethod(HttpMethod.POST), body);
    }

    @Override
    public void post(RequestOptions options, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(options.setMethod(HttpMethod.POST), body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(RequestOptions options, ReadStream<Buffer> body) {
        return this.send(options.setMethod(HttpMethod.POST), body);
    }

    @Override
    public void post(int port, String host, String requestURI, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, port, host, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(int port, String host, String requestURI, Buffer body) {
        return this.send(HttpMethod.POST, port, host, requestURI, body);
    }

    @Override
    public void post(int port, String host, String requestURI, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, port, host, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(int port, String host, String requestURI, ReadStream<Buffer> body) {
        return this.send(HttpMethod.POST, port, host, requestURI, body);
    }

    @Override
    public void post(String host, String requestURI, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, host, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(String host, String requestURI, Buffer body) {
        return this.send(HttpMethod.POST, host, requestURI, body);
    }

    @Override
    public void post(String host, String requestURI, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, host, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(String host, String requestURI, ReadStream<Buffer> body) {
        return this.send(HttpMethod.POST, host, requestURI, body);
    }

    @Override
    public void post(String requestURI, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(String requestURI, Buffer body) {
        return this.send(HttpMethod.POST, requestURI, body);
    }

    @Override
    public void post(String requestURI, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.POST, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> post(String requestURI, ReadStream<Buffer> body) {
        return this.send(HttpMethod.POST, requestURI, body);
    }

    @Override
    public void put(int port, String host, String requestURI, MultiMap headers, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, port, host, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(int port, String host, String requestURI, MultiMap headers, Buffer body) {
        return this.send(HttpMethod.PUT, port, host, requestURI, headers, body);
    }

    @Override
    public void put(int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, port, host, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return this.send(HttpMethod.PUT, port, host, requestURI, headers, body);
    }

    @Override
    public void put(String host, String requestURI, MultiMap headers, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, host, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(String host, String requestURI, MultiMap headers, Buffer body) {
        return this.send(HttpMethod.PUT, host, requestURI, headers, body);
    }

    @Override
    public void put(String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, host, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return this.send(HttpMethod.PUT, host, requestURI, headers, body);
    }

    @Override
    public void put(String requestURI, MultiMap headers, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(String requestURI, MultiMap headers, Buffer body) {
        return this.send(HttpMethod.PUT, requestURI, headers, body);
    }

    @Override
    public void put(String requestURI, MultiMap headers, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, requestURI, headers, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return this.send(HttpMethod.PUT, requestURI, headers, body);
    }

    @Override
    public void put(RequestOptions options, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(options.setMethod(HttpMethod.PUT), body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(RequestOptions options, Buffer body) {
        return this.send(options.setMethod(HttpMethod.PUT), body);
    }

    @Override
    public void put(RequestOptions options, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(options.setMethod(HttpMethod.PUT), body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(RequestOptions options, ReadStream<Buffer> body) {
        return this.send(options.setMethod(HttpMethod.PUT), body);
    }

    @Override
    public void put(int port, String host, String requestURI, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, port, host, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(int port, String host, String requestURI, Buffer body) {
        return this.send(HttpMethod.PUT, port, host, requestURI, body);
    }

    @Override
    public void put(int port, String host, String requestURI, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, port, host, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(int port, String host, String requestURI, ReadStream<Buffer> body) {
        return this.send(HttpMethod.PUT, port, host, requestURI, body);
    }

    @Override
    public void put(String host, String requestURI, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, host, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(String host, String requestURI, Buffer body) {
        return this.send(HttpMethod.PUT, host, requestURI, body);
    }

    @Override
    public void put(String host, String requestURI, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, host, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(String host, String requestURI, ReadStream<Buffer> body) {
        return this.send(HttpMethod.PUT, host, requestURI, body);
    }

    @Override
    public void put(String requestURI, Buffer body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(String requestURI, Buffer body) {
        return this.send(HttpMethod.PUT, requestURI, body);
    }

    @Override
    public void put(String requestURI, ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.PUT, requestURI, body, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> put(String requestURI, ReadStream<Buffer> body) {
        return this.send(HttpMethod.PUT, requestURI, body);
    }

    @Override
    public void head(int port, String host, String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.HEAD, port, host, requestURI, headers, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> head(int port, String host, String requestURI, MultiMap headers) {
        return this.send(HttpMethod.HEAD, port, host, requestURI, headers);
    }

    @Override
    public void head(String host, String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.HEAD, host, requestURI, headers, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> head(String host, String requestURI, MultiMap headers) {
        return this.send(HttpMethod.HEAD, host, requestURI, headers);
    }

    @Override
    public void head(String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.HEAD, requestURI, headers, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> head(String requestURI, MultiMap headers) {
        return this.send(HttpMethod.HEAD, requestURI, headers);
    }

    @Override
    public void head(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(options.setMethod(HttpMethod.HEAD), responseHandler);
    }

    @Override
    public Future<HttpClientResponse> head(RequestOptions options) {
        return this.send(options.setMethod(HttpMethod.HEAD));
    }

    @Override
    public void head(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.HEAD, port, host, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> head(int port, String host, String requestURI) {
        return this.send(HttpMethod.HEAD, port, host, requestURI);
    }

    @Override
    public void head(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.HEAD, host, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> head(String host, String requestURI) {
        return this.send(HttpMethod.HEAD, host, requestURI);
    }

    @Override
    public void head(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.HEAD, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> head(String requestURI) {
        return this.send(HttpMethod.HEAD, requestURI);
    }

    @Override
    public void options(int port, String host, String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.OPTIONS, port, host, requestURI, headers, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> options(int port, String host, String requestURI, MultiMap headers) {
        return this.send(HttpMethod.OPTIONS, port, host, requestURI, headers);
    }

    @Override
    public void options(String host, String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.OPTIONS, host, requestURI, headers, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> options(String host, String requestURI, MultiMap headers) {
        return this.send(HttpMethod.OPTIONS, host, requestURI, headers);
    }

    @Override
    public void options(String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.OPTIONS, requestURI, headers, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> options(String requestURI, MultiMap headers) {
        return this.send(HttpMethod.OPTIONS, requestURI, headers);
    }

    @Override
    public void options(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(options.setMethod(HttpMethod.OPTIONS), responseHandler);
    }

    @Override
    public Future<HttpClientResponse> options(RequestOptions options) {
        return this.send(options.setMethod(HttpMethod.OPTIONS));
    }

    @Override
    public void options(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.OPTIONS, port, host, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> options(int port, String host, String requestURI) {
        return this.send(HttpMethod.OPTIONS, port, host, requestURI);
    }

    @Override
    public void options(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.OPTIONS, host, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> options(String host, String requestURI) {
        return this.send(HttpMethod.OPTIONS, host, requestURI);
    }

    @Override
    public void options(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.OPTIONS, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> options(String requestURI) {
        return this.send(HttpMethod.OPTIONS, requestURI);
    }

    @Override
    public void delete(int port, String host, String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.DELETE, port, host, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> delete(int port, String host, String requestURI, MultiMap headers) {
        return this.send(HttpMethod.DELETE, port, host, requestURI);
    }

    @Override
    public void delete(String host, String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.DELETE, host, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> delete(String host, String requestURI, MultiMap headers) {
        return this.send(HttpMethod.DELETE, host, requestURI);
    }

    @Override
    public void delete(String requestURI, MultiMap headers, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.DELETE, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> delete(String requestURI, MultiMap headers) {
        return this.send(HttpMethod.DELETE, requestURI);
    }

    @Override
    public void delete(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(options.setMethod(HttpMethod.DELETE), responseHandler);
    }

    @Override
    public Future<HttpClientResponse> delete(RequestOptions options) {
        return this.send(options.setMethod(HttpMethod.DELETE));
    }

    @Override
    public void delete(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.DELETE, port, host, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> delete(int port, String host, String requestURI) {
        return this.send(HttpMethod.DELETE, port, host, requestURI);
    }

    @Override
    public void delete(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.DELETE, host, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> delete(String host, String requestURI) {
        return this.send(HttpMethod.DELETE, host, requestURI);
    }

    @Override
    public void delete(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.send(HttpMethod.DELETE, requestURI, responseHandler);
    }

    @Override
    public Future<HttpClientResponse> delete(String requestURI) {
        return this.send(HttpMethod.DELETE, requestURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Promise<Void> completion) {
        HttpClientImpl httpClientImpl = this;
        synchronized (httpClientImpl) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.webSocketCM.close();
        this.httpCM.close();
        ChannelGroupFuture fut = this.channelGroup.close();
        if (this.metrics != null) {
            PromiseInternal p = (PromiseInternal)Promise.promise();
            fut.addListener((GenericFutureListener)p);
            p.future().compose(v -> {
                this.metrics.close();
                return Future.succeededFuture();
            }).onComplete(completion);
        } else {
            fut.addListener((GenericFutureListener)((PromiseInternal)completion));
        }
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        this.closeFuture.close(handler != null ? closingCtx.promise(handler) : null);
    }

    @Override
    public Future<Void> close() {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = closingCtx.promise();
        this.closeFuture.close(promise);
        return promise.future();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.getMetrics() != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public HttpClient connectionHandler(Handler<HttpConnection> handler) {
        this.connectionHandler = handler;
        return this;
    }

    Handler<HttpConnection> connectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public HttpClient redirectHandler(Function<HttpClientResponse, Future<RequestOptions>> handler) {
        if (handler == null) {
            handler = DEFAULT_HANDLER;
        }
        this.redirectHandler = handler;
        return this;
    }

    @Override
    public Function<HttpClientResponse, Future<RequestOptions>> redirectHandler() {
        return this.redirectHandler;
    }

    public HttpClientOptions getOptions() {
        return this.options;
    }

    public VertxInternal getVertx() {
        return this.vertx;
    }

    SSLHelper getSslHelper() {
        return this.sslHelper;
    }

    private void request(HttpMethod method, SocketAddress server, String host, int port, Boolean ssl, String requestURI, MultiMap headers, String authority, long timeout, Boolean followRedirects, PromiseInternal<HttpClientRequest> requestPromise) {
        SocketAddress peerAddress;
        boolean useProxy;
        boolean useSSL;
        Objects.requireNonNull(method, "no null method accepted");
        Objects.requireNonNull(host, "no null host accepted");
        Objects.requireNonNull(requestURI, "no null requestURI accepted");
        boolean useAlpn = this.options.isUseAlpn();
        boolean bl = useSSL = ssl != null ? ssl.booleanValue() : this.options.isSsl();
        if (!useAlpn && useSSL && this.options.getProtocolVersion() == HttpVersion.HTTP_2) {
            throw new IllegalArgumentException("Must enable ALPN when using H2");
        }
        this.checkClosed();
        boolean bl2 = useProxy = !useSSL && this.proxyType == ProxyType.HTTP;
        if (useProxy) {
            ProxyOptions proxyOptions;
            if (!ABS_URI_START_PATTERN.matcher(requestURI).find()) {
                int defaultPort = 80;
                String addPort = port != -1 && port != defaultPort ? ":" + port : "";
                requestURI = (ssl == Boolean.TRUE ? "https://" : "http://") + host + addPort + requestURI;
            }
            if ((proxyOptions = this.options.getProxyOptions()).getUsername() != null && proxyOptions.getPassword() != null) {
                if (headers == null) {
                    headers = HttpHeaders.headers();
                }
                headers.add("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((proxyOptions.getUsername() + ":" + proxyOptions.getPassword()).getBytes()));
            }
            server = SocketAddress.inetSocketAddress(proxyOptions.getPort(), proxyOptions.getHost());
        } else if (server == null) {
            server = SocketAddress.inetSocketAddress(port, host);
        }
        if (authority != null) {
            int idx = authority.lastIndexOf(58);
            peerAddress = idx != -1 ? SocketAddress.inetSocketAddress(Integer.parseInt(authority.substring(idx + 1)), authority.substring(0, idx)) : SocketAddress.inetSocketAddress(80, authority);
        } else {
            String peerHost = host;
            if (peerHost.endsWith(".")) {
                peerHost = peerHost.substring(0, peerHost.length() - 1);
            }
            peerAddress = SocketAddress.inetSocketAddress(port, peerHost);
        }
        this.request(method, peerAddress, server, host, port, useSSL, requestURI, headers, authority, timeout, followRedirects, requestPromise);
    }

    private void request(HttpMethod method, SocketAddress peerAddress, SocketAddress server, String host, int port, Boolean useSSL, String requestURI, MultiMap headers, String authority, long timeout, Boolean followRedirects, PromiseInternal<HttpClientRequest> requestPromise) {
        ContextInternal ctx = (ContextInternal)requestPromise.future().context();
        EndpointKey key = new EndpointKey(useSSL, server, peerAddress);
        long timerID = timeout > 0L ? ctx.setTimer(timeout, id -> requestPromise.tryFail(HttpClientRequestBase.timeoutEx(timeout, method, server, requestURI))) : -1L;
        this.httpCM.getConnection(ctx, key, ar1 -> {
            if (ar1.succeeded()) {
                HttpClientConnection conn = (HttpClientConnection)ar1.result();
                conn.createStream(ctx, ar2 -> {
                    if (ar2.succeeded()) {
                        HttpClientStream stream = (HttpClientStream)ar2.result();
                        HttpClientRequestImpl req = new HttpClientRequestImpl(this, stream, ctx.promise(), useSSL, method, server, host, port, requestURI);
                        if (authority != null) {
                            req.setAuthority(authority);
                        }
                        if (headers != null) {
                            req.headers().setAll(headers);
                        }
                        if (followRedirects != null) {
                            req.setFollowRedirects(followRedirects);
                        }
                        if (timerID >= 0L) {
                            if (!this.vertx.cancelTimer(timerID)) {
                                req.reset(0L);
                                return;
                            }
                            req.setTimeout(timeout);
                        }
                        requestPromise.complete(req);
                    } else {
                        requestPromise.tryFail(ar2.cause());
                    }
                });
            } else {
                requestPromise.tryFail(ar1.cause());
            }
        });
    }

    private void checkClosed() {
        if (this.closeFuture.isClosed()) {
            throw new IllegalStateException("Client is closed");
        }
    }

    protected void finalize() throws Throwable {
        this.close((Handler<AsyncResult<Void>>)Promise.promise());
        super.finalize();
    }

    private static class PoolChecker
    implements Handler<Long> {
        final WeakReference<HttpClientImpl> ref;

        private PoolChecker(HttpClientImpl client) {
            this.ref = new WeakReference<HttpClientImpl>(client);
        }

        @Override
        public void handle(Long event) {
            HttpClientImpl client = (HttpClientImpl)this.ref.get();
            if (client != null) {
                client.checkExpired(this);
            }
        }
    }
}

