/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.WebSocketInternal;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.streams.impl.InboundBuffer;
import java.util.UUID;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public abstract class WebSocketImplBase<S extends WebSocketBase>
implements WebSocketInternal {
    private final boolean supportsContinuation;
    private final String textHandlerID;
    private final String binaryHandlerID;
    private final int maxWebSocketFrameSize;
    private final int maxWebSocketMessageSize;
    private final InboundBuffer<WebSocketFrameInternal> pending;
    private ChannelHandlerContext chctx;
    protected final ContextInternal context;
    private MessageConsumer binaryHandlerRegistration;
    private MessageConsumer textHandlerRegistration;
    private String subProtocol;
    private Object metric;
    private Handler<Buffer> handler;
    private Handler<WebSocketFrameInternal> frameHandler;
    private Handler<Buffer> pongHandler;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    protected final Http1xConnectionBase conn;
    private boolean writable;
    protected boolean closed;
    private Short closeStatusCode;
    private String closeReason;
    private MultiMap headers;
    private boolean closeFrameSent;

    WebSocketImplBase(ContextInternal context, Http1xConnectionBase conn, boolean supportsContinuation, int maxWebSocketFrameSize, int maxWebSocketMessageSize) {
        this.supportsContinuation = supportsContinuation;
        this.textHandlerID = "__vertx.ws." + UUID.randomUUID().toString();
        this.binaryHandlerID = "__vertx.ws." + UUID.randomUUID().toString();
        this.conn = conn;
        this.context = context;
        this.maxWebSocketFrameSize = maxWebSocketFrameSize;
        this.maxWebSocketMessageSize = maxWebSocketMessageSize;
        this.pending = new InboundBuffer(context);
        this.writable = !conn.isNotWritable();
        this.chctx = conn.channelHandlerContext();
        this.pending.handler(this::receiveFrame);
        this.pending.drainHandler((Void v) -> conn.doResume());
    }

    void registerHandler(EventBus eventBus) {
        Handler<Message> binaryHandler = msg -> this.writeBinaryFrameInternal((Buffer)msg.body());
        Handler<Message> textHandler = msg -> this.writeTextFrameInternal((String)msg.body());
        this.binaryHandlerRegistration = eventBus.localConsumer(this.binaryHandlerID).handler(binaryHandler);
        this.textHandlerRegistration = eventBus.localConsumer(this.textHandlerID).handler(textHandler);
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.chctx;
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }

    @Override
    public String binaryHandlerID() {
        return this.binaryHandlerID;
    }

    @Override
    public String textHandlerID() {
        return this.textHandlerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            return this.conn.isNotWritable();
        }
    }

    @Override
    public Future<Void> close() {
        return this.close((short)1000, (String)null);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        Future<Void> future = this.close();
        if (handler != null) {
            future.onComplete(handler);
        }
    }

    @Override
    public Future<Void> close(short statusCode) {
        return this.close(statusCode, (String)null);
    }

    @Override
    public void close(short statusCode, Handler<AsyncResult<Void>> handler) {
        Future<Void> future = this.close(statusCode, (String)null);
        if (handler != null) {
            future.onComplete(handler);
        }
    }

    @Override
    public void close(short statusCode, @Nullable String reason, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.close(statusCode, reason);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close(short statusCode, String reason) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (this.closed) {
                return this.context.succeededFuture();
            }
            this.closed = true;
            this.closeFrameSent = true;
        }
        this.unregisterHandlers();
        ByteBuf byteBuf = HttpUtils.generateWSCloseFrameByteBuf(statusCode, reason);
        CloseWebSocketFrame frame = new CloseWebSocketFrame(true, 0, byteBuf);
        this.conn.writeToChannel(frame);
        return this.conn.closeFuture();
    }

    @Override
    public boolean isSsl() {
        return this.conn.isSsl();
    }

    @Override
    public SSLSession sslSession() {
        return this.conn.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public Future<Void> writeFinalTextFrame(String text) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writeFinalTextFrame(text, promise);
        return promise.future();
    }

    public S writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) {
        return this.writeFrame(WebSocketFrame.textFrame(text, true), handler);
    }

    @Override
    public Future<Void> writeFinalBinaryFrame(Buffer data) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writeFinalBinaryFrame(data, promise);
        return promise.future();
    }

    public S writeFinalBinaryFrame(Buffer data, Handler<AsyncResult<Void>> handler) {
        return this.writeFrame(WebSocketFrame.binaryFrame(data, true), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String subProtocol() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.subProtocol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subProtocol(String subProtocol) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.subProtocol = subProtocol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short closeStatusCode() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.closeStatusCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String closeReason() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.closeReason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap headers() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.headers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void headers(MultiMap responseHeaders) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.headers = responseHeaders;
        }
    }

    @Override
    public Future<Void> writeBinaryMessage(Buffer data) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writeBinaryMessage(data, promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S writeBinaryMessage(Buffer data, Handler<AsyncResult<Void>> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.writePartialMessage(FrameType.BINARY, data, 0, handler);
            return (S)this;
        }
    }

    @Override
    public Future<Void> writeTextMessage(String text) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writeTextMessage(text, promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S writeTextMessage(String text, @Nullable Handler<AsyncResult<Void>> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            Buffer data = Buffer.buffer(text);
            this.writePartialMessage(FrameType.TEXT, data, 0, handler);
            return (S)this;
        }
    }

    @Override
    public Future<Void> write(Buffer data) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(data, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.writeFrame(WebSocketFrame.binaryFrame(data, true), handler);
    }

    @Override
    public Future<Void> writePing(Buffer data) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writePing(data, promise);
        return promise.future();
    }

    @Override
    public WebSocketBase writePing(Buffer data, Handler<AsyncResult<Void>> handler) {
        if (data.length() > this.maxWebSocketFrameSize || data.length() > 125) {
            throw new IllegalStateException("Ping cannot exceed maxWebSocketFrameSize or 125 bytes");
        }
        return this.writeFrame(WebSocketFrame.pingFrame(data), handler);
    }

    @Override
    public Future<Void> writePong(Buffer data) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writePong(data, promise);
        return promise.future();
    }

    @Override
    public WebSocketBase writePong(Buffer data, Handler<AsyncResult<Void>> handler) {
        if (data.length() > this.maxWebSocketFrameSize || data.length() > 125) {
            throw new IllegalStateException("Pong cannot exceed maxWebSocketFrameSize or 125 bytes");
        }
        return this.writeFrame(WebSocketFrame.pongFrame(data), handler);
    }

    private void writePartialMessage(FrameType frameType, Buffer data, int offset, Handler<AsyncResult<Void>> handler) {
        boolean isFinal;
        int end = offset + this.maxWebSocketFrameSize;
        if (end >= data.length()) {
            end = data.length();
            isFinal = true;
        } else {
            isFinal = false;
        }
        Buffer slice = data.slice(offset, end);
        WebSocketFrame frame = offset == 0 || !this.supportsContinuation ? new WebSocketFrameImpl(frameType, slice.getByteBuf(), isFinal) : WebSocketFrame.continuationFrame(slice, isFinal);
        int newOffset = offset + this.maxWebSocketFrameSize;
        if (isFinal) {
            this.writeFrame(frame, handler);
        } else {
            this.writeFrame(frame);
            this.writePartialMessage(frameType, data, newOffset, handler);
        }
    }

    private void writeBinaryFrameInternal(Buffer data) {
        ByteBuf buf = data.getByteBuf();
        WebSocketFrameImpl frame = new WebSocketFrameImpl(FrameType.BINARY, buf);
        this.writeFrame(frame);
    }

    private void writeTextFrameInternal(String str) {
        WebSocketFrameImpl frame = new WebSocketFrameImpl(str);
        this.writeFrame(frame);
    }

    @Override
    public Future<Void> writeFrame(WebSocketFrame frame) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writeFrame(frame, promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.conn.writeToChannel((Object)this.encodeFrame((WebSocketFrameImpl)frame), handler == null ? null : this.context.promise(handler));
        }
        return (S)this;
    }

    private io.netty.handler.codec.http.websocketx.WebSocketFrame encodeFrame(WebSocketFrameImpl frame) {
        ByteBuf buf = frame.getBinaryData();
        if (buf != Unpooled.EMPTY_BUFFER) {
            buf = VertxHandler.safeBuffer(buf, this.chctx.alloc());
        }
        switch (frame.type()) {
            case BINARY: {
                return new BinaryWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case TEXT: {
                return new TextWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case CLOSE: {
                return new CloseWebSocketFrame(true, 0, buf);
            }
            case CONTINUATION: {
                return new ContinuationWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case PONG: {
                return new PongWebSocketFrame(buf);
            }
            case PING: {
                return new PingWebSocketFrame(buf);
            }
        }
        throw new IllegalStateException("Unsupported WebSocket msg " + frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClosed() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (this.closed) {
                throw new IllegalStateException("WebSocket is closed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.closed;
        }
    }

    private WebSocketFrameInternal decodeFrame(io.netty.handler.codec.http.websocketx.WebSocketFrame msg) {
        FrameType frameType;
        ByteBuf payload = VertxHandler.safeBuffer((ByteBufHolder)msg, this.chctx.alloc());
        boolean isFinal = msg.isFinalFragment();
        if (msg instanceof BinaryWebSocketFrame) {
            frameType = FrameType.BINARY;
        } else if (msg instanceof CloseWebSocketFrame) {
            frameType = FrameType.CLOSE;
        } else if (msg instanceof PingWebSocketFrame) {
            frameType = FrameType.PING;
        } else if (msg instanceof PongWebSocketFrame) {
            frameType = FrameType.PONG;
        } else if (msg instanceof TextWebSocketFrame) {
            frameType = FrameType.TEXT;
        } else if (msg instanceof ContinuationWebSocketFrame) {
            frameType = FrameType.CONTINUATION;
        } else {
            throw new IllegalStateException("Unsupported WebSocket msg " + msg);
        }
        return new WebSocketFrameImpl(frameType, payload, isFinal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleFrame(io.netty.handler.codec.http.websocketx.WebSocketFrame msg) {
        WebSocketFrameInternal frame = this.decodeFrame(msg);
        switch (frame.type()) {
            case PING: {
                this.conn.writeToChannel(new PongWebSocketFrame(frame.getBinaryData().copy()));
                break;
            }
            case PONG: {
                Handler<Buffer> pongHandler = this.pongHandler();
                if (pongHandler == null) break;
                this.context.dispatch(frame.binaryData(), pongHandler);
                break;
            }
            case CLOSE: {
                boolean echo;
                Http1xConnectionBase http1xConnectionBase = this.conn;
                synchronized (http1xConnectionBase) {
                    this.closeStatusCode = frame.closeStatusCode();
                    this.closeReason = frame.closeReason();
                    echo = !this.closeFrameSent;
                }
                this.handleCloseFrame(echo, frame.closeStatusCode(), frame.closeReason());
            }
        }
        if (!this.pending.write(frame)) {
            this.conn.doPause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveFrame(WebSocketFrameInternal frame) {
        Handler<WebSocketFrameInternal> frameHandler;
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            frameHandler = this.frameHandler;
        }
        if (frameHandler != null) {
            this.context.dispatch(frame, frameHandler);
        }
        switch (frame.type()) {
            case CLOSE: {
                Handler<Void> endHandler = this.endHandler();
                if (endHandler == null) break;
                this.context.dispatch(endHandler);
                break;
            }
            case BINARY: 
            case TEXT: 
            case CONTINUATION: {
                Handler<Buffer> handler = this.handler();
                if (handler == null) break;
                this.context.dispatch(frame.binaryData(), handler);
            }
        }
    }

    protected void handleCloseFrame(boolean echo, short statusCode, String reason) {
        if (echo) {
            ChannelPromise fut = this.conn.channelFuture();
            this.conn.writeToChannel((Object)new CloseWebSocketFrame((int)statusCode, reason), fut);
            fut.addListener(v -> this.doClose());
        } else {
            this.doClose();
        }
    }

    protected abstract void doClose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S frameHandler(Handler<WebSocketFrame> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.frameHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketBase textMessageHandler(Handler<String> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            if (this.frameHandler == null || this.frameHandler.getClass() != FrameAggregator.class) {
                this.frameHandler = new FrameAggregator();
            }
            ((FrameAggregator)this.frameHandler).textMessageHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S binaryMessageHandler(Handler<Buffer> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            if (this.frameHandler == null || this.frameHandler.getClass() != FrameAggregator.class) {
                this.frameHandler = new FrameAggregator();
            }
            ((FrameAggregator)this.frameHandler).binaryMessageHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketBase pongHandler(Handler<Buffer> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.pongHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<Buffer> pongHandler() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.pongHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWritabilityChanged(boolean writable) {
        Handler<Void> handler;
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            boolean skip = this.writable && !writable;
            this.writable = writable;
            handler = this.drainHandler;
            if (handler == null || skip) {
                return;
            }
        }
        this.context.dispatch(null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        Handler<Throwable> handler;
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            handler = this.exceptionHandler;
            if (handler == null) {
                return;
            }
        }
        this.context.dispatch(t, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClosed() {
        Handler<Throwable> exceptionHandler;
        Handler<Void> closeHandler;
        this.unregisterHandlers();
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            closeHandler = this.closeHandler;
            exceptionHandler = this.closeStatusCode == null ? this.exceptionHandler : null;
            this.closed = true;
            this.binaryHandlerRegistration = null;
            this.textHandlerRegistration = null;
        }
        if (exceptionHandler != null) {
            this.context.dispatch(ConnectionBase.CLOSED_EXCEPTION, exceptionHandler);
        }
        if (closeHandler != null) {
            this.context.dispatch(null, closeHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterHandlers() {
        MessageConsumer textConsumer;
        MessageConsumer binaryConsumer;
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            binaryConsumer = this.binaryHandlerRegistration;
            textConsumer = this.textHandlerRegistration;
            this.binaryHandlerRegistration = null;
            this.textHandlerRegistration = null;
        }
        if (binaryConsumer != null) {
            binaryConsumer.unregister();
        }
        if (textConsumer != null) {
            textConsumer.unregister();
        }
    }

    synchronized void setMetric(Object metric) {
        this.metric = metric;
    }

    synchronized Object getMetric() {
        return this.metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S handler(Handler<Buffer> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.handler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<Buffer> handler() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S endHandler(Handler<Void> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.endHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<Void> endHandler() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.endHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S exceptionHandler(Handler<Throwable> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.exceptionHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S closeHandler(Handler<Void> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.closeHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S drainHandler(Handler<Void> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.drainHandler = handler;
            return (S)this;
        }
    }

    public S pause() {
        this.pending.pause();
        return (S)this;
    }

    public S resume() {
        this.pending.resume();
        return (S)this;
    }

    public S fetch(long amount) {
        this.pending.fetch(amount);
        return (S)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S setWriteQueueMaxSize(int maxSize) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.conn.doSetWriteQueueMaxSize(maxSize);
            return (S)this;
        }
    }

    @Override
    public Future<Void> end() {
        return this.close();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.close(handler);
    }

    private class FrameAggregator
    implements Handler<WebSocketFrameInternal> {
        private Handler<String> textMessageHandler;
        private Handler<Buffer> binaryMessageHandler;
        private Buffer textMessageBuffer;
        private Buffer binaryMessageBuffer;

        private FrameAggregator() {
        }

        @Override
        public void handle(WebSocketFrameInternal frame) {
            switch (frame.type()) {
                case TEXT: {
                    this.handleTextFrame(frame);
                    break;
                }
                case BINARY: {
                    this.handleBinaryFrame(frame);
                    break;
                }
                case CONTINUATION: {
                    if (this.textMessageBuffer != null && this.textMessageBuffer.length() > 0) {
                        this.handleTextFrame(frame);
                        break;
                    }
                    if (this.binaryMessageBuffer == null || this.binaryMessageBuffer.length() <= 0) break;
                    this.handleBinaryFrame(frame);
                }
            }
        }

        private void handleTextFrame(WebSocketFrameInternal frame) {
            Buffer frameBuffer = Buffer.buffer(frame.getBinaryData());
            if (this.textMessageBuffer == null) {
                this.textMessageBuffer = frameBuffer;
            } else {
                this.textMessageBuffer.appendBuffer(frameBuffer);
            }
            if (this.textMessageBuffer.length() > WebSocketImplBase.this.maxWebSocketMessageSize) {
                int len = this.textMessageBuffer.length() - frameBuffer.length();
                this.textMessageBuffer = null;
                String msg = "Cannot process text frame of size " + frameBuffer.length() + ", it would cause message buffer (size " + len + ") to overflow max message size of " + WebSocketImplBase.this.maxWebSocketMessageSize;
                WebSocketImplBase.this.handleException(new IllegalStateException(msg));
                return;
            }
            if (frame.isFinal()) {
                String fullMessage = this.textMessageBuffer.toString();
                this.textMessageBuffer = null;
                if (this.textMessageHandler != null) {
                    this.textMessageHandler.handle(fullMessage);
                }
            }
        }

        private void handleBinaryFrame(WebSocketFrameInternal frame) {
            Buffer frameBuffer = Buffer.buffer(frame.getBinaryData());
            if (this.binaryMessageBuffer == null) {
                this.binaryMessageBuffer = frameBuffer;
            } else {
                this.binaryMessageBuffer.appendBuffer(frameBuffer);
            }
            if (this.binaryMessageBuffer.length() > WebSocketImplBase.this.maxWebSocketMessageSize) {
                int len = this.binaryMessageBuffer.length() - frameBuffer.length();
                this.binaryMessageBuffer = null;
                String msg = "Cannot process binary frame of size " + frameBuffer.length() + ", it would cause message buffer (size " + len + ") to overflow max message size of " + WebSocketImplBase.this.maxWebSocketMessageSize;
                WebSocketImplBase.this.handleException(new IllegalStateException(msg));
                return;
            }
            if (frame.isFinal()) {
                Buffer fullMessage = this.binaryMessageBuffer.copy();
                this.binaryMessageBuffer = null;
                if (this.binaryMessageHandler != null) {
                    this.binaryMessageHandler.handle(fullMessage);
                }
            }
        }
    }
}

