/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.VertxException;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.file.impl.FileCache;
import io.vertx.core.net.impl.URIDecoder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileResolver {
    public static final String DISABLE_FILE_CACHING_PROP_NAME = "vertx.disableFileCaching";
    public static final String DISABLE_CP_RESOLVING_PROP_NAME = "vertx.disableFileCPResolving";
    public static final String CACHE_DIR_BASE_PROP_NAME = "vertx.cacheDirBase";
    private static final IntPredicate CACHE_PATH_CHECKER = PlatformDependent.isWindows() ? c -> {
        if (c < 33) {
            return false;
        }
        switch (c) {
            case 34: 
            case 42: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 124: {
                return false;
            }
        }
        return true;
    } : c -> c != 0;
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final boolean NON_UNIX_FILE_SEP = !FILE_SEP.equals("/");
    private static final String JAR_URL_SEP = "!/";
    private static final Pattern JAR_URL_SEP_PATTERN = Pattern.compile("!/");
    private final File cwd;
    private final boolean enableCaching;
    private final boolean closeCache;
    private final FileCache cache;

    public FileResolver() {
        this(new FileSystemOptions());
    }

    public FileResolver(FileSystemOptions fileSystemOptions) {
        this(fileSystemOptions.isFileCachingEnabled(), fileSystemOptions.isClassPathResolvingEnabled() ? FileCache.setupCache(fileSystemOptions.getFileCacheDir()) : null, fileSystemOptions.isClassPathResolvingEnabled());
    }

    public FileResolver(boolean enableCaching, FileCache cache, boolean closeCache) {
        this.enableCaching = enableCaching;
        this.cache = cache;
        this.closeCache = closeCache;
        String cwdOverride = System.getProperty("vertx.cwd");
        this.cwd = cwdOverride != null ? new File(cwdOverride).getAbsoluteFile() : null;
    }

    public void close() throws IOException {
        if (this.closeCache) {
            this.cache.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File resolveFile(String fileName) {
        File file = new File(fileName);
        if (this.cwd != null && !file.isAbsolute()) {
            file = new File(this.cwd, fileName);
        }
        if (this.cache == null) {
            return file;
        }
        FileCache fileCache = this.cache;
        synchronized (fileCache) {
            if (!file.exists()) {
                URL url;
                URL directoryContents;
                String parentFileName;
                File cacheFile = this.cache.getFile(fileName);
                if (this.enableCaching && cacheFile.exists()) {
                    return cacheFile;
                }
                ClassLoader cl = this.getClassLoader();
                if (NON_UNIX_FILE_SEP) {
                    fileName = fileName.replace(FILE_SEP, "/");
                }
                if ((parentFileName = file.getParent()) != null && (directoryContents = FileResolver.getValidClassLoaderResource(cl, parentFileName)) != null) {
                    this.unpackUrlResource(directoryContents, parentFileName, cl, true);
                }
                if ((url = FileResolver.getValidClassLoaderResource(cl, fileName)) != null) {
                    return this.unpackUrlResource(url, fileName, cl, false);
                }
            }
        }
        return file;
    }

    private static boolean isValidCachePath(String fileName) {
        int len = fileName.length();
        for (int i = 0; i < len; ++i) {
            char c = fileName.charAt(i);
            if (CACHE_PATH_CHECKER.test(c)) continue;
            return false;
        }
        return true;
    }

    private static URL getValidClassLoaderResource(ClassLoader cl, String fileName) {
        URL resource = cl.getResource(fileName);
        if (resource != null && !FileResolver.isValidCachePath(fileName)) {
            return null;
        }
        return resource;
    }

    private File unpackUrlResource(URL url, String fileName, ClassLoader cl, boolean isDir) {
        String prot;
        switch (prot = url.getProtocol()) {
            case "file": {
                return this.unpackFromFileURL(url, fileName, cl);
            }
            case "jar": {
                return this.unpackFromJarURL(url, fileName, cl);
            }
            case "bundle": 
            case "bundleentry": 
            case "bundleresource": 
            case "resource": {
                return this.unpackFromBundleURL(url, isDir);
            }
        }
        throw new IllegalStateException("Invalid url protocol: " + prot);
    }

    private File unpackFromFileURL(URL url, String fileName, ClassLoader cl) {
        String[] listing;
        File cacheFile;
        File resource = new File(URIDecoder.decodeURIComponent(url.getPath(), false));
        boolean isDirectory = resource.isDirectory();
        try {
            cacheFile = this.cache.cache(fileName, resource, !this.enableCaching);
        }
        catch (IOException e) {
            throw new VertxException(e);
        }
        if (isDirectory && (listing = resource.list()) != null) {
            for (String file : listing) {
                String subResource = fileName + "/" + file;
                URL url2 = FileResolver.getValidClassLoaderResource(cl, subResource);
                if (url2 == null) {
                    throw new VertxException("Invalid resource: " + subResource);
                }
                this.unpackFromFileURL(url2, subResource, cl);
            }
        }
        return cacheFile;
    }

    private File unpackFromJarURL(URL url, String fileName, ClassLoader cl) {
        ZipFile zip = null;
        try {
            int idx2;
            String path = url.getPath();
            int idx1 = path.lastIndexOf(".jar!");
            if (idx1 == -1) {
                idx1 = path.lastIndexOf(".zip!");
            }
            if ((idx2 = path.lastIndexOf(".jar!", idx1 - 1)) == -1) {
                idx2 = path.lastIndexOf(".zip!", idx1 - 1);
            }
            if (idx2 == -1) {
                File file = new File(URIDecoder.decodeURIComponent(path.substring(5, idx1 + 4), false));
                zip = new ZipFile(file);
            } else {
                String s = path.substring(idx2 + 6, idx1 + 4);
                File file = this.resolveFile(s);
                zip = new ZipFile(file);
            }
            String inJarPath = path.substring(idx1 + 6);
            String[] parts = JAR_URL_SEP_PATTERN.split(inJarPath);
            StringBuilder prefixBuilder = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                prefixBuilder.append(parts[i]).append("/");
            }
            String prefix = prefixBuilder.toString();
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String p;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(prefix.isEmpty() ? fileName : prefix + fileName)) continue;
                String string = p = prefix.isEmpty() ? name : name.substring(prefix.length());
                if (name.endsWith("/")) {
                    this.cache.cacheDir(p);
                    continue;
                }
                InputStream is = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    this.cache.cacheFile(p, is, !this.enableCaching);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            this.closeQuietly(zip);
        }
        catch (IOException e) {
            try {
                throw new VertxException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(zip);
                throw throwable;
            }
        }
        return this.cache.getFile(fileName);
    }

    private void closeQuietly(Closeable zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isBundleUrlDirectory(URL url) {
        return url.toExternalForm().endsWith("/") || FileResolver.getValidClassLoaderResource(this.getClassLoader(), url.getPath().substring(1) + "/") != null;
    }

    private File unpackFromBundleURL(URL url, boolean isDir) {
        String file;
        block15: {
            file = url.getHost() + File.separator + url.getFile();
            try {
                if (this.getClassLoader() != null && this.isBundleUrlDirectory(url) || isDir) {
                    this.cache.cacheDir(file);
                    break block15;
                }
                try (InputStream is = url.openStream();){
                    this.cache.cacheFile(file, is, !this.enableCaching);
                }
            }
            catch (IOException e) {
                throw new VertxException(e);
            }
        }
        return this.cache.getFile(file);
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }
}

