/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.HttpServerConnectionHandler;
import io.vertx.core.http.impl.HttpServerWorker;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.TCPServerBase;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.streams.ReadStream;
import java.util.List;

public class HttpServerImpl
extends TCPServerBase
implements HttpServer,
Closeable,
MetricsProvider {
    static final Logger log = LoggerFactory.getLogger(HttpServerImpl.class);
    private static final Handler<Throwable> DEFAULT_EXCEPTION_HANDLER = t -> log.trace("Connection failure", (Throwable)t);
    private static final String FLASH_POLICY_HANDLER_PROP_NAME = "vertx.flashPolicyHandler";
    private static final String DISABLE_WEBSOCKETS_PROP_NAME = "vertx.disableWebsockets";
    private static final String DISABLE_H2C_PROP_NAME = "vertx.disableH2c";
    static final boolean USE_FLASH_POLICY_HANDLER = Boolean.getBoolean("vertx.flashPolicyHandler");
    static final boolean DISABLE_WEBSOCKETS = Boolean.getBoolean("vertx.disableWebsockets");
    final HttpServerOptions options;
    private final boolean disableH2c;
    private final HttpStreamHandler<ServerWebSocket> wsStream = new HttpStreamHandler();
    private final HttpStreamHandler<HttpServerRequest> requestStream = new HttpStreamHandler();
    private Handler<HttpConnection> connectionHandler;
    private Handler<Throwable> exceptionHandler;

    public HttpServerImpl(VertxInternal vertx, HttpServerOptions options) {
        super(vertx, options);
        this.options = new HttpServerOptions(options);
        this.disableH2c = Boolean.getBoolean(DISABLE_H2C_PROP_NAME) || options.isSsl();
    }

    @Override
    protected TCPMetrics<?> createMetrics(SocketAddress localAddress) {
        VertxMetrics vertxMetrics = this.vertx.metricsSPI();
        if (vertxMetrics != null) {
            return vertxMetrics.createHttpServerMetrics(this.options, localAddress);
        }
        return null;
    }

    @Override
    public synchronized HttpServer requestHandler(Handler<HttpServerRequest> handler) {
        this.requestStream.handler(handler);
        return this;
    }

    @Override
    public ReadStream<HttpServerRequest> requestStream() {
        return this.requestStream;
    }

    @Override
    public HttpServer webSocketHandler(Handler<ServerWebSocket> handler) {
        this.webSocketStream().handler(handler);
        return this;
    }

    @Override
    public Handler<HttpServerRequest> requestHandler() {
        return this.requestStream.handler();
    }

    @Override
    public synchronized HttpServer connectionHandler(Handler<HttpConnection> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.connectionHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServer exceptionHandler(Handler<Throwable> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<ServerWebSocket> webSocketHandler() {
        return this.wsStream.handler();
    }

    @Override
    public ReadStream<ServerWebSocket> webSocketStream() {
        return this.wsStream;
    }

    @Override
    public Future<HttpServer> listen() {
        return this.listen(this.options.getPort(), this.options.getHost());
    }

    @Override
    public HttpServer listen(Handler<AsyncResult<HttpServer>> listenHandler) {
        Future<HttpServer> fut = this.listen();
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    @Override
    public Future<HttpServer> listen(int port, String host) {
        return this.listen(SocketAddress.inetSocketAddress(port, host));
    }

    @Override
    public HttpServer listen(int port, String host, Handler<AsyncResult<HttpServer>> listenHandler) {
        Future<HttpServer> fut = this.listen(port, host);
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    @Override
    public Future<HttpServer> listen(int port) {
        return this.listen(port, "0.0.0.0");
    }

    @Override
    public HttpServer listen(int port, Handler<AsyncResult<HttpServer>> listenHandler) {
        Future<HttpServer> fut = this.listen(port);
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    private Handler<Channel> childHandler(ContextInternal context, HttpServerConnectionHandler handlers, Handler<Throwable> exceptionHandler, SocketAddress address, String serverOrigin) {
        return new HttpServerWorker(context, this, this.vertx, this.sslHelper, this.options, serverOrigin, this.disableH2c, handlers, handlers.exceptionHandler);
    }

    @Override
    public Future<HttpServer> listen(SocketAddress address) {
        if (this.requestStream.handler() == null && this.wsStream.handler() == null) {
            throw new IllegalStateException("Set request or WebSocket handler first");
        }
        ContextInternal listenContext = this.vertx.getOrCreateContext();
        String host = address.isInetSocket() ? address.host() : "localhost";
        int port = address.port();
        List<HttpVersion> applicationProtocols = this.options.getAlpnVersions();
        this.sslHelper.setApplicationProtocols(applicationProtocols);
        String serverOrigin = (this.options.isSsl() ? "https" : "http") + "://" + host + ":" + port;
        HttpServerConnectionHandler hello = new HttpServerConnectionHandler(this, ((HttpStreamHandler)this.requestStream).handler, ((HttpStreamHandler)this.wsStream).handler, this.connectionHandler, this.exceptionHandler == null ? DEFAULT_EXCEPTION_HANDLER : this.exceptionHandler);
        Handler<Channel> channelHandler = this.childHandler(listenContext, hello, this.exceptionHandler, address, serverOrigin);
        io.netty.util.concurrent.Future<Channel> bindFuture = this.listen(address, listenContext, channelHandler);
        PromiseInternal promise = listenContext.promise();
        bindFuture.addListener(res -> {
            if (res.isSuccess()) {
                promise.complete(this);
            } else {
                promise.fail(res.cause());
            }
        });
        return promise.future();
    }

    @Override
    public HttpServer listen(SocketAddress address, Handler<AsyncResult<HttpServer>> listenHandler) {
        if (listenHandler == null) {
            listenHandler = res -> {
                if (res.failed()) {
                    log.error("Failed to listen", res.cause());
                }
            };
        }
        this.listen(address).onComplete(listenHandler);
        return this;
    }

    @Override
    public Future<Void> close() {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = context.promise();
        this.close((Promise<Void>)promise);
        return promise.future();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> done) {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = context.promise();
        this.close((Promise<Void>)promise);
        if (done != null) {
            promise.future().onComplete(done);
        }
    }

    @Override
    public synchronized void close(Promise<Void> completion) {
        if (this.wsStream.endHandler() != null || this.requestStream.endHandler() != null) {
            Handler<Void> wsEndHandler = this.wsStream.endHandler();
            this.wsStream.endHandler(null);
            Handler<Void> requestEndHandler = this.requestStream.endHandler();
            this.requestStream.endHandler(null);
            completion.future().onComplete(ar -> {
                if (wsEndHandler != null) {
                    wsEndHandler.handle(null);
                }
                if (requestEndHandler != null) {
                    requestEndHandler.handle(null);
                }
            });
        }
        super.close(completion);
    }

    public boolean isClosed() {
        return !this.isListening();
    }

    public SSLHelper getSslHelper() {
        return this.sslHelper;
    }

    boolean requestAccept() {
        return this.requestStream.accept();
    }

    boolean wsAccept() {
        return this.wsStream.accept();
    }

    class HttpStreamHandler<C extends ReadStream<Buffer>>
    implements ReadStream<C> {
        private Handler<C> handler;
        private long demand = Long.MAX_VALUE;
        private Handler<Void> endHandler;

        HttpStreamHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<C> handler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.handler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean accept() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                boolean accept;
                boolean bl = accept = this.demand > 0L;
                if (accept && this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                return accept;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<Void> endHandler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.endHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream handler(Handler<C> handler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                if (HttpServerImpl.this.isListening()) {
                    throw new IllegalStateException("Please set handler before server is listening");
                }
                this.handler = handler;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream pause() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.demand = 0L;
                return this;
            }
        }

        @Override
        public ReadStream fetch(long amount) {
            if (amount > 0L) {
                this.demand += amount;
                if (this.demand < 0L) {
                    this.demand = Long.MAX_VALUE;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream resume() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.demand = Long.MAX_VALUE;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream endHandler(Handler<Void> endHandler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.endHandler = endHandler;
                return this;
            }
        }

        @Override
        public ReadStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }
}

