/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.ServiceHelper;
import io.vertx.test.spi.FakeFactory;
import io.vertx.test.spi.NotImplementedSPI;
import io.vertx.test.spi.SomeFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ServiceHelperTest {
    @Before
    public void setUp() throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        File output = new File("target/externals");
        output.mkdirs();
        fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singletonList(output));
        ArrayList<File> classesToCompile = new ArrayList<File>();
        classesToCompile.add(new File("src/test/classpath/servicehelper/SomeFactoryImplA.java"));
        Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(classesToCompile);
        compiler.getTask(null, fileManager, null, null, null, compilationUnits1).call();
        File source = new File("src/test/classpath/servicehelper/META-INF/services/io.vertx.test.spi.SomeFactory");
        File out = new File("target/externals/META-INF/services/io.vertx.test.spi.SomeFactory");
        out.getParentFile().mkdirs();
        Files.copy(source.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    @Test
    public void loadFactory() throws Exception {
        FakeFactory factory = (FakeFactory)ServiceHelper.loadFactory(FakeFactory.class);
        Assertions.assertThat((Object)factory.classloader()).isEqualTo((Object)ServiceHelperTest.class.getClassLoader());
    }

    @Test(expected=IllegalStateException.class)
    public void loadNotImplementedSPI() throws Exception {
        ServiceHelper.loadFactory(NotImplementedSPI.class);
    }

    @Test
    public void loadFactoryOrNull() throws Exception {
        NotImplementedSPI factory = (NotImplementedSPI)ServiceHelper.loadFactoryOrNull(NotImplementedSPI.class);
        Assertions.assertThat((Object)factory).isNull();
        FakeFactory fake = (FakeFactory)ServiceHelper.loadFactoryOrNull(FakeFactory.class);
        Assertions.assertThat((Object)fake).isNotNull();
        Assertions.assertThat((Object)fake.classloader()).isEqualTo((Object)ServiceHelperTest.class.getClassLoader());
    }

    @Test
    public void loadFactories() throws Exception {
        Collection factories = ServiceHelper.loadFactories(FakeFactory.class);
        Assertions.assertThat((Iterable)factories).isNotNull().hasSize(2);
        Collection impl = ServiceHelper.loadFactories(NotImplementedSPI.class);
        Assertions.assertThat((Iterable)impl).isNotNull().hasSize(0);
    }

    @Test
    public void loadFactoriesWithClassloader() throws Exception {
        URLClassLoader custom = new URLClassLoader(new URL[]{new File("target/externals").toURI().toURL()});
        Collection factories = ServiceHelper.loadFactories(SomeFactory.class);
        Assertions.assertThat((Iterable)factories).isNotNull().hasSize(0);
        factories = ServiceHelper.loadFactories(SomeFactory.class, (ClassLoader)custom);
        Assertions.assertThat((Iterable)factories).isNotNull().hasSize(1);
        Assertions.assertThat((Object)((SomeFactory)factories.iterator().next()).classloader()).isEqualTo((Object)custom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loadFactoriesFromTCCL() throws Exception {
        URLClassLoader custom = new URLClassLoader(new URL[]{new File("target/externals").toURI().toURL()});
        Collection factories = ServiceHelper.loadFactories(SomeFactory.class);
        Assertions.assertThat((Iterable)factories).isNotNull().hasSize(0);
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(custom);
            factories = ServiceHelper.loadFactories(SomeFactory.class);
            Assertions.assertThat((Iterable)factories).isNotNull().hasSize(1);
            Assertions.assertThat((Object)((SomeFactory)factories.iterator().next()).classloader()).isEqualTo((Object)custom);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    @Test
    public void loadFactoriesWithVertxClassloader() throws Exception {
        URLClassLoader custom = new URLClassLoader(new URL[]{new File("target/classes").toURI().toURL(), new File("target/test-classes").toURI().toURL(), new File("target/externals").toURI().toURL()}, null);
        Class<?> serviceHelperClass = custom.loadClass(ServiceHelper.class.getName());
        Class<?> someFactoryClass = custom.loadClass(SomeFactory.class.getName());
        Assertions.assertThat((Object)serviceHelperClass.getClassLoader()).isEqualTo((Object)custom);
        Assertions.assertThat((Object)someFactoryClass.getClassLoader()).isEqualTo((Object)custom);
        Method method = serviceHelperClass.getMethod("loadFactories", Class.class);
        Collection collection = (Collection)method.invoke(null, someFactoryClass);
        Assertions.assertThat((Iterable)collection).hasSize(1);
    }
}

