/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.impl.AddressResolver;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakedns.FakeDNSServer;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class HostnameResolutionTest
extends VertxTestBase {
    private FakeDNSServer dnsServer;
    private InetSocketAddress dnsServerAddress;

    @Override
    public void setUp() throws Exception {
        this.dnsServer = new FakeDNSServer().testResolveASameServer("127.0.0.1");
        this.dnsServer.start();
        this.dnsServerAddress = this.dnsServer.localAddress();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.dnsServer.stop();
        super.tearDown();
    }

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort());
        return options;
    }

    @Test
    public void testAsyncResolve() throws Exception {
        ((VertxImpl)this.vertx).resolveAddress("vertx.io", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.1", resolved.getHostAddress());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testAsyncResolveFail() throws Exception {
        ((VertxImpl)this.vertx).resolveAddress("vertx.com", this.onFailure(failure -> {
            this.assertTrue("Was expecting " + failure + " to be an instanceof UnknownHostException", failure instanceof UnknownHostException);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testNet() throws Exception {
        this.testNet("vertx.io");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNet(String hostname) throws Exception {
        NetClient client = this.vertx.createNetClient();
        NetServer server = this.vertx.createNetServer().connectHandler(so -> so.handler(buff -> {
            so.write(buff);
            so.close();
        }));
        try {
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(1234, hostname, this.onSuccess(s -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            client.connect(1234, hostname, this.onSuccess(so -> {
                Buffer buffer = Buffer.buffer();
                so.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
                so.closeHandler(v -> {
                    this.assertEquals(Buffer.buffer((String)"foo"), buffer);
                    this.testComplete();
                });
                so.write((Object)Buffer.buffer((String)"foo"));
            }));
            this.await();
        }
        finally {
            client.close();
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttp() throws Exception {
        HttpClient client = this.vertx.createHttpClient();
        HttpServer server = this.vertx.createHttpServer().requestHandler(req -> req.response().end("foo"));
        try {
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(8080, "vertx.io", this.onSuccess(s -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            client.request(HttpMethod.GET, 8080, "vertx.io", "/somepath", this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                Buffer buffer = Buffer.buffer();
                resp.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
                resp.endHandler(v -> {
                    this.assertEquals(Buffer.buffer((String)"foo"), buffer);
                    this.testComplete();
                });
            }))));
            this.await();
        }
        finally {
            client.close();
            server.close();
        }
    }

    @Test
    public void testOptions() {
        AddressResolverOptions options = new AddressResolverOptions();
        this.assertEquals(false, options.isOptResourceEnabled());
        this.assertEquals(AddressResolverOptions.DEFAULT_SERVERS, options.getServers());
        this.assertEquals(0L, options.getCacheMinTimeToLive());
        this.assertEquals(Integer.MAX_VALUE, options.getCacheMaxTimeToLive());
        this.assertEquals(0L, options.getCacheNegativeTimeToLive());
        this.assertEquals(5000L, options.getQueryTimeout());
        this.assertEquals(4L, options.getMaxQueries());
        this.assertEquals(true, options.getRdFlag());
        this.assertEquals(AddressResolverOptions.DEFAULT_NDOTS, options.getNdots());
        this.assertEquals(AddressResolverOptions.DEFAULT_SEACH_DOMAINS, options.getSearchDomains());
        boolean optResourceEnabled = TestUtils.randomBoolean();
        List<String> servers = Arrays.asList("1.2.3.4", "5.6.7.8");
        int minTTL = TestUtils.randomPositiveInt();
        int maxTTL = minTTL + 1000;
        int negativeTTL = TestUtils.randomPositiveInt();
        int queryTimeout = 1 + TestUtils.randomPositiveInt();
        int maxQueries = 1 + TestUtils.randomPositiveInt();
        boolean rdFlag = TestUtils.randomBoolean();
        int ndots = TestUtils.randomPositiveInt() - 2;
        ArrayList<String> searchDomains = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            searchDomains.add(TestUtils.randomAlphaString(15));
        }
        this.assertSame(options, options.setOptResourceEnabled(optResourceEnabled));
        this.assertSame(options, options.setServers(new ArrayList<String>(servers)));
        this.assertSame(options, options.setCacheMinTimeToLive(0));
        this.assertSame(options, options.setCacheMinTimeToLive(minTTL));
        try {
            options.setCacheMinTimeToLive(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertSame(options, options.setCacheMaxTimeToLive(0));
        this.assertSame(options, options.setCacheMaxTimeToLive(maxTTL));
        try {
            options.setCacheMaxTimeToLive(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertSame(options, options.setCacheNegativeTimeToLive(0));
        this.assertSame(options, options.setCacheNegativeTimeToLive(negativeTTL));
        try {
            options.setCacheNegativeTimeToLive(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertSame(options, options.setQueryTimeout((long)queryTimeout));
        try {
            options.setQueryTimeout(0L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertSame(options, options.setMaxQueries(maxQueries));
        try {
            options.setMaxQueries(0);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertSame(options, options.setRdFlag(rdFlag));
        this.assertSame(options, options.setSearchDomains(searchDomains));
        this.assertSame(options, options.setNdots(ndots));
        try {
            options.setNdots(-2);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertEquals(optResourceEnabled, options.isOptResourceEnabled());
        this.assertEquals(servers, options.getServers());
        this.assertEquals(minTTL, options.getCacheMinTimeToLive());
        this.assertEquals(maxTTL, options.getCacheMaxTimeToLive());
        this.assertEquals(negativeTTL, options.getCacheNegativeTimeToLive());
        this.assertEquals(queryTimeout, options.getQueryTimeout());
        this.assertEquals(maxQueries, options.getMaxQueries());
        this.assertEquals(rdFlag, options.getRdFlag());
        this.assertEquals(ndots, options.getNdots());
        this.assertEquals(searchDomains, options.getSearchDomains());
        AddressResolverOptions copy = new AddressResolverOptions(options);
        AddressResolverOptions jsonCopy = new AddressResolverOptions(options.toJson());
        options.setOptResourceEnabled(false);
        options.getServers().clear();
        options.setCacheMinTimeToLive(0);
        options.setCacheMaxTimeToLive(Integer.MAX_VALUE);
        options.setCacheNegativeTimeToLive(0);
        options.setQueryTimeout(5000L);
        options.setMaxQueries(4);
        options.setRdFlag(true);
        options.setNdots(AddressResolverOptions.DEFAULT_NDOTS);
        options.setSearchDomains(AddressResolverOptions.DEFAULT_SEACH_DOMAINS);
        this.assertEquals(optResourceEnabled, copy.isOptResourceEnabled());
        this.assertEquals(servers, copy.getServers());
        this.assertEquals(minTTL, copy.getCacheMinTimeToLive());
        this.assertEquals(maxTTL, copy.getCacheMaxTimeToLive());
        this.assertEquals(negativeTTL, copy.getCacheNegativeTimeToLive());
        this.assertEquals(queryTimeout, copy.getQueryTimeout());
        this.assertEquals(maxQueries, copy.getMaxQueries());
        this.assertEquals(rdFlag, copy.getRdFlag());
        this.assertEquals(ndots, copy.getNdots());
        this.assertEquals(searchDomains, copy.getSearchDomains());
        this.assertEquals(optResourceEnabled, jsonCopy.isOptResourceEnabled());
        this.assertEquals(servers, jsonCopy.getServers());
        this.assertEquals(minTTL, jsonCopy.getCacheMinTimeToLive());
        this.assertEquals(maxTTL, jsonCopy.getCacheMaxTimeToLive());
        this.assertEquals(negativeTTL, jsonCopy.getCacheNegativeTimeToLive());
        this.assertEquals(queryTimeout, jsonCopy.getQueryTimeout());
        this.assertEquals(maxQueries, jsonCopy.getMaxQueries());
        this.assertEquals(rdFlag, jsonCopy.getRdFlag());
        this.assertEquals(ndots, jsonCopy.getNdots());
        this.assertEquals(searchDomains, jsonCopy.getSearchDomains());
    }

    @Test
    public void testDefaultJsonOptions() {
        AddressResolverOptions options = new AddressResolverOptions(new JsonObject());
        this.assertEquals(false, options.isOptResourceEnabled());
        this.assertEquals(AddressResolverOptions.DEFAULT_SERVERS, options.getServers());
        this.assertEquals(0L, options.getCacheMinTimeToLive());
        this.assertEquals(Integer.MAX_VALUE, options.getCacheMaxTimeToLive());
        this.assertEquals(0L, options.getCacheNegativeTimeToLive());
        this.assertEquals(5000L, options.getQueryTimeout());
        this.assertEquals(4L, options.getMaxQueries());
        this.assertEquals(true, options.getRdFlag());
        this.assertEquals(AddressResolverOptions.DEFAULT_SEACH_DOMAINS, options.getSearchDomains());
        this.assertEquals(AddressResolverOptions.DEFAULT_NDOTS, options.getNdots());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncResolveConnectIsNotifiedOnChannelEventLoop() throws Exception {
        CountDownLatch listenLatch = new CountDownLatch(1);
        try (NetServer server = this.vertx.createNetServer().connectHandler(so -> {});){
            server.listen(1234, "localhost", this.onSuccess(v -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            final AtomicReference channelThread = new AtomicReference();
            final CountDownLatch connectLatch = new CountDownLatch(1);
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.channelFactory(((VertxInternal)this.vertx).transport().channelFactory(false));
            bootstrap.group(this.vertx.nettyEventLoopGroup());
            bootstrap.resolver(((VertxInternal)this.vertx).nettyAddressResolverGroup());
            bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    channelThread.set(Thread.currentThread());
                    connectLatch.countDown();
                }
            });
            ChannelFuture channelFut = bootstrap.connect("localhost", 1234);
            this.awaitLatch(connectLatch);
            channelFut.addListener(v -> {
                this.assertTrue(v.isSuccess());
                this.assertEquals(channelThread.get(), Thread.currentThread());
                this.testComplete();
            });
            this.await();
        }
    }

    @Test
    public void testInvalidHostsConfig() {
        try {
            AddressResolverOptions options = new AddressResolverOptions().setHostsPath("whatever.txt");
            this.vertx(new VertxOptions().setAddressResolverOptions(options));
            this.fail();
        }
        catch (VertxException vertxException) {
            // empty catch block
        }
    }

    @Test
    public void testResolveFromClasspath() {
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsPath("hosts_config.txt")));
        vertx.resolveAddress("server.net", this.onSuccess(addr -> {
            this.assertEquals("192.168.0.15", addr.getHostAddress());
            this.assertEquals("server.net", addr.getHostName());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testResolveFromFile() {
        File f = new File(new File(new File(new File("src"), "test"), "resources"), "hosts_config.txt");
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsPath(f.getAbsolutePath())));
        vertx.resolveAddress("server.net", this.onSuccess(addr -> {
            this.assertEquals("192.168.0.15", addr.getHostAddress());
            this.assertEquals("server.net", addr.getHostName());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testResolveFromBuffer() {
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsValue(Buffer.buffer((String)"192.168.0.15 server.net"))));
        vertx.resolveAddress("server.net", this.onSuccess(addr -> {
            this.assertEquals("192.168.0.15", addr.getHostAddress());
            this.assertEquals("server.net", addr.getHostName());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCaseInsensitiveResolveFromHosts() {
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsPath("hosts_config.txt")));
        vertx.resolveAddress("SERVER.NET", this.onSuccess(addr -> {
            this.assertEquals("192.168.0.15", addr.getHostAddress());
            this.assertEquals("server.net", addr.getHostName());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testTrailingDotResolveFromHosts() {
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsPath("hosts_config.txt")));
        vertx.resolveAddress("server.net.", this.onSuccess(addr -> {
            this.assertEquals("192.168.0.15", addr.getHostAddress());
            this.assertEquals("server.net", addr.getHostName());
            this.testComplete();
        }));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveMissingLocalhost() throws Exception {
        InetAddress localhost = InetAddress.getByName("localhost");
        this.dnsServer.testResolveASameServer("127.0.0.1");
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort()).setOptResourceEnabled(false)));
        CompletableFuture test1 = new CompletableFuture();
        vertx.resolveAddress("localhost", ar -> {
            if (ar.succeeded()) {
                InetAddress resolved = (InetAddress)ar.result();
                if (resolved.equals(localhost)) {
                    test1.complete(null);
                } else {
                    test1.completeExceptionally((Throwable)((Object)new AssertionError((Object)("Unexpected localhost value " + resolved))));
                }
            } else {
                test1.completeExceptionally(ar.cause());
            }
        });
        test1.get(10L, TimeUnit.SECONDS);
        CompletableFuture test2 = new CompletableFuture();
        vertx.resolveAddress("LOCALHOST", ar -> {
            if (ar.succeeded()) {
                InetAddress resolved = (InetAddress)ar.result();
                if (resolved.equals(localhost)) {
                    test2.complete(null);
                } else {
                    test2.completeExceptionally((Throwable)((Object)new AssertionError((Object)("Unexpected localhost value " + resolved))));
                }
            } else {
                test2.completeExceptionally(ar.cause());
            }
        });
        test2.get(10L, TimeUnit.SECONDS);
        CompletableFuture test3 = new CompletableFuture();
        try (NetServer server = vertx.createNetServer(new NetServerOptions().setPort(1234).setHost(localhost.getHostAddress()));){
            server.connectHandler(so -> so.end((Object)Buffer.buffer((String)"hello")));
            server.listen(ar -> {
                if (ar.succeeded()) {
                    test3.complete(null);
                } else {
                    test3.completeExceptionally(ar.cause());
                }
            });
            test3.get(10L, TimeUnit.SECONDS);
            CompletableFuture test4 = new CompletableFuture();
            NetClient client = vertx.createNetClient();
            client.connect(1234, "localhost", ar -> {
                if (ar.succeeded()) {
                    test4.complete(null);
                } else {
                    test4.completeExceptionally(ar.cause());
                }
            });
            test4.get(10L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testSearchDomain() throws Exception {
        String addr_host1_foo_com = "127.0.0.1";
        String addr_host1 = "127.0.0.2";
        String addr_host3 = "127.0.0.3";
        String addr_host4_sub_foo_com = "127.0.0.4";
        String addr_host5_sub_foo_com = "127.0.0.5";
        String addr_host5_sub = "127.0.0.6";
        String addr_host6_sub_sub_foo_com = "127.0.0.7";
        String addr_host7_sub_sub_foo_com = "127.0.0.8";
        String addr_host7_sub_sub = "127.0.0.9";
        HashMap<String, String> records = new HashMap<String, String>();
        records.put("host1.foo.com", addr_host1_foo_com);
        records.put("host1", addr_host1);
        records.put("host3", addr_host3);
        records.put("host4.sub.foo.com", addr_host4_sub_foo_com);
        records.put("host5.sub.foo.com", addr_host5_sub_foo_com);
        records.put("host5.sub", addr_host5_sub);
        records.put("host6.sub.sub.foo.com", addr_host6_sub_sub_foo_com);
        records.put("host7.sub.sub.foo.com", addr_host7_sub_sub_foo_com);
        records.put("host7.sub.sub", addr_host7_sub_sub);
        this.dnsServer.testResolveA(records);
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort()).setOptResourceEnabled(false).setNdots(2).addSearchDomain("foo.com")));
        CountDownLatch latch1 = new CountDownLatch(1);
        vertx.resolveAddress("host1", this.onSuccess(resolved -> {
            this.assertEquals(addr_host1_foo_com, resolved.getHostAddress());
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        vertx.resolveAddress("host1.", this.onSuccess(resolved -> {
            this.assertEquals(addr_host1, resolved.getHostAddress());
            latch2.countDown();
        }));
        this.awaitLatch(latch2);
        CountDownLatch latch3 = new CountDownLatch(1);
        vertx.resolveAddress("host2", this.onFailure(cause -> {
            this.assertTrue(cause instanceof UnknownHostException);
            latch3.countDown();
        }));
        this.awaitLatch(latch3);
        CountDownLatch latch4 = new CountDownLatch(1);
        vertx.resolveAddress("host3", this.onSuccess(cause -> {
            this.assertEquals(addr_host3, cause.getHostAddress());
            latch4.countDown();
        }));
        this.awaitLatch(latch4);
        CountDownLatch latch5 = new CountDownLatch(1);
        vertx.resolveAddress("host3.", this.onSuccess(resolved -> {
            this.assertEquals(addr_host3, resolved.getHostAddress());
            latch5.countDown();
        }));
        this.awaitLatch(latch5);
        CountDownLatch latch6 = new CountDownLatch(1);
        vertx.resolveAddress("host4.sub", this.onSuccess(resolved -> {
            this.assertEquals(addr_host4_sub_foo_com, resolved.getHostAddress());
            latch6.countDown();
        }));
        this.awaitLatch(latch6);
        CountDownLatch latch7 = new CountDownLatch(1);
        vertx.resolveAddress("host5.sub", this.onSuccess(resolved -> {
            this.assertEquals(addr_host5_sub_foo_com, resolved.getHostAddress());
            latch7.countDown();
        }));
        this.awaitLatch(latch7);
        CountDownLatch latch8 = new CountDownLatch(1);
        vertx.resolveAddress("host6.sub.sub", this.onSuccess(resolved -> {
            this.assertEquals(addr_host6_sub_sub_foo_com, resolved.getHostAddress());
            latch8.countDown();
        }));
        this.awaitLatch(latch8);
        CountDownLatch latch9 = new CountDownLatch(1);
        vertx.resolveAddress("host7.sub.sub", this.onSuccess(resolved -> {
            this.assertEquals(addr_host7_sub_sub, resolved.getHostAddress());
            latch9.countDown();
        }));
        this.awaitLatch(latch9);
    }

    @Test
    public void testMultipleSearchDomain() throws Exception {
        HashMap<String, String> records = new HashMap<String, String>();
        records.put("host1.foo.com", "127.0.0.1");
        records.put("host2.bar.com", "127.0.0.2");
        records.put("host3.bar.com", "127.0.0.3");
        records.put("host3.foo.com", "127.0.0.4");
        this.dnsServer.testResolveA(records);
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsValue(Buffer.buffer()).setNdots(1).addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort()).setOptResourceEnabled(false).addSearchDomain("foo.com").addSearchDomain("bar.com")));
        CountDownLatch latch1 = new CountDownLatch(1);
        vertx.resolveAddress("host1", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.1", resolved.getHostAddress());
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        vertx.resolveAddress("host2", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.2", resolved.getHostAddress());
            latch2.countDown();
        }));
        this.awaitLatch(latch2);
        CountDownLatch latch3 = new CountDownLatch(1);
        vertx.resolveAddress("host3", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.4", resolved.getHostAddress());
            latch3.countDown();
        }));
        this.awaitLatch(latch3);
        vertx.resolveAddress("host4", this.onFailure(cause -> {
            this.assertTrue(cause instanceof UnknownHostException);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSearchDomainWithNdots2() throws Exception {
        HashMap<String, String> records = new HashMap<String, String>();
        records.put("host1.sub.foo.com", "127.0.0.1");
        records.put("host2.sub.foo.com", "127.0.0.2");
        records.put("host2.sub", "127.0.0.3");
        this.dnsServer.testResolveA(records);
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort()).setOptResourceEnabled(false).addSearchDomain("foo.com").setNdots(2)));
        CountDownLatch latch1 = new CountDownLatch(1);
        vertx.resolveAddress("host1.sub", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.1", resolved.getHostAddress());
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        vertx.resolveAddress("host2.sub", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.2", resolved.getHostAddress());
            latch2.countDown();
        }));
        this.awaitLatch(latch2);
    }

    @Test
    public void testSearchDomainWithNdots0() throws Exception {
        HashMap<String, String> records = new HashMap<String, String>();
        records.put("host1", "127.0.0.2");
        records.put("host1.foo.com", "127.0.0.3");
        this.dnsServer.testResolveA(records);
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort()).setOptResourceEnabled(false).addSearchDomain("foo.com").setNdots(0)));
        CountDownLatch latch1 = new CountDownLatch(1);
        vertx.resolveAddress("host1", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.2", resolved.getHostAddress());
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        vertx.resolveAddress("host1.foo.com", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.3", resolved.getHostAddress());
            latch2.countDown();
        }));
        this.awaitLatch(latch2);
    }

    @Test
    public void testNetSearchDomain() throws Exception {
        HashMap<String, String> records = new HashMap<String, String>();
        records.put("host1.foo.com", "127.0.0.1");
        this.dnsServer.testResolveA(records);
        this.vertx.close();
        this.vertx = this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsValue(Buffer.buffer()).setNdots(1).addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort()).setOptResourceEnabled(false).addSearchDomain("foo.com")));
        this.testNet("host1");
    }

    @Test
    public void testParseResolvConf() {
        this.assertEquals(-1L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots: 4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"\noptions ndots: 4"));
        this.assertEquals(-1L, AddressResolver.parseNdotsOptionFromResolvConf((String)"boptions ndots: 4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)" options ndots: 4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"\toptions ndots: 4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"\foptions ndots: 4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"\n options ndots: 4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options\tndots: 4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options\fndots: 4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options  ndots: 4"));
        this.assertEquals(-1L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options\nndots: 4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:\t4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:  4"));
        this.assertEquals(-1L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:\n4"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:4 "));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:4\t"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:4\f"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:4\n"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:4\r"));
        this.assertEquals(-1L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:4_"));
        this.assertEquals(2L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:4\noptions ndots:2"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options ndots:4 debug"));
        this.assertEquals(4L, AddressResolver.parseNdotsOptionFromResolvConf((String)"options debug ndots:4"));
        this.assertEquals(false, AddressResolver.parseRotateOptionFromResolvConf((String)"options"));
        this.assertEquals(true, AddressResolver.parseRotateOptionFromResolvConf((String)"options rotate"));
        this.assertEquals(true, AddressResolver.parseRotateOptionFromResolvConf((String)"options rotate\n"));
        this.assertEquals(false, AddressResolver.parseRotateOptionFromResolvConf((String)"options\nrotate"));
    }

    @Test
    public void testResolveLocalhost() {
        AddressResolver resolver = new AddressResolver((Vertx)((VertxImpl)this.vertx), new AddressResolverOptions());
        resolver.resolveHostname("LOCALHOST", res -> {
            if (res.succeeded()) {
                this.assertEquals("localhost", ((InetAddress)res.result()).getHostName().toLowerCase(Locale.ENGLISH));
                resolver.resolveHostname("LocalHost", res2 -> {
                    if (res2.succeeded()) {
                        this.assertEquals("localhost", ((InetAddress)res2.result()).getHostName().toLowerCase(Locale.ENGLISH));
                        resolver.resolveHostname("localhost", res3 -> {
                            if (res3.succeeded()) {
                                this.assertEquals("localhost", ((InetAddress)res3.result()).getHostName().toLowerCase(Locale.ENGLISH));
                                this.testComplete();
                            } else {
                                this.fail(res3.cause());
                            }
                        });
                    } else {
                        this.fail(res2.cause());
                    }
                });
            } else {
                this.fail(res.cause());
            }
        });
        this.await();
    }

    @Test
    public void testRotationalServerSelection() throws Exception {
        this.testServerSelection(true, false);
    }

    @Test
    public void testRotationalServerSelectionWithCache() throws Exception {
        this.testServerSelection(true, true);
    }

    @Test
    public void testFirstServerSelection() throws Exception {
        this.testServerSelection(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testServerSelection(boolean rotateServers, boolean cache) throws Exception {
        int num = VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE + 4;
        ArrayList<FakeDNSServer> dnsServers = new ArrayList<FakeDNSServer>();
        try {
            for (int index = 1; index <= num; ++index) {
                FakeDNSServer server = new FakeDNSServer().store(FakeDNSServer.A_store(Collections.singletonMap("vertx.io", "127.0.0." + index)));
                server.port(53530 + index);
                server.start();
                dnsServers.add(server);
            }
            AddressResolverOptions options = new AddressResolverOptions();
            options.setRotateServers(rotateServers);
            options.setOptResourceEnabled(false);
            if (!cache) {
                options.setCacheMaxTimeToLive(0);
            }
            for (int i = 0; i < num; ++i) {
                InetSocketAddress dnsServerAddress = ((FakeDNSServer)((Object)dnsServers.get(i))).localAddress();
                options.addServer(dnsServerAddress.getAddress().getHostAddress() + ":" + dnsServerAddress.getPort());
            }
            AddressResolver resolver = new AddressResolver(this.vertx, options);
            for (int i = 0; i < num; ++i) {
                CompletableFuture result = new CompletableFuture();
                resolver.resolveHostname("vertx.io", ar -> {
                    if (ar.succeeded()) {
                        result.complete(ar.result());
                    } else {
                        result.completeExceptionally(ar.cause());
                    }
                });
                String resolved = ((InetAddress)result.get(10L, TimeUnit.SECONDS)).getHostAddress();
                int expected = rotateServers && !cache ? 1 + i : 1;
                this.assertEquals("127.0.0." + expected, resolved);
            }
        }
        finally {
            dnsServers.forEach(FakeDNSServer::stop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerFailover() throws Exception {
        FakeDNSServer server = new FakeDNSServer().store(FakeDNSServer.A_store(Collections.singletonMap("vertx.io", "127.0.0.1"))).port(53532);
        try {
            AddressResolverOptions options = new AddressResolverOptions();
            options.setOptResourceEnabled(false);
            options.setMaxQueries(4);
            server.start();
            InetSocketAddress dnsServerAddress = server.localAddress();
            options.addServer(dnsServerAddress.getAddress().getHostAddress() + ":" + 53531);
            options.addServer(dnsServerAddress.getAddress().getHostAddress() + ":" + dnsServerAddress.getPort());
            AddressResolver resolver = new AddressResolver((Vertx)((VertxImpl)this.vertx), options);
            CompletableFuture result = new CompletableFuture();
            resolver.resolveHostname("vertx.io", ar -> {
                if (ar.succeeded()) {
                    result.complete(ar.result());
                } else {
                    result.completeExceptionally(ar.cause());
                }
            });
            String resolved = ((InetAddress)result.get(10L, TimeUnit.SECONDS)).getHostAddress();
            this.assertEquals("127.0.0.1", resolved);
        }
        finally {
            server.stop();
        }
    }
}

