/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.impl.VertxFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Test;

public class CustomNodeSelectorTest
extends VertxTestBase {
    private List<Vertx> vertices;

    @Test
    public void test() throws Exception {
        CompositeFuture startFuture = IntStream.range(0, 4).mapToObj(i -> {
            VertxOptions vertxOptions = this.getOptions();
            vertxOptions.getEventBusOptions().setClusterNodeMetadata(new JsonObject().put("rack", (Object)(i % 2 == 0 ? "foo" : "bar")));
            return vertxOptions;
        }).map(options -> {
            VertxFactory factory = new VertxFactory(options).clusterNodeSelector((NodeSelector)new CustomNodeSelector());
            Promise promise = Promise.promise();
            factory.clusteredVertx((Handler)promise);
            return promise.future();
        }).collect(Collectors.collectingAndThen(Collectors.toList(), CompositeFuture::all));
        CountDownLatch startLatch = new CountDownLatch(1);
        startFuture.onComplete(this.onSuccess(cf -> startLatch.countDown()));
        this.awaitLatch(startLatch);
        this.vertices = startFuture.list();
        ConcurrentHashMap received = new ConcurrentHashMap();
        CountDownLatch latch = new CountDownLatch(8);
        CompositeFuture cf2 = IntStream.range(0, 4).mapToObj(i -> this.vertices.get(i).eventBus().consumer("test", msg -> {
            received.merge(i, Collections.singleton(msg.body()), (s1, s2) -> Stream.concat(s1.stream(), s2.stream()).collect(Collectors.toSet()));
            latch.countDown();
        })).map(consumer -> {
            Promise promise = Promise.promise();
            consumer.completionHandler((Handler)promise);
            return promise.future();
        }).collect(Collectors.collectingAndThen(Collectors.toList(), CompositeFuture::all));
        HashMap expected = new HashMap();
        cf2.onComplete(this.onSuccess(v -> {
            for (int i = 0; i < 4; ++i) {
                String s = String.valueOf((char)(97 + i));
                this.vertices.get(i).eventBus().publish("test", (Object)s);
                expected.merge(i, Collections.singleton(s), (s1, s2) -> Stream.concat(s1.stream(), s2.stream()).collect(Collectors.toSet()));
                expected.merge((i + 2) % 4, Collections.singleton(s), (s1, s2) -> Stream.concat(s1.stream(), s2.stream()).collect(Collectors.toSet()));
            }
        }));
        this.awaitLatch(latch);
        this.assertEquals(expected, received);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.vertices != null) {
                this.closeClustered(this.vertices);
            }
        }
        finally {
            super.tearDown();
        }
    }

    private static class CustomNodeSelector
    implements NodeSelector {
        private ClusterManager clusterManager;
        private String rack;

        private CustomNodeSelector() {
        }

        public void init(Vertx vertx, ClusterManager clusterManager) {
            this.clusterManager = clusterManager;
        }

        public void eventBusStarted() {
            this.rack = this.clusterManager.getNodeInfo().metadata().getString("rack");
        }

        public void selectForSend(Message<?> message, Promise<String> promise) {
            promise.fail("Not implemented");
        }

        public void selectForPublish(Message<?> message, Promise<Iterable<String>> promise) {
            List nodes = this.clusterManager.getNodes();
            CompositeFuture future = nodes.stream().map(nodeId -> {
                Promise nodeInfo = Promise.promise();
                this.clusterManager.getNodeInfo(nodeId, nodeInfo);
                return nodeInfo.future();
            }).collect(Collectors.collectingAndThen(Collectors.toList(), CompositeFuture::all));
            future.map(cf -> {
                ArrayList res = new ArrayList();
                for (int i = 0; i < nodes.size(); ++i) {
                    NodeInfo nodeInfo = (NodeInfo)cf.resultAt(i);
                    if (!nodeInfo.metadata().getString("rack").equals(this.rack)) continue;
                    res.add(nodes.get(i));
                }
                return res;
            }).onComplete(promise);
        }

        public void registrationsUpdated(RegistrationUpdateEvent event) {
        }

        public void registrationsLost() {
        }
    }
}

