/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.file.FileSystemProps;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.impl.Utils;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileSystemTest
extends VertxTestBase {
    private static final String DEFAULT_DIR_PERMS = "rwxr-xr-x";
    private static final String DEFAULT_FILE_PERMS = "rw-r--r--";
    private String pathSep;
    private String testDir;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        java.nio.file.FileSystem fs = FileSystems.getDefault();
        this.pathSep = fs.getSeparator();
        File ftestDir = this.testFolder.newFolder();
        this.testDir = ftestDir.toString();
    }

    @Test
    public void testIllegalArguments() {
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copy(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copy("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyRecursive(null, "ignored", true, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyRecursive("ignored", null, true, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyRecursiveBlocking(null, "ignored", true));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyRecursiveBlocking("ignored", null, true));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().move(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().move("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().moveBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().moveBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().truncate(null, 0L, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().truncateBlocking(null, 0L));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmod(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmod("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodRecursive(null, "ignored", "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodRecursive("ignored", null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodRecursiveBlocking(null, "ignored", "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodRecursiveBlocking("ignored", null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chown(null, "ignored", "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chownBlocking(null, "ignored", "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().props(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().propsBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().lprops(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().lpropsBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().link(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().link("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().linkBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().linkBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().symlink(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().symlink("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().symlinkBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().symlinkBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().unlink(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().unlinkBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readSymlink(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readSymlinkBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().delete(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().deleteBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().deleteRecursive(null, true, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().deleteRecursiveBlocking(null, true));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdir(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdir(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirs(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirsBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirs(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirsBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readDir(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readDirBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readDir(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readDirBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readFile(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readFileBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().writeFile(null, Buffer.buffer(), h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().writeFile("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().writeFileBlocking(null, Buffer.buffer()));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().writeFileBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().open(null, new OpenOptions(), h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().open("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().openBlocking(null, new OpenOptions()));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().openBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().createFile(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().createFileBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().createFile(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().createFileBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().exists(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().existsBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().fsProps(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().fsPropsBlocking(null));
        String fileName = "some-file.dat";
        AsyncFile asyncFile = this.vertx.fileSystem().openBlocking(this.testDir + this.pathSep + fileName, new OpenOptions());
        TestUtils.assertNullPointerException(() -> asyncFile.write(null));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.setWriteQueueMaxSize(1));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.setWriteQueueMaxSize(0));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.setWriteQueueMaxSize(-1));
        TestUtils.assertNullPointerException(() -> asyncFile.write(null, 0L, h -> {}));
        TestUtils.assertNullPointerException(() -> asyncFile.write(Buffer.buffer(), 0L, null));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.write(Buffer.buffer(), -1L, h -> {}));
        TestUtils.assertNullPointerException(() -> asyncFile.read(null, 0, 0L, 0, h -> {}));
        TestUtils.assertNullPointerException(() -> asyncFile.read(Buffer.buffer(), 0, 0L, 0, null));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.read(Buffer.buffer(), -1, 0L, 0, h -> {}));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.read(Buffer.buffer(), 0, -1L, 0, h -> {}));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.read(Buffer.buffer(), 0, 0L, -1, h -> {}));
    }

    @Test
    public void testSimpleCopy() throws Exception {
        String source = "foo.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        this.testCopy(source, target, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSimpleCopyFileAlreadyExists() throws Exception {
        String source = "foo.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        this.createFileWithJunk(target, 100L);
        this.testCopy(source, target, false, false, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCopyIntoDir() throws Exception {
        String source = "foo.txt";
        String dir = "some-dir";
        String target = dir + this.pathSep + "bar.txt";
        this.mkDir(dir);
        this.createFileWithJunk(source, 100L);
        this.testCopy(source, target, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCopyEmptyDir() throws Exception {
        String source = "some-dir";
        String target = "some-other-dir";
        this.mkDir(source);
        this.testCopy(source, target, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCopyNonEmptyDir() throws Exception {
        String source = "some-dir";
        String target = "some-other-dir";
        String file1 = this.pathSep + "somefile.bar";
        this.mkDir(source);
        this.createFileWithJunk(source + file1, 100L);
        this.testCopy(source, target, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
            this.assertFalse(this.fileExists(target + file1));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testFailCopyDirAlreadyExists() throws Exception {
        String source = "some-dir";
        String target = "some-other-dir";
        this.mkDir(source);
        this.mkDir(target);
        this.testCopy(source, target, false, false, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testRecursiveCopy() throws Exception {
        String dir = "some-dir";
        String file1 = this.pathSep + "file1.dat";
        String file2 = this.pathSep + "index.html";
        String dir2 = "next-dir";
        String file3 = this.pathSep + "blah.java";
        this.mkDir(dir);
        this.createFileWithJunk(dir + file1, 100L);
        this.createFileWithJunk(dir + file2, 100L);
        this.mkDir(dir + this.pathSep + dir2);
        this.createFileWithJunk(dir + this.pathSep + dir2 + file3, 100L);
        String target = "some-other-dir";
        this.testCopy(dir, target, true, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(dir));
            this.assertTrue(this.fileExists(target));
            this.assertTrue(this.fileExists(target + file1));
            this.assertTrue(this.fileExists(target + file2));
            this.assertTrue(this.fileExists(target + this.pathSep + dir2 + file3));
            this.testComplete();
        }));
        this.await();
    }

    private void testCopy(String source, String target, boolean recursive, boolean shouldPass, Handler<Void> afterOK) {
        if (recursive) {
            this.vertx.fileSystem().copyRecursive(this.testDir + this.pathSep + source, this.testDir + this.pathSep + target, true, this.createHandler(shouldPass, afterOK));
        } else {
            this.vertx.fileSystem().copy(this.testDir + this.pathSep + source, this.testDir + this.pathSep + target, this.createHandler(shouldPass, afterOK));
        }
    }

    @Test
    public void testSimpleMove() throws Exception {
        String source = "foo.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        this.testMove(source, target, true, (Handler<Void>)((Handler)v -> {
            this.assertFalse(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSimpleMoveFileAlreadyExists() throws Exception {
        String source = "foo.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        this.createFileWithJunk(target, 100L);
        this.testMove(source, target, false, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMoveEmptyDir() throws Exception {
        String source = "some-dir";
        String target = "some-other-dir";
        this.mkDir(source);
        this.testMove(source, target, true, (Handler<Void>)((Handler)v -> {
            this.assertFalse(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMoveEmptyDirTargetExists() throws Exception {
        String source = "some-dir";
        String target = "some-other-dir";
        this.mkDir(source);
        this.mkDir(target);
        this.testMove(source, target, false, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMoveNonEmptyDir() throws Exception {
        String dir = "some-dir";
        String file1 = this.pathSep + "file1.dat";
        String file2 = this.pathSep + "index.html";
        String dir2 = "next-dir";
        String file3 = this.pathSep + "blah.java";
        this.mkDir(dir);
        this.createFileWithJunk(dir + file1, 100L);
        this.createFileWithJunk(dir + file2, 100L);
        this.mkDir(dir + this.pathSep + dir2);
        this.createFileWithJunk(dir + this.pathSep + dir2 + file3, 100L);
        String target = "some-other-dir";
        this.testMove(dir, target, true, (Handler<Void>)((Handler)v -> {
            this.assertFalse(this.fileExists(dir));
            this.assertTrue(this.fileExists(target));
            this.assertTrue(this.fileExists(target + file1));
            this.assertTrue(this.fileExists(target + file2));
            this.assertTrue(this.fileExists(target + this.pathSep + dir2 + file3));
            this.testComplete();
        }));
        this.await();
    }

    private void testMove(String source, String target, boolean shouldPass, Handler<Void> afterOK) {
        this.vertx.fileSystem().move(this.testDir + this.pathSep + source, this.testDir + this.pathSep + target, this.createHandler(shouldPass, afterOK));
    }

    @Test
    public void testTruncate() throws Exception {
        String file1 = "some-file.dat";
        long initialLen = 1000L;
        long truncatedLen = 534L;
        this.createFileWithJunk(file1, initialLen);
        this.assertEquals(initialLen, this.fileLength(file1));
        this.testTruncate(file1, truncatedLen, true, (Handler<Void>)((Handler)v -> {
            this.assertEquals(truncatedLen, this.fileLength(file1));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testTruncateExtendsFile() throws Exception {
        String file1 = "some-file.dat";
        long initialLen = 500L;
        long truncatedLen = 1000L;
        this.createFileWithJunk(file1, initialLen);
        this.assertEquals(initialLen, this.fileLength(file1));
        this.testTruncate(file1, truncatedLen, true, (Handler<Void>)((Handler)v -> {
            this.assertEquals(truncatedLen, this.fileLength(file1));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testTruncateFileDoesNotExist() {
        String file1 = "some-file.dat";
        long truncatedLen = 534L;
        this.testTruncate(file1, truncatedLen, false, (Handler<Void>)((Handler)v -> this.testComplete()));
        this.await();
    }

    private void testTruncate(String file, long truncatedLen, boolean shouldPass, Handler<Void> afterOK) {
        this.vertx.fileSystem().truncate(this.testDir + this.pathSep + file, truncatedLen, this.createHandler(shouldPass, afterOK));
    }

    @Test
    public void testChmodNonRecursive1() throws Exception {
        this.testChmodNonRecursive("rw-------");
    }

    @Test
    public void testChmodNonRecursive2() throws Exception {
        this.testChmodNonRecursive("rwx------");
    }

    @Test
    public void testChmodNonRecursive3() throws Exception {
        this.testChmodNonRecursive("rw-rw-rw-");
    }

    @Test
    public void testChmodNonRecursive4() throws Exception {
        this.testChmodNonRecursive(DEFAULT_FILE_PERMS);
    }

    @Test
    public void testChmodNonRecursive5() throws Exception {
        this.testChmodNonRecursive("rw--w--w-");
    }

    @Test
    public void testChmodNonRecursive6() throws Exception {
        this.testChmodNonRecursive("rw-rw-rw-");
    }

    private void testChmodNonRecursive(String perms) throws Exception {
        String file1 = "some-file.dat";
        this.createFileWithJunk(file1, 100L);
        this.testChmod(file1, perms, null, true, (Handler<Void>)((Handler)v -> {
            this.assertPerms(perms, file1);
            this.deleteFile(file1);
            this.testComplete();
        }));
        this.await();
    }

    private void assertPerms(String perms, String file1) {
        if (!Utils.isWindows()) {
            this.assertEquals(perms, this.getPerms(file1));
        }
    }

    @Test
    public void testChmodRecursive1() throws Exception {
        this.testChmodRecursive("rw-------", "rwx------");
    }

    @Test
    public void testChmodRecursive2() throws Exception {
        this.testChmodRecursive("rwx------", "rwx------");
    }

    @Test
    public void testChmodRecursive3() throws Exception {
        this.testChmodRecursive("rw-rw-rw-", "rwxrw-rw-");
    }

    @Test
    public void testChmodRecursive4() throws Exception {
        this.testChmodRecursive(DEFAULT_FILE_PERMS, "rwxr--r--");
    }

    @Test
    public void testChmodRecursive5() throws Exception {
        this.testChmodRecursive("rw--w--w-", "rwx-w--w-");
    }

    @Test
    public void testChmodRecursive6() throws Exception {
        this.testChmodRecursive("rw-rw-rw-", "rwxrw-rw-");
    }

    private void testChmodRecursive(String perms, String dirPerms) throws Exception {
        String dir = "some-dir";
        String file1 = this.pathSep + "file1.dat";
        String file2 = this.pathSep + "index.html";
        String dir2 = "next-dir";
        String file3 = this.pathSep + "blah.java";
        this.mkDir(dir);
        this.createFileWithJunk(dir + file1, 100L);
        this.createFileWithJunk(dir + file2, 100L);
        this.mkDir(dir + this.pathSep + dir2);
        this.createFileWithJunk(dir + this.pathSep + dir2 + file3, 100L);
        this.testChmod(dir, perms, dirPerms, true, (Handler<Void>)((Handler)v -> {
            this.assertPerms(dirPerms, dir);
            this.assertPerms(perms, dir + file1);
            this.assertPerms(perms, dir + file2);
            this.assertPerms(dirPerms, dir + this.pathSep + dir2);
            this.assertPerms(perms, dir + this.pathSep + dir2 + file3);
            this.deleteDir(dir);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testChownToRootFails() throws Exception {
        this.testChownFails("root");
    }

    @Test
    public void testChownToNotExistingUserFails() throws Exception {
        this.testChownFails("jfhfhjejweg");
    }

    private void testChownFails(String user) throws Exception {
        String file1 = "some-file.dat";
        this.createFileWithJunk(file1, 100L);
        this.vertx.fileSystem().chown(this.testDir + this.pathSep + file1, user, null, ar -> {
            this.deleteFile(file1);
            this.assertTrue(ar.failed());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testChownToOwnUser() throws Exception {
        String file1 = "some-file.dat";
        this.createFileWithJunk(file1, 100L);
        String fullPath = this.testDir + this.pathSep + file1;
        Path path = Paths.get(fullPath, new String[0]);
        UserPrincipal owner = Files.getOwner(path, new LinkOption[0]);
        String user = owner.getName();
        this.vertx.fileSystem().chown(fullPath, user, null, ar -> {
            this.deleteFile(file1);
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testChownToOwnGroup() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String file1 = "some-file.dat";
        this.createFileWithJunk(file1, 100L);
        String fullPath = this.testDir + this.pathSep + file1;
        Path path = Paths.get(fullPath, new String[0]);
        GroupPrincipal group = Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS).group();
        this.vertx.fileSystem().chown(fullPath, null, group.getName(), ar -> {
            this.deleteFile(file1);
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    private void testChmod(String file, String perms, String dirPerms, boolean shouldPass, Handler<Void> afterOK) {
        if (Files.isDirectory(Paths.get(this.testDir + this.pathSep + file, new String[0]), new LinkOption[0])) {
            this.assertPerms(DEFAULT_DIR_PERMS, file);
        } else {
            this.assertPerms(DEFAULT_FILE_PERMS, file);
        }
        if (dirPerms != null) {
            this.vertx.fileSystem().chmodRecursive(this.testDir + this.pathSep + file, perms, dirPerms, this.createHandler(shouldPass, afterOK));
        } else {
            this.vertx.fileSystem().chmod(this.testDir + this.pathSep + file, perms, this.createHandler(shouldPass, afterOK));
        }
    }

    @Test
    public void testProps() throws Exception {
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        long start = 1000L * (System.currentTimeMillis() / 1000L - 1L);
        this.createFileWithJunk(fileName, fileSize);
        this.testProps(fileName, false, true, (Handler<FileProps>)((Handler)st -> {
            this.assertNotNull(st);
            this.assertEquals(fileSize, st.size());
            this.assertTrue(st.creationTime() >= start);
            this.assertTrue(st.lastAccessTime() >= start);
            this.assertTrue(st.lastModifiedTime() >= start);
            this.assertFalse(st.isDirectory());
            this.assertTrue(st.isRegularFile());
            this.assertFalse(st.isSymbolicLink());
        }));
        this.await();
    }

    @Test
    public void testPropsFileDoesNotExist() {
        String fileName = "some-file.txt";
        this.testProps(fileName, false, false, null);
        this.await();
    }

    @Test
    public void testPropsFollowLink() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        long start = 1000L * (System.currentTimeMillis() / 1000L - 1L);
        this.createFileWithJunk(fileName, fileSize);
        long end = 1000L * (System.currentTimeMillis() / 1000L + 1L);
        String linkName = "some-link.txt";
        Files.createSymbolicLink(Paths.get(this.testDir + this.pathSep + linkName, new String[0]), Paths.get(fileName, new String[0]), new FileAttribute[0]);
        this.testProps(linkName, false, true, (Handler<FileProps>)((Handler)st -> {
            this.assertNotNull(st);
            this.assertEquals(fileSize, st.size());
            this.assertTrue(st.creationTime() >= start);
            this.assertTrue(st.creationTime() <= end);
            this.assertTrue(st.lastAccessTime() >= start);
            this.assertTrue(st.lastAccessTime() <= end);
            this.assertTrue(st.lastModifiedTime() >= start);
            this.assertTrue(st.lastModifiedTime() <= end);
            this.assertFalse(st.isDirectory());
            this.assertFalse(st.isOther());
            this.assertTrue(st.isRegularFile());
            this.assertFalse(st.isSymbolicLink());
        }));
        this.await();
    }

    @Test
    public void testPropsDontFollowLink() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        this.createFileWithJunk(fileName, fileSize);
        String linkName = "some-link.txt";
        Files.createSymbolicLink(Paths.get(this.testDir + this.pathSep + linkName, new String[0]), Paths.get(fileName, new String[0]), new FileAttribute[0]);
        this.testProps(linkName, true, true, (Handler<FileProps>)((Handler)st -> {
            this.assertNotNull(st != null);
            this.assertTrue(st.isSymbolicLink());
        }));
        this.await();
    }

    private void testProps(String fileName, boolean link, boolean shouldPass, Handler<FileProps> afterOK) {
        Handler handler = ar -> {
            if (ar.failed()) {
                if (shouldPass) {
                    this.fail(ar.cause().getMessage());
                } else {
                    this.assertTrue(ar.cause() instanceof FileSystemException);
                    if (afterOK != null) {
                        afterOK.handle(ar.result());
                    }
                    this.testComplete();
                }
            } else if (shouldPass) {
                if (afterOK != null) {
                    afterOK.handle(ar.result());
                }
                this.testComplete();
            } else {
                this.fail("stat should fail");
            }
        };
        if (link) {
            this.vertx.fileSystem().lprops(this.testDir + this.pathSep + fileName, handler);
        } else {
            this.vertx.fileSystem().props(this.testDir + this.pathSep + fileName, handler);
        }
    }

    @Test
    public void testLink() throws Exception {
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        this.createFileWithJunk(fileName, fileSize);
        String linkName = "some-link.txt";
        this.testLink(linkName, fileName, false, true, (Handler<Void>)((Handler)v -> {
            this.assertEquals(fileSize, this.fileLength(linkName));
            this.assertFalse(Files.isSymbolicLink(Paths.get(this.testDir + this.pathSep + linkName, new String[0])));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSymLink() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        this.createFileWithJunk(fileName, fileSize);
        String symlinkName = "some-sym-link.txt";
        this.testLink(symlinkName, fileName, true, true, (Handler<Void>)((Handler)v -> {
            this.assertEquals(fileSize, this.fileLength(symlinkName));
            this.assertTrue(Files.isSymbolicLink(Paths.get(this.testDir + this.pathSep + symlinkName, new String[0])));
            String read = this.vertx.fileSystem().readSymlinkBlocking(this.testDir + this.pathSep + symlinkName);
            this.assertEquals(fileName, read);
            this.testComplete();
        }));
        this.await();
    }

    private void testLink(String from, String to, boolean symbolic, boolean shouldPass, Handler<Void> afterOK) {
        if (symbolic) {
            this.vertx.fileSystem().symlink(this.testDir + this.pathSep + from, to, this.createHandler(shouldPass, afterOK));
        } else {
            this.vertx.fileSystem().link(this.testDir + this.pathSep + from, this.testDir + this.pathSep + to, this.createHandler(shouldPass, afterOK));
        }
    }

    @Test
    public void testUnlink() throws Exception {
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        this.createFileWithJunk(fileName, fileSize);
        String linkName = "some-link.txt";
        Files.createLink(Paths.get(this.testDir + this.pathSep + linkName, new String[0]), Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
        this.assertEquals(fileSize, this.fileLength(linkName));
        this.vertx.fileSystem().unlink(this.testDir + this.pathSep + linkName, this.createHandler(true, (Handler<Void>)((Handler)v -> {
            this.assertFalse(this.fileExists(linkName));
            this.testComplete();
        })));
        this.await();
    }

    @Test
    public void testReadSymLink() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        this.createFileWithJunk(fileName, fileSize);
        String linkName = "some-link.txt";
        Files.createSymbolicLink(Paths.get(this.testDir + this.pathSep + linkName, new String[0]), Paths.get(fileName, new String[0]), new FileAttribute[0]);
        this.vertx.fileSystem().readSymlink(this.testDir + this.pathSep + linkName, ar -> {
            if (ar.failed()) {
                this.fail(ar.cause().getMessage());
            } else {
                this.assertEquals(fileName, ar.result());
                this.testComplete();
            }
        });
        this.await();
    }

    @Test
    public void testSimpleDelete() throws Exception {
        String fileName = "some-file.txt";
        this.createFileWithJunk(fileName, 100L);
        this.assertTrue(this.fileExists(fileName));
        this.testDelete(fileName, false, true, (Handler<Void>)((Handler)v -> {
            this.assertFalse(this.fileExists(fileName));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeleteEmptyDir() throws Exception {
        String dirName = "some-dir";
        this.mkDir(dirName);
        this.assertTrue(this.fileExists(dirName));
        this.testDelete(dirName, false, true, (Handler<Void>)((Handler)v -> {
            this.assertFalse(this.fileExists(dirName));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeleteNonExistent() {
        String dirName = "some-dir";
        this.assertFalse(this.fileExists(dirName));
        this.testDelete(dirName, false, false, (Handler<Void>)((Handler)v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testDeleteNonEmptyFails() throws Exception {
        String dirName = "some-dir";
        this.mkDir(dirName);
        String file1 = "some-file.txt";
        this.createFileWithJunk(dirName + this.pathSep + file1, 100L);
        this.testDelete(dirName, false, false, (Handler<Void>)((Handler)v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        String dir = "some-dir";
        String file1 = this.pathSep + "file1.dat";
        String file2 = this.pathSep + "index.html";
        String dir2 = "next-dir";
        String file3 = this.pathSep + "blah.java";
        this.mkDir(dir);
        this.createFileWithJunk(dir + file1, 100L);
        this.createFileWithJunk(dir + file2, 100L);
        this.mkDir(dir + this.pathSep + dir2);
        this.createFileWithJunk(dir + this.pathSep + dir2 + file3, 100L);
        this.testDelete(dir, true, true, (Handler<Void>)((Handler)v -> {
            this.assertFalse(this.fileExists(dir));
            this.testComplete();
        }));
        this.await();
    }

    private void testDelete(String fileName, boolean recursive, boolean shouldPass, Handler<Void> afterOK) {
        if (recursive) {
            this.vertx.fileSystem().deleteRecursive(this.testDir + this.pathSep + fileName, recursive, this.createHandler(shouldPass, afterOK));
        } else {
            this.vertx.fileSystem().delete(this.testDir + this.pathSep + fileName, this.createHandler(shouldPass, afterOK));
        }
    }

    @Test
    public void testMkdirSimple() {
        String dirName = "some-dir";
        this.testMkdir(dirName, null, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(dirName));
            this.assertTrue(Files.isDirectory(Paths.get(this.testDir + this.pathSep + dirName, new String[0]), new LinkOption[0]));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMkdirWithParentsFails() {
        String dirName = "top-dir" + this.pathSep + "some-dir";
        this.testMkdir(dirName, null, false, false, (Handler<Void>)((Handler)v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testMkdirWithPerms() {
        String dirName = "some-dir";
        String perms = "rwx--x--x";
        this.testMkdir(dirName, perms, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(dirName));
            this.assertTrue(Files.isDirectory(Paths.get(this.testDir + this.pathSep + dirName, new String[0]), new LinkOption[0]));
            this.assertPerms(perms, dirName);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMkdirAlreadyExist() {
        String dirName = "some-dir";
        this.testMkdir(dirName, null, false, true, (Handler<Void>)((Handler)v1 -> this.testMkdir(dirName, null, false, false, (Handler<Void>)((Handler)v2 -> {
            this.assertTrue(this.fileExists(dirName));
            this.assertTrue(Files.isDirectory(Paths.get(this.testDir + this.pathSep + dirName, new String[0]), new LinkOption[0]));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testMkdirCreateParents() {
        String dirName = "top-dir" + this.pathSep + "/some-dir";
        this.testMkdir(dirName, null, true, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(dirName));
            this.assertTrue(Files.isDirectory(Paths.get(this.testDir + this.pathSep + dirName, new String[0]), new LinkOption[0]));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMkdirCreateParentsWithPerms() {
        String dirName = "top-dir" + this.pathSep + "/some-dir";
        String perms = "rwx--x--x";
        this.testMkdir(dirName, perms, true, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(dirName));
            this.assertTrue(Files.isDirectory(Paths.get(this.testDir + this.pathSep + dirName, new String[0]), new LinkOption[0]));
            this.assertPerms(perms, dirName);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMkdirCreateParentsDirExist() {
        String dirName = "some-dir";
        this.testMkdir(dirName, null, true, true, (Handler<Void>)((Handler)v1 -> this.testMkdir(dirName, null, true, true, (Handler<Void>)((Handler)v2 -> {
            this.assertTrue(this.fileExists(dirName));
            this.assertTrue(Files.isDirectory(Paths.get(this.testDir + this.pathSep + dirName, new String[0]), new LinkOption[0]));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testMkdirCreateParentsFileExist() throws Exception {
        String dirName = "some-dir";
        this.createFileWithJunk(dirName, 1024L);
        this.testMkdir(dirName, null, true, false, (Handler<Void>)((Handler)v2 -> {
            this.assertTrue(this.fileExists(dirName));
            this.assertFalse(Files.isDirectory(Paths.get(this.testDir + this.pathSep + dirName, new String[0]), new LinkOption[0]));
            this.testComplete();
        }));
        this.await();
    }

    private void testMkdir(String dirName, String perms, boolean createParents, boolean shouldPass, Handler<Void> afterOK) {
        Handler<AsyncResult<Void>> handler = this.createHandler(shouldPass, afterOK);
        if (createParents) {
            if (perms != null) {
                this.vertx.fileSystem().mkdirs(this.testDir + this.pathSep + dirName, perms, handler);
            } else {
                this.vertx.fileSystem().mkdirs(this.testDir + this.pathSep + dirName, handler);
            }
        } else if (perms != null) {
            this.vertx.fileSystem().mkdir(this.testDir + this.pathSep + dirName, perms, handler);
        } else {
            this.vertx.fileSystem().mkdir(this.testDir + this.pathSep + dirName, handler);
        }
    }

    @Test
    public void testReadDirSimple() throws Exception {
        String dirName = "some-dir";
        this.mkDir(dirName);
        int numFiles = 10;
        for (int i = 0; i < numFiles; ++i) {
            this.createFileWithJunk(dirName + this.pathSep + "file-" + i + ".dat", 100L);
        }
        this.testReadDir(dirName, null, true, (Handler<List<String>>)((Handler)fileNames -> {
            String root;
            this.assertEquals(numFiles, fileNames.size());
            HashSet<String> fset = new HashSet<String>();
            for (String fileName : fileNames) {
                fset.add(fileName);
            }
            File dir = new File(this.testDir + this.pathSep + dirName);
            try {
                root = dir.getCanonicalPath();
            }
            catch (IOException e) {
                this.fail(e.getMessage());
                return;
            }
            for (int i = 0; i < numFiles; ++i) {
                this.assertTrue(fset.contains(root + this.pathSep + "file-" + i + ".dat"));
            }
        }));
        this.await();
    }

    @Test
    public void testReadDirWithFilter() throws Exception {
        int i;
        String dirName = "some-dir";
        this.mkDir(dirName);
        int numFiles = 10;
        for (i = 0; i < numFiles; ++i) {
            this.createFileWithJunk(dirName + this.pathSep + "foo-" + i + ".txt", 100L);
        }
        for (i = 0; i < numFiles; ++i) {
            this.createFileWithJunk(dirName + this.pathSep + "bar-" + i + ".txt", 100L);
        }
        this.testReadDir(dirName, "foo.+", true, (Handler<List<String>>)((Handler)fileNames -> {
            String root;
            this.assertEquals(numFiles, fileNames.size());
            HashSet<String> fset = new HashSet<String>();
            for (String fileName : fileNames) {
                fset.add(fileName);
            }
            File dir = new File(this.testDir + this.pathSep + dirName);
            try {
                root = dir.getCanonicalPath();
            }
            catch (IOException e) {
                this.fail(e.getMessage());
                return;
            }
            for (int i = 0; i < numFiles; ++i) {
                this.assertTrue(fset.contains(root + this.pathSep + "foo-" + i + ".txt"));
            }
        }));
        this.await();
    }

    private void testReadDir(String dirName, String filter, boolean shouldPass, Handler<List<String>> afterOK) {
        Handler handler = ar -> {
            if (ar.failed()) {
                if (shouldPass) {
                    this.fail(ar.cause().getMessage());
                } else {
                    this.assertTrue(ar.cause() instanceof FileSystemException);
                    if (afterOK != null) {
                        afterOK.handle(null);
                    }
                    this.testComplete();
                }
            } else if (shouldPass) {
                if (afterOK != null) {
                    afterOK.handle(ar.result());
                }
                this.testComplete();
            } else {
                this.fail("read should fail");
            }
        };
        if (filter == null) {
            this.vertx.fileSystem().readDir(this.testDir + this.pathSep + dirName, handler);
        } else {
            this.vertx.fileSystem().readDir(this.testDir + this.pathSep + dirName, filter, handler);
        }
    }

    @Test
    public void testReadFile() throws Exception {
        byte[] content = TestUtils.randomByteArray(1000);
        String fileName = "some-file.dat";
        this.createFile(fileName, content);
        this.vertx.fileSystem().readFile(this.testDir + this.pathSep + fileName, ar -> {
            if (ar.failed()) {
                this.fail(ar.cause().getMessage());
            } else {
                this.assertEquals(Buffer.buffer((byte[])content), ar.result());
                this.testComplete();
            }
        });
        this.await();
    }

    @Test
    public void testWriteFile() {
        byte[] content = TestUtils.randomByteArray(1000);
        Buffer buff = Buffer.buffer((byte[])content);
        String fileName = "some-file.dat";
        this.vertx.fileSystem().writeFile(this.testDir + this.pathSep + fileName, buff, ar -> {
            if (ar.failed()) {
                this.fail(ar.cause().getMessage());
            } else {
                byte[] readBytes;
                this.assertTrue(this.fileExists(fileName));
                this.assertEquals(content.length, this.fileLength(fileName));
                try {
                    readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
                }
                catch (IOException e) {
                    this.fail(e.getMessage());
                    return;
                }
                this.assertEquals(buff, Buffer.buffer((byte[])readBytes));
                this.testComplete();
            }
        });
        this.await();
    }

    @Test
    public void testWriteAsync() {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        Buffer buff = Buffer.buffer((byte[])content);
        AtomicInteger count = new AtomicInteger();
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), arr -> {
            if (arr.succeeded()) {
                for (int i = 0; i < chunks; ++i) {
                    Buffer chunk = buff.getBuffer(i * chunkSize, (i + 1) * chunkSize);
                    this.assertEquals(chunkSize, chunk.length());
                    ((AsyncFile)arr.result()).write(chunk, (long)(i * chunkSize), ar -> {
                        if (ar.succeeded()) {
                            if (count.incrementAndGet() == chunks) {
                                ((AsyncFile)arr.result()).close(ar2 -> {
                                    if (ar2.failed()) {
                                        this.fail(ar2.cause().getMessage());
                                    } else {
                                        byte[] readBytes;
                                        this.assertTrue(this.fileExists(fileName));
                                        try {
                                            readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
                                        }
                                        catch (IOException e) {
                                            this.fail(e.getMessage());
                                            return;
                                        }
                                        Buffer read = Buffer.buffer((byte[])readBytes);
                                        this.assertEquals(buff, read);
                                        this.testComplete();
                                    }
                                });
                            }
                        } else {
                            this.fail(ar.cause().getMessage());
                        }
                    });
                }
            } else {
                this.fail(arr.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testCloseFileAfterFailure() {
        if (!this.vertx.fileSystem().existsBlocking("/dev/full")) {
            throw new AssumptionViolatedException("/dev/full special device file is not available");
        }
        AsyncFile asyncFile = this.vertx.fileSystem().openBlocking("/dev/full", new OpenOptions());
        int loops = 100;
        this.waitFor(loops + 1);
        for (int i = 0; i < loops; ++i) {
            asyncFile.write((Object)TestUtils.randomBuffer(256), this.onFailure(write -> this.complete()));
        }
        asyncFile.close(this.onSuccess(close -> this.complete()));
        this.await();
    }

    @Test
    public void testWriteEmptyAsync() {
        String fileName = "some-file.dat";
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), this.onSuccess(file -> file.write(Buffer.buffer(), 0L, this.onSuccess(v -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testReadAsync() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        Buffer expected = Buffer.buffer((byte[])content);
        this.createFile(fileName, content);
        AtomicInteger reads = new AtomicInteger();
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), arr -> {
            if (arr.succeeded()) {
                Buffer buff = Buffer.buffer((int)(chunks * chunkSize));
                for (int i = 0; i < chunks; ++i) {
                    ((AsyncFile)arr.result()).read(buff, i * chunkSize, (long)(i * chunkSize), chunkSize, arb -> {
                        if (arb.succeeded()) {
                            if (reads.incrementAndGet() == chunks) {
                                ((AsyncFile)arr.result()).close(ar -> {
                                    if (ar.failed()) {
                                        this.fail(ar.cause().getMessage());
                                    } else {
                                        this.assertEquals(expected, buff);
                                        this.assertEquals(buff, arb.result());
                                        this.testComplete();
                                    }
                                });
                            }
                        } else {
                            this.fail(arb.cause().getMessage());
                        }
                    });
                }
            } else {
                this.fail(arr.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testWriteStream() {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        Buffer buff = Buffer.buffer((byte[])content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                WriteStream ws = (WriteStream)ar.result();
                ws.exceptionHandler(t -> this.fail(t.getMessage()));
                for (int i = 0; i < chunks; ++i) {
                    Buffer chunk = buff.getBuffer(i * chunkSize, (i + 1) * chunkSize);
                    this.assertEquals(chunkSize, chunk.length());
                    ws.write((Object)chunk);
                }
                ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        byte[] readBytes;
                        this.assertTrue(this.fileExists(fileName));
                        try {
                            readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
                        }
                        catch (IOException e) {
                            this.fail(e.getMessage());
                            return;
                        }
                        this.assertEquals(buff, Buffer.buffer((byte[])readBytes));
                        this.testComplete();
                    }
                });
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testWriteStreamAppend() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] existing = TestUtils.randomByteArray(1000);
        this.createFile(fileName, existing);
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        Buffer buff = Buffer.buffer((byte[])content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions().setAppend(true), ar -> {
            if (ar.succeeded()) {
                AsyncFile ws = (AsyncFile)ar.result();
                ws.exceptionHandler(t -> this.fail(t.getMessage()));
                for (int i = 0; i < chunks; ++i) {
                    Buffer chunk = buff.getBuffer(i * chunkSize, (i + 1) * chunkSize);
                    this.assertEquals(chunkSize, chunk.length());
                    ws.write((Object)chunk);
                }
                ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        byte[] readBytes;
                        this.assertTrue(this.fileExists(fileName));
                        try {
                            readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
                        }
                        catch (IOException e) {
                            this.fail(e.getMessage());
                            return;
                        }
                        this.assertEquals(Buffer.buffer((byte[])existing).appendBuffer(buff), Buffer.buffer((byte[])readBytes));
                        this.testComplete();
                    }
                });
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testWriteStreamWithCompositeBuffer() {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content1 = TestUtils.randomByteArray(chunkSize * (chunks / 2));
        byte[] content2 = TestUtils.randomByteArray(chunkSize * (chunks / 2));
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[][])new byte[][]{content1, content2});
        Buffer buff = Buffer.buffer((ByteBuf)byteBuf);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                WriteStream ws = (WriteStream)ar.result();
                ws.exceptionHandler(t -> this.fail(t.getMessage()));
                ws.write((Object)buff);
                ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        byte[] readBytes;
                        this.assertTrue(this.fileExists(fileName));
                        try {
                            readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
                        }
                        catch (IOException e) {
                            this.fail(e.getMessage());
                            return;
                        }
                        this.assertEquals(buff, Buffer.buffer((byte[])readBytes));
                        byteBuf.release();
                        this.testComplete();
                    }
                });
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testReadStream() throws Exception {
        this.testReadStream(ReadStrategy.NONE);
    }

    @Test
    public void testReadStreamFlowing() throws Exception {
        this.testReadStream(ReadStrategy.FLOWING);
    }

    @Test
    public void testReadStreamFetch() throws Exception {
        this.testReadStream(ReadStrategy.FETCH);
    }

    private void testReadStream(ReadStrategy strategy) throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        this.createFile(fileName, content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                AtomicInteger inProgress = new AtomicInteger();
                AtomicBoolean ended = new AtomicBoolean();
                Buffer buff = Buffer.buffer();
                Runnable checkEnd = () -> {
                    if (ended.get() && inProgress.get() == 0) {
                        ((AsyncFile)ar.result()).close(ar2 -> {
                            if (ar2.failed()) {
                                this.fail(ar2.cause().getMessage());
                            } else {
                                this.assertEquals(Buffer.buffer((byte[])content), buff);
                                this.testComplete();
                            }
                        });
                    }
                };
                ReadStream rs = (ReadStream)ar.result();
                strategy.init((ReadStream<Buffer>)rs);
                rs.handler(chunk -> {
                    buff.appendBuffer(chunk);
                    inProgress.incrementAndGet();
                    Future<Void> fut = strategy.handle((ReadStream<Buffer>)rs);
                    fut.onComplete(v -> {
                        inProgress.decrementAndGet();
                        checkEnd.run();
                    });
                });
                rs.exceptionHandler(t -> this.fail(t.getMessage()));
                rs.endHandler(v -> {
                    ended.set(true);
                    checkEnd.run();
                });
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testReadStreamWithBufferSize() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 16384;
        int chunks = 1;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        this.createFile(fileName, content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                AsyncFile rs = (AsyncFile)ar.result();
                rs.setReadBufferSize(chunkSize);
                Buffer buff = Buffer.buffer();
                int[] callCount = new int[]{0};
                rs.handler(buff1 -> {
                    buff.appendBuffer(buff1);
                    callCount[0] = callCount[0] + 1;
                });
                rs.exceptionHandler(t -> this.fail(t.getMessage()));
                rs.endHandler(v -> ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        this.assertEquals(1L, callCount[0]);
                        this.assertEquals(Buffer.buffer((byte[])content), buff);
                        this.testComplete();
                    }
                }));
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testReadStreamSetReadPos() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        this.createFile(fileName, content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                AsyncFile rs = (AsyncFile)ar.result();
                rs.setReadPos((long)(chunkSize * chunks / 2));
                Buffer buff = Buffer.buffer();
                rs.handler(arg_0 -> ((Buffer)buff).appendBuffer(arg_0));
                rs.exceptionHandler(t -> this.fail(t.getMessage()));
                rs.endHandler(v -> ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        this.assertEquals(chunkSize * chunks / 2, buff.length());
                        byte[] lastHalf = new byte[chunkSize * chunks / 2];
                        System.arraycopy(content, chunkSize * chunks / 2, lastHalf, 0, chunkSize * chunks / 2);
                        this.assertEquals(Buffer.buffer((byte[])lastHalf), buff);
                        this.testComplete();
                    }
                }));
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testReadStreamSetReadLength() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        int readLength = chunkSize * chunks / 3;
        this.createFile(fileName, content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                AsyncFile rs = (AsyncFile)ar.result();
                rs.setReadLength((long)readLength);
                Buffer buff = Buffer.buffer();
                rs.handler(arg_0 -> ((Buffer)buff).appendBuffer(arg_0));
                rs.exceptionHandler(t -> this.fail(t.getMessage()));
                rs.endHandler(v -> ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        this.assertEquals(readLength, buff.length());
                        byte[] firstThird = new byte[readLength];
                        System.arraycopy(content, 0, firstThird, 0, readLength);
                        this.assertEquals(Buffer.buffer((byte[])firstThird), buff);
                        this.testComplete();
                    }
                }));
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testReadStreamSetReadPosReadLengthBufferSize() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        int readLength = chunkSize * chunks / 3;
        int readPos = chunkSize * chunks / 3;
        int readBufferSize = 1000;
        int numOfReads = readLength / readBufferSize + (readLength % readBufferSize > 0 ? 1 : 0);
        this.createFile(fileName, content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                AsyncFile rs = (AsyncFile)ar.result();
                rs.setReadPos((long)readPos);
                rs.setReadLength((long)readLength);
                rs.setReadBufferSize(readBufferSize);
                Buffer buff = Buffer.buffer();
                int[] appendCount = new int[]{0};
                rs.handler(rsBuff -> {
                    buff.appendBuffer(rsBuff);
                    appendCount[0] = appendCount[0] + 1;
                });
                rs.exceptionHandler(t -> this.fail(t.getMessage()));
                rs.endHandler(v -> ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        this.assertEquals(buff.length(), readLength);
                        this.assertEquals(numOfReads, appendCount[0]);
                        byte[] middleThird = new byte[readLength];
                        System.arraycopy(content, readPos, middleThird, 0, readLength);
                        this.assertEquals(Buffer.buffer((byte[])middleThird), buff);
                        this.testComplete();
                    }
                }));
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testReadStreamNoLock() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 16384;
        int chunks = 1;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        this.createFile(fileName, content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), this.onSuccess(rs -> {
            rs.handler(buff -> this.assertFalse(Thread.holdsLock(rs)));
            rs.endHandler(v -> {
                this.assertFalse(Thread.holdsLock(rs));
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testPumpFileStreams() throws Exception {
        String fileName1 = "some-file.dat";
        String fileName2 = "some-other-file.dat";
        int fileSize = 8194457;
        byte[] content = TestUtils.randomByteArray(fileSize);
        this.createFile(fileName1, content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName1, new OpenOptions(), arr -> {
            if (arr.succeeded()) {
                ReadStream rs = (ReadStream)arr.result();
                this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName2, new OpenOptions(), ar -> {
                    if (ar.succeeded()) {
                        WriteStream ws = (WriteStream)ar.result();
                        Pump p = Pump.pump((ReadStream)rs, (WriteStream)ws);
                        p.start();
                        rs.endHandler(v -> ((AsyncFile)arr.result()).close(car -> {
                            if (car.failed()) {
                                this.fail(ar.cause().getMessage());
                            } else {
                                ((AsyncFile)ar.result()).close(ar2 -> {
                                    if (ar2.failed()) {
                                        this.fail(ar2.cause().getMessage());
                                    } else {
                                        byte[] readBytes;
                                        this.assertTrue(this.fileExists(fileName2));
                                        try {
                                            readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName2, new String[0]));
                                        }
                                        catch (IOException e) {
                                            this.fail(e.getMessage());
                                            return;
                                        }
                                        this.assertEquals(Buffer.buffer((byte[])content), Buffer.buffer((byte[])readBytes));
                                        this.testComplete();
                                    }
                                });
                            }
                        }));
                    } else {
                        this.fail(ar.cause().getMessage());
                    }
                });
            } else {
                this.fail(arr.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testCreateFileNoPerms() {
        this.testCreateFile(null, true);
    }

    @Test
    public void testCreateFileWithPerms() {
        this.testCreateFile("rwx------", true);
    }

    @Test
    public void testCreateFileAlreadyExists() throws Exception {
        this.createFileWithJunk("some-file.dat", 100L);
        this.testCreateFile(null, false);
    }

    private void testCreateFile(String perms, boolean shouldPass) {
        String fileName = "some-file.dat";
        Handler handler = ar -> {
            if (ar.failed()) {
                if (shouldPass) {
                    this.fail(ar.cause().getMessage());
                } else {
                    this.assertTrue(ar.cause() instanceof FileSystemException);
                    this.testComplete();
                }
            } else if (shouldPass) {
                this.assertTrue(this.fileExists(fileName));
                this.assertEquals(0L, this.fileLength(fileName));
                if (perms != null) {
                    this.assertPerms(perms, fileName);
                }
                this.testComplete();
            } else {
                this.fail("test should fail");
            }
        };
        if (perms != null) {
            this.vertx.fileSystem().createFile(this.testDir + this.pathSep + fileName, perms, handler);
        } else {
            this.vertx.fileSystem().createFile(this.testDir + this.pathSep + fileName, handler);
        }
        this.await();
    }

    @Test
    public void testExists() throws Exception {
        this.testExists(true);
    }

    @Test
    public void testNotExists() throws Exception {
        this.testExists(false);
    }

    private void testExists(boolean exists) throws Exception {
        String fileName = "some-file.dat";
        if (exists) {
            this.createFileWithJunk(fileName, 100L);
        }
        this.vertx.fileSystem().exists(this.testDir + this.pathSep + fileName, ar -> {
            if (ar.succeeded()) {
                if (exists) {
                    this.assertTrue((Boolean)ar.result());
                } else {
                    this.assertFalse((Boolean)ar.result());
                }
                this.testComplete();
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testFSProps() throws Exception {
        String fileName = "some-file.txt";
        this.createFileWithJunk(fileName, 1234L);
        this.testFSProps(fileName, (Handler<FileSystemProps>)((Handler)props -> {
            this.assertTrue(props.totalSpace() > 0L);
            this.assertTrue(props.unallocatedSpace() > 0L);
            this.assertTrue(props.usableSpace() > 0L);
        }));
        this.await();
    }

    private void testFSProps(String fileName, Handler<FileSystemProps> afterOK) {
        this.vertx.fileSystem().fsProps(this.testDir + this.pathSep + fileName, ar -> {
            if (ar.failed()) {
                this.fail(ar.cause().getMessage());
            } else {
                afterOK.handle(ar.result());
                this.testComplete();
            }
        });
    }

    @Test
    public void testOpenOptions() {
        OpenOptions opts = new OpenOptions();
        this.assertNull(opts.getPerms());
        String perms = "rwxrwxrwx";
        this.assertEquals(opts, opts.setPerms(perms));
        this.assertEquals(perms, opts.getPerms());
        this.assertTrue(opts.isCreate());
        this.assertEquals(opts, opts.setCreate(false));
        this.assertFalse(opts.isCreate());
        this.assertFalse(opts.isCreateNew());
        this.assertEquals(opts, opts.setCreateNew(true));
        this.assertTrue(opts.isCreateNew());
        this.assertTrue(opts.isRead());
        this.assertEquals(opts, opts.setRead(false));
        this.assertFalse(opts.isRead());
        this.assertTrue(opts.isWrite());
        this.assertEquals(opts, opts.setWrite(false));
        this.assertFalse(opts.isWrite());
        this.assertFalse(opts.isDsync());
        this.assertEquals(opts, opts.setDsync(true));
        this.assertTrue(opts.isDsync());
        this.assertFalse(opts.isSync());
        this.assertEquals(opts, opts.setSync(true));
        this.assertTrue(opts.isSync());
        this.assertFalse(opts.isDeleteOnClose());
        this.assertEquals(opts, opts.setDeleteOnClose(true));
        this.assertTrue(opts.isDeleteOnClose());
        this.assertFalse(opts.isTruncateExisting());
        this.assertEquals(opts, opts.setTruncateExisting(true));
        this.assertTrue(opts.isTruncateExisting());
        this.assertFalse(opts.isSparse());
        this.assertEquals(opts, opts.setSparse(true));
        this.assertTrue(opts.isSparse());
    }

    @Test
    public void testDefaultOptionOptions() {
        OpenOptions def = new OpenOptions();
        OpenOptions json = new OpenOptions(new JsonObject());
        this.assertEquals(def.getPerms(), json.getPerms());
        this.assertEquals(def.isRead(), json.isRead());
        this.assertEquals(def.isWrite(), json.isWrite());
        this.assertEquals(def.isCreate(), json.isCreate());
        this.assertEquals(def.isCreateNew(), json.isCreateNew());
        this.assertEquals(def.isDeleteOnClose(), json.isDeleteOnClose());
        this.assertEquals(def.isTruncateExisting(), json.isTruncateExisting());
        this.assertEquals(def.isSparse(), json.isSparse());
        this.assertEquals(def.isSync(), json.isSync());
        this.assertEquals(def.isDsync(), json.isDsync());
    }

    @Test
    public void testAsyncFileCloseHandlerIsAsync() throws Exception {
        String fileName = "some-file.dat";
        this.createFileWithJunk(fileName, 100L);
        AsyncFile file = this.vertx.fileSystem().openBlocking(this.testDir + this.pathSep + fileName, new OpenOptions());
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        file.close(ar -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDrainNotCalledAfterClose() {
        String fileName = "some-file.dat";
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), this.onSuccess(file -> {
            Buffer buf = TestUtils.randomBuffer(0x100000);
            file.write((Object)buf);
            AtomicBoolean drainAfterClose = new AtomicBoolean();
            file.drainHandler(v -> drainAfterClose.set(true));
            file.close(ar -> {
                this.assertFalse(drainAfterClose.get());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testDrainSetOnce() {
        String fileName = "some-file.dat";
        Buffer buff = TestUtils.randomBuffer(1024);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), this.onSuccess(file -> {
            file.setWriteQueueMaxSize(4096);
            Context ctx = Vertx.currentContext();
            this.assertNotNull(ctx);
            AtomicInteger times = new AtomicInteger(7);
            file.drainHandler(v -> {
                this.assertSame(ctx, Vertx.currentContext());
                if (times.decrementAndGet() > 0) {
                    while (!file.writeQueueFull()) {
                        file.write((Object)buff);
                    }
                } else {
                    this.assertEquals(0L, times.get());
                    this.testComplete();
                }
            });
            while (!file.writeQueueFull()) {
                file.write((Object)buff);
            }
        }));
        this.await();
    }

    @Test
    public void testResumeFileInEndHandler() throws Exception {
        Buffer expected = TestUtils.randomBuffer(10000);
        String fileName = "some-file.dat";
        this.createFile(fileName, expected.getBytes());
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), this.onSuccess(file -> {
            Buffer buffer = Buffer.buffer();
            file.endHandler(v -> {
                this.assertEquals(buffer.length(), expected.length());
                file.pause();
                file.resume();
                this.complete();
            });
            file.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
        }));
        this.await();
    }

    @Test
    public void testPausedEnd() throws Exception {
        String fileName = "some-file.dat";
        this.createFile(fileName, new byte[0]);
        AtomicBoolean paused = new AtomicBoolean(false);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), this.onSuccess(file -> {
            Buffer buffer = Buffer.buffer();
            paused.set(true);
            file.pause();
            this.vertx.setTimer(100L, id -> {
                paused.set(false);
                file.resume();
            });
            file.endHandler(v -> {
                this.assertFalse(paused.get());
                this.testComplete();
            });
            file.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
        }));
        this.await();
    }

    private Handler<AsyncResult<Void>> createHandler(boolean shouldPass, Handler<Void> afterOK) {
        return ar -> {
            if (ar.failed()) {
                if (shouldPass) {
                    this.fail(ar.cause().getMessage());
                } else {
                    this.assertTrue(ar.cause() instanceof FileSystemException);
                    if (afterOK != null) {
                        afterOK.handle(null);
                    }
                }
            } else if (shouldPass) {
                if (afterOK != null) {
                    afterOK.handle(null);
                }
            } else {
                this.fail("operation should fail");
            }
        };
    }

    private boolean fileExists(String fileName) {
        File file = new File(this.testDir, fileName);
        return file.exists();
    }

    private void createFileWithJunk(String fileName, long length) throws Exception {
        this.createFile(fileName, TestUtils.randomByteArray((int)length));
    }

    private void createFile(String fileName, byte[] bytes) throws Exception {
        File file = new File(this.testDir, fileName);
        Path path = Paths.get(file.getCanonicalPath(), new String[0]);
        Files.write(path, bytes, new OpenOption[0]);
        this.setPerms(path, DEFAULT_FILE_PERMS);
    }

    private void deleteDir(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.deleteDir(files[i]);
                continue;
            }
            files[i].delete();
        }
        dir.delete();
    }

    private void deleteDir(String dir) {
        this.deleteDir(new File(this.testDir + this.pathSep + dir));
    }

    private void mkDir(String dirName) throws Exception {
        File dir = new File(this.testDir + this.pathSep + dirName);
        dir.mkdir();
        this.setPerms(Paths.get(dir.getCanonicalPath(), new String[0]), DEFAULT_DIR_PERMS);
    }

    private long fileLength(String fileName) {
        File file = new File(this.testDir, fileName);
        return file.length();
    }

    private void setPerms(Path path, String perms) {
        if (!Utils.isWindows()) {
            try {
                Files.setPosixFilePermissions(path, PosixFilePermissions.fromString(perms));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private String getPerms(String fileName) {
        try {
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(Paths.get(this.testDir + this.pathSep + fileName, new String[0]), new LinkOption[0]);
            return PosixFilePermissions.toString(perms);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void deleteFile(String fileName) {
        File file = new File(this.testDir + this.pathSep + fileName);
        file.delete();
    }

    @Test
    public void testAsyncFileConcurrency() throws Exception {
        String fileName = "some-file.dat";
        AtomicReference arFile = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                AsyncFile af = (AsyncFile)ar.result();
                arFile.set(af);
            } else {
                this.fail(ar.cause().getMessage());
            }
            latch.countDown();
        });
        this.awaitLatch(latch);
        AsyncFile af = (AsyncFile)arFile.get();
        Buffer buff = Buffer.buffer((byte[])TestUtils.randomByteArray(4096));
        for (int i = 0; i < 100000; ++i) {
            af.write((Object)buff);
        }
        af.close(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testAtomicMove() throws Exception {
        String source = "foo.txt";
        String middle = "baz.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        try {
            Files.move(new File(this.testDir, source).toPath(), new File(this.testDir, middle).toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            throw new AssumptionViolatedException("Atomic move unsupported");
        }
        FileSystem fs = this.vertx.fileSystem();
        String from = this.testDir + this.pathSep + middle;
        String to = this.testDir + this.pathSep + target;
        CopyOptions options = new CopyOptions().setAtomicMove(true);
        fs.move(from, to, options, this.onSuccess(v -> {
            this.assertFalse(this.fileExists(middle));
            this.assertTrue(this.fileExists(target));
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testCopyReplaceExisting() throws Exception {
        String source = "foo.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        this.createFileWithJunk(target, 100L);
        FileSystem fs = this.vertx.fileSystem();
        String from = this.testDir + this.pathSep + source;
        String to = this.testDir + this.pathSep + target;
        CopyOptions options = new CopyOptions().setReplaceExisting(true);
        fs.copy(from, to, options, this.onSuccess(v -> fs.readFile(from, this.onSuccess(expected -> fs.readFile(to, this.onSuccess(actual -> {
            this.assertEquals(expected, actual);
            this.complete();
        }))))));
        this.await();
    }

    @Test
    public void testCopyNoReplaceExisting() throws Exception {
        String source = "foo.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        this.createFileWithJunk(target, 100L);
        FileSystem fs = this.vertx.fileSystem();
        String from = this.testDir + this.pathSep + source;
        String to = this.testDir + this.pathSep + target;
        CopyOptions options = new CopyOptions();
        fs.copy(from, to, options, this.onFailure(t -> {
            this.assertThat(t, CoreMatchers.instanceOf(FileSystemException.class));
            this.assertThat(t.getCause(), CoreMatchers.instanceOf(FileAlreadyExistsException.class));
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testCopyFileAttributes() throws Exception {
        String source = "foo.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        try {
            Files.setPosixFilePermissions(new File(this.testDir, source).toPath(), EnumSet.of(PosixFilePermission.OWNER_READ));
        }
        catch (UnsupportedOperationException e) {
            throw new AssumptionViolatedException("POSIX file perms unsupported");
        }
        FileSystem fs = this.vertx.fileSystem();
        String from = this.testDir + this.pathSep + source;
        String to = this.testDir + this.pathSep + target;
        CopyOptions options = new CopyOptions().setCopyAttributes(false);
        fs.copy(from, to, options, this.onSuccess(v -> fs.props(from, this.onSuccess(expected -> fs.props(from, this.onSuccess(actual -> {
            this.assertEquals(expected.creationTime(), actual.creationTime());
            this.assertEquals(expected.lastModifiedTime(), actual.lastModifiedTime());
            this.vertx.executeBlocking(fut -> {
                try {
                    fut.complete(Files.getPosixFilePermissions(new File(this.testDir, target).toPath(), LinkOption.NOFOLLOW_LINKS));
                }
                catch (IOException e) {
                    fut.fail((Throwable)e);
                }
            }, this.onSuccess(perms -> {
                this.assertEquals(EnumSet.of(PosixFilePermission.OWNER_READ), perms);
                this.complete();
            }));
        }))))));
        this.await();
    }

    @Test
    public void testCopyNoFollowLinks() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String source = "foo.txt";
        String link = "link.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        try {
            Files.createSymbolicLink(new File(this.testDir, link).toPath(), new File(this.testDir, source).toPath(), new FileAttribute[0]);
        }
        catch (UnsupportedOperationException e) {
            throw new AssumptionViolatedException("Links unsupported");
        }
        FileSystem fs = this.vertx.fileSystem();
        String from = this.testDir + this.pathSep + link;
        String to = this.testDir + this.pathSep + target;
        CopyOptions options = new CopyOptions().setNofollowLinks(true);
        fs.copy(from, to, options, this.onSuccess(v -> fs.lprops(to, this.onSuccess(props -> {
            this.assertTrue(props.isSymbolicLink());
            fs.readFile(from, this.onSuccess(expected -> fs.readFile(to, this.onSuccess(actual -> {
                this.assertEquals(expected, actual);
                this.complete();
            }))));
        }))));
        this.await();
    }

    @Test
    public void testCreateTempDirectory() {
        FileSystem fs = this.vertx.fileSystem();
        fs.createTempDirectory("project", this.onSuccess(tempDirectory -> {
            this.assertNotNull(tempDirectory);
            this.assertTrue(Files.exists(Paths.get(tempDirectory, new String[0]), new LinkOption[0]));
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testCreateTempDirectoryBlocking() {
        FileSystem fs = this.vertx.fileSystem();
        String tempDirectory = fs.createTempDirectoryBlocking("project");
        this.assertTrue(Files.exists(Paths.get(tempDirectory, new String[0]), new LinkOption[0]));
    }

    @Test
    public void testCreateTempDirectoryWithPerms() {
        Assume.assumeFalse((boolean)Utils.isWindows());
        FileSystem fs = this.vertx.fileSystem();
        fs.createTempDirectory("project", DEFAULT_DIR_PERMS, this.onSuccess(tempDirectory -> {
            try {
                String perms = PosixFilePermissions.toString(Files.getPosixFilePermissions(Paths.get(tempDirectory, new String[0]), new LinkOption[0]));
                this.assertEquals(perms, DEFAULT_DIR_PERMS);
            }
            catch (IOException e) {
                this.fail(e);
            }
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testCreateTempDirectoryWithPermsBlocking() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        FileSystem fs = this.vertx.fileSystem();
        String tempDirectory = fs.createTempDirectoryBlocking("project", DEFAULT_DIR_PERMS);
        String perms = PosixFilePermissions.toString(Files.getPosixFilePermissions(Paths.get(tempDirectory, new String[0]), new LinkOption[0]));
        this.assertEquals(perms, DEFAULT_DIR_PERMS);
    }

    @Test
    public void testCreateTempDirectoryWithDirectory() {
        FileSystem fs = this.vertx.fileSystem();
        fs.createTempDirectory(this.testDir, "project", null, this.onSuccess(tempDirectory -> {
            Path path = Paths.get(tempDirectory, new String[0]);
            this.assertTrue(Files.exists(path, new LinkOption[0]));
            this.assertTrue(path.startsWith(this.testDir));
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testCreateTempDirectoryWithDirectoryBlocking() {
        FileSystem fs = this.vertx.fileSystem();
        String tempDirectory = fs.createTempDirectoryBlocking(this.testDir, "project", null);
        Path path = Paths.get(tempDirectory, new String[0]);
        this.assertTrue(Files.exists(Paths.get(tempDirectory, new String[0]), new LinkOption[0]));
        this.assertTrue(path.startsWith(this.testDir));
    }

    @Test
    public void testCreateTempFile() {
        FileSystem fs = this.vertx.fileSystem();
        fs.createTempFile("project", ".tmp", this.onSuccess(tempFile -> {
            this.assertNotNull(tempFile);
            this.assertTrue(Files.exists(Paths.get(tempFile, new String[0]), new LinkOption[0]));
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testCreateTempFileBlocking() {
        FileSystem fs = this.vertx.fileSystem();
        String tempFile = fs.createTempFileBlocking("project", ".tmp");
        this.assertNotNull(tempFile);
        this.assertTrue(Files.exists(Paths.get(tempFile, new String[0]), new LinkOption[0]));
    }

    @Test
    public void testCreateTempFileWithDirectory() {
        FileSystem fs = this.vertx.fileSystem();
        fs.createTempFile(this.testDir, "project", ".tmp", null, this.onSuccess(tempFile -> {
            this.assertNotNull(tempFile);
            Path path = Paths.get(tempFile, new String[0]);
            this.assertTrue(Files.exists(path, new LinkOption[0]));
            this.assertTrue(path.startsWith(this.testDir));
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testCreateTempFileWithDirectoryBlocking() {
        FileSystem fs = this.vertx.fileSystem();
        String tempFile = fs.createTempFileBlocking(this.testDir, "project", ".tmp", null);
        this.assertNotNull(tempFile);
        Path path = Paths.get(tempFile, new String[0]);
        this.assertTrue(Files.exists(path, new LinkOption[0]));
        this.assertTrue(path.startsWith(this.testDir));
    }

    @Test
    public void testCreateTempFileWithPerms() {
        Assume.assumeFalse((boolean)Utils.isWindows());
        FileSystem fs = this.vertx.fileSystem();
        fs.createTempFile("project", ".tmp", DEFAULT_FILE_PERMS, this.onSuccess(tempFile -> {
            Path path = Paths.get(tempFile, new String[0]);
            this.assertTrue(Files.exists(path, new LinkOption[0]));
            try {
                String perms = PosixFilePermissions.toString(Files.getPosixFilePermissions(path, new LinkOption[0]));
                this.assertEquals(perms, DEFAULT_FILE_PERMS);
            }
            catch (IOException e) {
                this.fail(e);
            }
        }));
    }

    @Test
    public void testCreateTempFileWithPermsBlocking() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        FileSystem fs = this.vertx.fileSystem();
        String tempFile = fs.createTempFileBlocking("project", ".tmp", DEFAULT_FILE_PERMS);
        Path path = Paths.get(tempFile, new String[0]);
        this.assertTrue(Files.exists(path, new LinkOption[0]));
        String perms = PosixFilePermissions.toString(Files.getPosixFilePermissions(path, new LinkOption[0]));
        this.assertEquals(perms, DEFAULT_FILE_PERMS);
    }

    static enum ReadStrategy {
        NONE{

            @Override
            void init(ReadStream<Buffer> stream) {
            }

            @Override
            Future<Void> handle(ReadStream<Buffer> stream) {
                return Future.succeededFuture();
            }
        }
        ,
        FLOWING{

            @Override
            void init(ReadStream<Buffer> stream) {
                flowing.set(true);
            }

            @Override
            Future<Void> handle(ReadStream<Buffer> stream) {
                Promise fut = Promise.promise();
                assert (flowing.getAndSet(false));
                stream.pause();
                Vertx.currentContext().owner().setTimer(1L, id -> {
                    assert (!flowing.getAndSet(true));
                    stream.resume();
                    fut.complete();
                });
                return fut.future();
            }
        }
        ,
        FETCH{

            @Override
            void init(ReadStream<Buffer> stream) {
                fetching.set(true);
                stream.pause();
                stream.fetch(1L);
            }

            @Override
            Future<Void> handle(ReadStream<Buffer> stream) {
                Promise fut = Promise.promise();
                assert (fetching.getAndSet(false));
                Vertx.currentContext().owner().setTimer(1L, id -> {
                    assert (!fetching.getAndSet(true));
                    stream.fetch(1L);
                    fut.complete();
                });
                return fut.future();
            }
        };

        static final AtomicBoolean flowing;
        static final AtomicBoolean fetching;

        abstract void init(ReadStream<Buffer> var1);

        abstract Future<Void> handle(ReadStream<Buffer> var1);

        static {
            flowing = new AtomicBoolean();
            fetching = new AtomicBoolean();
        }
    }
}

