/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.util.function.Consumer;
import org.junit.Test;

public class Http1xProxyTest
extends HttpTestBase {
    @Test
    public void testHttpProxyRequest() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort())));
        this.testHttpProxyRequest2(handler -> this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(8080)).setURI("/")).compose(HttpClientRequest::send).onComplete(handler));
    }

    @Test
    public void testHttpProxyRequestOverrideClientSsl() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setSsl(true).setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort())));
        this.testHttpProxyRequest2(handler -> this.client.request(new RequestOptions().setSsl(Boolean.valueOf(false)).setHost("localhost").setPort(Integer.valueOf(8080))).compose(HttpClientRequest::send).onComplete(handler));
    }

    private void testHttpProxyRequest2(Consumer<Handler<AsyncResult<HttpClientResponse>>> reqFact) throws Exception {
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> reqFact.accept(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.assertEquals("Host header doesn't contain target host", "localhost:8080", this.proxy.getLastRequestHeaders().get("Host"));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testHttpProxyRequestAuth() throws Exception {
        this.startProxy("user", ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort()).setUsername("user").setPassword("user")));
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(8080)).setURI("/")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.assertEquals("Host header doesn't contain target host", "localhost:8080", this.proxy.getLastRequestHeaders().get("Host"));
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testHttpProxyFtpRequest() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort())));
        String url = "ftp://ftp.gnu.org/gnu/";
        this.proxy.setForceUri("http://localhost:8080/");
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> this.client.request(new RequestOptions().setURI("ftp://ftp.gnu.org/gnu/")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("request did sent the expected url", "ftp://ftp.gnu.org/gnu/", this.proxy.getLastUri());
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testHttpSocksProxyRequest() throws Exception {
        this.startProxy(null, ProxyType.SOCKS5);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(this.proxy.getPort())));
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(8080)).setURI("/")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testHttpSocksProxyRequestAuth() throws Exception {
        this.startProxy("user", ProxyType.SOCKS5);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(this.proxy.getPort()).setUsername("user").setPassword("user")));
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(8080)).setURI("/")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.testComplete();
        }))));
        this.await();
    }
}

