/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.headers;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public abstract class HeadersTestBase {
    protected abstract MultiMap newMultiMap();

    @Test
    public void testCaseInsensitiveHeaders() {
        MultiMap result = this.newMultiMap();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    @Test
    public void testAddAll1() {
        MultiMap mmap = this.newMultiMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "b");
        MultiMap result = mmap.addAll(map);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"a=b\n", (Object)result.toString());
    }

    @Test
    public void testAddAll2() {
        MultiMap mmap = this.newMultiMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "b");
        map.put("c", "d");
        Assert.assertEquals((Object)"a=b\nc=d\n", (Object)mmap.addAll(map).toString());
    }

    @Test
    public void testAddAllEmptyMap() {
        MultiMap mmap = this.newMultiMap();
        HashMap map = new HashMap();
        Assert.assertEquals((Object)"", (Object)mmap.addAll(map).toString());
    }

    @Test
    public void testAddAllEmptyMultiMap() {
        MultiMap mmap = this.newMultiMap();
        MultiMap headers = this.newMultiMap();
        Assert.assertEquals((Object)"", (Object)mmap.addAll(headers).toString());
    }

    @Test
    public void testAddCharSequenceNameCharSequenceValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        String value = "value";
        Assert.assertEquals((Object)"name=value\n", (Object)mmap.add((CharSequence)name, (CharSequence)value).toString());
    }

    @Test
    public void testAddCharSequenceNameIterableCharSequenceValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)"name=somevalue\n", (Object)mmap.add((CharSequence)name, values).toString());
    }

    @Test
    public void testAddStringNameStringValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "a";
        String strVal = "b";
        Assert.assertEquals((Object)"a=b\n", (Object)mmap.add(name, strVal).toString());
    }

    @Test
    public void testAddStringNameEmptyStringValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "aaa";
        String strVal = "";
        Assert.assertEquals((Object)"aaa=\n", (Object)mmap.add(name, strVal).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testAddNullStringValueTest() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("name", (String)null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddNullCharSequenceValueTest() {
        MultiMap mmap = this.newMultiMap();
        mmap.add((CharSequence)"name", (CharSequence)null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddNullIterableStringValueTest() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("name", (Iterable)null);
    }

    @Test
    public void testAddStringNameIterableStringValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        ArrayList<String> values = new ArrayList<String>();
        values.add("value1");
        values.add("value2");
        MultiMap result = mmap.add(name, values);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"name=value1\nname=value2\n", (Object)result.toString());
    }

    @Test
    public void testAddAllMultiMap() {
        MultiMap mmap = this.newMultiMap();
        MultiMap mm = this.newMultiMap();
        mm.add("header1", "value1");
        mm.add("header2", "value2");
        MultiMap result = mmap.addAll(mm);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"header1=value1\nheader2=value2\n", (Object)result.toString());
    }

    @Test
    public void testClearTest1() {
        MultiMap mmap = this.newMultiMap();
        MultiMap result = mmap.clear();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    @Test
    public void testContainsCharSequence() {
        MultiMap mmap = this.newMultiMap();
        String name = String.valueOf(new Object());
        Assert.assertFalse((boolean)mmap.contains((CharSequence)name));
    }

    @Test
    public void testContainsEmptyString() {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        Assert.assertFalse((boolean)mmap.contains(name));
    }

    @Test
    public void testContainsEmptyValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "0123456789";
        Assert.assertFalse((boolean)mmap.contains(name));
        mmap.add(name, "");
        Assert.assertTrue((boolean)mmap.contains(name));
    }

    @Test
    public void testEntriesEmpty() {
        MultiMap mmap = this.newMultiMap();
        List result = mmap.entries();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testGetMissingCharSequenceName() {
        MultiMap mmap = this.newMultiMap();
        String name = String.valueOf(new Object());
        Assert.assertNull((Object)mmap.get((CharSequence)name));
    }

    @Test
    public void testGetMissingStringName() {
        MultiMap mmap = this.newMultiMap();
        String name = "1";
        Assert.assertNull((Object)mmap.get(name));
    }

    @Test
    public void testGetStringName() {
        MultiMap mmap = this.newMultiMap();
        Assert.assertNull((Object)mmap.get("name"));
        mmap.add("name", "value");
        Assert.assertEquals((Object)"value", (Object)mmap.get("name"));
    }

    @Test(expected=NullPointerException.class)
    public void testGetNullStringName() {
        this.newMultiMap().get(null);
    }

    @Test
    public void testGetAllTestMissingName() {
        MultiMap mmap = this.newMultiMap();
        List result = mmap.getAll("1");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testGetAll() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("name", "value1");
        mmap.add("name", "value2");
        List result = mmap.getAll("name");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"value1", result.get(0));
    }

    @Test(expected=NullPointerException.class)
    public void testGetAllNullName() {
        this.newMultiMap().getAll(null);
    }

    @Test
    public void testIsEmptyEmpty() {
        MultiMap mmap = this.newMultiMap();
        Assert.assertTrue((boolean)mmap.isEmpty());
    }

    @Test
    public void testIsEmptyNonEmpty() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("a", "b");
        Assert.assertFalse((boolean)mmap.isEmpty());
    }

    @Test
    public void testIteratorEmpty() {
        MultiMap mmap = this.newMultiMap();
        Iterator result = mmap.iterator();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testIterator() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("a", "b");
        Iterator result = mmap.iterator();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.hasNext());
    }

    @Test
    public void testNamesEmpty() {
        MultiMap mmap = this.newMultiMap();
        Set result = mmap.names();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testRemoveMissingName() {
        MultiMap mmap = this.newMultiMap();
        String name = String.valueOf(new Object());
        MultiMap result = mmap.remove((CharSequence)name);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNullName() {
        this.newMultiMap().remove(null);
    }

    @Test
    public void testRemove() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("name", "value");
        Assert.assertTrue((boolean)mmap.contains("name"));
        Assert.assertSame((Object)mmap, (Object)mmap.remove("name"));
        Assert.assertFalse((boolean)mmap.contains("name"));
    }

    @Test
    public void testSetAll() {
        MultiMap mmap = this.newMultiMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("aaa", "bbb");
        MultiMap result = mmap.setAll(map);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"aaa=bbb\n", (Object)result.toString());
    }

    @Test
    public void testSetAllEmptyMap() {
        MultiMap mmap = this.newMultiMap();
        MultiMap result = mmap.setAll(new HashMap());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    @Test
    public void testSetAllEmptyMultiMap() {
        MultiMap mmap = this.newMultiMap();
        MultiMap result = mmap.setAll(this.newMultiMap());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    @Test
    public void testSetCharSequenceNameCharSequenceValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        String value = "value";
        MultiMap result = mmap.set((CharSequence)name, (CharSequence)value);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"name=value\n", (Object)result.toString());
    }

    @Test
    public void testSetCharSequenceNameIterableCharSequenceValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)"name=somevalue\n", (Object)mmap.set((CharSequence)name, values).toString());
    }

    @Test
    public void testSetStringNameStringValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "aaa";
        String strVal = "bbb";
        MultiMap result = mmap.set(name, strVal);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"aaa=bbb\n", (Object)result.toString());
    }

    @Test
    public void testSetStringNameEmptyStringValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "aaa";
        String strVal = "";
        MultiMap result = mmap.set(name, strVal);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"aaa=\n", (Object)result.toString());
    }

    @Test
    public void testSetNullCharSequenceValue() {
        MultiMap mmap = this.newMultiMap();
        mmap.set("name", "value");
        mmap.set((CharSequence)"name", (CharSequence)null);
        Assert.assertFalse((boolean)mmap.contains("name"));
        Assert.assertTrue((boolean)mmap.isEmpty());
        Assert.assertFalse((boolean)mmap.iterator().hasNext());
    }

    @Test
    public void testSetNullStringValue() {
        MultiMap mmap = this.newMultiMap();
        mmap.set("name", "value");
        mmap.set("name", (String)null);
        Assert.assertFalse((boolean)mmap.contains("name"));
        Assert.assertTrue((boolean)mmap.isEmpty());
        Assert.assertFalse((boolean)mmap.iterator().hasNext());
    }

    @Test(expected=NullPointerException.class)
    public void testSetNullIterableStringValue() {
        this.newMultiMap().set("name", (Iterable)null);
    }

    @Test(expected=NullPointerException.class)
    public void testSetNullIterableCharSequenceValue() {
        this.newMultiMap().set("name", (Iterable)null);
    }

    @Test
    public void testSetEmptyIterableStringValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        ArrayList values = new ArrayList();
        MultiMap result = mmap.set(name, values);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    @Test
    public void testSetEmptyIterableCharSequenceValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        ArrayList values = new ArrayList();
        MultiMap result = mmap.set((CharSequence)name, values);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    @Test
    public void testSetIterableStringValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        ArrayList<String> values = new ArrayList<String>();
        values.add("value1");
        values.add(null);
        values.add("value3");
        MultiMap result = mmap.set(name, values);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"name=value1\n", (Object)result.toString());
    }

    @Test
    public void testSize() {
        MultiMap mmap = this.newMultiMap();
        Assert.assertEquals((long)0L, (long)mmap.size());
        mmap.add("header", "value");
        Assert.assertEquals((long)1L, (long)mmap.size());
        mmap.add("header2", "value2");
        Assert.assertEquals((long)2L, (long)mmap.size());
        mmap.add("header", "value3");
        Assert.assertEquals((long)2L, (long)mmap.size());
    }

    private String sortByLine(String str) {
        Object[] lines = str.split("\n");
        Arrays.sort(lines);
        StringBuilder sb = new StringBuilder();
        for (Object s : lines) {
            sb.append((String)s);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Test
    public void testToString() {
        MultiMap mm = this.newMultiMap();
        Assert.assertEquals((Object)"", (Object)mm.toString());
        mm.add("header1", "Value1");
        Assert.assertEquals((Object)"header1=Value1\n", (Object)this.sortByLine(mm.toString()));
        mm.add("header2", "Value2");
        Assert.assertEquals((Object)"header1=Value1\nheader2=Value2\n", (Object)this.sortByLine(mm.toString()));
        mm.add("header1", "Value3");
        Assert.assertEquals((Object)"header1=Value1\nheader1=Value3\nheader2=Value2\n", (Object)this.sortByLine(mm.toString()));
        mm.remove("header1");
        Assert.assertEquals((Object)"header2=Value2\n", (Object)this.sortByLine(mm.toString()));
        mm.set("header2", "Value4");
        Assert.assertEquals((Object)"header2=Value4\n", (Object)this.sortByLine(mm.toString()));
    }

    @Test
    public void testMapEntrySetValue() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("header", "oldvalue");
        for (Map.Entry me : mmap) {
            me.setValue("newvalue");
        }
        Assert.assertEquals((Object)"newvalue", (Object)mmap.get("header"));
    }

    @Test
    public void testMapEntryToString() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("header", "value");
        Assert.assertEquals((Object)"header=value", (Object)((Map.Entry)mmap.iterator().next()).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testMapEntrySetValueNull() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("header", "oldvalue");
        for (Map.Entry me : mmap) {
            me.setValue(null);
        }
    }

    @Test
    public void testContainsValueString() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("headeR", "vAlue");
        Assert.assertTrue((boolean)mmap.contains("heaDer", "vAlue", false));
        Assert.assertFalse((boolean)mmap.contains("heaDer", "Value", false));
    }

    @Test
    public void testContainsValueStringIgnoreCase() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("headeR", "vAlue");
        Assert.assertTrue((boolean)mmap.contains("heaDer", "vAlue", true));
        Assert.assertTrue((boolean)mmap.contains("heaDer", "Value", true));
    }

    @Test
    public void testContainsValueCharSequence() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("headeR", "vAlue");
        CharSequence name = HttpHeaders.createOptimized((String)"heaDer");
        CharSequence vAlue = HttpHeaders.createOptimized((String)"vAlue");
        CharSequence Value = HttpHeaders.createOptimized((String)"Value");
        Assert.assertTrue((boolean)mmap.contains(name, vAlue, false));
        Assert.assertFalse((boolean)mmap.contains(name, Value, false));
    }

    @Test
    public void testContainsValueCharSequenceIgnoreCase() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("headeR", "vAlue");
        CharSequence name = HttpHeaders.createOptimized((String)"heaDer");
        CharSequence vAlue = HttpHeaders.createOptimized((String)"vAlue");
        CharSequence Value = HttpHeaders.createOptimized((String)"Value");
        Assert.assertTrue((boolean)mmap.contains(name, vAlue, true));
        Assert.assertTrue((boolean)mmap.contains(name, Value, true));
    }

    @Test
    public void testGetShouldReturnAddedEntriesInOrder() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("header", "value1");
        mmap.add("header", "value2");
        mmap.add("header", "value3");
        Assert.assertEquals((Object)"value1", (Object)mmap.get("header"));
        Assert.assertEquals(Arrays.asList("value1", "value2", "value3"), (Object)mmap.getAll("header"));
    }

    @Test
    public void testGetShouldReturnEntriesFromListInOrder() {
        MultiMap mmap = this.newMultiMap();
        mmap.add((CharSequence)"header", Arrays.asList("value1", "value2", "value3"));
        Assert.assertEquals((Object)"value1", (Object)mmap.get("header"));
        Assert.assertEquals(Arrays.asList("value1", "value2", "value3"), (Object)mmap.getAll("header"));
    }

    @Test
    public void testIterableArgument() {
        MultiMap mmap = this.newMultiMap();
        mmap.add("header", Arrays.asList("value1", "value2"));
        Assert.assertEquals(Arrays.asList("value1", "value2"), (Object)mmap.getAll("header"));
        mmap = this.newMultiMap();
        mmap.add((CharSequence)"header", Arrays.asList(HttpHeaders.createOptimized((String)"value1"), HttpHeaders.createOptimized((String)"value2")));
        Assert.assertEquals(Arrays.asList("value1", "value2"), (Object)mmap.getAll("header"));
        mmap = this.newMultiMap();
        mmap.set((CharSequence)"header", Arrays.asList("value1", "value2"));
        Assert.assertEquals(Arrays.asList("value1", "value2"), (Object)mmap.getAll("header"));
        mmap = this.newMultiMap();
        mmap.set((CharSequence)"header", Arrays.asList(HttpHeaders.createOptimized((String)"value1"), HttpHeaders.createOptimized((String)"value2")));
        Assert.assertEquals(Arrays.asList("value1", "value2"), (Object)mmap.getAll("header"));
    }
}

