/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.headers;

import io.netty.util.AsciiString;
import io.vertx.core.MultiMap;
import io.vertx.core.http.headers.HeadersTestBase;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class VertxHttpHeadersTest
extends HeadersTestBase {
    protected String sameHash1 = "ABCDEF";
    protected String sameHash2 = "HOBOURN";
    protected String sameBucket1 = "ZEITOUN";
    protected String sameBucket2 = "AAKSUHX";

    @Override
    protected MultiMap newMultiMap() {
        return HeadersMultiMap.httpHeaders();
    }

    @Test
    public void checkNameCollision() {
        Assert.assertEquals((long)AsciiString.hashCode((CharSequence)this.sameHash1), (long)AsciiString.hashCode((CharSequence)this.sameHash2));
        Assert.assertEquals((long)(AsciiString.hashCode((CharSequence)this.sameBucket1) & 0xF), (long)(AsciiString.hashCode((CharSequence)this.sameBucket2) & 0xF));
        Assert.assertNotEquals((long)AsciiString.hashCode((CharSequence)this.sameBucket1), (long)AsciiString.hashCode((CharSequence)this.sameBucket2));
    }

    @Test
    public void testAddEmptyStringNameIterableStringValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)"=somevalue\n", (Object)mmap.add((CharSequence)name, values).toString());
    }

    @Test
    public void testAddEmptyStringNameEmptyStringValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "";
        Assert.assertEquals((Object)"=\n", (Object)mmap.add(name, strVal).toString());
    }

    @Test
    public void testAddEmptyStringName() {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "aaa";
        Assert.assertEquals((Object)"=aaa\n", (Object)mmap.add(name, strVal).toString());
    }

    @Test
    public void testSetAllEmptyStringNameAndEmptyValue() {
        MultiMap mmap = this.newMultiMap();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("", "");
        MultiMap result = mmap.setAll(headers);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"=\n", (Object)result.toString());
    }

    @Test
    public void testSetEmptyStringNameAndEmptyValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "";
        MultiMap result = mmap.set(name, strVal);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"=\n", (Object)result.toString());
    }

    @Test
    public void testSetEmptyStringName() {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "bbb";
        MultiMap result = mmap.set(name, strVal);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"=bbb\n", (Object)result.toString());
    }

    @Override
    @Test
    public void testSetAll() {
        MultiMap mmap = this.newMultiMap();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("", "");
        headers.put("aaa", "bbb");
        MultiMap result = mmap.setAll(headers);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"=\naaa=bbb\n", (Object)result.toString());
    }

    @Test
    public void testSetEmptyStringNameIterableStringValue() {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)"=somevalue\n", (Object)mmap.set((CharSequence)name, values).toString());
    }

    @Test
    public void testGetHashColl() {
        MultiMap mm = this.newMultiMap();
        String name1 = this.sameHash1;
        String name2 = this.sameHash2;
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"value1", (Object)mm.get(name1));
        Assert.assertEquals((Object)"value2", (Object)mm.get(name2));
        mm = this.newMultiMap();
        name1 = this.sameBucket1;
        name2 = this.sameBucket2;
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"value1", (Object)mm.get(name1));
        Assert.assertEquals((Object)"value2", (Object)mm.get(name2));
    }

    @Test
    public void testGetAllHashColl() {
        MultiMap mm = this.newMultiMap();
        String name1 = this.sameHash1;
        String name2 = this.sameHash2;
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"[value1]", (Object)mm.getAll(name1).toString());
        Assert.assertEquals((Object)"[value2]", (Object)mm.getAll(name2).toString());
        mm = this.newMultiMap();
        name1 = this.sameBucket1;
        name2 = this.sameBucket2;
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"[value1]", (Object)mm.getAll(name1).toString());
        Assert.assertEquals((Object)"[value2]", (Object)mm.getAll(name2).toString());
    }

    @Test
    public void testRemoveHashColl() {
        MultiMap mm = this.newMultiMap();
        String name1 = this.sameHash1;
        String name2 = this.sameHash2;
        String name3 = "RZ";
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        mm.add(name3, "value3");
        mm.add(name1, "value4");
        mm.add(name2, "value5");
        mm.add(name3, "value6");
        Assert.assertEquals((long)3L, (long)mm.size());
        mm.remove(name1);
        mm.remove(name2);
        Assert.assertEquals((long)1L, (long)mm.size());
        mm = this.newMultiMap();
        name1 = this.sameBucket1;
        name2 = this.sameBucket2;
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        mm.remove(name1);
        mm.remove(name2);
        Assert.assertTrue((String)"not empty", (boolean)mm.isEmpty());
    }

    @Test
    public void testRemovalNext() {
        MultiMap mmap = this.newMultiMap();
        String name1 = this.sameHash1;
        String name2 = this.sameHash2;
        mmap.add(name1, "v");
        mmap.add(name1, "v");
        mmap.add(name2, "q");
        mmap.remove(name1);
        mmap.set(name1, "w");
        Assert.assertEquals((Object)"w", (Object)mmap.get(name1));
    }
}

