/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxFactory;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.test.fakemetrics.FakeVertxMetrics;
import io.vertx.test.faketracer.FakeTracer;
import io.vertx.test.faketracer.FakeTracerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class VertxFactoryTest {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Test
    public void testCreate() {
        VertxFactory factory = new VertxFactory();
        Vertx vertx = factory.vertx();
        Assert.assertNotNull((Object)vertx);
    }

    @Test
    public void testCreateClustered() throws Exception {
        VertxFactory factory = new VertxFactory();
        CompletableFuture fut = new CompletableFuture();
        factory.clusteredVertx(ar -> {
            if (ar.succeeded()) {
                fut.complete(ar.result());
            } else {
                fut.completeExceptionally(ar.cause());
            }
        });
        Vertx vertx = (Vertx)fut.get(10L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)vertx);
        Assert.assertNotNull((Object)((VertxInternal)vertx).getClusterManager());
    }

    @Test
    public void testFactoryMetricsOverridesMetaInf() {
        this.runWithServiceFromMetaInf(VertxMetricsFactory.class, FakeVertxMetrics.class.getName(), () -> {
            FakeVertxMetrics metrics = new FakeVertxMetrics();
            MetricsOptions metricsOptions = new MetricsOptions().setEnabled(true);
            VertxFactory factory = new VertxFactory(new VertxOptions().setMetricsOptions(metricsOptions));
            factory.metrics((VertxMetrics)metrics);
            Vertx vertx = factory.vertx();
            Assert.assertSame((Object)metrics, (Object)((VertxInternal)vertx).metricsSPI());
        });
    }

    @Test
    public void testFactoryMetricsFactoryOverridesOptions() {
        FakeVertxMetrics metrics = new FakeVertxMetrics();
        MetricsOptions metricsOptions = new MetricsOptions().setEnabled(true).setFactory(options -> {
            throw new AssertionError();
        });
        VertxFactory factory = new VertxFactory(new VertxOptions().setMetricsOptions(metricsOptions));
        factory.metrics((VertxMetrics)metrics);
        Vertx vertx = factory.vertx();
        Assert.assertSame((Object)metrics, (Object)((VertxInternal)vertx).metricsSPI());
    }

    @Test
    public void testFactoryTracerOverridesMetaInf() {
        this.runWithServiceFromMetaInf(VertxTracerFactory.class, FakeTracerFactory.class.getName(), () -> {
            FakeTracer tracer = new FakeTracer();
            TracingOptions tracingOptions = new TracingOptions();
            VertxFactory factory = new VertxFactory(new VertxOptions().setTracingOptions(tracingOptions));
            factory.tracer((VertxTracer)tracer);
            Vertx vertx = factory.vertx();
            Assert.assertSame((Object)tracer, (Object)((VertxInternal)vertx).getOrCreateContext().tracer());
        });
    }

    @Test
    public void testFactoryTracerFactoryOverridesOptions() {
        FakeTracer tracer = new FakeTracer();
        TracingOptions tracingOptions = new TracingOptions().setFactory(new VertxTracerFactory(){

            public VertxTracer tracer(TracingOptions options) {
                throw new AssertionError();
            }
        });
        VertxFactory factory = new VertxFactory(new VertxOptions().setTracingOptions(tracingOptions));
        factory.tracer((VertxTracer)tracer);
        Vertx vertx = factory.vertx();
        Assert.assertSame((Object)tracer, (Object)((VertxInternal)vertx).getOrCreateContext().tracer());
    }

    @Test
    public void testFactoryClusterManagerOverridesMetaInf() throws Exception {
        FakeClusterManager clusterManager = new FakeClusterManager();
        CompletableFuture res = new CompletableFuture();
        this.runWithServiceFromMetaInf(ClusterManager.class, FakeClusterManager.class.getName(), () -> {
            VertxFactory factory = new VertxFactory(new VertxOptions());
            factory.clusterManager((ClusterManager)clusterManager);
            factory.clusteredVertx(ar -> {
                if (ar.succeeded()) {
                    res.complete(ar.result());
                } else {
                    res.completeExceptionally(ar.cause());
                }
            });
        });
        Vertx vertx = (Vertx)res.get(10L, TimeUnit.SECONDS);
        Assert.assertSame((Object)clusterManager, (Object)((VertxInternal)vertx).getClusterManager());
    }

    @Test
    public void testFactoryTransportOverridesDefault() {
        VertxFactory factory = new VertxFactory();
        Transport override = new Transport(){};
        factory.transport(override);
        Vertx vertx = factory.vertx();
        Assert.assertSame((Object)override, (Object)((VertxInternal)vertx).transport());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithServiceFromMetaInf(Class<?> service, String implementationName, Runnable runnable) {
        URLClassLoader classLoader;
        try {
            File dir = new File(this.testFolder.newFolder("META-INF"), "services");
            dir.mkdirs();
            Assert.assertTrue((boolean)dir.exists());
            File desc = new File(dir, service.getName());
            Files.write(desc.toPath(), implementationName.getBytes(), new OpenOption[0]);
            Assert.assertTrue((boolean)desc.exists());
            classLoader = new URLClassLoader(new URL[]{this.testFolder.getRoot().toURI().toURL()});
        }
        catch (IOException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
        Thread thread = Thread.currentThread();
        ClassLoader prev = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            runnable.run();
        }
        finally {
            thread.setContextClassLoader(prev);
        }
    }
}

