/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.shareddata.Shareable;
import io.vertx.test.core.TestUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonObjectTest {
    protected JsonObject jsonObject;

    @Before
    public void setUp() throws Exception {
        this.jsonObject = new JsonObject();
    }

    @Test
    public void testGetInteger() {
        this.jsonObject.put("foo", (Object)123);
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("foo"));
        this.jsonObject.put("bar", (Object)"hello");
        try {
            this.jsonObject.getInteger("bar");
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.put("foo", (Object)123L);
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("foo"));
        this.jsonObject.put("foo", (Object)123.0);
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("foo"));
        this.jsonObject.put("foo", (Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("foo"));
        this.jsonObject.put("foo", (Object)Long.MAX_VALUE);
        Assert.assertEquals((Object)-1, (Object)this.jsonObject.getInteger("foo"));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getInteger("foo"));
        Assert.assertNull((Object)this.jsonObject.getInteger("absent"));
        try {
            this.jsonObject.getInteger(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetIntegerDefault() {
        this.jsonObject.put("foo", (Object)123);
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("foo", Integer.valueOf(321)));
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("foo", null));
        this.jsonObject.put("bar", (Object)"hello");
        try {
            this.jsonObject.getInteger("bar", Integer.valueOf(123));
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.put("foo", (Object)123L);
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("foo", Integer.valueOf(321)));
        this.jsonObject.put("foo", (Object)123.0);
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("foo", Integer.valueOf(321)));
        this.jsonObject.put("foo", (Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("foo", Integer.valueOf(321)));
        this.jsonObject.put("foo", (Object)Long.MAX_VALUE);
        Assert.assertEquals((Object)-1, (Object)this.jsonObject.getInteger("foo", Integer.valueOf(321)));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getInteger("foo", Integer.valueOf(321)));
        Assert.assertEquals((Object)321, (Object)this.jsonObject.getInteger("absent", Integer.valueOf(321)));
        Assert.assertNull((Object)this.jsonObject.getInteger("foo", null));
        Assert.assertNull((Object)this.jsonObject.getInteger("absent", null));
        try {
            this.jsonObject.getInteger(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetLong() {
        this.jsonObject.put("foo", (Object)123L);
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("foo"));
        this.jsonObject.put("bar", (Object)"hello");
        try {
            this.jsonObject.getLong("bar");
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.put("foo", (Object)123);
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("foo"));
        this.jsonObject.put("foo", (Object)123.0);
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("foo"));
        this.jsonObject.put("foo", (Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("foo"));
        this.jsonObject.put("foo", (Object)Long.MAX_VALUE);
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)this.jsonObject.getLong("foo"));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getLong("foo"));
        Assert.assertNull((Object)this.jsonObject.getLong("absent"));
        try {
            this.jsonObject.getLong(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetLongDefault() {
        this.jsonObject.put("foo", (Object)123L);
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("foo", Long.valueOf(321L)));
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("foo", null));
        this.jsonObject.put("bar", (Object)"hello");
        try {
            this.jsonObject.getLong("bar", Long.valueOf(123L));
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.put("foo", (Object)123);
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("foo", Long.valueOf(321L)));
        this.jsonObject.put("foo", (Object)123.0);
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("foo", Long.valueOf(321L)));
        this.jsonObject.put("foo", (Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("foo", Long.valueOf(321L)));
        this.jsonObject.put("foo", (Object)Long.MAX_VALUE);
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)this.jsonObject.getLong("foo", Long.valueOf(321L)));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getLong("foo", Long.valueOf(321L)));
        Assert.assertEquals((Object)321L, (Object)this.jsonObject.getLong("absent", Long.valueOf(321L)));
        Assert.assertNull((Object)this.jsonObject.getLong("foo", null));
        Assert.assertNull((Object)this.jsonObject.getLong("absent", null));
        try {
            this.jsonObject.getLong(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFloat() {
        this.jsonObject.put("foo", (Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getFloat("foo"));
        this.jsonObject.put("bar", (Object)"hello");
        try {
            this.jsonObject.getFloat("bar");
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.put("foo", (Object)123);
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getFloat("foo"));
        this.jsonObject.put("foo", (Object)123.0);
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getFloat("foo"));
        this.jsonObject.put("foo", (Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getFloat("foo"));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getFloat("foo"));
        Assert.assertNull((Object)this.jsonObject.getFloat("absent"));
        try {
            this.jsonObject.getFloat(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFloatDefault() {
        this.jsonObject.put("foo", (Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getFloat("foo", Float.valueOf(321.0f)));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getFloat("foo", null));
        this.jsonObject.put("bar", (Object)"hello");
        try {
            this.jsonObject.getFloat("bar", Float.valueOf(123.0f));
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.put("foo", (Object)123);
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getFloat("foo", Float.valueOf(321.0f)));
        this.jsonObject.put("foo", (Object)123.0);
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getFloat("foo", Float.valueOf(321.0f)));
        this.jsonObject.put("foo", (Object)123L);
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getFloat("foo", Float.valueOf(321.0f)));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getFloat("foo", Float.valueOf(321.0f)));
        Assert.assertEquals((Object)Float.valueOf(321.0f), (Object)this.jsonObject.getFloat("absent", Float.valueOf(321.0f)));
        Assert.assertNull((Object)this.jsonObject.getFloat("foo", null));
        Assert.assertNull((Object)this.jsonObject.getFloat("absent", null));
        try {
            this.jsonObject.getFloat(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDouble() {
        this.jsonObject.put("foo", (Object)123.0);
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getDouble("foo"));
        this.jsonObject.put("bar", (Object)"hello");
        try {
            this.jsonObject.getDouble("bar");
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.put("foo", (Object)123);
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getDouble("foo"));
        this.jsonObject.put("foo", (Object)123L);
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getDouble("foo"));
        this.jsonObject.put("foo", (Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getDouble("foo"));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getDouble("foo"));
        Assert.assertNull((Object)this.jsonObject.getDouble("absent"));
        try {
            this.jsonObject.getDouble(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDoubleDefault() {
        this.jsonObject.put("foo", (Object)123.0);
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getDouble("foo", Double.valueOf(321.0)));
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getDouble("foo", null));
        this.jsonObject.put("bar", (Object)"hello");
        try {
            this.jsonObject.getDouble("bar", Double.valueOf(123.0));
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.put("foo", (Object)123);
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getDouble("foo", Double.valueOf(321.0)));
        this.jsonObject.put("foo", (Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getDouble("foo", Double.valueOf(321.0)));
        this.jsonObject.put("foo", (Object)123L);
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getDouble("foo", Double.valueOf(321.0)));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getDouble("foo", Double.valueOf(321.0)));
        Assert.assertEquals((Object)321.0, (Object)this.jsonObject.getDouble("absent", Double.valueOf(321.0)));
        Assert.assertNull((Object)this.jsonObject.getDouble("foo", null));
        Assert.assertNull((Object)this.jsonObject.getDouble("absent", null));
        try {
            this.jsonObject.getDouble(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetString() {
        this.jsonObject.put("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getString("foo"));
        this.jsonObject.put("bar", (Object)123);
        Assert.assertEquals((Object)"123", (Object)this.jsonObject.getString("bar"));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getString("foo"));
        Assert.assertNull((Object)this.jsonObject.getString("absent"));
        try {
            this.jsonObject.getString(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetStringDefault() {
        this.jsonObject.put("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getString("foo", "wibble"));
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getString("foo", null));
        this.jsonObject.put("bar", (Object)123);
        Assert.assertEquals((Object)"123", (Object)this.jsonObject.getString("bar", "wibble"));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getString("foo", "wibble"));
        Assert.assertEquals((Object)"wibble", (Object)this.jsonObject.getString("absent", "wibble"));
        Assert.assertNull((Object)this.jsonObject.getString("foo", null));
        Assert.assertNull((Object)this.jsonObject.getString("absent", null));
        try {
            this.jsonObject.getString(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBoolean() {
        this.jsonObject.put("foo", (Object)true);
        Assert.assertEquals((Object)true, (Object)this.jsonObject.getBoolean("foo"));
        this.jsonObject.put("foo", (Object)false);
        Assert.assertEquals((Object)false, (Object)this.jsonObject.getBoolean("foo"));
        this.jsonObject.put("bar", (Object)123);
        try {
            this.jsonObject.getBoolean("bar");
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getBoolean("foo"));
        Assert.assertNull((Object)this.jsonObject.getBoolean("absent"));
        try {
            this.jsonObject.getBoolean(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBooleanDefault() {
        this.jsonObject.put("foo", (Object)true);
        Assert.assertEquals((Object)true, (Object)this.jsonObject.getBoolean("foo", Boolean.valueOf(false)));
        Assert.assertEquals((Object)true, (Object)this.jsonObject.getBoolean("foo", null));
        this.jsonObject.put("foo", (Object)false);
        Assert.assertEquals((Object)false, (Object)this.jsonObject.getBoolean("foo", Boolean.valueOf(true)));
        Assert.assertEquals((Object)false, (Object)this.jsonObject.getBoolean("foo", null));
        this.jsonObject.put("bar", (Object)123);
        try {
            this.jsonObject.getBoolean("bar", Boolean.valueOf(true));
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getBoolean("foo", Boolean.valueOf(true)));
        Assert.assertNull((Object)this.jsonObject.getBoolean("foo", Boolean.valueOf(false)));
        Assert.assertEquals((Object)true, (Object)this.jsonObject.getBoolean("absent", Boolean.valueOf(true)));
        Assert.assertEquals((Object)false, (Object)this.jsonObject.getBoolean("absent", Boolean.valueOf(false)));
        try {
            this.jsonObject.getBoolean(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBinary() {
        byte[] bytes = TestUtils.randomByteArray(100);
        this.jsonObject.put("foo", (Object)bytes);
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.jsonObject.getBinary("foo"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)this.jsonObject.getValue("foo"));
        String val = this.jsonObject.getString("foo");
        Assert.assertNotNull((Object)val);
        byte[] retrieved = JsonUtil.BASE64_DECODER.decode(val);
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(bytes, retrieved));
        this.jsonObject.put("foo", (Object)123);
        try {
            this.jsonObject.getBinary("foo");
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getBinary("foo"));
        Assert.assertNull((Object)this.jsonObject.getValue("foo"));
        Assert.assertNull((Object)this.jsonObject.getBinary("absent"));
        Assert.assertNull((Object)this.jsonObject.getValue("absent"));
        try {
            this.jsonObject.getBinary(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.jsonObject.getBinary(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBuffer() {
        Buffer bytes = TestUtils.randomBuffer(100);
        this.jsonObject.put("foo", (Object)bytes);
        Assert.assertEquals((Object)bytes, (Object)this.jsonObject.getBuffer("foo"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes.getBytes()), (Object)this.jsonObject.getValue("foo"));
        String val = this.jsonObject.getString("foo");
        Assert.assertNotNull((Object)val);
        byte[] retrieved = JsonUtil.BASE64_DECODER.decode(val);
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(bytes.getBytes(), retrieved));
        this.jsonObject.put("foo", (Object)123);
        try {
            this.jsonObject.getBuffer("foo");
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getBuffer("foo"));
        Assert.assertNull((Object)this.jsonObject.getValue("foo"));
        Assert.assertNull((Object)this.jsonObject.getBuffer("absent"));
        Assert.assertNull((Object)this.jsonObject.getValue("absent"));
        try {
            this.jsonObject.getBuffer(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.jsonObject.getBuffer(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetInstant() {
        Instant now = Instant.now();
        this.jsonObject.put("foo", (Object)now);
        Assert.assertEquals((Object)now, (Object)this.jsonObject.getInstant("foo"));
        Assert.assertEquals((Object)now.toString(), (Object)this.jsonObject.getValue("foo"));
        String val = this.jsonObject.getString("foo");
        Assert.assertNotNull((Object)val);
        Instant retrieved = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(val));
        Assert.assertEquals((Object)now, (Object)retrieved);
        this.jsonObject.put("foo", (Object)123);
        try {
            this.jsonObject.getInstant("foo");
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getInstant("foo"));
        Assert.assertNull((Object)this.jsonObject.getValue("foo"));
        Assert.assertNull((Object)this.jsonObject.getInstant("absent"));
        Assert.assertNull((Object)this.jsonObject.getValue("absent"));
        try {
            this.jsonObject.getInstant(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.jsonObject.getValue(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.jsonObject.getInstant(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.jsonObject.getValue(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBinaryDefault() {
        byte[] bytes = TestUtils.randomByteArray(100);
        byte[] defBytes = TestUtils.randomByteArray(100);
        this.jsonObject.put("foo", (Object)bytes);
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.jsonObject.getBinary("foo", defBytes));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)this.jsonObject.getValue("foo", (Object)JsonUtil.BASE64_ENCODER.encode(defBytes)));
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.jsonObject.getBinary("foo", null));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)this.jsonObject.getValue("foo", null));
        this.jsonObject.put("foo", (Object)123);
        try {
            this.jsonObject.getBinary("foo", defBytes);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getBinary("foo", defBytes));
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(defBytes, this.jsonObject.getBinary("absent", defBytes)));
        Assert.assertNull((Object)this.jsonObject.getBinary("foo", null));
        Assert.assertNull((Object)this.jsonObject.getBinary("absent", null));
        try {
            this.jsonObject.getBinary(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetInstantDefault() {
        Instant now = Instant.now();
        Instant later = now.plus(1L, ChronoUnit.DAYS);
        this.jsonObject.put("foo", (Object)now);
        Assert.assertEquals((Object)now, (Object)this.jsonObject.getInstant("foo", later));
        Assert.assertEquals((Object)now.toString(), (Object)this.jsonObject.getValue("foo", (Object)later));
        Assert.assertEquals((Object)now, (Object)this.jsonObject.getInstant("foo", null));
        Assert.assertEquals((Object)now.toString(), (Object)this.jsonObject.getValue("foo", null));
        this.jsonObject.put("foo", (Object)123);
        try {
            this.jsonObject.getInstant("foo", later);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getInstant("foo", later));
        Assert.assertEquals((Object)later, (Object)this.jsonObject.getInstant("absent", later));
        Assert.assertEquals((Object)later, (Object)this.jsonObject.getValue("absent", (Object)later));
        Assert.assertNull((Object)this.jsonObject.getInstant("foo", null));
        Assert.assertNull((Object)this.jsonObject.getValue("foo", null));
        Assert.assertNull((Object)this.jsonObject.getInstant("absent", null));
        Assert.assertNull((Object)this.jsonObject.getValue("absent", null));
        try {
            this.jsonObject.getInstant(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.jsonObject.getValue(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetJsonObject() {
        JsonObject obj = new JsonObject().put("blah", (Object)"wibble");
        this.jsonObject.put("foo", (Object)obj);
        Assert.assertEquals((Object)obj, (Object)this.jsonObject.getJsonObject("foo"));
        this.jsonObject.put("foo", (Object)"hello");
        try {
            this.jsonObject.getJsonObject("foo");
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getJsonObject("foo"));
        Assert.assertNull((Object)this.jsonObject.getJsonObject("absent"));
        try {
            this.jsonObject.getJsonObject(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetJsonObjectDefault() {
        JsonObject obj = new JsonObject().put("blah", (Object)"wibble");
        JsonObject def = new JsonObject().put("eek", (Object)"quuz");
        this.jsonObject.put("foo", (Object)obj);
        Assert.assertEquals((Object)obj, (Object)this.jsonObject.getJsonObject("foo", def));
        Assert.assertEquals((Object)obj, (Object)this.jsonObject.getJsonObject("foo", null));
        this.jsonObject.put("foo", (Object)"hello");
        try {
            this.jsonObject.getJsonObject("foo", def);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getJsonObject("foo", def));
        Assert.assertEquals((Object)def, (Object)this.jsonObject.getJsonObject("absent", def));
        Assert.assertNull((Object)this.jsonObject.getJsonObject("foo", null));
        Assert.assertNull((Object)this.jsonObject.getJsonObject("absent", null));
        try {
            this.jsonObject.getJsonObject(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetJsonArray() {
        JsonArray arr = new JsonArray().add((Object)"blah").add((Object)"wibble");
        this.jsonObject.put("foo", (Object)arr);
        Assert.assertEquals((Object)arr, (Object)this.jsonObject.getJsonArray("foo"));
        this.jsonObject.put("foo", (Object)"hello");
        try {
            this.jsonObject.getJsonArray("foo");
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getJsonArray("foo"));
        Assert.assertNull((Object)this.jsonObject.getJsonArray("absent"));
        try {
            this.jsonObject.getJsonArray(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetJsonArrayDefault() {
        JsonArray arr = new JsonArray().add((Object)"blah").add((Object)"wibble");
        JsonArray def = new JsonArray().add((Object)"quux").add((Object)"eek");
        this.jsonObject.put("foo", (Object)arr);
        Assert.assertEquals((Object)arr, (Object)this.jsonObject.getJsonArray("foo", def));
        Assert.assertEquals((Object)arr, (Object)this.jsonObject.getJsonArray("foo", null));
        this.jsonObject.put("foo", (Object)"hello");
        try {
            this.jsonObject.getJsonArray("foo", def);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getJsonArray("foo", def));
        Assert.assertEquals((Object)def, (Object)this.jsonObject.getJsonArray("absent", def));
        Assert.assertNull((Object)this.jsonObject.getJsonArray("foo", null));
        Assert.assertNull((Object)this.jsonObject.getJsonArray("absent", null));
        try {
            this.jsonObject.getJsonArray(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetValue() {
        this.jsonObject.put("foo", (Object)123);
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("foo", (Object)123L);
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("foo", (Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("foo", (Object)123.0);
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("foo", (Object)false);
        Assert.assertEquals((Object)false, (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("foo", (Object)true);
        Assert.assertEquals((Object)true, (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getValue("foo"));
        JsonObject obj = new JsonObject().put("blah", (Object)"wibble");
        this.jsonObject.put("foo", (Object)obj);
        Assert.assertEquals((Object)obj, (Object)this.jsonObject.getValue("foo"));
        JsonArray arr = new JsonArray().add((Object)"blah").add((Object)"wibble");
        this.jsonObject.put("foo", (Object)arr);
        Assert.assertEquals((Object)arr, (Object)this.jsonObject.getValue("foo"));
        byte[] bytes = TestUtils.randomByteArray(100);
        this.jsonObject.put("foo", (Object)bytes);
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(bytes, JsonUtil.BASE64_DECODER.decode((String)this.jsonObject.getValue("foo"))));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getValue("foo"));
        Assert.assertNull((Object)this.jsonObject.getValue("absent"));
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        HashMap<String, String> innerMap = new HashMap<String, String>();
        innerMap.put("blah", "wibble");
        map.put("foo", innerMap);
        this.jsonObject = new JsonObject(map);
        obj = (JsonObject)this.jsonObject.getValue("foo");
        Assert.assertEquals((Object)"wibble", (Object)obj.getString("blah"));
        map = new HashMap();
        ArrayList<String> innerList = new ArrayList<String>();
        innerList.add("blah");
        map.put("foo", innerList);
        this.jsonObject = new JsonObject(map);
        arr = (JsonArray)this.jsonObject.getValue("foo");
        Assert.assertEquals((Object)"blah", (Object)arr.getString(0));
    }

    @Test
    public void testGetValueDefault() {
        this.jsonObject.put("foo", (Object)123);
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getValue("foo", (Object)"blah"));
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getValue("foo", null));
        this.jsonObject.put("foo", (Object)123L);
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getValue("foo", (Object)"blah"));
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getValue("foo", null));
        this.jsonObject.put("foo", (Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getValue("foo", (Object)"blah"));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getValue("foo", null));
        this.jsonObject.put("foo", (Object)123.0);
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getValue("foo", (Object)"blah"));
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getValue("foo", null));
        this.jsonObject.put("foo", (Object)false);
        Assert.assertEquals((Object)false, (Object)this.jsonObject.getValue("foo", (Object)"blah"));
        Assert.assertEquals((Object)false, (Object)this.jsonObject.getValue("foo", null));
        this.jsonObject.put("foo", (Object)true);
        Assert.assertEquals((Object)true, (Object)this.jsonObject.getValue("foo", (Object)"blah"));
        Assert.assertEquals((Object)true, (Object)this.jsonObject.getValue("foo", null));
        this.jsonObject.put("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getValue("foo", (Object)"blah"));
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getValue("foo", null));
        JsonObject obj = new JsonObject().put("blah", (Object)"wibble");
        this.jsonObject.put("foo", (Object)obj);
        Assert.assertEquals((Object)obj, (Object)this.jsonObject.getValue("foo", (Object)"blah"));
        Assert.assertEquals((Object)obj, (Object)this.jsonObject.getValue("foo", null));
        JsonArray arr = new JsonArray().add((Object)"blah").add((Object)"wibble");
        this.jsonObject.put("foo", (Object)arr);
        Assert.assertEquals((Object)arr, (Object)this.jsonObject.getValue("foo", (Object)"blah"));
        Assert.assertEquals((Object)arr, (Object)this.jsonObject.getValue("foo", null));
        byte[] bytes = TestUtils.randomByteArray(100);
        this.jsonObject.put("foo", (Object)bytes);
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(bytes, JsonUtil.BASE64_DECODER.decode((String)this.jsonObject.getValue("foo", (Object)"blah"))));
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(bytes, JsonUtil.BASE64_DECODER.decode((String)this.jsonObject.getValue("foo", null))));
        this.jsonObject.putNull("foo");
        Assert.assertNull((Object)this.jsonObject.getValue("foo", (Object)"blah"));
        Assert.assertNull((Object)this.jsonObject.getValue("foo", null));
        Assert.assertEquals((Object)"blah", (Object)this.jsonObject.getValue("absent", (Object)"blah"));
        Assert.assertNull((Object)this.jsonObject.getValue("absent", null));
    }

    @Test
    public void testContainsKey() {
        this.jsonObject.put("foo", (Object)"bar");
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        this.jsonObject.putNull("foo");
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        Assert.assertFalse((boolean)this.jsonObject.containsKey("absent"));
    }

    @Test
    public void testFieldNames() {
        this.jsonObject.put("foo", (Object)"bar");
        this.jsonObject.put("eek", (Object)123);
        this.jsonObject.put("flib", (Object)new JsonObject());
        Set fieldNames = this.jsonObject.fieldNames();
        Assert.assertEquals((long)3L, (long)fieldNames.size());
        Assert.assertTrue((boolean)fieldNames.contains("foo"));
        Assert.assertTrue((boolean)fieldNames.contains("eek"));
        Assert.assertTrue((boolean)fieldNames.contains("flib"));
        this.jsonObject.remove("foo");
        Assert.assertEquals((long)2L, (long)fieldNames.size());
        Assert.assertFalse((boolean)fieldNames.contains("foo"));
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)this.jsonObject.size());
        this.jsonObject.put("foo", (Object)"bar");
        Assert.assertEquals((long)1L, (long)this.jsonObject.size());
        this.jsonObject.put("bar", (Object)123);
        Assert.assertEquals((long)2L, (long)this.jsonObject.size());
        this.jsonObject.putNull("wibble");
        Assert.assertEquals((long)3L, (long)this.jsonObject.size());
        this.jsonObject.remove("wibble");
        Assert.assertEquals((long)2L, (long)this.jsonObject.size());
        this.jsonObject.clear();
        Assert.assertEquals((long)0L, (long)this.jsonObject.size());
    }

    @Test
    public void testPutEnum() {
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)SomeEnum.FOO));
        Assert.assertEquals((Object)SomeEnum.FOO.toString(), (Object)this.jsonObject.getString("foo"));
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)SomeEnum.FOO);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutString() {
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)"bar"));
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getString("foo"));
        this.jsonObject.put("quux", (Object)"wibble");
        Assert.assertEquals((Object)"wibble", (Object)this.jsonObject.getString("quux"));
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getString("foo"));
        this.jsonObject.put("foo", (Object)"blah");
        Assert.assertEquals((Object)"blah", (Object)this.jsonObject.getString("foo"));
        this.jsonObject.put("foo", (Object)null);
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)"blah");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutCharSequence() {
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)new StringBuilder("bar")));
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getString("foo"));
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getString("foo", "def"));
        this.jsonObject.put("quux", (Object)new StringBuilder("wibble"));
        Assert.assertEquals((Object)"wibble", (Object)this.jsonObject.getString("quux"));
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getString("foo"));
        this.jsonObject.put("foo", (Object)new StringBuilder("blah"));
        Assert.assertEquals((Object)"blah", (Object)this.jsonObject.getString("foo"));
        this.jsonObject.put("foo", (Object)null);
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)"blah");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutInteger() {
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)123));
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("foo"));
        this.jsonObject.put("quux", (Object)321);
        Assert.assertEquals((Object)321, (Object)this.jsonObject.getInteger("quux"));
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("foo"));
        this.jsonObject.put("foo", (Object)456);
        Assert.assertEquals((Object)456, (Object)this.jsonObject.getInteger("foo"));
        this.jsonObject.put("foo", (Object)null);
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)123);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutLong() {
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)123L));
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("foo"));
        this.jsonObject.put("quux", (Object)321L);
        Assert.assertEquals((Object)321L, (Object)this.jsonObject.getLong("quux"));
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("foo"));
        this.jsonObject.put("foo", (Object)456L);
        Assert.assertEquals((Object)456L, (Object)this.jsonObject.getLong("foo"));
        this.jsonObject.put("foo", (Object)null);
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)123L);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutFloat() {
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)Float.valueOf(123.0f)));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getFloat("foo"));
        this.jsonObject.put("quux", (Object)Float.valueOf(321.0f));
        Assert.assertEquals((Object)Float.valueOf(321.0f), (Object)this.jsonObject.getFloat("quux"));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonObject.getFloat("foo"));
        this.jsonObject.put("foo", (Object)Float.valueOf(456.0f));
        Assert.assertEquals((Object)Float.valueOf(456.0f), (Object)this.jsonObject.getFloat("foo"));
        this.jsonObject.put("foo", (Object)null);
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)Float.valueOf(1.2f));
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutDouble() {
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)123.0));
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getDouble("foo"));
        this.jsonObject.put("quux", (Object)321.0);
        Assert.assertEquals((Object)321.0, (Object)this.jsonObject.getDouble("quux"));
        Assert.assertEquals((Object)123.0, (Object)this.jsonObject.getDouble("foo"));
        this.jsonObject.put("foo", (Object)456.0);
        Assert.assertEquals((Object)456.0, (Object)this.jsonObject.getDouble("foo"));
        this.jsonObject.put("foo", (Object)null);
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)1.23);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutBoolean() {
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)true));
        Assert.assertEquals((Object)true, (Object)this.jsonObject.getBoolean("foo"));
        this.jsonObject.put("quux", (Object)true);
        Assert.assertEquals((Object)true, (Object)this.jsonObject.getBoolean("quux"));
        Assert.assertEquals((Object)true, (Object)this.jsonObject.getBoolean("foo"));
        this.jsonObject.put("foo", (Object)true);
        Assert.assertEquals((Object)true, (Object)this.jsonObject.getBoolean("foo"));
        this.jsonObject.put("foo", (Object)null);
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)false);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutJsonObject() {
        JsonObject obj1 = new JsonObject().put("blah", (Object)"wibble");
        JsonObject obj2 = new JsonObject().put("eeek", (Object)"flibb");
        JsonObject obj3 = new JsonObject().put("floob", (Object)"plarp");
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)obj1));
        Assert.assertEquals((Object)obj1, (Object)this.jsonObject.getJsonObject("foo"));
        this.jsonObject.put("quux", (Object)obj2);
        Assert.assertEquals((Object)obj2, (Object)this.jsonObject.getJsonObject("quux"));
        Assert.assertEquals((Object)obj1, (Object)this.jsonObject.getJsonObject("foo"));
        this.jsonObject.put("foo", (Object)obj3);
        Assert.assertEquals((Object)obj3, (Object)this.jsonObject.getJsonObject("foo"));
        this.jsonObject.put("foo", (Object)null);
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)new JsonObject());
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutJsonArray() {
        JsonArray obj1 = new JsonArray().add((Object)"parp");
        JsonArray obj2 = new JsonArray().add((Object)"fleep");
        JsonArray obj3 = new JsonArray().add((Object)"woob");
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)obj1));
        Assert.assertEquals((Object)obj1, (Object)this.jsonObject.getJsonArray("foo"));
        this.jsonObject.put("quux", (Object)obj2);
        Assert.assertEquals((Object)obj2, (Object)this.jsonObject.getJsonArray("quux"));
        Assert.assertEquals((Object)obj1, (Object)this.jsonObject.getJsonArray("foo"));
        this.jsonObject.put("foo", (Object)obj3);
        Assert.assertEquals((Object)obj3, (Object)this.jsonObject.getJsonArray("foo"));
        this.jsonObject.put("foo", (Object)null);
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)new JsonArray());
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutBinary() {
        byte[] bin1 = TestUtils.randomByteArray(100);
        byte[] bin2 = TestUtils.randomByteArray(100);
        byte[] bin3 = TestUtils.randomByteArray(100);
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)bin1));
        Assert.assertArrayEquals((byte[])bin1, (byte[])this.jsonObject.getBinary("foo"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bin1), (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("quux", (Object)bin2);
        Assert.assertArrayEquals((byte[])bin2, (byte[])this.jsonObject.getBinary("quux"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bin2), (Object)this.jsonObject.getValue("quux"));
        Assert.assertArrayEquals((byte[])bin1, (byte[])this.jsonObject.getBinary("foo"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bin1), (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("foo", (Object)bin3);
        Assert.assertArrayEquals((byte[])bin3, (byte[])this.jsonObject.getBinary("foo"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bin3), (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("foo", (Object)null);
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)bin1);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutInstant() {
        Instant bin1 = Instant.now();
        Instant bin2 = bin1.plus(1L, ChronoUnit.DAYS);
        Instant bin3 = bin1.plus(1L, ChronoUnit.MINUTES);
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.put("foo", (Object)bin1));
        Assert.assertEquals((Object)bin1, (Object)this.jsonObject.getInstant("foo"));
        Assert.assertEquals((Object)bin1.toString(), (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("quux", (Object)bin2);
        Assert.assertEquals((Object)bin2, (Object)this.jsonObject.getInstant("quux"));
        Assert.assertEquals((Object)bin2.toString(), (Object)this.jsonObject.getValue("quux"));
        Assert.assertEquals((Object)bin1, (Object)this.jsonObject.getInstant("foo"));
        Assert.assertEquals((Object)bin1.toString(), (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("foo", (Object)bin3);
        Assert.assertEquals((Object)bin3, (Object)this.jsonObject.getInstant("foo"));
        Assert.assertEquals((Object)bin3.toString(), (Object)this.jsonObject.getValue("foo"));
        this.jsonObject.put("foo", (Object)null);
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        try {
            this.jsonObject.put(null, (Object)bin1);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutNull() {
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.putNull("foo"));
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        Assert.assertSame((Object)this.jsonObject, (Object)this.jsonObject.putNull("bar"));
        Assert.assertTrue((boolean)this.jsonObject.containsKey("bar"));
        try {
            this.jsonObject.putNull(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPutValue() {
        this.jsonObject.put("str", (Object)"bar");
        this.jsonObject.put("int", (Object)123);
        this.jsonObject.put("long", (Object)123L);
        this.jsonObject.put("float", (Object)Float.valueOf(1.23f));
        this.jsonObject.put("double", (Object)1.23);
        this.jsonObject.put("boolean", (Object)true);
        byte[] bytes = TestUtils.randomByteArray(10);
        this.jsonObject.put("binary", (Object)bytes);
        Instant now = Instant.now();
        this.jsonObject.put("instant", (Object)now);
        JsonObject obj = new JsonObject().put("foo", (Object)"blah");
        JsonArray arr = new JsonArray().add((Object)"quux");
        this.jsonObject.put("obj", (Object)obj);
        this.jsonObject.put("arr", (Object)arr);
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.getString("str"));
        Assert.assertEquals((Object)123, (Object)this.jsonObject.getInteger("int"));
        Assert.assertEquals((Object)123L, (Object)this.jsonObject.getLong("long"));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)this.jsonObject.getFloat("float"));
        Assert.assertEquals((Object)1.23, (Object)this.jsonObject.getDouble("double"));
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.jsonObject.getBinary("binary"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)this.jsonObject.getValue("binary"));
        Assert.assertEquals((Object)now, (Object)this.jsonObject.getInstant("instant"));
        Assert.assertEquals((Object)now.toString(), (Object)this.jsonObject.getValue("instant"));
        Assert.assertEquals((Object)obj, (Object)this.jsonObject.getJsonObject("obj"));
        Assert.assertEquals((Object)arr, (Object)this.jsonObject.getJsonArray("arr"));
        try {
            this.jsonObject.put("inv", (Object)new SomeClass());
        }
        catch (RuntimeException e) {
            Assert.fail();
        }
        try {
            this.jsonObject.put("inv", (Object)new BigDecimal(123));
        }
        catch (RuntimeException e) {
            Assert.fail();
        }
        try {
            this.jsonObject.put("inv", (Object)new Date());
        }
        catch (RuntimeException e) {
            Assert.fail();
        }
    }

    @Test
    public void testMergeIn1() {
        JsonObject obj1 = new JsonObject().put("foo", (Object)"bar");
        JsonObject obj2 = new JsonObject().put("eek", (Object)"flurb");
        obj1.mergeIn(obj2);
        Assert.assertEquals((long)2L, (long)obj1.size());
        Assert.assertEquals((Object)"bar", (Object)obj1.getString("foo"));
        Assert.assertEquals((Object)"flurb", (Object)obj1.getString("eek"));
        Assert.assertEquals((long)1L, (long)obj2.size());
        Assert.assertEquals((Object)"flurb", (Object)obj2.getString("eek"));
    }

    @Test
    public void testMergeIn2() {
        JsonObject obj1 = new JsonObject().put("foo", (Object)"bar");
        JsonObject obj2 = new JsonObject().put("foo", (Object)"flurb");
        obj1.mergeIn(obj2);
        Assert.assertEquals((long)1L, (long)obj1.size());
        Assert.assertEquals((Object)"flurb", (Object)obj1.getString("foo"));
        Assert.assertEquals((long)1L, (long)obj2.size());
        Assert.assertEquals((Object)"flurb", (Object)obj2.getString("foo"));
    }

    @Test
    public void testMergeInDepth0() {
        JsonObject obj1 = new JsonObject().put("foo", (Object)new JsonObject().put("bar", (Object)"flurb"));
        JsonObject obj2 = new JsonObject().put("foo", (Object)new JsonObject().put("bar", (Object)"eek"));
        obj1.mergeIn(obj2, 0);
        Assert.assertEquals((long)1L, (long)obj1.size());
        Assert.assertEquals((long)1L, (long)obj1.getJsonObject("foo").size());
        Assert.assertEquals((Object)"flurb", (Object)obj1.getJsonObject("foo").getString("bar"));
    }

    @Test
    public void testMergeInFlat() {
        JsonObject obj1 = new JsonObject().put("foo", (Object)new JsonObject().put("bar", (Object)"flurb").put("eek", (Object)32));
        JsonObject obj2 = new JsonObject().put("foo", (Object)new JsonObject().put("bar", (Object)"eek"));
        obj1.mergeIn(obj2, false);
        Assert.assertEquals((long)1L, (long)obj1.size());
        Assert.assertEquals((long)1L, (long)obj1.getJsonObject("foo").size());
        Assert.assertEquals((Object)"eek", (Object)obj1.getJsonObject("foo").getString("bar"));
    }

    @Test
    public void testMergeInDepth1() {
        JsonObject obj1 = new JsonObject().put("foo", (Object)"bar").put("flurb", (Object)new JsonObject().put("eek", (Object)"foo").put("bar", (Object)"flurb"));
        JsonObject obj2 = new JsonObject().put("flurb", (Object)new JsonObject().put("bar", (Object)"flurb1"));
        obj1.mergeIn(obj2, 1);
        Assert.assertEquals((long)2L, (long)obj1.size());
        Assert.assertEquals((long)1L, (long)obj1.getJsonObject("flurb").size());
        Assert.assertEquals((Object)"flurb1", (Object)obj1.getJsonObject("flurb").getString("bar"));
    }

    @Test
    public void testMergeInDepth2() {
        JsonObject obj1 = new JsonObject().put("foo", (Object)"bar").put("flurb", (Object)new JsonObject().put("eek", (Object)"foo").put("bar", (Object)"flurb"));
        JsonObject obj2 = new JsonObject().put("flurb", (Object)new JsonObject().put("bar", (Object)"flurb1"));
        obj1.mergeIn(obj2, 2);
        Assert.assertEquals((long)2L, (long)obj1.size());
        Assert.assertEquals((long)2L, (long)obj1.getJsonObject("flurb").size());
        Assert.assertEquals((Object)"foo", (Object)obj1.getJsonObject("flurb").getString("eek"));
        Assert.assertEquals((Object)"flurb1", (Object)obj1.getJsonObject("flurb").getString("bar"));
    }

    @Test
    public void testToString() {
        this.jsonObject.put("foo", (Object)"bar");
        Assert.assertEquals((Object)this.jsonObject.encode(), (Object)this.jsonObject.toString());
    }

    @Test
    public void testClear() {
        this.jsonObject.put("foo", (Object)"bar");
        this.jsonObject.put("quux", (Object)123);
        Assert.assertEquals((long)2L, (long)this.jsonObject.size());
        this.jsonObject.clear();
        Assert.assertEquals((long)0L, (long)this.jsonObject.size());
        Assert.assertNull((Object)this.jsonObject.getValue("foo"));
        Assert.assertNull((Object)this.jsonObject.getValue("quux"));
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.jsonObject.isEmpty());
        this.jsonObject.put("foo", (Object)"bar");
        this.jsonObject.put("quux", (Object)123);
        Assert.assertFalse((boolean)this.jsonObject.isEmpty());
        this.jsonObject.clear();
        Assert.assertTrue((boolean)this.jsonObject.isEmpty());
    }

    @Test
    public void testRemove() {
        this.jsonObject.put("mystr", (Object)"bar");
        this.jsonObject.put("myint", (Object)123);
        Assert.assertEquals((Object)"bar", (Object)this.jsonObject.remove("mystr"));
        Assert.assertNull((Object)this.jsonObject.getValue("mystr"));
        Assert.assertEquals((Object)123, (Object)this.jsonObject.remove("myint"));
        Assert.assertNull((Object)this.jsonObject.getValue("myint"));
        Assert.assertTrue((boolean)this.jsonObject.isEmpty());
    }

    @Test
    public void testIterator() {
        this.jsonObject.put("foo", (Object)"bar");
        this.jsonObject.put("quux", (Object)123);
        JsonObject obj = this.createJsonObject();
        this.jsonObject.put("wibble", (Object)obj);
        Iterator iter = this.jsonObject.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Assert.assertEquals((Object)"foo", entry.getKey());
        Assert.assertEquals((Object)"bar", entry.getValue());
        Assert.assertTrue((boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        Assert.assertEquals((Object)"quux", entry.getKey());
        Assert.assertEquals((Object)123, entry.getValue());
        Assert.assertTrue((boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        Assert.assertEquals((Object)"wibble", entry.getKey());
        Assert.assertEquals((Object)obj, entry.getValue());
        Assert.assertFalse((boolean)iter.hasNext());
        iter.remove();
        Assert.assertFalse((boolean)obj.containsKey("wibble"));
        Assert.assertEquals((long)2L, (long)this.jsonObject.size());
    }

    @Test
    public void testIteratorDoesntChangeObject() {
        LinkedHashMap<String, Cloneable> map = new LinkedHashMap<String, Cloneable>();
        map.put("nestedMap", new HashMap());
        map.put("nestedList", new ArrayList());
        JsonObject obj = new JsonObject(map);
        Iterator iter = obj.iterator();
        Map.Entry entry1 = (Map.Entry)iter.next();
        Assert.assertEquals((Object)"nestedMap", entry1.getKey());
        Object val1 = entry1.getValue();
        Assert.assertTrue((boolean)(val1 instanceof JsonObject));
        Map.Entry entry2 = (Map.Entry)iter.next();
        Assert.assertEquals((Object)"nestedList", entry2.getKey());
        Object val2 = entry2.getValue();
        Assert.assertTrue((boolean)(val2 instanceof JsonArray));
        Assert.assertTrue((boolean)(map.get("nestedMap") instanceof HashMap));
        Assert.assertTrue((boolean)(map.get("nestedList") instanceof ArrayList));
    }

    @Test
    public void testStream() {
        this.jsonObject.put("foo", (Object)"bar");
        this.jsonObject.put("quux", (Object)123);
        JsonObject obj = this.createJsonObject();
        this.jsonObject.put("wibble", (Object)obj);
        List list = this.jsonObject.stream().collect(Collectors.toList());
        Iterator iter = list.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Assert.assertEquals((Object)"foo", entry.getKey());
        Assert.assertEquals((Object)"bar", entry.getValue());
        Assert.assertTrue((boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        Assert.assertEquals((Object)"quux", entry.getKey());
        Assert.assertEquals((Object)123, entry.getValue());
        Assert.assertTrue((boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        Assert.assertEquals((Object)"wibble", entry.getKey());
        Assert.assertEquals((Object)obj, entry.getValue());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testCopy() {
        this.jsonObject.put("foo", (Object)"bar");
        this.jsonObject.put("quux", (Object)123);
        JsonObject obj = this.createJsonObject();
        this.jsonObject.put("wibble", (Object)obj);
        this.jsonObject.put("eek", (Object)new StringBuilder("blah"));
        JsonObject copy = this.jsonObject.copy();
        Assert.assertNotSame((Object)this.jsonObject, (Object)copy);
        Assert.assertEquals((Object)this.jsonObject, (Object)copy);
        copy.put("blah", (Object)"flib");
        Assert.assertFalse((boolean)this.jsonObject.containsKey("blah"));
        copy.remove("foo");
        Assert.assertFalse((boolean)copy.containsKey("foo"));
        Assert.assertTrue((boolean)this.jsonObject.containsKey("foo"));
        this.jsonObject.put("oob", (Object)"flarb");
        Assert.assertFalse((boolean)copy.containsKey("oob"));
        this.jsonObject.remove("quux");
        Assert.assertFalse((boolean)this.jsonObject.containsKey("quux"));
        Assert.assertTrue((boolean)copy.containsKey("quux"));
        JsonObject nested = this.jsonObject.getJsonObject("wibble");
        JsonObject nestedCopied = copy.getJsonObject("wibble");
        Assert.assertNotSame((Object)nested, (Object)nestedCopied);
        Assert.assertEquals((Object)nested, (Object)nestedCopied);
        Assert.assertEquals((Object)"blah", (Object)copy.getString("eek"));
    }

    @Test
    public void testInvalidValsOnCopy1() {
        HashMap<String, SomeClass> invalid = new HashMap<String, SomeClass>();
        invalid.put("foo", new SomeClass());
        JsonObject object = new JsonObject(invalid);
        try {
            object.copy();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidValsOnCopy2() {
        HashMap invalid = new HashMap();
        HashMap<String, SomeClass> invalid2 = new HashMap<String, SomeClass>();
        invalid2.put("foo", new SomeClass());
        invalid.put("bar", invalid2);
        JsonObject object = new JsonObject(invalid);
        try {
            object.copy();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidValsOnCopy3() {
        HashMap invalid = new HashMap();
        ArrayList<SomeClass> invalid2 = new ArrayList<SomeClass>();
        invalid2.add(new SomeClass());
        invalid.put("bar", invalid2);
        JsonObject object = new JsonObject(invalid);
        try {
            object.copy();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetMap() {
        this.jsonObject.put("foo", (Object)"bar");
        this.jsonObject.put("quux", (Object)123);
        JsonObject obj = this.createJsonObject();
        this.jsonObject.put("wibble", (Object)obj);
        Map map = this.jsonObject.getMap();
        map.remove("foo");
        Assert.assertFalse((boolean)this.jsonObject.containsKey("foo"));
        map.put("bleep", "flarp");
        Assert.assertTrue((boolean)this.jsonObject.containsKey("bleep"));
        this.jsonObject.remove("quux");
        Assert.assertFalse((boolean)map.containsKey("quux"));
        this.jsonObject.put("wooble", (Object)"plink");
        Assert.assertTrue((boolean)map.containsKey("wooble"));
        Assert.assertSame((Object)obj, map.get("wibble"));
    }

    @Test
    public void testCreateFromMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", "bar");
        map.put("quux", 123);
        JsonObject obj = new JsonObject(map);
        Assert.assertEquals((Object)"bar", (Object)obj.getString("foo"));
        Assert.assertEquals((Object)123, (Object)obj.getInteger("quux"));
        Assert.assertSame(map, (Object)obj.getMap());
    }

    @Test
    public void testCreateFromBuffer() {
        JsonObject excepted = new JsonObject();
        excepted.put("foo", (Object)"bar");
        excepted.put("quux", (Object)123);
        Buffer buf = Buffer.buffer((String)excepted.encode());
        Assert.assertEquals((Object)excepted, (Object)new JsonObject(buf));
    }

    @Test
    public void testCreateFromMapCharSequence() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", "bar");
        map.put("quux", 123);
        map.put("eeek", new StringBuilder("blah"));
        JsonObject obj = new JsonObject(map);
        Assert.assertEquals((Object)"bar", (Object)obj.getString("foo"));
        Assert.assertEquals((Object)123, (Object)obj.getInteger("quux"));
        Assert.assertEquals((Object)"blah", (Object)obj.getString("eeek"));
        Assert.assertSame(map, (Object)obj.getMap());
    }

    @Test
    public void testCreateFromMapNestedJsonObject() {
        HashMap<String, JsonObject> map = new HashMap<String, JsonObject>();
        JsonObject nestedObj = new JsonObject().put("foo", (Object)"bar");
        map.put("nested", nestedObj);
        JsonObject obj = new JsonObject(map);
        JsonObject nestedRetrieved = obj.getJsonObject("nested");
        Assert.assertEquals((Object)"bar", (Object)nestedRetrieved.getString("foo"));
    }

    @Test
    public void testCreateFromMapNestedMap() {
        HashMap map = new HashMap();
        HashMap<String, String> nestedMap = new HashMap<String, String>();
        nestedMap.put("foo", "bar");
        map.put("nested", nestedMap);
        JsonObject obj = new JsonObject(map);
        JsonObject nestedRetrieved = obj.getJsonObject("nested");
        Assert.assertEquals((Object)"bar", (Object)nestedRetrieved.getString("foo"));
    }

    @Test
    public void testCreateFromMapNestedJsonArray() {
        HashMap<String, JsonArray> map = new HashMap<String, JsonArray>();
        JsonArray nestedArr = new JsonArray().add((Object)"foo");
        map.put("nested", nestedArr);
        JsonObject obj = new JsonObject(map);
        JsonArray nestedRetrieved = obj.getJsonArray("nested");
        Assert.assertEquals((Object)"foo", (Object)nestedRetrieved.getString(0));
    }

    @Test
    public void testCreateFromMapNestedList() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        List<String> nestedArr = Arrays.asList("foo");
        map.put("nested", nestedArr);
        JsonObject obj = new JsonObject(map);
        JsonArray nestedRetrieved = obj.getJsonArray("nested");
        Assert.assertEquals((Object)"foo", (Object)nestedRetrieved.getString(0));
    }

    @Test
    public void testClusterSerializable() {
        this.jsonObject.put("foo", (Object)"bar").put("blah", (Object)123);
        Buffer buff = Buffer.buffer();
        this.jsonObject.writeToBuffer(buff);
        JsonObject deserialized = new JsonObject();
        deserialized.readFromBuffer(0, buff);
        Assert.assertEquals((Object)this.jsonObject, (Object)deserialized);
    }

    @Test
    public void testNumberEquality() {
        this.assertNumberEquals(4, 4);
        this.assertNumberEquals(4, 4L);
        this.assertNumberEquals(4, Float.valueOf(4.0f));
        this.assertNumberEquals(4, 4.0);
        this.assertNumberEquals(4L, 4L);
        this.assertNumberEquals(4L, Float.valueOf(4.0f));
        this.assertNumberEquals(4L, 4.0);
        this.assertNumberEquals(Float.valueOf(4.0f), Float.valueOf(4.0f));
        this.assertNumberEquals(Float.valueOf(4.0f), 4.0);
        this.assertNumberEquals(4.0, 4.0);
        this.assertNumberEquals(4.1, 4.1);
        this.assertNumberEquals(Float.valueOf(4.1f), Float.valueOf(4.1f));
        this.assertNumberNotEquals(Float.valueOf(4.1f), 4.1);
        this.assertNumberEquals(4.5, 4.5);
        this.assertNumberEquals(Float.valueOf(4.5f), Float.valueOf(4.5f));
        this.assertNumberEquals(Float.valueOf(4.5f), 4.5);
        this.assertNumberNotEquals(4, 5);
        this.assertNumberNotEquals(4, 5L);
        this.assertNumberNotEquals(4, 5.0);
        this.assertNumberNotEquals(4, Float.valueOf(5.0f));
        this.assertNumberNotEquals(4L, 5L);
        this.assertNumberNotEquals(4L, 5.0);
        this.assertNumberNotEquals(4L, Float.valueOf(5.0f));
        this.assertNumberNotEquals(Float.valueOf(4.0f), Float.valueOf(5.0f));
        this.assertNumberNotEquals(Float.valueOf(4.0f), 5.0);
        this.assertNumberNotEquals(4.0, 5.0);
    }

    private void assertNumberEquals(Number value1, Number value2) {
        JsonArray a2;
        JsonArray a1;
        JsonObject o2;
        JsonObject o1 = new JsonObject().put("key", (Object)value1);
        if (!o1.equals((Object)(o2 = new JsonObject().put("key", (Object)value2)))) {
            Assert.fail((String)("Was expecting " + value1.getClass().getSimpleName() + ":" + value1 + " == " + value2.getClass().getSimpleName() + ":" + value2));
        }
        if (!(a1 = new JsonArray().add((Object)value1)).equals((Object)(a2 = new JsonArray().add((Object)value2)))) {
            Assert.fail((String)("Was expecting " + value1.getClass().getSimpleName() + ":" + value1 + " == " + value2.getClass().getSimpleName() + ":" + value2));
        }
    }

    private void assertNumberNotEquals(Number value1, Number value2) {
        JsonObject o2;
        JsonObject o1 = new JsonObject().put("key", (Object)value1);
        if (o1.equals((Object)(o2 = new JsonObject().put("key", (Object)value2)))) {
            Assert.fail((String)("Was expecting " + value1.getClass().getSimpleName() + ":" + value1 + " != " + value2.getClass().getSimpleName() + ":" + value2));
        }
    }

    @Test
    public void testJsonObjectEquality() {
        JsonObject obj = new JsonObject(Collections.singletonMap("abc", Collections.singletonMap("def", 3)));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", Collections.singletonMap("def", 3))));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", Collections.singletonMap("def", 3L))));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", new JsonObject().put("def", (Object)3))));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", new JsonObject().put("def", (Object)3L))));
        Assert.assertNotEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", Collections.singletonMap("def", 4))));
        Assert.assertNotEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", new JsonObject().put("def", (Object)4))));
        JsonArray array = new JsonArray(Collections.singletonList(Collections.singletonMap("def", 3)));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(Collections.singletonMap("def", 3))));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(Collections.singletonMap("def", 3L))));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(new JsonObject().put("def", (Object)3))));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(new JsonObject().put("def", (Object)3L))));
        Assert.assertNotEquals((Object)array, (Object)new JsonArray(Collections.singletonList(Collections.singletonMap("def", 4))));
        Assert.assertNotEquals((Object)array, (Object)new JsonArray(Collections.singletonList(new JsonObject().put("def", (Object)4))));
    }

    @Test
    public void testJsonObjectEquality2() {
        JsonObject obj1 = new JsonObject().put("arr", (Object)new JsonArray().add((Object)"x"));
        ArrayList<String> list = new ArrayList<String>();
        list.add("x");
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("arr", list);
        JsonObject obj2 = new JsonObject(map);
        for (Map.Entry entry : obj2) {
        }
        Assert.assertEquals((Object)obj2, (Object)obj1);
    }

    @Test
    public void testPutInstantAsObject() {
        Instant instant = Instant.now();
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("instant", (Object)instant);
        Assert.assertTrue((boolean)(jsonObject.getValue("instant") instanceof String));
    }

    @Test
    public void testStreamCorrectTypes() throws Exception {
        String json = "{\"object1\": {\"object2\": 12}}";
        JsonObject object = new JsonObject(json);
        this.testStreamCorrectTypes(object.copy());
        this.testStreamCorrectTypes(object);
    }

    @Test
    public void testRemoveMethodReturnedObject() {
        JsonObject obj = new JsonObject();
        obj.put("simple", (Object)"bar").put("object", (Object)new JsonObject().put("name", (Object)"vert.x").put("count", (Object)2)).put("array", (Object)new JsonArray().add((Object)1.0).add((Object)2.0));
        Object removed = obj.remove("missing");
        Assert.assertNull((Object)removed);
        removed = obj.remove("simple");
        Assert.assertTrue((boolean)(removed instanceof String));
        removed = obj.remove("object");
        Assert.assertTrue((boolean)(removed instanceof JsonObject));
        Assert.assertEquals((Object)((JsonObject)removed).getString("name"), (Object)"vert.x");
        removed = obj.remove("array");
        Assert.assertTrue((boolean)(removed instanceof JsonArray));
        Assert.assertEquals((double)((JsonArray)removed).getDouble(0), (double)1.0, (double)0.0);
    }

    @Test
    public void testOrder() {
        ArrayList<String> expectedKeys = new ArrayList<String>();
        int size = 100;
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < size; ++i) {
            sb.append("\"key-").append(i).append("\":").append(i).append(",");
            expectedKeys.add("key-" + i);
        }
        sb.setCharAt(sb.length() - 1, '}');
        JsonObject obj = new JsonObject(sb.toString());
        ArrayList keys = new ArrayList();
        obj.forEach(e -> keys.add(e.getKey()));
        Assert.assertEquals(expectedKeys, keys);
        keys.clear();
        obj.copy().forEach(e -> keys.add(e.getKey()));
        Assert.assertEquals(expectedKeys, keys);
    }

    @Test
    public void testMergeInNullValue() {
        JsonObject obj = new JsonObject();
        obj.put("key", (Object)"value");
        JsonObject otherObj = new JsonObject();
        otherObj.putNull("key");
        obj.mergeIn(otherObj, true);
        Assert.assertNull((Object)obj.getString("key", "other"));
    }

    private void testStreamCorrectTypes(JsonObject object) {
        object.stream().forEach(entry -> {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            Assert.assertEquals((Object)"object1", (Object)key);
            Assert.assertTrue((String)("Expecting JsonObject, found: " + val.getClass().getCanonicalName()), (boolean)(val instanceof JsonObject));
        });
    }

    private JsonObject createJsonObject() {
        JsonObject obj = new JsonObject();
        obj.put("mystr", (Object)"bar");
        obj.put("myint", (Object)Integer.MAX_VALUE);
        obj.put("mylong", (Object)Long.MAX_VALUE);
        obj.put("myfloat", (Object)Float.valueOf(Float.MAX_VALUE));
        obj.put("mydouble", (Object)Double.MAX_VALUE);
        obj.put("myboolean", (Object)true);
        obj.put("mybinary", (Object)TestUtils.randomByteArray(100));
        obj.put("myinstant", (Object)Instant.now());
        return obj;
    }

    @Test
    public void testInvalidConstruction() {
        try {
            new JsonObject((String)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new JsonObject((Buffer)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new JsonObject((Map)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals((Object)new JsonObject().put("a", (Object)1), (Object)new JsonObject().put("b", (Object)1));
        Assert.assertNotEquals((Object)new JsonObject().put("a", (Object)1), (Object)new JsonObject());
        Assert.assertNotEquals((Object)new JsonObject(), (Object)new JsonObject().put("b", (Object)1));
        Assert.assertNotEquals((Object)new JsonObject().put("a", (Object)1), (Object)new JsonObject().put("a", (Object)2));
        Assert.assertNotEquals((Object)new JsonObject().put("a", (Object)1), (Object)new JsonObject().putNull("a"));
        Assert.assertNotEquals((Object)new JsonObject().putNull("a"), (Object)new JsonObject().put("a", (Object)1));
        Assert.assertEquals((Object)new JsonObject().putNull("a"), (Object)new JsonObject().putNull("a"));
    }

    @Test
    public void testNoEncode() {
        Instant now = Instant.now();
        JsonObject json = new JsonObject();
        json.getMap().put("now", now);
        Assert.assertEquals((Object)now, (Object)json.getInstant("now"));
        Assert.assertSame((Object)now, (Object)json.getInstant("now"));
        byte[] bytes = "bytes".getBytes();
        json.getMap().put("bytes", bytes);
        Assert.assertEquals((Object)bytes, (Object)json.getBinary("bytes"));
        Assert.assertSame((Object)bytes, (Object)json.getBinary("bytes"));
    }

    @Test
    public void testBigDecimal() {
        BigDecimal bd1 = new BigDecimal("124567890.0987654321");
        JsonObject json = new JsonObject();
        json.put("bd1", (Object)bd1);
        Assert.assertEquals((Object)bd1, (Object)json.getValue("bd1"));
        Assert.assertSame((Object)bd1, (Object)json.getValue("bd1"));
        JsonObject json2 = json.copy();
        Assert.assertEquals((Object)"{\"bd1\":124567890.0987654321}", (Object)json.encode());
    }

    @Test
    public void testShareable() {
        final AtomicInteger cnt = new AtomicInteger(0);
        Shareable myShareable = new Shareable(){

            public Shareable copy() {
                cnt.incrementAndGet();
                return this;
            }
        };
        JsonObject json = new JsonObject();
        json.put("0", (Object)myShareable);
        Assert.assertEquals((Object)myShareable, (Object)json.getValue("0"));
        Assert.assertSame((Object)myShareable, (Object)json.getValue("0"));
        Assert.assertEquals((long)0L, (long)cnt.get());
        JsonObject json2 = json.copy();
        Assert.assertEquals((long)1L, (long)cnt.get());
        Assert.assertEquals((Object)myShareable, (Object)json2.getValue("0"));
        Assert.assertSame((Object)myShareable, (Object)json2.getValue("0"));
    }

    @Test
    public void testNumber() {
        JsonObject numbers = new JsonObject().put("BigDecimal", (Object)new BigDecimal("124567890.0987654321")).put("BigInteger", (Object)new BigInteger("1234567890123456789012345678901234567890")).put("byte", (Object)10).put("double", (Object)Math.PI).put("float", (Object)Float.valueOf((float)Math.PI)).put("int", (Object)42).put("long", (Object)1234567890123456789L).put("short", (Object)Short.MAX_VALUE);
        JsonObject json2 = numbers.copy();
        Assert.assertEquals((Object)"{\"BigDecimal\":124567890.0987654321,\"BigInteger\":1234567890123456789012345678901234567890,\"byte\":10,\"double\":3.141592653589793,\"float\":3.1415927,\"int\":42,\"long\":1234567890123456789,\"short\":32767}", (Object)numbers.encode());
        Assert.assertNotNull((Object)numbers.getNumber("BigDecimal"));
        Assert.assertNotNull((Object)numbers.getNumber("BigInteger"));
        Assert.assertNotNull((Object)numbers.getNumber("byte"));
        Assert.assertNotNull((Object)numbers.getNumber("double"));
        Assert.assertNotNull((Object)numbers.getNumber("float"));
        Assert.assertNotNull((Object)numbers.getNumber("int"));
        Assert.assertNotNull((Object)numbers.getNumber("long"));
        Assert.assertNotNull((Object)numbers.getNumber("short"));
        Assert.assertTrue((boolean)(numbers.getNumber("BigDecimal") instanceof BigDecimal));
        Assert.assertTrue((boolean)(numbers.getNumber("BigInteger") instanceof BigInteger));
        Assert.assertTrue((boolean)(numbers.getNumber("byte") instanceof Byte));
        Assert.assertTrue((boolean)(numbers.getNumber("double") instanceof Double));
        Assert.assertTrue((boolean)(numbers.getNumber("float") instanceof Float));
        Assert.assertTrue((boolean)(numbers.getNumber("int") instanceof Integer));
        Assert.assertTrue((boolean)(numbers.getNumber("long") instanceof Long));
        Assert.assertTrue((boolean)(numbers.getNumber("short") instanceof Short));
        JsonObject object = new JsonObject().put("v", (Object)42000);
        Number n = object.getNumber("v");
        Assert.assertEquals((long)-23536L, (long)n.shortValue());
        Assert.assertEquals((long)42000L, (long)n.intValue());
    }

    @Test
    public void testNumberDefaults() {
        JsonObject numbers = new JsonObject();
        for (Number n : new Number[]{new BigDecimal("124567890.0987654321"), new BigInteger("1234567890123456789012345678901234567890"), (byte)10, Math.PI, Float.valueOf((float)Math.PI), 42, 1234567890123456789L, (short)Short.MAX_VALUE}) {
            this.assertNumberEquals(n, numbers.getNumber("missingKey", n));
        }
    }

    class SomeClass {
        SomeClass() {
        }
    }

    static enum SomeEnum {
        FOO,
        BAR;

    }
}

