/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.cluster.impl.selector;

import io.vertx.core.spi.cluster.impl.selector.WeightedRoundRobinSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WeightedRoundRobinSelectorTest {
    private final Map<String, Integer> weights;
    private final int totalWeight;
    private final WeightedRoundRobinSelector selector;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("foo", 38);
        map.put("bar", 13);
        objects.add(new Object[]{map});
        map = new HashMap();
        map.put("foo", 91);
        map.put("bar", 22);
        map.put("baz", 115);
        objects.add(new Object[]{map});
        map = new HashMap();
        map.put("foo", 28);
        map.put("bar", 91);
        map.put("baz", 28);
        map.put("qux", 13);
        map.put("quux", 28);
        objects.add(new Object[]{map});
        return objects;
    }

    public WeightedRoundRobinSelectorTest(Map<String, Integer> weights) {
        this.weights = weights;
        this.totalWeight = weights.values().stream().mapToInt(value -> value).sum();
        this.selector = new WeightedRoundRobinSelector(weights);
    }

    @Test
    public void testSelectForSend() {
        List list = IntStream.range(0, this.totalWeight * 10).mapToObj(i -> this.selector.selectForSend()).collect(Collectors.toList());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (String string : list) {
            Assert.assertTrue((boolean)this.weights.containsKey(string));
            counts.merge(string, 1, Math::addExact);
        }
        for (Map.Entry entry : counts.entrySet()) {
            Assert.assertEquals((long)(10 * this.weights.get(entry.getKey())), (long)((Integer)entry.getValue()).intValue());
        }
    }

    @Test
    public void testSelectForPublish() {
        for (int i = 0; i < 10; ++i) {
            Iterable iterable = this.selector.selectForPublish();
            List list = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
            Assert.assertTrue((boolean)list.containsAll(this.weights.keySet()));
            Assert.assertTrue((boolean)this.weights.keySet().containsAll(list));
        }
    }
}

