/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.tracing;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.faketracer.FakeTracer;
import io.vertx.test.faketracer.Span;
import java.util.List;
import org.junit.Test;

public abstract class EventBusTracingTestBase
extends VertxTestBase {
    Vertx vertx1;
    Vertx vertx2;
    FakeTracer tracer;

    @Override
    protected VertxTracer getTracer() {
        this.tracer = new FakeTracer();
        return this.tracer;
    }

    @Test
    public void testEventBusSend() {
        this.vertx2.eventBus().consumer("the-address", msg -> {});
        Span rootSpan = this.tracer.newTrace();
        Context ctx = this.vertx1.getOrCreateContext();
        ctx.runOnContext(v -> {
            this.tracer.activate(rootSpan);
            this.vertx1.eventBus().send("the-address", (Object)"ping");
        });
        EventBusTracingTestBase.waitUntil(() -> this.tracer.getFinishedSpans().size() == 2);
        List<Span> finishedSpans = this.tracer.getFinishedSpans();
        this.assertSingleTrace(finishedSpans);
        finishedSpans.forEach(span -> this.assertEquals("send", span.operation));
    }

    @Test
    public void testEventBusPublish() {
        this.vertx2.eventBus().consumer("the-address", msg -> {});
        this.vertx2.eventBus().consumer("the-address", msg -> {});
        Span rootSpan = this.tracer.newTrace();
        Context ctx = this.vertx1.getOrCreateContext();
        ctx.runOnContext(v -> {
            this.tracer.activate(rootSpan);
            this.vertx1.eventBus().publish("the-address", (Object)"ping");
        });
        EventBusTracingTestBase.waitUntil(() -> this.tracer.getFinishedSpans().size() == 3);
        List<Span> finishedSpans = this.tracer.getFinishedSpans();
        this.assertSingleTrace(finishedSpans);
        finishedSpans.forEach(span -> this.assertEquals("publish", span.operation));
    }

    @Test
    public void testEventBusRequestReply() {
        this.vertx2.eventBus().consumer("the-address", msg -> msg.reply((Object)"pong"));
        Span rootSpan = this.tracer.newTrace();
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            this.tracer.activate(rootSpan);
            this.vertx1.eventBus().request("the-address", (Object)"ping", this.onSuccess(reply -> {}));
        });
        EventBusTracingTestBase.waitUntil(() -> this.tracer.getFinishedSpans().size() == 2);
        List<Span> finishedSpans = this.tracer.getFinishedSpans();
        this.assertSingleTrace(finishedSpans);
        finishedSpans.forEach(span -> this.assertEquals("send", span.operation));
    }

    @Test
    public void testEventBusRequestReplyFailure() {
        this.vertx2.eventBus().consumer("the-address", msg -> msg.fail(10, "it failed"));
        Span rootSpan = this.tracer.newTrace();
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            this.tracer.activate(rootSpan);
            this.vertx1.eventBus().request("the-address", (Object)"ping", this.onFailure(err -> {}));
        });
        EventBusTracingTestBase.waitUntil(() -> this.tracer.getFinishedSpans().size() == 2);
        List<Span> finishedSpans = this.tracer.getFinishedSpans();
        this.assertSingleTrace(finishedSpans);
        finishedSpans.forEach(span -> this.assertEquals("send", span.operation));
    }

    private void assertSingleTrace(List<Span> spans) {
        for (int i = 1; i < spans.size(); ++i) {
            this.assertEquals(spans.get((int)(i - 1)).traceId, spans.get((int)i).traceId);
        }
    }
}

