/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.Http2ClientConnection;
import io.vertx.core.http.impl.HttpChannelConnector;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.net.impl.clientconnection.ConnectResult;
import io.vertx.core.net.impl.clientconnection.ConnectionListener;
import io.vertx.core.net.impl.clientconnection.ConnectionProvider;

public class HttpConnectionProvider
implements ConnectionProvider<HttpClientConnection> {
    private final HttpClientImpl client;
    private final HttpChannelConnector connector;
    private final ContextInternal context;
    private final HttpClientOptions options;
    private final long weight;
    private final long http1Weight;
    private final long http2Weight;

    public HttpConnectionProvider(HttpClientImpl client, HttpChannelConnector connector, ContextInternal context, HttpVersion version) {
        this.client = client;
        this.connector = connector;
        this.context = context;
        this.options = client.getOptions();
        this.http1Weight = this.options.getHttp2MaxPoolSize();
        this.http2Weight = this.options.getMaxPoolSize();
        this.weight = version == HttpVersion.HTTP_2 ? this.http2Weight : this.http1Weight;
    }

    public long weight() {
        return this.weight;
    }

    @Override
    public void close(HttpClientConnection conn) {
        conn.close();
    }

    @Override
    public void init(HttpClientConnection conn) {
        Handler<HttpConnection> handler = this.client.connectionHandler();
        if (handler != null) {
            this.context.emit(conn, handler);
        }
    }

    @Override
    public boolean isValid(HttpClientConnection conn) {
        return conn.isValid();
    }

    @Override
    public void connect(ConnectionListener<HttpClientConnection> listener, ContextInternal context, Handler<AsyncResult<ConnectResult<HttpClientConnection>>> asyncResultHandler) {
        this.connector.httpConnect((EventLoopContext)context).map(conn -> {
            conn.evictionHandler(recycle -> listener.onEvict());
            conn.concurrencyChangeHandler(listener::onConcurrencyChange);
            long weight = conn instanceof Http1xClientConnection ? this.http1Weight : (conn instanceof Http2ClientConnection ? this.http2Weight : this.http2Weight);
            return new ConnectResult<HttpClientConnection>((HttpClientConnection)conn, conn.concurrency(), weight);
        }).onComplete(asyncResultHandler);
    }
}

