/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.AbstractContext;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class DuplicatedContext
extends AbstractContext {
    protected final ContextImpl delegate;
    private TaskQueue orderedTasks;
    private ConcurrentMap<Object, Object> localData;

    DuplicatedContext(ContextImpl delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TaskQueue orderedTasks() {
        DuplicatedContext duplicatedContext = this;
        synchronized (duplicatedContext) {
            if (this.orderedTasks == null) {
                this.orderedTasks = new TaskQueue();
            }
            return this.orderedTasks;
        }
    }

    @Override
    boolean inThread() {
        return this.delegate.inThread();
    }

    @Override
    public final CloseFuture closeFuture() {
        return this.delegate.closeFuture();
    }

    @Override
    public final boolean isDeployment() {
        return this.delegate.isDeployment();
    }

    @Override
    public final VertxTracer tracer() {
        return this.delegate.tracer();
    }

    @Override
    public final String deploymentID() {
        return this.delegate.deploymentID();
    }

    @Override
    public final JsonObject config() {
        return this.delegate.config();
    }

    @Override
    public final int getInstanceCount() {
        return this.delegate.getInstanceCount();
    }

    @Override
    public final Context exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public final Handler<Throwable> exceptionHandler() {
        return this.delegate.exceptionHandler();
    }

    @Override
    public final EventLoop nettyEventLoop() {
        return this.delegate.nettyEventLoop();
    }

    @Override
    public final Deployment getDeployment() {
        return this.delegate.getDeployment();
    }

    @Override
    public final VertxInternal owner() {
        return this.delegate.owner();
    }

    @Override
    public final ClassLoader classLoader() {
        return this.delegate.classLoader();
    }

    @Override
    public WorkerPool workerPool() {
        return this.delegate.workerPool();
    }

    @Override
    public final void reportException(Throwable t) {
        this.delegate.reportException(t);
    }

    @Override
    public final ConcurrentMap<Object, Object> contextData() {
        return this.delegate.contextData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ConcurrentMap<Object, Object> localContextData() {
        DuplicatedContext duplicatedContext = this;
        synchronized (duplicatedContext) {
            if (this.localData == null) {
                this.localData = new ConcurrentHashMap<Object, Object>();
            }
            return this.localData;
        }
    }

    @Override
    public final <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action) {
        return ContextImpl.executeBlocking(this, action, this.delegate.internalBlockingPool, this.delegate.internalOrderedTasks);
    }

    @Override
    public final <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action, boolean ordered) {
        return ContextImpl.executeBlocking(this, action, this.delegate.internalBlockingPool, ordered ? this.delegate.internalOrderedTasks : null);
    }

    @Override
    public final <T> Future<T> executeBlocking(Handler<Promise<T>> action, boolean ordered) {
        TaskQueue queue = ordered ? this.orderedTasks() : null;
        return ContextImpl.executeBlocking(this, action, this.delegate.workerPool, queue);
    }

    @Override
    public final <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue) {
        return ContextImpl.executeBlocking(this, blockingCodeHandler, this.delegate.workerPool, queue);
    }

    @Override
    public final void runOnContext(Handler<Void> action) {
        this.delegate.runOnContext(this, action);
    }

    @Override
    public final <T> void execute(T argument, Handler<T> task) {
        this.delegate.execute(this, argument, task);
    }

    @Override
    public <T> void emit(T argument, Handler<T> task) {
        this.delegate.emit(this, argument, task);
    }

    @Override
    public void execute(Runnable task) {
        this.delegate.execute(this, task);
    }

    @Override
    public boolean isEventLoopContext() {
        return this.delegate.isEventLoopContext();
    }

    @Override
    public ContextInternal duplicate() {
        return new DuplicatedContext(this.delegate);
    }
}

