/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.netty.channel.EventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.test.core.VertxTestBase;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.Test;

public class ContextTest
extends VertxTestBase {
    private ExecutorService workerExecutor;

    private ContextInternal createWorkerContext() {
        return ((VertxInternal)this.vertx).createWorkerContext(null, new CloseFuture(), new WorkerPool(this.workerExecutor, null), Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void setUp() throws Exception {
        this.workerExecutor = Executors.newFixedThreadPool(2, r -> new VertxThread(r, "vert.x-worker-thread", true, 10L, TimeUnit.SECONDS));
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.workerExecutor.shutdown();
        super.tearDown();
    }

    @Test
    public void testRunOnContext() throws Exception {
        this.vertx.runOnContext(v -> {
            final Thread th = Thread.currentThread();
            final Context ctx = Vertx.currentContext();
            ctx.runOnContext(v2 -> {
                this.assertEquals(th, Thread.currentThread());
                for (int i = 0; i < 10; ++i) {
                    Context c = Vertx.currentContext();
                    this.assertEquals(ctx, c);
                }
                new Thread(){

                    @Override
                    public void run() {
                        ctx.runOnContext(v3 -> {
                            ContextTest.this.assertEquals(th, Thread.currentThread());
                            ContextTest.this.assertEquals(ctx, Vertx.currentContext());
                            ContextTest.this.testComplete();
                        });
                    }
                }.start();
            });
        });
        this.await();
    }

    @Test
    public void testNoContext() throws Exception {
        this.assertNull(Vertx.currentContext());
    }

    @Test
    public void testPutGetRemoveData() throws Exception {
        SomeObject obj = new SomeObject();
        this.vertx.runOnContext(v -> {
            Context ctx = Vertx.currentContext();
            ctx.put("foo", (Object)obj);
            ctx.runOnContext(v2 -> {
                this.assertEquals(obj, ctx.get("foo"));
                this.assertTrue(ctx.remove("foo"));
                ctx.runOnContext(v3 -> {
                    this.assertNull(ctx.get("foo"));
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testGettingContextContextUnderContextAnotherInstanceShouldReturnDifferentContext() throws Exception {
        Vertx other = this.vertx();
        Context context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> {
            Context otherContext = other.getOrCreateContext();
            this.assertNotSame(otherContext, context);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testExecuteOrderedBlocking() throws Exception {
        Context context = this.vertx.getOrCreateContext();
        context.executeBlocking(f -> {
            this.assertTrue(Context.isOnWorkerThread());
            f.complete((Object)3);
        }, r -> {
            this.assertTrue(Context.isOnEventLoopThread());
            this.assertEquals(r.result(), (Object)3);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testExecuteUnorderedBlocking() throws Exception {
        Context context = this.vertx.getOrCreateContext();
        context.executeBlocking(f -> {
            this.assertTrue(Context.isOnWorkerThread());
            f.complete((Object)3);
        }, false, r -> {
            this.assertTrue(Context.isOnEventLoopThread());
            this.assertEquals(r.result(), (Object)3);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testExecuteBlockingThreadSyncComplete() throws Exception {
        Context context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> {
            Thread expected = Thread.currentThread();
            context.executeBlocking(Promise::complete, r -> {
                this.assertSame(expected, Thread.currentThread());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testExecuteBlockingThreadAsyncComplete() throws Exception {
        Context context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> {
            Thread expected = Thread.currentThread();
            context.executeBlocking(fut -> new Thread(() -> {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                fut.complete();
            }).start(), r -> {
                this.assertSame(context, Vertx.currentContext());
                this.assertSame(expected, Thread.currentThread());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testContextExceptionHandler() {
        RuntimeException failure = new RuntimeException();
        Context context = this.vertx.getOrCreateContext();
        context.exceptionHandler(err -> {
            this.assertSame(context, Vertx.currentContext());
            this.assertSame(failure, err);
            this.testComplete();
        });
        context.runOnContext(v -> {
            throw failure;
        });
        this.await();
    }

    @Test
    public void testContextExceptionHandlerFailing() {
        RuntimeException failure = new RuntimeException();
        Context context = this.vertx.getOrCreateContext();
        AtomicInteger count = new AtomicInteger();
        context.exceptionHandler(err -> {
            if (count.getAndIncrement() == 0) {
                throw new RuntimeException();
            }
            this.assertSame(failure, err);
            this.testComplete();
        });
        context.runOnContext(v -> {
            throw new RuntimeException();
        });
        context.runOnContext(v -> {
            throw failure;
        });
        this.await();
    }

    @Test
    public void testDefaultContextExceptionHandler() {
        RuntimeException failure = new RuntimeException();
        Context context = this.vertx.getOrCreateContext();
        this.vertx.exceptionHandler(err -> {
            this.assertSame(failure, err);
            this.testComplete();
        });
        context.runOnContext(v -> {
            throw failure;
        });
        this.await();
    }

    @Test
    public void testExceptionHandlerOnDeploymentAsyncResultHandlerFailure() {
        RuntimeException failure = new RuntimeException();
        Context ctx = this.vertx.getOrCreateContext();
        ctx.exceptionHandler(err -> {
            this.assertSame(failure, err);
            this.testComplete();
        });
        ctx.runOnContext(v -> this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
            }
        }, ar -> {
            throw failure;
        }));
        this.await();
    }

    @Test
    public void testExceptionHandlerOnAsyncDeploymentAsyncResultHandlerFailure() {
        RuntimeException failure = new RuntimeException();
        Context ctx = this.vertx.getOrCreateContext();
        ctx.exceptionHandler(err -> {
            this.assertSame(failure, err);
            this.testComplete();
        });
        ctx.runOnContext(v -> this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start(Promise<Void> startPromise) throws Exception {
                this.context.runOnContext(arg_0 -> startPromise.complete(arg_0));
            }
        }, ar -> {
            throw failure;
        }));
        this.await();
    }

    @Test
    public void testExceptionInExecutingBlockingWithContextExceptionHandler() {
        RuntimeException expected = new RuntimeException("test");
        Context context = this.vertx.getOrCreateContext();
        context.exceptionHandler(t -> {
            this.assertSame(expected, t);
            this.complete();
        });
        this.vertx.exceptionHandler(t -> this.fail("Should not be invoked"));
        context.executeBlocking(promise -> {
            throw expected;
        }, null);
        this.await();
    }

    @Test
    public void testExceptionInExecutingBlockingWithVertxExceptionHandler() {
        RuntimeException expected = new RuntimeException("test");
        Context context = this.vertx.getOrCreateContext();
        this.vertx.exceptionHandler(t -> {
            this.assertSame(expected, t);
            this.complete();
        });
        context.executeBlocking(promise -> {
            throw expected;
        }, null);
        this.await();
    }

    @Test
    public void testVerticleUseDifferentExecuteBlockingOrderedExecutor() throws Exception {
        this.testVerticleUseDifferentOrderedExecutor(false);
    }

    @Test
    public void testWorkerVerticleUseDifferentExecuteBlockingOrderedExecutor() throws Exception {
        this.testVerticleUseDifferentOrderedExecutor(true);
    }

    private void testVerticleUseDifferentOrderedExecutor(boolean worker) throws Exception {
        this.waitFor(2);
        final CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                this.vertx.executeBlocking(fut -> {
                    latch1.countDown();
                    try {
                        ContextTest.this.awaitLatch(latch2);
                        fut.complete();
                    }
                    catch (InterruptedException e) {
                        fut.fail((Throwable)e);
                    }
                }, ar -> {
                    ContextTest.this.assertTrue(ar.succeeded());
                    ContextTest.this.complete();
                });
            }
        }, new DeploymentOptions().setWorker(worker));
        this.awaitLatch(latch1);
        final CountDownLatch latch3 = new CountDownLatch(1);
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                this.vertx.executeBlocking(fut -> {
                    latch3.countDown();
                    fut.complete();
                }, ar -> {
                    ContextTest.this.assertTrue(ar.succeeded());
                    ContextTest.this.complete();
                });
            }
        }, new DeploymentOptions().setWorker(worker));
        this.awaitLatch(latch3);
        latch2.countDown();
        this.await();
    }

    @Test
    public void testInternalExecuteBlockingWithQueue() {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        ArrayList<Consumer<Handler<Promise<Object>>>> lst = new ArrayList<Consumer<Handler<Promise<Object>>>>();
        for (int i = 0; i < 2; ++i) {
            TaskQueue queue = new TaskQueue();
            lst.add(task -> context.executeBlocking(task, queue, ar -> {}));
        }
        this.testInternalExecuteBlockingWithQueue(lst);
    }

    public void testInternalExecuteBlockingWithQueue(List<Consumer<Handler<Promise<Object>>>> lst) {
        AtomicReference[] current = new AtomicReference[lst.size()];
        this.waitFor(lst.size());
        for (int i = 0; i < current.length; ++i) {
            current[i] = new AtomicReference();
        }
        CyclicBarrier barrier = new CyclicBarrier(2);
        CountDownLatch latch = new CountDownLatch(3);
        int numTasks = 10;
        for (int i = 0; i < numTasks; ++i) {
            int ival = i;
            for (int j = 0; j < lst.size(); ++j) {
                int jval = j;
                Handler task = fut -> {
                    if (ival == 0) {
                        current[jval].set(Thread.currentThread());
                        latch.countDown();
                        try {
                            latch.await(20L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            this.fail(e);
                        }
                    } else {
                        this.assertSame(Thread.currentThread(), current[jval].get());
                        try {
                            barrier.await();
                        }
                        catch (Exception e) {
                            this.fail(e);
                        }
                    }
                    if (ival == numTasks - 1) {
                        this.complete();
                    }
                };
                lst.get(j).accept((Handler<Promise<Object>>)task);
            }
        }
        latch.countDown();
        this.await();
    }

    @Test
    public void testEventLoopContextDispatchReportsFailure() {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        RuntimeException failure = new RuntimeException();
        AtomicReference caught = new AtomicReference();
        ctx.exceptionHandler(caught::set);
        ctx.emit(new Object(), event -> {
            throw failure;
        });
        ContextTest.assertWaitUntil(() -> caught.get() == failure);
    }

    @Test
    public void testWorkerContextDispatchReportsFailure() {
        ContextInternal ctx = this.createWorkerContext();
        RuntimeException failure = new RuntimeException();
        AtomicReference caught = new AtomicReference();
        ctx.exceptionHandler(caught::set);
        ctx.emit(new Object(), event -> {
            throw failure;
        });
        ContextTest.assertWaitUntil(() -> caught.get() == failure);
    }

    @Test
    public void testReportExceptionToContext() {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        RuntimeException expected = new RuntimeException();
        AtomicReference err = new AtomicReference();
        ctx.exceptionHandler(err::set);
        ctx.reportException((Throwable)expected);
        this.assertSame(expected, err.get());
    }

    @Test
    public void testDuplicate() throws Exception {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        ContextInternal duplicate = ctx.duplicate();
        this.checkDuplicate(ctx, duplicate);
    }

    @Test
    public void testDuplicateWorker() throws Exception {
        ContextInternal ctx = this.createWorkerContext();
        ContextInternal duplicate = ctx.duplicate();
        this.checkDuplicate(ctx, duplicate);
    }

    @Test
    public void testDuplicateTwice() throws Exception {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        ContextInternal duplicated = ctx.duplicate().duplicate();
        this.checkDuplicate(ctx, duplicated);
    }

    private void checkDuplicate(ContextInternal ctx, ContextInternal duplicated) throws Exception {
        this.assertSame(ctx.nettyEventLoop(), duplicated.nettyEventLoop());
        this.assertSame(ctx.getDeployment(), duplicated.getDeployment());
        this.assertSame(ctx.classLoader(), duplicated.classLoader());
        this.assertSame(ctx.owner(), duplicated.owner());
        Object shared = new Object();
        Object local = new Object();
        ctx.put("key", shared);
        ctx.putLocal("key", local);
        this.assertSame(shared, duplicated.get("key"));
        this.assertNull(duplicated.getLocal("key"));
        this.assertTrue(duplicated.remove("key"));
        this.assertNull(ctx.get("key"));
        CountDownLatch latch1 = new CountDownLatch(1);
        duplicated.runOnContext(v -> {
            this.assertSame(Vertx.currentContext(), duplicated);
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        Throwable failure = new Throwable();
        ctx.exceptionHandler(err -> {
            this.assertSame(failure, err);
            latch2.countDown();
        });
        duplicated.reportException(failure);
        this.awaitLatch(latch2);
        CountDownLatch latch3 = new CountDownLatch(1);
        duplicated.runOnContext(v -> this.vertx.setTimer(10L, id -> {
            this.assertSame(duplicated, Vertx.currentContext());
            latch3.countDown();
        }));
        this.awaitLatch(latch3);
        CountDownLatch latch4 = new CountDownLatch(1);
        duplicated.runOnContext(v -> this.vertx.executeBlocking(Promise::complete, res -> {
            this.assertSame(duplicated, Vertx.currentContext());
            latch4.countDown();
        }));
        this.awaitLatch(latch4);
    }

    @Test
    public void testDuplicateWorkerConcurrency() throws Exception {
        this.testDuplicateWorkerConcurrency((ctx, task) -> ctx.runOnContext(v -> task.run()));
        this.testDuplicateWorkerConcurrency((ctx, task) -> ctx.execute(v -> task.run()));
        this.testDuplicateWorkerConcurrency((ctx, task) -> ctx.execute(null, v -> task.run()));
        this.testDuplicateWorkerConcurrency(ContextInternal::execute);
        this.testDuplicateWorkerConcurrency((ctx, task) -> ctx.emit(v -> task.run()));
        this.testDuplicateWorkerConcurrency((ctx, task) -> ctx.emit(null, v -> task.run()));
    }

    private void testDuplicateWorkerConcurrency(BiConsumer<ContextInternal, Runnable> task) throws Exception {
        WorkerContext worker = ((VertxInternal)this.vertx).createWorkerContext();
        ContextInternal[] contexts = new ContextInternal[]{worker.duplicate(), worker.duplicate()};
        this.waitFor(contexts.length);
        AtomicBoolean owner = new AtomicBoolean();
        CountDownLatch latch = new CountDownLatch(contexts.length);
        for (ContextInternal context : contexts) {
            task.accept(context, () -> {
                try {
                    this.assertTrue(owner.compareAndSet(false, true));
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    owner.set(false);
                }
                latch.countDown();
            });
        }
        this.awaitLatch(latch);
    }

    @Test
    public void testDuplicateEventLoopExecuteBlocking() throws Exception {
        this.testDuplicateExecuteBlocking((ContextInternal)this.vertx.getOrCreateContext());
    }

    @Test
    public void testDuplicateWorkerExecuteBlocking() throws Exception {
        this.testDuplicateExecuteBlocking(this.createWorkerContext());
    }

    private void testDuplicateExecuteBlocking(ContextInternal ctx) throws Exception {
        ContextInternal dup1 = ctx.duplicate();
        ContextInternal dup2 = ctx.duplicate();
        AtomicInteger cnt = new AtomicInteger();
        Future f1 = dup1.executeBlocking(p -> {
            this.assertTrue(Context.isOnWorkerThread());
            this.assertEquals(1L, cnt.incrementAndGet());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.fail(e);
            }
            finally {
                cnt.decrementAndGet();
            }
            p.complete();
        });
        Future f2 = dup2.executeBlocking(p -> {
            this.assertTrue(Context.isOnWorkerThread());
            this.assertEquals(1L, cnt.incrementAndGet());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.fail(e);
            }
            finally {
                cnt.decrementAndGet();
            }
            p.complete();
        });
        CompositeFuture.all((Future)f1, (Future)f2).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReentrantDispatch() {
        ClassLoader prev = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader cl = new URLClassLoader(new URL[0]);
            Thread.currentThread().setContextClassLoader(cl);
            ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
            ctx.runOnContext(v1 -> {
                this.assertSame(ctx, Vertx.currentContext());
                this.assertSame(cl, Thread.currentThread().getContextClassLoader());
                int[] called = new int[1];
                BlockedThreadChecker.Task thread = (BlockedThreadChecker.Task)Thread.currentThread();
                long start = thread.startTime();
                ctx.dispatch(v2 -> {
                    called[0] = called[0] + 1;
                    this.assertSame(cl, Thread.currentThread().getContextClassLoader());
                    try {
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException e) {
                        this.fail(e);
                    }
                });
                this.assertEquals(start, thread.startTime());
                this.assertEquals(1L, called[0]);
                this.assertSame(ctx, Vertx.currentContext());
                this.assertSame(cl, Thread.currentThread().getContextClassLoader());
                this.testComplete();
            });
            this.await();
        }
        finally {
            Thread.currentThread().setContextClassLoader(prev);
        }
    }

    @Test
    public void testEventLoopContextPromiseReentrantSuccess() {
        this.testEventLoopContextPromiseReentrantCompletion(p -> p.complete((Object)"the-value"));
    }

    private void testEventLoopContextPromiseReentrantCompletion(Consumer<Promise<String>> action) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = context.promise();
        context.runOnContext(arg_0 -> this.lambda$testEventLoopContextPromiseReentrantCompletion$66((Promise)promise, action, arg_0));
        this.await();
    }

    @Test
    public void testEventLoopContextPromiseReentrantFailingSuccess() {
        this.testEventLoopContextPromiseReentrantFailingCompletion(p -> p.complete((Object)"the-value"));
    }

    @Test
    public void testEventLoopContextPromiseReentrantFailingFailure() {
        this.testEventLoopContextPromiseReentrantFailingCompletion(p -> p.fail((Throwable)new Exception()));
    }

    private void testEventLoopContextPromiseReentrantFailingCompletion(Consumer<Promise<String>> action) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = context.promise();
        context.runOnContext(arg_0 -> this.lambda$testEventLoopContextPromiseReentrantFailingCompletion$71(context, (Promise)promise, action, arg_0));
        this.await();
    }

    @Test
    public void testEventLoopContextPromiseSucceededByAnotherEventLoopThread() {
        this.testEventLoopContextPromiseCompletedByAnotherEventLoopThread(p -> p.complete((Object)"the-value"));
    }

    @Test
    public void testEventLoopContextPromiseFailedByAnotherEventLoopThread() {
        this.testEventLoopContextPromiseCompletedByAnotherEventLoopThread(p -> p.fail((Throwable)new Exception()));
    }

    void testEventLoopContextPromiseCompletedByAnotherEventLoopThread(Consumer<Promise<String>> action) {
        Context any = this.vertx.getOrCreateContext();
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = context.promise();
        context.runOnContext(arg_0 -> this.lambda$testEventLoopContextPromiseCompletedByAnotherEventLoopThread$76((Promise)promise, any, action, arg_0));
        this.await();
    }

    @Test
    public void testEventLoopContextPromiseSucceededByWorkerThread() {
        this.testEventLoopContextPromiseCompletedByWorkerThread(p -> p.complete((Object)"the-value"));
    }

    @Test
    public void testEventLoopContextPromiseFailedByWorkerThread() {
        this.testEventLoopContextPromiseCompletedByWorkerThread(p -> p.fail((Throwable)new Exception()));
    }

    private void testEventLoopContextPromiseCompletedByWorkerThread(Consumer<Promise<String>> action) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = context.promise();
        context.runOnContext(arg_0 -> this.lambda$testEventLoopContextPromiseCompletedByWorkerThread$81((Promise)promise, context, action, arg_0));
        this.await();
    }

    @Test
    public void testEventLoopContextPromiseSucceededByNonVertxThread() {
        this.testEventLoopContextPromiseCompletedByNonVertxThread(p -> p.complete((Object)"the-value"));
    }

    @Test
    public void testEventLoopContextPromiseFailedByNonVertxThread() {
        this.testEventLoopContextPromiseCompletedByNonVertxThread(p -> p.fail((Throwable)new Exception()));
    }

    private void testEventLoopContextPromiseCompletedByNonVertxThread(Consumer<Promise<String>> action) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = context.promise();
        context.runOnContext(arg_0 -> this.lambda$testEventLoopContextPromiseCompletedByNonVertxThread$86((Promise)promise, action, arg_0));
        this.await();
    }

    @Test
    public void testEventLoopContextPromiseListenerSuccess() {
        this.testEventLoopContextPromiseListenerCompletion(p -> p.setSuccess((Object)"the-value"));
    }

    @Test
    public void testEventLoopContextPromiseListenerFailure() {
        this.testEventLoopContextPromiseListenerCompletion(p -> p.setFailure((Throwable)new Exception()));
    }

    private void testEventLoopContextPromiseListenerCompletion(Consumer<io.netty.util.concurrent.Promise<String>> action) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = context.promise();
        promise.future().onComplete(ar -> {
            this.assertSame(context, Vertx.currentContext());
            this.testComplete();
        });
        EventLoop eventLoop = context.nettyEventLoop();
        action.accept((io.netty.util.concurrent.Promise<String>)eventLoop.newPromise().addListener((GenericFutureListener)promise));
        this.await();
    }

    @Test
    public void testComposeContextPropagation1() {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = context.promise();
        Future future = promise.future().compose(res -> {
            this.assertEquals(context, Vertx.currentContext());
            return Future.succeededFuture((Object)"value-2");
        });
        promise.complete((Object)"value-1");
        future.onComplete(ar -> {
            this.assertSame(context, Vertx.currentContext());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testComposeContextPropagation2() {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = context.promise();
        Future future = promise.future().compose(res -> {
            this.assertSame(context, Vertx.currentContext());
            return Future.succeededFuture((Object)"value-2");
        });
        future.onComplete(ar -> {
            this.assertSame(context, Vertx.currentContext());
            this.testComplete();
        });
        promise.complete((Object)"value-1");
        this.await();
    }

    @Test
    public void testComposeContextPropagation3() {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = context.promise();
        ContextInternal anotherContext = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal anotherPromise = anotherContext.promise();
        Future future = promise.future().compose(arg_0 -> ContextTest.lambda$testComposeContextPropagation3$94((Promise)anotherPromise, arg_0));
        promise.complete((Object)"value-1");
        future.onComplete(ar -> {
            this.assertSame(context, Vertx.currentContext());
            this.testComplete();
        });
        anotherPromise.complete((Object)"value-2");
        this.await();
    }

    @Test
    public void testSucceededFutureContextPropagation1() {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        Future future = context.succeededFuture();
        future.onComplete(ar -> {
            this.assertSame(context, Vertx.currentContext());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testSucceededFutureContextPropagation2() throws Exception {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        Future future = context.succeededFuture();
        future = future.compose(value -> {
            this.assertSame(context, Vertx.currentContext());
            return Future.succeededFuture((Object)"value-2");
        });
        Thread.sleep(100L);
        future.onComplete(ar -> {
            this.assertSame(context, Vertx.currentContext());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testFailedFutureContextPropagation1() {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        Future future = context.failedFuture("error");
        future.onComplete(ar -> {
            this.assertSame(context, Vertx.currentContext());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testFailedFutureContextPropagation2() {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        Future future = context.failedFuture("error");
        future = future.recover(err -> {
            this.assertSame(context, Vertx.currentContext());
            return Future.succeededFuture((Object)"value-2");
        });
        future.onComplete(ar -> {
            this.assertSame(context, Vertx.currentContext());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testSticky() {
        Context ctx = this.vertx.getOrCreateContext();
        this.assertSame(ctx, this.vertx.getOrCreateContext());
    }

    @Test
    public void testUnwrapPromiseWithoutContext() {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        ArrayList<Function<Promise, PromiseInternal>> suppliers = new ArrayList<Function<Promise, PromiseInternal>>();
        suppliers.add(arg_0 -> ((ContextInternal)ctx).promise(arg_0));
        suppliers.add(arg_0 -> ((VertxInternal)((VertxInternal)this.vertx)).promise(arg_0));
        for (Function function : suppliers) {
            Promise p1 = Promise.promise();
            PromiseInternal p2 = (PromiseInternal)function.apply(p1);
            this.assertNotSame(p1, p2);
            this.assertSame(ctx, p2.context());
            Object result = new Object();
            p2.complete(result);
            ContextTest.assertWaitUntil(() -> p1.future().isComplete());
            this.assertSame(result, p1.future().result());
        }
    }

    @Test
    public void testTopLevelContextClassLoader() {
        URLClassLoader cl = new URLClassLoader(new URL[0]);
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        EventLoop el = ctx.nettyEventLoop();
        el.execute(() -> {
            Thread.currentThread().setContextClassLoader(cl);
            ctx.runOnContext(v -> el.execute(() -> {
                this.assertSame(cl, Thread.currentThread().getContextClassLoader());
                this.testComplete();
            }));
        });
        this.await();
    }

    private static /* synthetic */ Future lambda$testComposeContextPropagation3$94(Promise anotherPromise, String res) {
        return anotherPromise.future();
    }

    private /* synthetic */ void lambda$testEventLoopContextPromiseCompletedByNonVertxThread$86(Promise promise, Consumer action, Void v) {
        Thread th = Thread.currentThread();
        promise.future().onComplete(ar -> {
            this.assertSame(th, Thread.currentThread());
            this.testComplete();
        });
        new Thread(() -> action.accept(promise)).start();
    }

    private /* synthetic */ void lambda$testEventLoopContextPromiseCompletedByWorkerThread$81(Promise promise, ContextInternal context, Consumer action, Void v) {
        Thread th = Thread.currentThread();
        promise.future().onComplete(ar -> {
            this.assertSame(th, Thread.currentThread());
            this.testComplete();
        });
        context.executeBlocking(fut -> action.accept(promise));
    }

    private /* synthetic */ void lambda$testEventLoopContextPromiseCompletedByAnotherEventLoopThread$76(Promise promise, Context any, Consumer action, Void v1) {
        Thread th = Thread.currentThread();
        promise.future().onComplete(ar -> {
            this.assertSame(th, Thread.currentThread());
            this.testComplete();
        });
        any.runOnContext(v2 -> action.accept(promise));
    }

    private /* synthetic */ void lambda$testEventLoopContextPromiseReentrantFailingCompletion$71(ContextInternal context, Promise promise, Consumer action, Void v1) {
        ArrayList exceptions = new ArrayList();
        context.exceptionHandler(exceptions::add);
        RuntimeException failure = new RuntimeException();
        promise.future().onComplete(ar -> {
            context.runOnContext(v2 -> {
                this.assertEquals(1L, exceptions.size());
                this.assertSame(failure, exceptions.get(0));
                this.testComplete();
            });
            throw failure;
        });
        action.accept(promise);
    }

    private /* synthetic */ void lambda$testEventLoopContextPromiseReentrantCompletion$66(Promise promise, Consumer action, Void v) {
        Thread th = Thread.currentThread();
        promise.future().onComplete(ar -> {
            this.assertSame(th, Thread.currentThread());
            this.testComplete();
        });
        action.accept(promise);
    }

    class SomeObject {
        SomeObject() {
        }
    }
}

